/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap.builder;

import com.sas.MissingValues;
import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.LocaleInstruction;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution.instructions.SubmitInstructionFactory;
import com.sas.iquery.execution.relational.offline.CachedTabularResultSet;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.execution2.ResultSetUpdateInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.builder.ROLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.util.LocalizableString;
import com.sas.util.transforms.ObjectToStringTransform;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultSetUtil {
    public static final String BLANK_VALUE = " ";
    public static final String MISSING_VALUE = ObjectToStringTransform.defaultInstance.transform((Object)MissingValues.Dot).toString();
    private static final Logger _logger = LogManager.getLogger(ResultSetUtil.class);

    public static void readTupleValues(ResultSet tuplesRS, String[] tupleElementNames, String[] tupleElementLabels, int valueCount, int totalTypeValue, ROLAPBuilderInformation.AxisInformation axisInfo) throws SQLException {
        StringBuffer message = new StringBuffer();
        if (_logger.isDebugEnabled()) {
            message.append("axis = " + axisInfo.getAxisIndex() + ", ");
            message.append("categoryCount = " + valueCount + ", ");
        }
        List<DataItem> categoryItems = axisInfo.getCategoryDataItems();
        for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
            String newValue;
            String value;
            boolean isTotal;
            DataItem category = categoryItems.get(valueIndex);
            if (_logger.isDebugEnabled()) {
                message.append("valueIndex = " + valueIndex + ", ");
                message.append("type = " + totalTypeValue + ", ");
            }
            if (isTotal = ROLAPUtil.isTotalValue(value = tuplesRS.getString(valueIndex + 1), totalTypeValue, category, axisInfo)) {
                String missing;
                tupleElementNames[valueIndex] = missing = ResultSetUtil.handleSubtotal(value);
                tupleElementLabels[valueIndex] = missing;
                if (!_logger.isDebugEnabled()) continue;
                message.append("B: SubtotaledCategory = " + tupleElementNames[valueIndex] + ", ");
                continue;
            }
            tupleElementNames[valueIndex] = newValue = ResultSetUtil.handleMissing(value);
            tupleElementLabels[valueIndex] = newValue;
            if (!_logger.isDebugEnabled()) continue;
            int nonTotalType = -1 >>> 32 - valueCount;
            message.append("nonTotalType = " + nonTotalType + ", ");
            if (totalTypeValue == nonTotalType) {
                message.append("A: DetailCategory = " + tupleElementNames[valueIndex] + ", ");
                continue;
            }
            message.append("C: GroupByCategory = " + tupleElementNames[valueIndex] + ", ");
        }
        if (_logger.isDebugEnabled()) {
            message.append("\n");
            _logger.debug(message.toString());
            _logger.debug("-------------------------------------------------");
        }
    }

    public static int readTypeValue(ResultSet rs, int categoryCount) throws SQLException {
        return rs.getInt(categoryCount + 1);
    }

    public static String handleMissing(String var) {
        if (var == null) {
            return MISSING_VALUE;
        }
        String var2 = ResultSetUtil.stripTrailingSpaces(var);
        var = var2.length() > 0 ? var2 : BLANK_VALUE;
        return var;
    }

    private static String stripTrailingSpaces(String str) {
        char c;
        int index;
        char[] cstr = str.toCharArray();
        for (index = cstr.length - 1; index >= 0 && Character.isSpaceChar(c = cstr[index]); --index) {
        }
        if (index < 0) {
            return "";
        }
        return new String(cstr, 0, index + 1);
    }

    public static String handleSubtotal(String var) {
        return MISSING_VALUE;
    }

    public static ResultSet executeSQL(String sqlString, ExecutionContext executionContext, int tempTableCount, boolean isDual) throws ExecutionException {
        return ResultSetUtil.executeSQL(sqlString, executionContext, "%DATA%_" + tempTableCount, "%DATA%", isDual, false, null);
    }

    public static ResultSet executeSQL(String sqlString, ExecutionContext executionContext, String tableName, String tableNameTemplate, boolean isDual) throws ExecutionException {
        return ResultSetUtil.executeSQL(sqlString, executionContext, tableName, tableNameTemplate, isDual, false, null);
    }

    public static ResultSet executeSQL(String sqlString, ExecutionContext executionContext, String tableName, String tableNameTemplate, boolean isDual, boolean setLocale, DataSelection dataSelection) throws ExecutionException {
        ResultSetInterface result = ResultSetUtil.execute(sqlString, executionContext, tableName, tableNameTemplate, isDual, setLocale, dataSelection);
        ResultSet resultSet = (ResultSet)result.getResultSet();
        return resultSet;
    }

    public static ResultSetInterface execute(String sqlString, ExecutionContext executionContext, String tableName, String tableNameTemplate, boolean isDual, boolean setLocale, DataSelection dataSelection) throws ExecutionException {
        ExecutionInstructionInterface sasInstruction;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Executing query: " + sqlString);
        }
        ExecutionOptions executionOptions = new ExecutionOptions();
        ExecutionBlock block = null;
        if (setLocale) {
            block = new ExecutionBlock();
            Locale originalComputationLocale = LocaleUtilities.getDefaultComputationalLocale(dataSelection);
            Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(dataSelection, executionContext);
            LocaleInstruction localeInstruction = new LocaleInstruction(effectiveComputationLocale, originalComputationLocale);
            localeInstruction.setExecutionContext(executionContext);
            localeInstruction.execute();
            block.addInstruction(localeInstruction);
        }
        ArrayList<SQLComponentAbstract> compositeList = new ArrayList<SQLComponentAbstract>();
        try {
            DataSelectionProcessorAbstract dsProcessor = null;
            SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, false, null);
            SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, tableName);
            SQLStatementFactory.addText(compositeList, sqlString);
            SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        }
        catch (GenerationException e) {
            throw new ExecutionException(e);
        }
        String sasCode = SQLComponentAbstract.writeCompositeList(compositeList);
        AbstractExecutionInstruction submitInstruction = SubmitInstructionFactory.getSubmitInstruction(sasCode, tableName, tableNameTemplate, executionOptions, isDual, dataSelection);
        if (setLocale) {
            block.addInstruction(submitInstruction);
            sasInstruction = block;
        } else {
            sasInstruction = submitInstruction;
        }
        sasInstruction.setExecutionContext(executionContext);
        sasInstruction.execute();
        ResultSetInterface rsi = executionContext.getResult();
        ResultSetUtil.updateResultSet(rsi, sasCode, sasInstruction, dataSelection);
        return rsi;
    }

    private static void updateResultSet(ResultSetInterface rsi, String sasCode, ExecutionInstructionInterface sasInstruction, DataSelection dataSelection) throws ExecutionException {
        ExecutionContext executionContext = sasInstruction.getExecutionContext();
        if (rsi instanceof CachedTabularResultSet) {
            ((CachedTabularResultSet)rsi).setInstructions(Collections.singletonList(sasInstruction));
        }
        if (rsi instanceof ResultSetUpdateInterface) {
            ResultSetUpdateInterface updateResultSet = (ResultSetUpdateInterface)((Object)rsi);
            updateResultSet.setQuery(sasCode);
            List<DataItem> resultItems = dataSelection.getEffectiveResultItems();
            if (resultItems != null && resultItems.size() > 0) {
                for (DataItem item : resultItems) {
                    String rsid = item.getResultSetID();
                    LocalizableString labels = item.getLabels();
                    LocalizableString descs = item.getDescriptions();
                    updateResultSet.setLabels(rsid, labels);
                    updateResultSet.setDescriptions(rsid, descs);
                }
            }
            Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(dataSelection, executionContext);
            updateResultSet.setComputationalLocale(effectiveComputationLocale);
            StpNames stpNames = executionContext.getStpNames();
            updateResultSet.setStpNames(stpNames);
        }
    }
}

