/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.ROLAPSASSubmitInstruction;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AggregatedFilterStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AggregationSubStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AxisBuildingAndSortingStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.DataExtractionStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.FractionOfTotalStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInstruction;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RankingStep;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.VisualTotalSubStep;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SummaryROLAPComposite
extends SQLSASComposite {
    private static final Logger _logger = LogManager.getLogger(SummaryROLAPComposite.class);

    @Override
    public void prepareSQL() throws GenerationException {
        RolapDataSelectionProcessor dsProcessor = (RolapDataSelectionProcessor)this.getDataSelectionProcessor();
        dsProcessor.populate();
        dsProcessor.getTempTableName(this._dataSelection);
        dsProcessor.getTempTableIsView(this._dataSelection);
    }

    @Override
    public String writeSQL() {
        return "\n writeSQL from " + this.getClass().getName() + " was called.\n";
    }

    @Override
    protected void generateCodeInstructions(ExecutionBlock executionBlock, String sasCode, ExecutionOptions executionOptions) throws GenerationException {
        ROLAPBuilderInstruction summaryROLAPBuilderInstruction;
        RolapDataSelectionProcessor dsProcessor = (RolapDataSelectionProcessor)this.getDataSelectionProcessor();
        DataSelection dataSelection = this.getDataSelectionProcessor().getDataSelection();
        ROLAPBuilderInformation rolapInfo = new ROLAPBuilderInformation(dataSelection);
        String outputTable = dsProcessor.getTempTableName(this._dataSelection);
        dsProcessor.setTempTableIsView(this._dataSelection, true);
        String outputTablePattern = DataSelectionProcessorAbstract.getTempTablePattern();
        String tempTableStem = outputTable + "_";
        String detailTable = outputTable;
        String summaryFinalTable = outputTable + "SUMMARY_FINAL";
        String summaryTable = tempTableStem + "SUMMARY";
        String tupleTablesStem = outputTable + "Axis";
        String[] tupleTableNames = new String[6];
        ArrayList<SQLComponentAbstract> compositeList = new ArrayList<SQLComponentAbstract>();
        boolean isInfo = IQSystemProperties.isVerboseProcCommentsEnabled(this);
        try {
            if (isInfo) {
                SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 1. DataExtractionStep */\n");
            }
            DataExtractionStep.addCode(compositeList, dsProcessor, detailTable);
            if (isInfo) {
                SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 2. AggregatedFilterStep */\n");
            }
            AggregatedFilterStep.addCode(compositeList, dsProcessor, detailTable, tempTableStem);
            if (isInfo) {
                SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 3. RankingStep */\n");
            }
            RankingStep.addCode(compositeList, dsProcessor, detailTable, summaryFinalTable, tempTableStem);
            if (isInfo) {
                SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 4. AggregationSubStep */\n");
            }
            boolean ignoreDisabledTotals = false;
            AggregationSubStep.addCode(compositeList, dsProcessor, detailTable, summaryTable, summaryFinalTable, ignoreDisabledTotals);
            List<DataItem> measureItems = rolapInfo.getMeasureItems();
            String tempVtTableName = tempTableStem + "AggVt";
            VisualTotalSubStep.addCode(compositeList, dsProcessor, rolapInfo, measureItems, summaryFinalTable, tempVtTableName, "", false);
            if (isInfo) {
                SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 5. FractionOfTotalStep */\n");
            }
            FractionOfTotalStep.addCode(compositeList, dsProcessor, summaryFinalTable, tempTableStem);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("SummaryROLAPComposite.generateCodeInstructions.couldNotCreate.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        if (isInfo) {
            SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 6. AxisBuildingAndSortingStep */\n");
        }
        AxisBuildingAndSortingStep.addCode(compositeList, dsProcessor, summaryFinalTable, tupleTablesStem, tupleTableNames);
        if (isInfo) {
            SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 7. DropRemainingHiddenColumnsStep */\n");
        }
        SummaryROLAPComposite.addDropRemainingHiddenColumnsStep(compositeList, dsProcessor, dataSelection, rolapInfo, summaryFinalTable);
        if (isInfo) {
            SQLStatementFactory.addText(compositeList, "/* ROLAP STEP 8. JDBC Accesses follow */\n");
        }
        String sasStatement = SQLComponentAbstract.writeCompositeList(compositeList);
        if (_logger.isDebugEnabled()) {
            _logger.debug(sasStatement);
        }
        ROLAPSASSubmitInstruction sasInstruction = new ROLAPSASSubmitInstruction(sasStatement, outputTablePattern, executionOptions, dataSelection);
        executionBlock.addInstruction(sasInstruction);
        try {
            summaryROLAPBuilderInstruction = new ROLAPBuilderInstruction(summaryFinalTable, tupleTableNames, outputTablePattern, dataSelection, rolapInfo);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("SummaryROLAPComposite.generateCodeInstructions.couldNotCreate.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        catch (ExecutionException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("SummaryROLAPComposite.generateCodeInstructions.couldNotCreate.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        executionBlock.addInstruction(summaryROLAPBuilderInstruction);
    }

    public static void addDropRemainingHiddenColumnsStep(List<SQLComponentAbstract> compositeList, RolapDataSelectionProcessor dsProcessor, DataSelection dataSelection, ROLAPBuilderInformation rolapInfo, String summaryFinalTable) throws GenerationException {
        ArrayList<DataItem> dropList = new ArrayList<DataItem>();
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item1 = selectedItem.getItem();
            boolean rolapInfoSaysDrop = rolapInfo.getColumnsToBeDropped().contains(item1);
            if (!rolapInfoSaysDrop) continue;
            dropList.add(item1);
        }
        if (!dropList.isEmpty()) {
            StringBuffer code = new StringBuffer();
            code.append("/* Drop remaining hidden columns from the final data table */\n");
            code.append("Data ").append(summaryFinalTable).append("\n");
            code.append("  (drop=");
            String sep = "";
            for (DataItem item : dropList) {
                String rsid = item.getResultSetID();
                String identifier = dsProcessor.generateDataStepVar(rsid);
                code.append(sep).append(identifier).append("\n");
                sep = "    ";
            }
            code.append("  );\n");
            code.append("  set ").append(summaryFinalTable).append(";\n");
            code.append("run;\n");
            SQLStatementFactory.addText(compositeList, code);
        }
    }
}

