/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.summaryrolap.AbstractROLAPSASStatement;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLStatement
extends AbstractROLAPSASStatement {
    public static final String TYPE_FIELD_NAME = "_TYPE_";
    private Map _resultItemsMap;
    String _tableName;
    List<String> _categoryIds = new ArrayList<String>();
    List<String> _measureIds = new ArrayList<String>();

    public SQLStatement(DataSelection dataSelection, String tableName, Map aliasMap, ROLAPBuilderInformation rolapInfo) throws GenerationException {
        super(dataSelection, tableName, rolapInfo);
        this._tableName = tableName;
        this._resultItemsMap = aliasMap;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        String column;
        this._categoryIds.clear();
        this._measureIds.clear();
        SQLExpressionAbstract sqlExpression = (SQLExpressionAbstract)this.generateExpression();
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        List<DataItem> categoryItems = this.getCategoryItems();
        for (DataItem categoryItem : categoryItems) {
            ExpressionInterface expression = categoryItem.getExpression();
            String resultSetID = categoryItem.getResultSetID();
            String identifier = dsProcessor.generateColumnIdentifier(resultSetID);
            HashMap<ExpressionInterface, String> valueMap = new HashMap<ExpressionInterface, String>();
            valueMap.put(expression, identifier);
            column = sqlExpression.generateDataItemSelectSQL(categoryItem, valueMap);
            this._categoryIds.add(column);
        }
        ArrayList<DataItem> consolidationMeasures = new ArrayList<DataItem>();
        List<DataItem> measureItems = this.getMeasureItems();
        for (DataItem measureItem : measureItems) {
            if (FractionOfTotalUtilImpl.isFractionOfTotalItem(measureItem)) continue;
            consolidationMeasures.add(measureItem);
        }
        for (DataItem measureItem : consolidationMeasures) {
            String resultSetID = measureItem.getResultSetID();
            Map aliasMap = (Map)this._resultItemsMap.get(resultSetID);
            column = sqlExpression.generateDataItemSelectSQL(measureItem, aliasMap);
            this._measureIds.add(column);
        }
    }

    @Override
    public String writeSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nSELECT\n\t");
        for (String column : this._categoryIds) {
            stringBuffer.append(column).append(",\n\t");
        }
        stringBuffer.append(TYPE_FIELD_NAME).append(" AS ").append(TYPE_FIELD_NAME).append(" LABEL=''").append(TYPE_FIELD_NAME).append("''");
        if (this._measureIds.size() > 0) {
            for (String column : this._measureIds) {
                stringBuffer.append(",\n\t").append(column);
            }
        }
        stringBuffer.append(" \nFROM ").append(this._tableName);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

