/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.SASLogReader;
import com.sas.iquery.execution.instructions.SASOperations;
import com.sas.iquery.execution.util.ArrayUtils;
import com.sas.iquery.execution.util.NamedNode;
import com.sas.iquery.execution.util.ResultColumnDef;
import com.sas.iquery.execution.util.TreeUtils;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPDataSetBuilderInterface;
import com.sas.iquery.strategies.sas.oma.summaryrolap.builder.ROLAPUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.builder.ResultSetUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPDataSet;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPMetadataFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ROLAPResultSet;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.ResultSetMetadata;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.StringMessageFormatter;
import com.sas.storage.jdbc.JDBCDataTypeInfo;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.text.SASFormat;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcSummaryROLAPBuilder
implements ROLAPDataSetBuilderInterface {
    public static final String MAX_TUPLE_COUNT_PROPERTY_NAME = "com.sas.iquery.dataservices.ProcSummaryROLAPBuilder.MAX_TUPLE_COUNT";
    public static final Logger _logger = LogManager.getLogger(ProcSummaryROLAPBuilder.class);

    @Override
    public OLAPDataSetInterface buildOLAPDataSet(ExecutionContext executionContext, ROLAPBuilderInformation rolapInfo, String summaryTableName, String[] tupleTableNames, String tableNameTemplate) throws ExecutionException {
        ROLAPDataSet olapDataSet;
        try {
            String tempTableName = executionContext.getTemporaryTableName();
            StringBuffer queryText = new StringBuffer();
            LinkedHashMap<Integer, NamedNode> namedNodesByAxis = new LinkedHashMap<Integer, NamedNode>();
            ROLAPMetadataFactory dbMetadataFactory = new ROLAPMetadataFactory();
            ResultSetMetadata resultSetMetadata = this.buildResultSetMetadata(rolapInfo, namedNodesByAxis, summaryTableName, tupleTableNames, tableNameTemplate, tempTableName, executionContext, dbMetadataFactory, queryText);
            ROLAPResultSet rolapResultSet = dbMetadataFactory.newRolapResultSet(resultSetMetadata, rolapInfo.isDual());
            olapDataSet = dbMetadataFactory.newRolapDataSet(rolapResultSet);
            if (olapDataSet != null) {
                this.fillCells(olapDataSet, rolapInfo, namedNodesByAxis, summaryTableName, tableNameTemplate, tempTableName, executionContext, queryText);
                String queryInfoText = queryText.toString().replaceAll(tableNameTemplate, tempTableName);
                olapDataSet.setQueryStatement(queryInfoText);
            }
            rolapResultSet.pageOut();
            if (_logger.isInfoEnabled()) {
                _logger.info("Built in-memory OLAPDataSet with " + olapDataSet.getCellCount() + " cells");
            }
        }
        catch (SQLException e) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("ProcSummaryROLAPBuilder.buildOLAPDataSet.buildingFailed.txt", new Object[0]);
            ExecutionException e2 = new ExecutionException(errorMsg, (Throwable)e);
            this.readLogForException(executionContext, summaryTableName, e, errorMsg, e2);
            throw e2;
        }
        catch (OLAPException e) {
            MessageFormatter errorMsg = IQDataServicesResourceBundle.getMessageFormatter("ProcSummaryROLAPBuilder.buildOLAPDataSet.buildingFailed.txt", new Object[0]);
            ExecutionException e2 = new ExecutionException(errorMsg, (Throwable)e);
            this.readLogForException(executionContext, summaryTableName, (Exception)((Object)e), errorMsg, e2);
            throw e2;
        }
        return olapDataSet;
    }

    private void readLogForException(ExecutionContext executionContext, String summaryTableName, Exception e, MessageFormatter errorMsg, ExecutionException e2) {
        StringBuffer statementErrors = new StringBuffer();
        SASLogReader.flushLogForError(executionContext, statementErrors);
        SASLogReader.prepException((IQueryServicesException)e2, errorMsg, executionContext, statementErrors.toString());
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error("An exception occurred while attempting to execute a query.  reading summary table: " + summaryTableName + "\n" + statementErrors, (Throwable)e);
        }
    }

    private ResultSetMetadata buildResultSetMetadata(ROLAPBuilderInformation rolapInfo, Map<Integer, NamedNode> namedNodesByAxis, String summaryTableName, String[] tupleTableNames, String tableNameTemplate, String tempFileName, ExecutionContext executionContext, ROLAPMetadataFactory dbMetadataFactory, StringBuffer queryText) throws OLAPException, ExecutionException, SQLException {
        IWorkspace workspace = executionContext.getWorkspace();
        String cubeName = tempFileName;
        String catalogName = workspace.Name();
        String text = summaryTableName.replaceAll(tableNameTemplate, tempFileName);
        int dot = text.indexOf(46);
        String schemaName = dot != -1 ? text.substring(0, dot) : workspace.UniqueIdentifier();
        DataSelection dataSelection = rolapInfo.getDataSelection();
        Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(dataSelection, executionContext);
        String cubeLabel = dataSelection.getLabel();
        if (cubeLabel == null || cubeLabel.trim().length() == 0) {
            cubeLabel = dataSelection.getID() + ": cube " + cubeName;
        }
        queryText.append("/* ROLAP Query ").append(dataSelection.getIdentityString()).append("\n").append(" * Cube Name = '" + cubeName + "'\n").append(" * Schema Name = '" + schemaName + "'\n").append(" * Catalog Name = '" + catalogName + "'\n").append(" * Data Output Locale = " + (effectiveComputationLocale == null ? null : "'" + effectiveComputationLocale + "'") + "\n").append(" */\n");
        boolean isDual = rolapInfo.isDual();
        dbMetadataFactory.buildCube(catalogName, schemaName, cubeName, cubeLabel);
        Map<String, ResultColumnDef> resultsColumnDefs = this.getResultColumnDefs(executionContext, summaryTableName, tableNameTemplate);
        Map<String, Integer> dataItemAggregationMap = this.getDataItemAggregations(dataSelection);
        this.buildNamedNodeFromTuples(rolapInfo, namedNodesByAxis, tupleTableNames, tableNameTemplate, executionContext, dataSelection, isDual, queryText);
        MetadataInterface metadata = dbMetadataFactory.getMetadata();
        metadata.setConnection((Object)executionContext.getConnection());
        metadata.setLocale(effectiveComputationLocale);
        ResultSetMetadata rolapRsmd = dbMetadataFactory.newRolapMetadata();
        int[] axisOrder = new int[]{0, 1, 2, 3, 4};
        for (int i = 0; i < axisOrder.length; ++i) {
            int axisIndex = axisOrder[i];
            ROLAPBuilderInformation.AxisInformation axisInfo = rolapInfo.getAxisInformation(axisIndex);
            NamedNode namedNodes = namedNodesByAxis.get(axisIndex);
            if (axisInfo == null || namedNodes == null) break;
            if (_logger.isDebugEnabled()) {
                this.print(axisInfo, namedNodes, "");
            }
            AxisInterface axis = dbMetadataFactory.buildAxis(axisInfo, catalogName, schemaName, cubeName, namedNodes, dataItemAggregationMap, resultsColumnDefs);
            dbMetadataFactory.buildAxisMembers(axisInfo, catalogName, schemaName, cubeName, namedNodes, dataItemAggregationMap, resultsColumnDefs);
            if (axisInfo == null || namedNodes == null) break;
            rolapRsmd.addAxis(axis);
        }
        return rolapRsmd;
    }

    private Map<Integer, NamedNode> buildNamedNodeFromTuples(ROLAPBuilderInformation rolapInfo, Map<Integer, NamedNode> namedNodesByAxis, String[] tupleTableNames, String tableNameTemplate, ExecutionContext executionContext, DataSelection dataSelection, boolean isDual, StringBuffer queryText) throws SQLException, ExecutionException, OLAPException {
        for (Integer axisIndex : rolapInfo.getAxesIndices()) {
            if (axisIndex == -1) continue;
            ROLAPBuilderInformation.AxisInformation axisInfo = rolapInfo.getAxisInformation(axisIndex);
            NamedNode tupleNodes = this.buildTupleNodes(axisInfo, tableNameTemplate, tupleTableNames, executionContext, dataSelection, isDual, queryText);
            namedNodesByAxis.put(axisIndex, tupleNodes);
        }
        return namedNodesByAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedNode buildTupleNodes(ROLAPBuilderInformation.AxisInformation axisInfo, String tableNameTemplate, String[] tupleTableNames, ExecutionContext executionContext, DataSelection dataSelection, boolean isDual, StringBuffer queryText) throws ExecutionException, OLAPException {
        int categoryCount;
        int axisIndex = axisInfo.getAxisIndex();
        String toTableName = tableNameTemplate + "_" + axisIndex;
        String tupleTableName = tupleTableNames[axisIndex < 0 ? tupleTableNames.length + axisIndex : axisIndex];
        String axisTuplesQuery = "select * from " + tupleTableName;
        NamedNode elementNameTree = new NamedNode("root", "root");
        String[] measureIds = axisInfo.getMeasureIds();
        String[] measureLabels = axisInfo.getMeasureLabels();
        int tupleDepth = categoryCount = axisInfo.getCategoryCount();
        if (axisInfo.getMeasureCount() > 0) {
            ++tupleDepth;
        }
        String[] elementNames = new String[tupleDepth];
        String[] elementLabels = new String[tupleDepth];
        TupleElementType[] elementTypes = new TupleElementType[tupleDepth];
        if (categoryCount > 0) {
            queryText.append("\n/* " + axisInfo.getAxisRole() + " Axis Tuples Query: ").append(toTableName).append(" = */\n").append(axisTuplesQuery).append(";\n");
            ResultSetInterface result = ResultSetUtil.execute(axisTuplesQuery, executionContext, toTableName, tableNameTemplate, isDual, false, dataSelection);
            ResultSet rs = (ResultSet)result.getResultSet();
            try {
                this.beforeFirstRs(rs, result);
                while (this.nextRs(rs, result)) {
                    String label;
                    axisInfo.updateTupleCount(measureIds.length == 0 ? 1 : measureIds.length);
                    int totalTypeValue = this.readTupleValuesRs(rs, axisInfo, categoryCount, elementNames, elementLabels, result);
                    ROLAPUtil.useTotalLabels(elementNames, elementLabels, elementTypes, categoryCount, totalTypeValue, axisInfo);
                    if (measureIds.length == 0) {
                        TreeUtils.addNameNodes(elementNameTree, elementNames, elementLabels, elementTypes, 0);
                        continue;
                    }
                    int measureInsertionIndex = axisInfo.getROLAPBuilderInformation().getMeasureInsertionIndex(axisIndex);
                    if (measureInsertionIndex == -1) {
                        measureInsertionIndex = elementNames.length - 1;
                    } else {
                        int i;
                        for (i = elementNames.length - 2; i >= measureInsertionIndex; --i) {
                            String name;
                            elementNames[i + 1] = name = elementNames[i];
                            elementLabels[i + 1] = label = elementLabels[i];
                        }
                        for (i = elementTypes.length - 2; i >= measureInsertionIndex; --i) {
                            TupleElementType type;
                            elementTypes[i + 1] = type = elementTypes[i];
                        }
                    }
                    for (int m = 0; m < measureIds.length; ++m) {
                        String id = measureIds[m];
                        elementLabels[measureInsertionIndex] = label = measureLabels[m];
                        elementNames[measureInsertionIndex] = id;
                        elementTypes[measureInsertionIndex] = TupleElementType.MEASURE;
                        TreeUtils.addNameNodes(elementNameTree, elementNames, elementLabels, elementTypes, 0);
                    }
                }
            }
            finally {
                if (rs != null) {
                    this.closeRs(rs, result);
                }
            }
        } else {
            queryText.append("\n/* " + axisInfo.getAxisRole() + " Axis Tuples: ").append(toTableName).append(" */\n");
            for (int m = 0; m < measureIds.length; ++m) {
                String id = measureIds[m];
                String label = measureLabels[m];
                elementNames[elementNames.length - 1] = id;
                elementLabels[elementNames.length - 1] = label;
                TreeUtils.addNameNodes(elementNameTree, elementNames, elementLabels, new TupleElementType[]{TupleElementType.MEASURE}, 0);
            }
        }
        elementNameTree.updateLeafCount(0);
        return elementNameTree;
    }

    private int readTupleValuesRs(ResultSet rs, ROLAPBuilderInformation.AxisInformation axisInfo, int categoryCount, String[] elementNames, String[] elementLabels, ResultSetInterface result) throws ExecutionException {
        int totalTypeValue;
        try {
            totalTypeValue = ResultSetUtil.readTypeValue(rs, categoryCount);
            ResultSetUtil.readTupleValues(rs, elementNames, elementLabels, categoryCount, totalTypeValue, axisInfo);
        }
        catch (SQLException e) {
            this.logTrace(result, e);
            ExecutionException ee = new ExecutionException(e);
            ee.setSASLog(result.getSASLog());
            throw ee;
        }
        return totalTypeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCells(ROLAPDataSet olapDataSet, ROLAPBuilderInformation rolapInfo, Map<Integer, NamedNode> namedNodesByAxis, String summaryTableName, String tableNameTemplate, String tempTableName, ExecutionContext executionContext, StringBuffer queryText) throws OLAPException, ExecutionException {
        boolean isDual = rolapInfo.isDual();
        DataSelection dataSelection = rolapInfo.getDataSelection();
        NamedNode columnTupleNodes = namedNodesByAxis.get(0);
        NamedNode rowTupleNodes = namedNodesByAxis.get(1);
        long cellCount = olapDataSet.getCellCount();
        for (long i = 0L; i < cellCount; ++i) {
            olapDataSet.setCell(i, ResultSetUtil.MISSING_VALUE);
            olapDataSet.setFormattedCell(i, ResultSetUtil.MISSING_VALUE);
        }
        ResultSetMetadataInterface olapRSMD = olapDataSet.getResultSetMetadata();
        int[] measureIndices = rolapInfo.getMeasureIndices();
        String[] measureIds = rolapInfo.getMeasureIds();
        boolean areMeasuresOnColumns = rolapInfo.getAxisInformation(0).getMeasureCount() > 0;
        String cellTableName = tableNameTemplate + "_2";
        String cellQuery = this.buildCellValueQuery(rolapInfo, summaryTableName);
        queryText.append("\n/* Cell Values Query: ").append(cellTableName).append(" = */\n").append(cellQuery).append(";\n");
        ResultSetInterface result = ResultSetUtil.execute(cellQuery, executionContext, cellTableName, tableNameTemplate, isDual, false, dataSelection);
        ResultSet rs = (ResultSet)result.getResultSet();
        try {
            this.beforeFirstRs(rs, result);
            while (this.nextRs(rs, result)) {
                for (int i = 0; i < measureIndices.length; ++i) {
                    int measureIndex = measureIndices[i];
                    String measureId = measureIds[i];
                    String colMeasureId = areMeasuresOnColumns ? measureId : null;
                    String[] columnCategoryValues = this.readAxisValuesRs(colMeasureId, rs, 0, rolapInfo, result);
                    NamedNode columnTupleLeafNode = columnTupleNodes.getLeaf(columnCategoryValues);
                    if (columnTupleLeafNode == null) continue;
                    int columnCoord = columnTupleLeafNode.getLeafOffset();
                    String rowMeasureId = areMeasuresOnColumns ? null : measureId;
                    String[] rowCategoryValues = this.readAxisValuesRs(rowMeasureId, rs, 1, rolapInfo, result);
                    NamedNode rowTupleLeafNode = rowTupleNodes.getLeaf(rowCategoryValues);
                    if (rowTupleLeafNode == null) continue;
                    int rowCoord = rowTupleLeafNode.getLeafOffset();
                    int cellIdx = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)olapRSMD, (int[])new int[]{columnCoord, rowCoord});
                    Object cellValue = this.getRsObject(rs, measureIndex, result);
                    if (cellValue == null) {
                        cellValue = ResultSetUtil.MISSING_VALUE;
                    }
                    olapDataSet.setCell(cellIdx, cellValue);
                    if (!isDual) continue;
                    String formattedCellValue = this.getRsString(rs, measureIndex, result);
                    if (formattedCellValue == null) {
                        formattedCellValue = ResultSetUtil.MISSING_VALUE;
                    }
                    olapDataSet.setFormattedCell(cellIdx, formattedCellValue);
                }
            }
        }
        finally {
            if (rs != null) {
                this.closeRs(rs, result);
            }
        }
    }

    private String[] readAxisValuesRs(String measureId, ResultSet rs, int axis, ROLAPBuilderInformation rolapInfo, ResultSetInterface result) throws ExecutionException {
        String[] categoryValuesOnAxis;
        try {
            categoryValuesOnAxis = ProcSummaryROLAPBuilder.readAxisValues(rolapInfo, axis, rs, measureId);
        }
        catch (SQLException e) {
            this.logTrace(result, e);
            ExecutionException ee = new ExecutionException(e);
            ee.setSASLog(result.getSASLog());
            throw ee;
        }
        return categoryValuesOnAxis;
    }

    protected void logTrace(ResultSetInterface result, Throwable t) throws ExecutionException {
        _logger.trace("==========================================================");
        _logger.trace("Query:");
        _logger.trace(result.getQuery());
        _logger.trace("Stored Process Log:");
        _logger.trace(result.getStoredProcessLog());
        _logger.trace("SAS Log:");
        _logger.trace(result.getSASLog());
        _logger.trace("==========================================================");
        _logger.trace("Cause Failure:", t);
    }

    private boolean nextRs(ResultSet rs, ResultSetInterface result) throws ExecutionException {
        try {
            return rs.next();
        }
        catch (SQLException e) {
            this.logTrace(result, e);
            ExecutionException ee = new ExecutionException(e);
            ee.setSASLog(result.getSASLog());
            throw ee;
        }
    }

    private void beforeFirstRs(ResultSet rs, ResultSetInterface result) throws ExecutionException {
        try {
            rs.beforeFirst();
        }
        catch (SQLException e) {
            this.logTrace(result, e);
            ExecutionException ee = new ExecutionException(e);
            ee.setSASLog(result.getSASLog());
            throw ee;
        }
    }

    private Object getRsObject(ResultSet rs, int measureIndex, ResultSetInterface result) throws ExecutionException {
        Object cellValue;
        try {
            cellValue = rs.getObject(measureIndex);
        }
        catch (SQLException e) {
            StringMessageFormatter msg = new StringMessageFormatter("Error reading object from column {0}.", measureIndex);
            _logger.trace((Object)msg);
            this.logTrace(result, e);
            ExecutionException ee = new ExecutionException((MessageFormatter)msg, (Throwable)e);
            ee.setSASLog(result.getSASLog());
            throw ee;
        }
        return cellValue;
    }

    private String getRsString(ResultSet rs, int measureIndex, ResultSetInterface result) throws ExecutionException {
        String formattedCellValue;
        try {
            formattedCellValue = rs.getString(measureIndex);
        }
        catch (SQLException e) {
            StringMessageFormatter msg = new StringMessageFormatter("Error reading string from column {0}.", measureIndex);
            _logger.trace((Object)msg);
            this.logTrace(result, e);
            ExecutionException ee = new ExecutionException((MessageFormatter)msg, (Throwable)e);
            ee.setSASLog(result.getSASLog());
            throw ee;
        }
        return formattedCellValue;
    }

    private void closeRs(ResultSet rs, ResultSetInterface result) throws ExecutionException {
        try {
            rs.close();
        }
        catch (SQLException e) {
            this.logTrace(result, e);
        }
    }

    private String buildCellValueQuery(ROLAPBuilderInformation rolapInfo, String summaryTableName) {
        boolean hasHiddenCategories;
        String sql = "SELECT * FROM " + summaryTableName;
        int allCategoryCount = rolapInfo.getCategoryCount();
        ROLAPBuilderInformation.AxisInformation columnsInfo = rolapInfo.getAxisInformation(0);
        ROLAPBuilderInformation.AxisInformation rowsInfo = rolapInfo.getAxisInformation(1);
        boolean hasRowTotals = rowsInfo.hasTotals();
        boolean hasColumnTotals = columnsInfo.hasTotals();
        boolean bl = hasHiddenCategories = rolapInfo.getHiddenCategoryItems().size() > 0;
        if (!hasRowTotals && !hasColumnTotals) {
            int[] columnAxisCategoryIndices = columnsInfo.getCategoryIndices();
            int[] rowAxisCategoryIndices = rowsInfo.getCategoryIndices();
            int[] allAxisCategoryIndices = ArrayUtils.concatenate(columnAxisCategoryIndices, rowAxisCategoryIndices);
            int typeMatch = ROLAPUtil.calculateTypeValue(allAxisCategoryIndices, allCategoryCount);
            sql = sql + " WHERE _TYPE_ = " + typeMatch;
        } else if (hasHiddenCategories) {
            List<Integer> hiddenCategoryIndicesList = rolapInfo.getHiddenCategoryIndices();
            int[] hiddenCategoryIndices = ArrayUtils.makeIntArray(hiddenCategoryIndicesList);
            int typeMask = ROLAPUtil.calculateTypeValue(hiddenCategoryIndices, allCategoryCount);
            sql = sql + " WHERE BAnd( _TYPE_, " + typeMask + " ) = 0";
        }
        return sql;
    }

    public static String[] readAxisValues(ROLAPBuilderInformation rolapInfo, int axisIndex, ResultSet rs, String measureId) throws SQLException, ExecutionException {
        ROLAPBuilderInformation.AxisInformation axisInfo = rolapInfo.getAxisInformation(axisIndex);
        int[] categoryIndices = axisInfo.getCategoryIndices();
        int valueCount = categoryIndices.length;
        int measureInsertionIndex = -1;
        if (measureId != null) {
            ++valueCount;
            measureInsertionIndex = rolapInfo.getMeasureInsertionIndex(axisIndex);
        }
        int type = rs.getInt("_TYPE_");
        int totalCategoryCount = rolapInfo.getCategoryCount();
        String[] axisValues = new String[valueCount];
        int index = 0;
        for (int i = 0; i < categoryIndices.length; ++i) {
            int c = categoryIndices[i];
            String val = ROLAPUtil.isAbsentColumn(c, type, totalCategoryCount) ? (i == 0 ? axisInfo.getGrandTotalLabel() : (axisInfo.hasSubTotals() || axisInfo.hasAllTotals() ? axisInfo.getSubTotalLabel() : "")) : ResultSetUtil.handleMissing(rs.getString(c));
            if (index == measureInsertionIndex) {
                String measureLabel = rolapInfo.getDataItemLabel(measureId);
                axisValues[index] = measureLabel == null ? null : measureId;
                ++index;
            }
            axisValues[index] = val;
            ++index;
        }
        if (measureId != null && measureInsertionIndex == valueCount - 1) {
            String measureLabel = rolapInfo.getDataItemLabel(measureId);
            axisValues[valueCount - 1] = measureLabel == null ? null : measureId;
        }
        return axisValues;
    }

    private Map<String, Integer> getDataItemAggregations(DataSelection dataSelection) {
        LinkedHashMap<String, Integer> dataItemAggregationMap = new LinkedHashMap<String, Integer>();
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            String rsid = dataItem.getResultSetID();
            Function aggregationType = dataItem.getAggregationType();
            if (aggregationType == null) {
                dataItemAggregationMap.put(rsid, 9);
                continue;
            }
            FunctionNameID funcId = aggregationType.getFunctionNameID();
            if (funcId == FunctionNameID.INTERNAL_AGGREGATION || funcId.equals(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE) || funcId.equals(FunctionNameID.USER_FN) || funcId.equals(FunctionNameID.USER_FN_DISTINCT)) {
                dataItemAggregationMap.put(rsid, 8);
                continue;
            }
            String syntaxToken = aggregationType.getSyntaxToken();
            if (funcId.equals(FunctionNameID.SUM) || funcId.equals(FunctionNameID.SUM_DISTINCT) || syntaxToken.equalsIgnoreCase("SUM")) {
                dataItemAggregationMap.put(rsid, 1);
                continue;
            }
            if (funcId.equals(FunctionNameID.COUNT) || funcId.equals(FunctionNameID.KCOUNT) || funcId.equals(FunctionNameID.COUNT_DISTINCT) || funcId.equals(FunctionNameID.COUNT_PLUS_NMISS) || funcId.equals(FunctionNameID.COUNT_PLUS_NMISS_DISTINCT) || funcId.equals(FunctionNameID.COUNT_STAR) || funcId.equals(FunctionNameID.N) || funcId.equals(FunctionNameID.N_DISTINCT) || funcId.equals(FunctionNameID.NMISS) || funcId.equals(FunctionNameID.NMISS_DISTINCT) || syntaxToken.equalsIgnoreCase("COUNT") || syntaxToken.equalsIgnoreCase("N") || syntaxToken.equalsIgnoreCase("NMISS")) {
                dataItemAggregationMap.put(rsid, 2);
                continue;
            }
            if (funcId.equals(FunctionNameID.MAX) || funcId.equals(FunctionNameID.MAX_DISTINCT) || syntaxToken.equalsIgnoreCase("MAX")) {
                dataItemAggregationMap.put(rsid, 4);
                continue;
            }
            if (funcId.equals(FunctionNameID.MIN) || funcId.equals(FunctionNameID.MIN_DISTINCT) || syntaxToken.equalsIgnoreCase("MIN")) {
                dataItemAggregationMap.put(rsid, 3);
                continue;
            }
            if (funcId.equals(FunctionNameID.AVG) || funcId.equals(FunctionNameID.AVG_DISTINCT) || funcId.equals(FunctionNameID.MEAN) || funcId.equals(FunctionNameID.MEAN_DISTINCT) || syntaxToken.equalsIgnoreCase("AVG")) {
                dataItemAggregationMap.put(rsid, 5);
                continue;
            }
            if (funcId.equals(FunctionNameID.VAR) || funcId.equals(FunctionNameID.VAR_DISTINCT) || syntaxToken.equalsIgnoreCase("VAR")) {
                dataItemAggregationMap.put(rsid, 6);
                continue;
            }
            if (funcId.equals(FunctionNameID.STD) || funcId.equals(FunctionNameID.STD_DISTINCT) || syntaxToken.equalsIgnoreCase("STD")) {
                dataItemAggregationMap.put(rsid, 7);
                continue;
            }
            dataItemAggregationMap.put(rsid, 9);
        }
        return dataItemAggregationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ResultColumnDef> getResultColumnDefs(ExecutionContext executionContext, String summaryTableName, String tableNameTemplate) throws ExecutionException, SQLException {
        Map<String, ResultColumnDef> resultsColumnDefs;
        String query = "select * from " + summaryTableName;
        String resultTableName = executionContext.getTemporaryTableName();
        String jdbcStatement = GenerationUtil.replaceTableName(query, tableNameTemplate, resultTableName);
        ExecutionOptions executionOptions = new ExecutionOptions();
        executionOptions.setFormatted(false);
        try (Connection sqlConnection = SASOperations.createConnection(executionContext, executionOptions);
             Statement statement = SASOperations.createStatement(executionContext, sqlConnection, executionOptions);
             ResultSet jdbcResultSet = SASOperations.createTable(executionContext, statement, jdbcStatement);){
            resultsColumnDefs = this.getResultColumnDefs(jdbcResultSet);
        }
        return resultsColumnDefs;
    }

    private Map<String, ResultColumnDef> getResultColumnDefs(ResultSet rs) throws SQLException {
        LinkedHashMap<String, ResultColumnDef> resultsColumnDefs = new LinkedHashMap<String, ResultColumnDef>();
        ResultSetMetaData javaRsmd = rs.getMetaData();
        for (int i = 1; i <= javaRsmd.getColumnCount(); ++i) {
            String columnName = javaRsmd.getColumnName(i);
            String columnTypeName = javaRsmd.getColumnTypeName(i);
            String label = javaRsmd.getColumnLabel(i);
            int sqlType = javaRsmd.getColumnType(i);
            String jdbcTypeString = JDBCDataTypeInfo.getJDBCTypeString((int)sqlType);
            Class dataType = JDBCDataTypeInfo.getJavaClass((int)sqlType);
            int iqType = ExpressionUtil.getExprType(sqlType);
            String format = null;
            String unit = null;
            int precision = -1;
            int scale = -1;
            if (columnTypeName != null && columnTypeName.trim().length() > 0) {
                format = columnTypeName.trim();
                SASFormat instance = SASFormat.getInstance((String)format);
                if (instance != null) {
                    unit = instance.getBaseFormatName();
                    precision = instance.getDecimalWidth();
                    scale = instance.getWidth();
                } else {
                    int dot = format.indexOf(46);
                    if (dot != -1) {
                        String left = format.substring(0, dot).trim();
                        String right = format.substring(dot + 1).trim();
                        if (right.length() != 0) {
                            try {
                                precision = Integer.valueOf(right);
                            }
                            catch (NumberFormatException e) {
                                precision = -1;
                            }
                        }
                        if (left.length() != 0) {
                            String leftLeft = left.replaceAll("[\\d]*$", "").trim();
                            if (leftLeft.length() == left.length()) {
                                unit = left;
                            } else {
                                unit = leftLeft;
                                String leftRight = left.substring(leftLeft.length()).trim();
                                if (leftRight.length() != 0) {
                                    try {
                                        scale = Integer.valueOf(leftRight);
                                    }
                                    catch (NumberFormatException e) {
                                        scale = -1;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            String desc = label + (format != null ? ", format=" + format : "") + ", jdbcType=" + jdbcTypeString + ", sqlType=" + sqlType + ", javaType=" + (dataType == null ? null : dataType.getName());
            resultsColumnDefs.put(columnName, new ResultColumnDef(label, desc, dataType, format, unit, precision, scale, iqType));
        }
        return resultsColumnDefs;
    }

    private void print(ROLAPBuilderInformation.AxisInformation axisInfo, NamedNode node, String indent) throws OLAPException {
        _logger.debug(" * Axis: " + axisInfo.getAxisIndex() + " - Node: " + indent + (node.getChildren().size() > 0 ? "+" : " ") + " '" + node.getLabel() + "', name=" + node.getName() + ", type=" + node.getType() + ", children=" + node.getChildren().size() + ", leafs=" + node.getLeafCount() + ", from/to=(" + node.getLeafOffset() + "-" + node.getLastLeaf().getLeafOffset() + "), parent=" + node.getParent());
        for (NamedNode child : node.getChildren()) {
            this.print(axisInfo, child, indent + "  ");
        }
    }
}

