/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FractionOfGrandTotalStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.summaryrolap.builder.ROLAPUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FractionOfTotalStep {
    private static final boolean allowTsSqlInFractionOfTotalStep = false;
    static final String CHANGE_CRITERIA_SUBTOTAL = "first.";
    static final String CHANGE_CRITERIA_GRAND_TOTAL = "(_n_ = 1)";

    public static void addCode(List<SQLComponentAbstract> compositeList, RolapDataSelectionProcessor dsProcessor, String summaryFinalTable, String tempTableStem) throws GenerationException {
        String summaryTempTable = tempTableStem + "SUMMARY_TMP";
        String summaryHierTable = tempTableStem + "SUMMARY_HIERARCHIES";
        DataSelection dataSelection = dsProcessor.getDataSelection();
        List<DataItem> fractionItems = FractionOfTotalUtilImpl.getFractionOfTotalItems(dataSelection);
        if (!fractionItems.isEmpty()) {
            ROLAPBuilderInformation rolapInfo = new ROLAPBuilderInformation(dataSelection);
            SQLStatementFactory.addText(compositeList, "\n\n/* FractionOfTotalStep begin */\n");
            SQLStatementFactory.addProcDataSetsRename(compositeList, summaryFinalTable, summaryTempTable);
            FractionOfTotalStep.addAxisFractions(compositeList, dsProcessor, rolapInfo, true, summaryTempTable, summaryHierTable);
            FractionOfTotalStep.addAxisFractions(compositeList, dsProcessor, rolapInfo, false, summaryTempTable, summaryHierTable);
            FractionOfTotalStep.addCorrectColumnOrdering(compositeList, dsProcessor, rolapInfo, summaryFinalTable, summaryTempTable, summaryHierTable);
            SQLStatementFactory.addText(compositeList, "\n/* FractionOfTotalStep end */\n\n");
        }
    }

    private static void addCorrectColumnOrdering(List<SQLComponentAbstract> compositeList, RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, String summaryFinalTable, String summaryTempTable, String summaryHierTable) throws GenerationException {
        SQLStatementFactory.addNewLine(compositeList);
        SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, null);
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, summaryFinalTable);
        StringBuffer sql = FractionOfTotalStep.generateCorrectColumnOrderingQuery(dsProcessor, rolapInfo, summaryTempTable);
        SQLStatementFactory.addText(compositeList, sql);
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addDropTableByName(compositeList, dsProcessor, summaryTempTable);
        SQLStatementFactory.addDropTableByName(compositeList, dsProcessor, summaryHierTable);
        SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
    }

    private static StringBuffer generateCorrectColumnOrderingQuery(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, String summaryTempTable) throws GenerationException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select ");
        List<String> correctColumnsList = ROLAPStepGenerationUtil.getResultColumnsList(dsProcessor, rolapInfo);
        Iterator<String> iter = correctColumnsList.iterator();
        while (iter.hasNext()) {
            String rsid = iter.next();
            String identifier = dsProcessor.generateColumnIdentifier(rsid);
            sql.append(identifier);
            if (!iter.hasNext()) continue;
            sql.append(",\n         ");
        }
        sql.append("\n    from " + summaryTempTable);
        return sql;
    }

    private static void addAxisFractions(List<SQLComponentAbstract> compositeList, RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, boolean compareAgainstColumns, String summaryTempTable, String summaryHierTable) throws GenerationException {
        List<DataItem> fractionItems = FractionOfTotalStep.getFractionOfTotalItems(rolapInfo, compareAgainstColumns);
        if (!fractionItems.isEmpty()) {
            FractionOfTotalStep.addHierarchies(compositeList, dsProcessor, rolapInfo, compareAgainstColumns, summaryTempTable, summaryHierTable);
            StringBuffer dataStep = FractionOfTotalStep.generateFractions(dsProcessor, rolapInfo, compareAgainstColumns, fractionItems, summaryTempTable, summaryHierTable);
            SQLStatementFactory.addText(compositeList, dataStep);
        }
    }

    private static StringBuffer generateFractions(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, boolean compareAgainstColumns, List<DataItem> fractionItems, String summaryTempTable, String summaryHierTable) throws GenerationException {
        int[] nArray;
        StringBuffer dataStep = new StringBuffer();
        HashMap<String, String> tooLongAlias = new HashMap<String, String>();
        DataSelection dataSelection = rolapInfo.getDataSelection();
        dataStep.append("data " + summaryTempTable + ";\n");
        dataStep.append("\tset " + summaryHierTable + " (keep=);\n");
        dataStep.append("\tby ");
        if (compareAgainstColumns) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 0;
        }
        int[] axisIndices = nArray;
        ArrayList<String> usedCatIds = new ArrayList<String>();
        boolean needSeparator = false;
        for (int axisIndex : axisIndices) {
            ROLAPBuilderInformation.AxisInformation axisInfo = rolapInfo.getAxisInformation(axisIndex);
            String[] columnIds = axisInfo.getCategoryIds();
            int lineStart = FractionOfTotalStep.addToken(dataStep, null, 0, 200, "\n", "\n        ");
            for (String categoryId : columnIds) {
                if (needSeparator) {
                    lineStart = FractionOfTotalStep.addToken(dataStep, " ", lineStart, 200, "\n", "\n        ");
                } else {
                    needSeparator = true;
                }
                String strAliasBit = dsProcessor.generateDataStepVar("_bit_" + categoryId);
                String strAliasCat = dsProcessor.generateDataStepVar(categoryId);
                lineStart = FractionOfTotalStep.addToken(dataStep, strAliasBit, lineStart, 200, "\n", "\n        ");
                lineStart = FractionOfTotalStep.addToken(dataStep, " ", lineStart, 200, "\n", "\n        ");
                lineStart = FractionOfTotalStep.addToken(dataStep, strAliasCat, lineStart, 200, "\n", "\n        ");
                usedCatIds.add(categoryId);
            }
        }
        dataStep.append(";\n\n");
        ROLAPBuilderInformation.AxisInformation colAxis = rolapInfo.getAxisInformation(Role.COLUMN);
        int[] colCategoryIndices = colAxis.getCategoryIndices();
        int colCategoryCount = colAxis.getCategoryCount();
        ROLAPBuilderInformation.AxisInformation rowAxis = rolapInfo.getAxisInformation(Role.ROW);
        int[] rowCategoryIndices = rowAxis.getCategoryIndices();
        int rowCategoryCount = rowAxis.getCategoryCount();
        int totalCategoryCount = colCategoryCount + rowCategoryCount;
        StringBuffer cellTotalsMask = new StringBuffer();
        StringBuffer grandTotalMask = new StringBuffer();
        for (int i = 0; i < totalCategoryCount; ++i) {
            cellTotalsMask.append('1');
            grandTotalMask.append('0');
        }
        StringBuffer axisTotal = new StringBuffer();
        axisTotal.append("\t_axistotal_ = (_TYPE_='").append(grandTotalMask).append("'b)");
        if (colCategoryCount > 0 && rowCategoryCount > 0) {
            String colAxisTotalMask = ROLAPUtil.makeGrandTotalMask(colCategoryIndices, totalCategoryCount);
            axisTotal.append("\n\t           or (_TYPE_='").append(colAxisTotalMask).append("'b)");
            String rowAxisTotalMask = ROLAPUtil.makeGrandTotalMask(rowCategoryIndices, totalCategoryCount);
            axisTotal.append("\n\t           or (_TYPE_='").append(rowAxisTotalMask).append("'b)");
        }
        axisTotal.append(";\n");
        StringBuffer subTotal = new StringBuffer();
        subTotal.append("\t_celltotal_ = ( _TYPE_='").append(cellTotalsMask).append("'b);\n");
        subTotal.append("\t_subtotal_ = not ( _axistotal_ or _cellTotal_ );\n");
        boolean writtenAxisTotal = false;
        boolean writtenSubTotal = false;
        Iterator<DataItem> iterator = fractionItems.iterator();
        while (iterator.hasNext()) {
            DataItem dataItem;
            DataItem fractionItem = dataItem = iterator.next();
            FractionOfTotalExpression fractionExpr = (FractionOfTotalExpression)fractionItem.getExpression();
            String changeCriteria = FractionOfTotalStep.generateDenominatorChangeCriteria(dsProcessor, rolapInfo, fractionExpr);
            String aliasStem = fractionItem.getResultSetID();
            String numRsid = FractionOfTotalStep.getFractionOfTotalNumeratorId(aliasStem, dsProcessor, dataSelection, fractionItem);
            String newd = FractionOfTotalStep.createAlias(tooLongAlias, "_newd_", aliasStem);
            String denom = FractionOfTotalStep.createAlias(tooLongAlias, "_denom_", aliasStem);
            String fotAlias = dsProcessor.generateDataStepVar(aliasStem);
            String numAlias = dsProcessor.generateDataStepVar(numRsid);
            String newdAlias = dsProcessor.generateDataStepVar(newd);
            String denomAlias = dsProcessor.generateDataStepVar(denom);
            String fractionFormat = GenerationUtil.generateFormatEqStatement(fractionItem);
            String fractionLabel = GenerationUtil.generateLabelEqStatement(fractionItem);
            boolean disabledXT = DisabledTotalsBuilder.isDisabledTotaling(dataSelection, fractionItem, TotalingType.AXISTOTAL);
            boolean disabledST = DisabledTotalsBuilder.isDisabledTotaling(dataSelection, fractionItem, TotalingType.SUBTOTAL);
            if ((disabledXT || disabledST) && !writtenAxisTotal) {
                dataStep.append(axisTotal);
                writtenAxisTotal = true;
            }
            if (disabledST && !writtenSubTotal) {
                dataStep.append(subTotal);
                writtenSubTotal = true;
            }
            dataStep.append("\t/* ********* a denominator for a fraction ********* */\n");
            dataStep.append("\tretain " + denomAlias + " 1.00;\n");
            dataStep.append("\tattrib " + fotAlias + fractionFormat + fractionLabel + ";\n");
            dataStep.append("\n");
            dataStep.append("\t" + newdAlias + " = " + changeCriteria + ";\n");
            dataStep.append("\n");
            dataStep.append("\tif " + newdAlias + " then " + denomAlias + " = " + numAlias + ";\n");
            dataStep.append("\tif " + denomAlias + " = 0 then\n");
            dataStep.append("\t\t" + fotAlias + " = .;\n");
            if (disabledXT) {
                dataStep.append("\telse if _axistotal_ then\n");
                dataStep.append("\t\t").append(fotAlias).append(" = .;\n");
            }
            if (disabledST) {
                dataStep.append("\telse if _subtotal_ then\n");
                dataStep.append("\t\t").append(fotAlias).append(" = .;\n");
            }
            dataStep.append("\telse\n");
            dataStep.append("\t\t" + fotAlias + " = " + numAlias + " / " + denomAlias + ";\n");
            dataStep.append("\n");
        }
        dataStep.append("\n");
        dataStep.append("\tdrop _bit_: _newd_: _denom_:;\n");
        if (writtenAxisTotal) {
            dataStep.append("\tdrop _subtotal_ _cellTotal_;\n");
        }
        if (writtenSubTotal) {
            dataStep.append("\tdrop _axistotal_;\n");
        }
        dataStep.append("run;\n");
        return dataStep;
    }

    private static String createAlias(Map<String, String> aliasMap, String prefix, String stem) {
        String testAlias = prefix + stem;
        if (testAlias.length() > 31) {
            String newAlias = prefix + "ID" + aliasMap.size();
            aliasMap.put(testAlias, newAlias);
            testAlias = newAlias;
        } else {
            aliasMap.put(testAlias, testAlias);
        }
        return testAlias;
    }

    protected static String getFractionOfTotalNumeratorId(String aliasStem, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, DataItem item) throws GenerationException {
        String varName = FractionOfGrandTotalStep.generateFoTInputVarName(aliasStem, dsProcessor, dataSelection, item);
        return varName;
    }

    private static String generateDenominatorChangeCriteria(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, FractionOfTotalExpression fractionExpr) throws GenerationException {
        String changeCriteria;
        int denominatorType = fractionExpr.getDenominatorType();
        switch (denominatorType) {
            case 0: {
                DataItem denominator = fractionExpr.getDenominator();
                changeCriteria = FractionOfTotalStep.createSubtotalCriteria(dsProcessor, rolapInfo, denominator);
                break;
            }
            case 1: {
                changeCriteria = CHANGE_CRITERIA_GRAND_TOTAL;
                break;
            }
            case 2: {
                changeCriteria = FractionOfTotalStep.createChangeCriteria(dsProcessor, rolapInfo, 1);
                break;
            }
            case 3: {
                changeCriteria = FractionOfTotalStep.createChangeCriteria(dsProcessor, rolapInfo, 0);
                break;
            }
            default: {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalStep.getFractionOfTotalItems.UnknownDenominatorType.fmt.txt", denominatorType);
                throw new GenerationException(mft);
            }
        }
        return changeCriteria;
    }

    private static String createSubtotalCriteria(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, DataItem denominator) throws GenerationException {
        String changeCriteria;
        List<DataItem> hiddenCategories = rolapInfo.getHiddenCategoryItems();
        if (hiddenCategories != null && hiddenCategories.contains(denominator)) {
            changeCriteria = CHANGE_CRITERIA_GRAND_TOTAL;
        } else {
            String identifier = dsProcessor.generateDataStepVar(denominator.getResultSetID());
            changeCriteria = CHANGE_CRITERIA_SUBTOTAL + identifier;
        }
        return changeCriteria;
    }

    private static String createChangeCriteria(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, int axis) throws GenerationException {
        String changeCriteria;
        List<DataItem> opposingCategories = rolapInfo.getAxisInformation(axis).getCategoryDataItems();
        if (opposingCategories.isEmpty()) {
            changeCriteria = CHANGE_CRITERIA_GRAND_TOTAL;
        } else {
            DataItem denominator = opposingCategories.get(opposingCategories.size() - 1);
            String identifier = dsProcessor.generateDataStepVar(denominator.getResultSetID());
            changeCriteria = CHANGE_CRITERIA_SUBTOTAL + identifier;
        }
        return changeCriteria;
    }

    private static List<DataItem> getFractionOfTotalItems(ROLAPBuilderInformation rolapInfo, boolean compareAgainstColumns) throws GenerationException {
        ArrayList<DataItem> currentAxisComparisonCategories = compareAgainstColumns ? new ArrayList<DataItem>(rolapInfo.getAxisInformation(1).getCategoryDataItems()) : new ArrayList<DataItem>(rolapInfo.getAxisInformation(0).getCategoryDataItems());
        List<DataItem> hiddenCategories = rolapInfo.getHiddenCategoryItems();
        ArrayList<DataItem> matchingFractions = new ArrayList<DataItem>();
        List<DataItem> fractionItems = FractionOfTotalUtilImpl.getFractionOfTotalItems(rolapInfo.getDataSelection());
        for (DataItem fractionItem : fractionItems) {
            FractionOfTotalExpression fractionExpression = (FractionOfTotalExpression)fractionItem.getExpression();
            boolean compareAgainstThisAxis = false;
            int denominatorType = fractionExpression.getDenominatorType();
            switch (denominatorType) {
                case 1: {
                    if (!compareAgainstColumns) break;
                    compareAgainstThisAxis = true;
                    break;
                }
                case 3: {
                    if (!compareAgainstColumns) break;
                    compareAgainstThisAxis = true;
                    break;
                }
                case 2: {
                    if (compareAgainstColumns) break;
                    compareAgainstThisAxis = true;
                    break;
                }
                case 0: {
                    DataItem denominator = fractionExpression.getDenominator();
                    if (!currentAxisComparisonCategories.contains(denominator) && !hiddenCategories.contains(denominator)) break;
                    compareAgainstThisAxis = true;
                    break;
                }
                default: {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalStep.getFractionOfTotalItems.UnknownDenominatorType.fmt.txt", denominatorType);
                    throw new GenerationException(mft);
                }
            }
            if (!compareAgainstThisAxis) continue;
            matchingFractions.add(fractionItem);
        }
        return matchingFractions;
    }

    private static void addHierarchies(List<SQLComponentAbstract> code, RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, boolean sortColumnsFirst, String summaryTempTable, String summaryHierTable) throws GenerationException {
        SQLStatementFactory.addText(code, "\n\n");
        SQLStatementFactory.addStartProcSql(code, dsProcessor, true, null);
        SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
        SQLStatementFactory.addCreateTableAs(code, dsProcessor, summaryHierTable);
        StringBuffer sql = FractionOfTotalStep.generateHierarchiesQuery(dsProcessor, rolapInfo, sortColumnsFirst, summaryTempTable);
        SQLStatementFactory.addText(code, sql);
        SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
        SQLStatementFactory.addEndProcSql(code, dsProcessor);
        SQLStatementFactory.addText(code, "\n\n");
    }

    private static StringBuffer generateHierarchiesQuery(RolapDataSelectionProcessor dsProcessor, ROLAPBuilderInformation rolapInfo, boolean sortColumnsFirst, String summaryTempTable) throws GenerationException {
        int[] nArray;
        StringBuffer sql = new StringBuffer("  select *");
        int categoryCount = rolapInfo.getCategoryCount();
        String[] categoryIds = rolapInfo.getCategoryIds();
        categoryCount = categoryIds.length;
        for (int i = 0; i < categoryCount; ++i) {
            sql.append(",\n");
            String categoryId = categoryIds[i];
            String bitCategoryId = dsProcessor.generateColumnIdentifier("_bit_" + categoryId);
            int bitIndex = 33 - categoryCount + i;
            sql.append("         substring(put(_type_, binary32.) from " + bitIndex + " for 1) as " + bitCategoryId + " length=1");
        }
        sql.append("\n    from " + summaryTempTable);
        sql.append("\n   order by ");
        if (sortColumnsFirst) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 0;
        }
        int[] axisIndices = nArray;
        ArrayList<String> usedCatIds = new ArrayList<String>();
        boolean needSeparator = false;
        for (int axisIndex : axisIndices) {
            ROLAPBuilderInformation.AxisInformation axisInfo = rolapInfo.getAxisInformation(axisIndex);
            String[] columnIds = axisInfo.getCategoryIds();
            int lineStart = FractionOfTotalStep.addToken(sql, null, 0, 200, "\n", "\n               ");
            for (String categoryId : columnIds) {
                if (needSeparator) {
                    lineStart = FractionOfTotalStep.addToken(sql, ", ", lineStart, 200, "\n", "\n               ");
                } else {
                    needSeparator = true;
                }
                String strAliasBit = dsProcessor.generateColumnIdentifier("_bit_" + categoryId);
                String strAliasCat = dsProcessor.generateColumnIdentifier(categoryId);
                lineStart = FractionOfTotalStep.addToken(sql, strAliasBit, lineStart, 200, "\n", "\n               ");
                lineStart = FractionOfTotalStep.addToken(sql, ", ", lineStart, 200, "\n", "\n               ");
                lineStart = FractionOfTotalStep.addToken(sql, strAliasCat, lineStart, 200, "\n", "\n               ");
                usedCatIds.add(categoryId);
            }
        }
        Object object = rolapInfo.getHiddenCategoryItems().iterator();
        while (object.hasNext()) {
            DataItem hiddenCategory = (DataItem)object.next();
            String rsid = hiddenCategory.getResultSetID();
            if (usedCatIds.contains(rsid)) continue;
            String[] columnIds = new String[]{rsid};
            int lineStart = FractionOfTotalStep.addToken(sql, null, 0, 200, "\n", "\n               ");
            for (String categoryId : columnIds) {
                if (needSeparator) {
                    lineStart = FractionOfTotalStep.addToken(sql, ", ", lineStart, 200, "\n", "\n               ");
                } else {
                    needSeparator = true;
                }
                String strAliasBit = dsProcessor.generateColumnIdentifier("_bit_" + categoryId);
                String strAliasCat = dsProcessor.generateColumnIdentifier(categoryId);
                lineStart = FractionOfTotalStep.addToken(sql, strAliasBit, lineStart, 200, "\n", "\n               ");
                lineStart = FractionOfTotalStep.addToken(sql, ", ", lineStart, 200, "\n", "\n               ");
                lineStart = FractionOfTotalStep.addToken(sql, strAliasCat, lineStart, 200, "\n", "\n               ");
                usedCatIds.add(categoryId);
            }
        }
        return sql;
    }

    private static int addToken(StringBuffer code, String token, int lineStart, int maxLineLen, String newLine, String startNewLine) {
        if (token != null) {
            if (code.length() - lineStart + token.length() > maxLineLen) {
                code.append(startNewLine);
                lineStart = 0;
            }
            code.append(token);
        }
        if ((lineStart = code.lastIndexOf(newLine)) == -1) {
            lineStart = 0;
        }
        return lineStart;
    }
}

