/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.IQueryServicesRuntimeException;
import com.sas.iquery.execution.util.BasicFileBackedList;
import com.sas.iquery.execution.util.Chunk;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Axis;
import com.sas.iquery.strategies.sas.oma.summaryrolap.dbmetadata.Tuple;
import com.sas.storage.olap.OLAPException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileBackedAxisTupleList
extends BasicFileBackedList {
    private Axis _axis;
    private static final Logger _logger = LogManager.getLogger(FileBackedAxisTupleList.class);

    private FileBackedAxisTupleList() throws IOException {
    }

    public FileBackedAxisTupleList(int chunkSize, Axis axis) throws IOException {
        super(chunkSize);
        this._axis = axis;
    }

    protected Chunk performLoad(int newChunkNumber) throws IOException, ClassNotFoundException {
        Chunk loadedChunk = super.performLoad(newChunkNumber);
        int tupleCount = loadedChunk.getSize();
        for (int i = 0; i < tupleCount; ++i) {
            Tuple tuple = (Tuple)loadedChunk.get(i);
            if (tuple == null) continue;
            try {
                tuple.setAxis(this._axis);
                continue;
            }
            catch (OLAPException e) {
                _logger.error("Could not set the Axis", (Throwable)e);
                throw new IQueryServicesRuntimeException("Could not set the Axis", (Throwable)e);
            }
        }
        return loadedChunk;
    }
}

