/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.summaryrolap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AxisTupleCriteria {
    private List<String> _criteriaValues;
    private Role _criteriaAxisRole;
    private ROLAPBuilderInformation _rolapInfo;
    private DataItem _measure;

    public AxisTupleCriteria(ROLAPBuilderInformation rolapInfo, List<? extends Object> qualifiers) throws MetadataException, GenerationException {
        this._rolapInfo = rolapInfo;
        int measureIndex = AxisTupleCriteria.findMeasure(qualifiers);
        Object lastElement = null;
        if (measureIndex >= 0) {
            lastElement = qualifiers.get(measureIndex);
        }
        if (!(lastElement instanceof DataItem)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("AxisTupleCriteria.LastElementOfQualifierListNotDataItem.fmt.txt", lastElement);
            throw new GenerationException(mft);
        }
        this._measure = (DataItem)lastElement;
        DataSelection dataSelection = rolapInfo.getDataSelection();
        this._criteriaAxisRole = dataSelection.getResultItemRole(this._measure);
        ArrayList<? extends Object> qualifiersWithoutMeasure = new ArrayList<Object>(qualifiers);
        qualifiersWithoutMeasure.remove(measureIndex);
        this._criteriaValues = this.convertStringExpressions(qualifiersWithoutMeasure);
    }

    public Role getAxisRole() {
        return this._criteriaAxisRole;
    }

    public List<String> getNonTotalCriteriaValues() {
        ArrayList<String> filteredList = new ArrayList<String>(this._criteriaValues.size());
        for (String criteria : this._criteriaValues) {
            if (AxisTupleCriteria.isSubtotalOrTotalCriteria(criteria)) continue;
            filteredList.add(criteria);
        }
        return filteredList;
    }

    public int makeRowColumnType() throws MetadataException {
        DataSelection dataSelection = this._rolapInfo.getDataSelection();
        int type = 0;
        List<DataItem> categories = this._rolapInfo.getCategoryItems();
        for (DataItem category : categories) {
            Role categoryRole = dataSelection.getResultItemRole(category);
            if (this._criteriaAxisRole != null && this._criteriaAxisRole.equals(categoryRole)) {
                if (this.hasCriteriaExceptForTotalOrSubtotal(category)) {
                    type = (type << 1) + 1;
                    continue;
                }
                type <<= 1;
                continue;
            }
            type = (type << 1) + 1;
        }
        return type;
    }

    public List<DataItem> getCategoriesWithNonTotalValueCriteria() throws GenerationException, MetadataException {
        ArrayList<DataItem> categoriesOnTheSameAxisExceptTotals = new ArrayList<DataItem>();
        DataSelection dataSelection = this._rolapInfo.getDataSelection();
        boolean isOutputResultRole = Role.isOutputResultRole(dataSelection, this._criteriaAxisRole);
        if (!isOutputResultRole) {
            ArrayList<DataItem> allCat = new ArrayList<DataItem>();
            List<DataItem> one = this._rolapInfo.getAxisInformation(0).getCategoryDataItems();
            List<DataItem> two = this._rolapInfo.getAxisInformation(1).getCategoryDataItems();
            allCat.addAll(one);
            allCat.addAll(two);
            for (DataItem category : allCat) {
                if (!this.hasCriteriaExceptForTotalOrSubtotal(category)) continue;
                categoriesOnTheSameAxisExceptTotals.add(category);
            }
        } else {
            int axisIndex = Role.COLUMN.equals(this._criteriaAxisRole) ? 0 : 1;
            List<DataItem> categoriesOnTheSameAxis = this._rolapInfo.getAxisInformation(axisIndex).getCategoryDataItems();
            for (DataItem category : categoriesOnTheSameAxis) {
                if (!this.hasCriteriaExceptForTotalOrSubtotal(category)) continue;
                categoriesOnTheSameAxisExceptTotals.add(category);
            }
        }
        return categoriesOnTheSameAxisExceptTotals;
    }

    public DataItem getMeasure() {
        return this._measure;
    }

    public static boolean isSubtotalOrTotalCriteria(String criteria) {
        String value = criteria.substring(criteria.lastIndexOf("[") + 1, criteria.lastIndexOf("]"));
        return value.startsWith("&T") || value.startsWith("&S");
    }

    private boolean hasCriteriaExceptForTotalOrSubtotal(DataItem category) throws MetadataException {
        String resultSetId = category.getResultSetID();
        for (String criteria : this.getNonTotalCriteriaValues()) {
            String resultsetIDFromCriteria = criteria.substring(3, criteria.indexOf("]"));
            if (!resultSetId.equals(resultsetIDFromCriteria)) continue;
            return true;
        }
        return false;
    }

    private List<String> convertStringExpressions(Collection<? extends Object> criteriaExpressions) throws MetadataException, GenerationException {
        ArrayList<String> stringCriteria = new ArrayList<String>();
        for (Object object : criteriaExpressions) {
            if (object instanceof String) {
                stringCriteria.add((String)object);
                continue;
            }
            if (object instanceof StringExpression) {
                stringCriteria.add(((StringExpression)object).getText());
                continue;
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AxisBuildingAndSortingStep.initializeMeasureSortInfo.InvalidSortSpecification.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        return stringCriteria;
    }

    static int findMeasure(List<? extends Object> qualifiers) {
        int measureIndex = qualifiers.size() - 1;
        for (int i = 0; i < qualifiers.size(); ++i) {
            DataItem dataItem;
            Object object = qualifiers.get(i);
            if (!(object instanceof DataItem) || (dataItem = (DataItem)object).getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            measureIndex = i;
            break;
        }
        return measureIndex;
    }
}

