/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.sff.composite;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLSASFFOverriddenExpression
extends SQLExpressionAbstract {
    private boolean isFormattingForcedOverridden;
    private boolean formattingForcedOverrideValue;
    private boolean isCharacterFormattedWhenNoFormat;
    private static final Logger _logger = LogManager.getLogger(SQLSASFFOverriddenExpression.class);

    @Override
    public void prepareSQL() throws GenerationException {
    }

    @Override
    public String writeSQL() {
        return null;
    }

    public SQLSASFFOverriddenExpression(boolean isFormattingForcedOverridden, boolean formattingForcedOverrideValue, boolean isCharacterFormattedWhenNoFormat) {
        _logger.debug("SQLSASFFOverriddenExpression created");
        this.isFormattingForcedOverridden = isFormattingForcedOverridden;
        this.formattingForcedOverrideValue = formattingForcedOverrideValue;
        this.isCharacterFormattedWhenNoFormat = isCharacterFormattedWhenNoFormat;
    }

    @Override
    public boolean isPUTFunctionApplicable(DataItem item) throws GenerationException {
        boolean flag = super.isPUTFunctionApplicable(item);
        return this.getOverride(item, flag);
    }

    private boolean getOverride(DataItem item, boolean flag) {
        if (this.isFormattingForcedOverridden) {
            flag = this.formattingForcedOverrideValue;
        }
        if (flag && !this.isCharacterFormattedWhenNoFormat && item.getFormat() == null && item.getExpressionTypeIgnoringFormattingForced() == 3) {
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean forceFormatItemDeclaration(DataItem item) throws GenerationException {
        return false;
    }

    @Override
    public boolean forceFormatItemReference(DataItem item) throws GenerationException {
        boolean flag = super.forceFormatItemReference(item);
        return this.getOverride(item, flag);
    }

    protected String generateDataItemsExpressionSQL(DataItem item, int exprDoR, Map exprValues) throws GenerationException {
        ExpressionInterface expression = item.getExpression();
        SQLExpressionAbstract sqlExprAbs = this.getSQLFactory().createSQLExpression();
        sqlExprAbs.setSQLFactory(this.getSQLFactory());
        sqlExprAbs.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlExprAbs.setDataSelection(this._dataSelection);
        sqlExprAbs.setJoinGenerator(this.m_joinGenerator);
        return sqlExprAbs.generateExpressionSQL(expression, exprDoR, exprValues);
    }
}

