/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.generation2.MetadataDataSource;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.SASWorkspaceServer;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.physical.inmemory.InMemoryQueryTable;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.ApplyForcedFormattingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.DistinctDataStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalMetadataDataSource;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.RelationalTable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TempLibnameGeneration {
    private static final String SASIOIME_ENGINENAME = "SASIOIME";
    private static final String SASSPDS_ENGINENAME = "SASSPDS";
    private static final String SPDTEMP_LIBNAME = "SPDTEMP";
    private static final String LIBGEN_OPTIONS = "LIBGEN=YES";
    private static final String WORK = "WORK";
    private static final List<String> MEMBER_TYPES_VIEW = Arrays.asList("VIEW");
    private static final String SPDS_TEMP_OPTIONS = "TEMP=YES";
    private static final String SPDS_IP_OPTIONS = "IP=YES";
    private String _tempLibnameStatement;
    private String _tempLibname;
    private final LinkedHashSet<InMemoryQueryTable> _inMemoryQueryTables = new LinkedHashSet();
    private final LinkedHashSet<SASLibrary> _qtLibraries = new LinkedHashSet();
    private boolean _isUseExplicitSPDS = false;
    private boolean _isSpdsIpEnabled = false;
    private boolean _hasSPDSLibrary = false;
    private boolean _isIMLE = false;
    private boolean _isUseConnectionTo = false;
    private boolean _usesView = false;
    private boolean _allowsView = true;
    private String _connectStatement = null;
    private final DataSelectionProcessorAbstract _processor;
    private static final Logger _logger = LogManager.getLogger(TempLibnameGeneration.class);

    public TempLibnameGeneration(DataSelectionProcessorAbstract processor) {
        this._processor = processor;
    }

    public void populateTempLibnames(DataSelection dataSelection) throws GenerationException {
        try {
            ArrayList<SASLibrary> libraryList = new ArrayList<SASLibrary>();
            RelationalMetadataDataSource metadataDataSource = new RelationalMetadataDataSource(this._processor);
            ((MetadataDataSource)metadataDataSource).initializeData();
            List<DataSource> dataSources = metadataDataSource.getUniqueDataSources();
            for (DataSource dataSource : dataSources) {
                if (!(dataSource instanceof DataSourceTable)) continue;
                DataSourceTable dataSourceTable = (DataSourceTable)dataSource;
                Table table = dataSourceTable.getTable();
                if (table instanceof OMAWrapper) {
                    OMAWrapper omaWrapper = (OMAWrapper)((Object)table);
                    CMetadata omaObject = omaWrapper.getOMAObject();
                    if (!(omaObject instanceof RelationalTable)) continue;
                    RelationalTable relationalTable = (RelationalTable)omaObject;
                    try {
                        String memberType = relationalTable.getMemberType();
                        if (!MEMBER_TYPES_VIEW.contains(memberType)) continue;
                        this._usesView = true;
                    }
                    catch (RemoteException e) {
                        this._usesView = true;
                        if (!_logger.isEnabled(Level.WARN)) continue;
                        _logger.warn(e.toString(), (Throwable)e);
                    }
                    continue;
                }
                if (!(table instanceof InMemoryQueryTable)) continue;
                InMemoryQueryTable qt = (InMemoryQueryTable)table;
                this._inMemoryQueryTables.add(qt);
                this._qtLibraries.addAll(qt.getLibraries());
            }
            libraryList.addAll(metadataDataSource.getLibraryList());
            for (SASLibrary sasLibrary : libraryList) {
                String engine;
                if (sasLibrary.isPreassigned() || (engine = sasLibrary.getEngine()) == null) continue;
                String engineName = engine.toUpperCase();
                if (engineName.equals(SASIOIME_ENGINENAME)) {
                    this._isIMLE = true;
                    continue;
                }
                if (!engineName.equals(SASSPDS_ENGINENAME)) continue;
                this._hasSPDSLibrary = true;
            }
            boolean disableExplicitPassThrough = false;
            boolean useConnectionTo = false;
            boolean tempIsSASSPDS = false;
            SASLibrary spdsTempLibrary = this.getSpdsTempLibrary(libraryList);
            if (spdsTempLibrary == null) {
                disableExplicitPassThrough = true;
            } else {
                tempIsSASSPDS = true;
                if (this._tempLibname == null) {
                    this._hasSPDSLibrary = true;
                    this._tempLibname = SPDTEMP_LIBNAME;
                    this._tempLibnameStatement = this.generateTempLibnameStatement(dataSelection, this._tempLibname, spdsTempLibrary);
                    this._isSpdsIpEnabled = this._tempLibnameStatement.toUpperCase().indexOf(SPDS_IP_OPTIONS) != -1;
                }
                this._isUseExplicitSPDS = this._tempLibnameStatement != null;
            }
            if (tempIsSASSPDS) {
                CreateTableDataSelection ctds;
                RelationalSchema ctdsSchema;
                DataSelection possibleCTDS = this._processor.getActualDataSelection();
                if (possibleCTDS instanceof CreateTableDataSelection && (ctdsSchema = (ctds = (CreateTableDataSelection)possibleCTDS).getRelationalSchemaForCreation()) instanceof SASLibrary) {
                    SASLibrary dsServerLibrary;
                    SASLibrary ctdsSasLibrary = (SASLibrary)ctdsSchema;
                    String ctdsSasLibRef = ctdsSasLibrary.getLibref();
                    boolean foundEngine = false;
                    Server dsServer = this.getServer(dataSelection);
                    if (dsServer instanceof SASWorkspaceServer && (dsServerLibrary = this.findLibrary((SASWorkspaceServer)dsServer, ctdsSasLibRef)) != null) {
                        foundEngine = true;
                        String dsServerEngine = dsServerLibrary.getEngine();
                        boolean dsServerIsSPDS = dsServerEngine.equalsIgnoreCase(SASSPDS_ENGINENAME);
                        if (!dsServerIsSPDS) {
                            useConnectionTo = true;
                        }
                    }
                    if (this._isUseExplicitSPDS && !foundEngine) {
                        boolean isTempLib;
                        boolean bl = isTempLib = this._tempLibname != null && this._tempLibname.equalsIgnoreCase(ctdsSasLibRef);
                        if (!isTempLib) {
                            useConnectionTo = true;
                        }
                    }
                }
                if (useConnectionTo) {
                    this._isUseExplicitSPDS = false;
                    this._isUseConnectionTo = true;
                }
                if (this.isOrderByComplex(dataSelection)) {
                    disableExplicitPassThrough = true;
                }
                if (this.isLibgenEqualNoForAnyLibrary(libraryList)) {
                    disableExplicitPassThrough = true;
                }
                if (this.isRolapQuery(dataSelection)) {
                    disableExplicitPassThrough = true;
                }
                if (useConnectionTo || disableExplicitPassThrough || !this._isUseExplicitSPDS) {
                    this._allowsView = false;
                }
            }
            if (disableExplicitPassThrough) {
                this._isUseExplicitSPDS = false;
                this._connectStatement = null;
                this._isUseConnectionTo = false;
                this._tempLibname = null;
                this._tempLibnameStatement = null;
            }
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RelationalDataSelectionProcessor.getTempTablename.MetadataException.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
    }

    private boolean isSameDBMSServer(SASLibrary tempLibrary, SASLibrary dataLibrary) throws MetadataException {
        boolean isSamePort;
        boolean isSameServer = false;
        String tempHost = tempLibrary.getDBMSHost();
        String dataHost = dataLibrary.getDBMSHost();
        String tempPort = tempLibrary.getDBMSPort();
        String dataPort = dataLibrary.getDBMSPort();
        boolean isSameHost = tempHost != null && dataHost != null && tempHost.equals(dataHost);
        boolean bl = isSamePort = tempPort != null && dataPort != null && tempPort.equals(dataPort);
        if (isSameHost && isSamePort) {
            isSameServer = true;
        }
        return isSameServer;
    }

    private boolean isOrderByComplex(DataSelection dataSelection) throws GenerationException {
        boolean isComplex = false;
        if (dataSelection != null) {
            List<DataItem> sortByItems = dataSelection.getEffectiveSortOrderPrecedence();
            for (DataItem item : sortByItems) {
                if (item.isCalculatedItem()) {
                    isComplex = true;
                    continue;
                }
                DataItemActionType sort = item.getSortDirection();
                boolean hasSortDirection = sort != null && sort != DataItemActionType.SORT_NONE;
                boolean sortByFormattedValue = GenerationUtil.useFormattedValueForSorting(item);
                if (hasSortDirection && sortByFormattedValue) {
                    isComplex = true;
                    continue;
                }
                String sortFormat = GenerationUtil.getSortFormat(item);
                if (sortFormat == null) continue;
                isComplex = true;
            }
        }
        return isComplex;
    }

    private boolean isLibgenEqualNoForAnyLibrary(List<SASLibrary> libraryList) throws MetadataException {
        boolean isLibgenEqualNo = false;
        for (SASLibrary sasLibrary : libraryList) {
            String tempLibname;
            if (sasLibrary.isPreassigned() || (tempLibname = sasLibrary.getLibnameStatement()).toUpperCase().indexOf(LIBGEN_OPTIONS) != -1) continue;
            isLibgenEqualNo = true;
            break;
        }
        return isLibgenEqualNo;
    }

    private String generateTempLibnameStatement(DataSelection query, String tempLibName, SASLibrary dataLibrary) throws MetadataException, GenerationException {
        String tempLibnameStatement;
        SASLibrary omrDefinedTempLibrary = null;
        Server server = this.getServer(query);
        if (server instanceof SASWorkspaceServer) {
            SASWorkspaceServer workspaceServer = (SASWorkspaceServer)server;
            List<SASLibrary> serverLibraries = workspaceServer.getSasLibraries();
            SASLibrary firstSpdTempLib = null;
            boolean compatibleServer = false;
            for (SASLibrary testLibrary : serverLibraries) {
                if (!testLibrary.getEngine().equalsIgnoreCase(SASSPDS_ENGINENAME) || !testLibrary.getLibref().equalsIgnoreCase(tempLibName)) continue;
                if (this.isSameDBMSServer(testLibrary, dataLibrary)) {
                    omrDefinedTempLibrary = testLibrary;
                    compatibleServer = true;
                    break;
                }
                if (firstSpdTempLib != null) continue;
                firstSpdTempLib = testLibrary;
            }
            if (!compatibleServer) {
                omrDefinedTempLibrary = firstSpdTempLib;
            }
        }
        if (omrDefinedTempLibrary == null) {
            String libnameStatement = dataLibrary.getLibnameStatement().replaceFirst(dataLibrary.getLibref(), tempLibName);
            tempLibnameStatement = libnameStatement = libnameStatement.replaceFirst(";", " TEMP=YES;");
        } else if (!omrDefinedTempLibrary.isPreassigned()) {
            tempLibnameStatement = omrDefinedTempLibrary.getLibnameStatement();
            if (tempLibnameStatement.toUpperCase().indexOf(SPDS_TEMP_OPTIONS) == -1) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("TempLibnameGeneration.generateLibnameStatement.notTempLibname.fmt.txt", omrDefinedTempLibrary.getLabel(), SPDS_TEMP_OPTIONS);
                throw new GenerationException(formatter);
            }
        } else {
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn("Temporary library " + omrDefinedTempLibrary.getLabel() + " cannot be verified to have TEMP=YES because it is pre-assigned.");
            }
            tempLibnameStatement = null;
        }
        return tempLibnameStatement;
    }

    public boolean isUseExplicitSPDS() {
        return this._isUseExplicitSPDS;
    }

    public boolean isSpdsIpEnabled() {
        return this._isSpdsIpEnabled;
    }

    public boolean hasSPDSLibrary() {
        return this._hasSPDSLibrary;
    }

    public boolean isIMLE() {
        return this._isIMLE;
    }

    public boolean isUseConnectionTo() {
        return this._isUseConnectionTo;
    }

    public String getTempLibname() throws GenerationException {
        if (this._tempLibname == null) {
            return WORK;
        }
        return this._tempLibname;
    }

    public Collection<String> getLibnameStatements() throws GenerationException {
        ArrayList<String> libraryList;
        if (this._tempLibnameStatement == null && this._qtLibraries.isEmpty()) {
            libraryList = Collections.emptyList();
        } else {
            libraryList = new ArrayList();
            if (this._tempLibnameStatement != null) {
                libraryList.add(this._tempLibnameStatement);
            }
            for (SASLibrary l : this._qtLibraries) {
                try {
                    String s = l.getLibnameStatement();
                    if (s == null || l instanceof InMemorySASLibrary && "SASIOLA".equalsIgnoreCase(l.getEngine()) && s.toUpperCase().contains("STARTSERVER")) continue;
                    libraryList.add(s);
                }
                catch (MetadataException e) {
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("TempLibnameGeneration.Library.MetadataException.txt", new Object[0]);
                    throw new GenerationException(formatter, (Throwable)e);
                }
            }
        }
        return libraryList;
    }

    @Nonnull
    public List<String> getQueryTablesTexts() throws GenerationException {
        ArrayList<String> texts = new ArrayList<String>();
        for (InMemoryQueryTable u : this._inMemoryQueryTables) {
            try {
                String fullQueryText = u.getFullQueryText(false, false);
                texts.add(fullQueryText);
            }
            catch (MetadataException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("TempLibnameGeneration.InMemoryQueryTable.MetadataException.txt", new Object[0]);
                throw new GenerationException(formatter, (Throwable)e);
            }
        }
        return texts;
    }

    @Nonnull
    public List<String> getQueryTablesPrepareLogs() throws GenerationException {
        ArrayList<String> logs = new ArrayList<String>();
        for (InMemoryQueryTable u : this._inMemoryQueryTables) {
            String text = u.getPrepareLog();
            if (text.trim().length() <= 0) continue;
            String outputSchemaName = u.getOutputSchemaName();
            String tableName = u.getLabel();
            StringBuffer s = new StringBuffer();
            s.append("/** --- log of previously run prepare for ");
            if (outputSchemaName != null) {
                s.append(outputSchemaName).append('.');
            }
            s.append(tableName).append(" --- **/\n");
            s.append(text);
            s.append("/** ---- end prepare log --- **/\n");
            logs.add(s.toString());
        }
        return logs;
    }

    public boolean isTempTable(DataSelection dataSelection) {
        boolean isSetOp = dataSelection instanceof SetOperationDataSelection;
        boolean inlineSetOp = dataSelection.getQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION);
        boolean doNotInlineSetOp = isSetOp && !inlineSetOp;
        boolean isChildQuery = this._processor.getAllSubqueries().contains(dataSelection);
        boolean isDistinctNeeded = DistinctDataStep.isNeeded(dataSelection, isChildQuery);
        boolean isFFStepNeeded = ApplyForcedFormattingStep.isNeeded(dataSelection, isChildQuery);
        boolean isTsSqlDecoratorNeeded = false;
        boolean createTable = doNotInlineSetOp || isDistinctNeeded || isFFStepNeeded || isTsSqlDecoratorNeeded;
        return createTable;
    }

    public String getSPDSConnectStatement() {
        return this._connectStatement;
    }

    private Server getServer(BusinessModel bm) {
        Server out = null;
        List<DataSource> dataSources = bm.getObjects(true, DataSource.class);
        if (dataSources.size() > 0) {
            DataSource ds = dataSources.get(0);
            out = ds.getServer();
        }
        return out;
    }

    public boolean usesView() {
        return this._usesView;
    }

    public boolean isCreateViewAllowed() throws GenerationException {
        return this._allowsView;
    }

    private boolean isRolapQuery(DataSelection dataSelection) throws MetadataException {
        boolean isROLAP = false;
        if (dataSelection != null) {
            isROLAP = !dataSelection.getResultItems(Role.ROW).isEmpty();
        }
        return isROLAP;
    }

    private SASLibrary getSpdsTempLibrary(List<SASLibrary> libraryList) throws MetadataException {
        SASLibrary spdsTempLibrary = null;
        for (SASLibrary sasLibrary : libraryList) {
            boolean isCompatibleServer;
            String engine;
            if (sasLibrary.isPreassigned() || (engine = sasLibrary.getEngine()) == null) continue;
            String engineName = engine.toUpperCase();
            if (!engineName.equals(SASSPDS_ENGINENAME)) {
                spdsTempLibrary = null;
                break;
            }
            String localStatement = sasLibrary.getConnectStatementForExplicitPassThru(null);
            if (this._connectStatement == null) {
                this._connectStatement = localStatement;
            }
            if (!(isCompatibleServer = localStatement.equals(this._connectStatement))) {
                spdsTempLibrary = null;
                break;
            }
            spdsTempLibrary = sasLibrary;
            break;
        }
        return spdsTempLibrary;
    }

    private SASLibrary findLibrary(SASWorkspaceServer workspaceServer, String sasLibRef) throws MetadataException {
        SASLibrary foundLibrary = null;
        List<SASLibrary> dsServerLibraries = workspaceServer.getSasLibraries();
        for (SASLibrary dsServerLibrary : dsServerLibraries) {
            String dsServerLibref = dsServerLibrary.getLibref();
            if (!dsServerLibref.equalsIgnoreCase(sasLibRef)) continue;
            foundLibrary = dsServerLibrary;
            break;
        }
        return foundLibrary;
    }
}

