/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLEmptyOrderBy;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLOrderByAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SetOperationDataSelectionSASComposite
extends SQLSASComposite {
    final Map<DataSelection, SQLOrderByAbstract> orderByClauses = new LinkedHashMap<DataSelection, SQLOrderByAbstract>();
    DataSelection originalSetOpDataSelection = null;

    @Override
    public void prepareSQL() throws GenerationException {
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        SQLComponentAbstract sqlSetOperator = this._generateSetOperator();
        SetOperationDataSelection setOpDS = (SetOperationDataSelection)this._dataSelection;
        List<DataSelection> childDataSelections = setOpDS.getDataSelections();
        this.originalSetOpDataSelection = this._dataSelection;
        if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
            String label = this._dataSelection.getLabel();
            if (label == null || label.trim().length() == 0) {
                label = this._dataSelection.getID();
            }
            label = label.replaceAll("[*][/]", "* /");
            SQLStatementFactory.addText(this.getCompositeList(), "/* SetOp: " + label + ", op=" + setOpDS.getSetOperation() + " (w/" + childDataSelections.size() + " children) */\n");
        }
        int i = 0;
        Iterator<DataSelection> childDSIter = childDataSelections.iterator();
        while (childDSIter.hasNext()) {
            ++i;
            DataSelection dschildDataSelection = childDSIter.next();
            this.setDataSelection(dschildDataSelection);
            boolean createTable = dsProcessor.isTempTable(dschildDataSelection);
            if (createTable) {
                String tempTableName = dsProcessor.getTempTableName(dschildDataSelection);
                StringBuffer sqlString = new StringBuffer();
                if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
                    String childLabel = dschildDataSelection.getLabel();
                    if (childLabel == null || childLabel.trim().length() == 0) {
                        childLabel = dschildDataSelection.getID();
                    }
                    childLabel = childLabel.replaceAll("[*][/]", "* /");
                    sqlString.append("/* " + i + ". " + childLabel + " */\n");
                }
                sqlString.append("Select ");
                String prefix = "";
                List<SelectedItem> selectedItems = dschildDataSelection.getSelectedItems();
                for (SelectedItem si : selectedItems) {
                    Role role = si.getRole();
                    if (!Role.isOutputResultRole(dschildDataSelection, role)) continue;
                    DataItem di = si.getItem();
                    String alias = dsProcessor.generateColumnIdentifier(di.getResultSetID());
                    sqlString.append(prefix).append(alias);
                    prefix = ",\n\t";
                }
                sqlString.append("\nfrom ");
                sqlString.append(tempTableName);
                SQLStatementFactory.addText(this.getCompositeList(), sqlString);
                this._generateOrderBy();
            } else {
                super.prepareSQL();
            }
            if (!childDSIter.hasNext()) continue;
            this.addComponent(sqlSetOperator);
        }
        this.setDataSelection(this.originalSetOpDataSelection);
        SQLOrderByAbstract parent = (SQLOrderByAbstract)super._generateOrderBy();
        if (parent != null && !parent.getSortColumns().isEmpty()) {
            this.addComponent(parent);
        } else {
            DataSelection lastChild = childDataSelections.get(childDataSelections.size() - 1);
            SQLOrderByAbstract last = this.orderByClauses.get(lastChild);
            if (last != null && !last.getSortColumns().isEmpty()) {
                this.addComponent(last);
            } else {
                DataSelection firstChild = childDataSelections.get(0);
                SQLOrderByAbstract first = this.orderByClauses.get(firstChild);
                if (first != null && !first.getSortColumns().isEmpty()) {
                    this.addComponent(first);
                }
            }
        }
    }

    @Override
    protected SQLComponentAbstract _generateOrderBy() throws GenerationException {
        SQLComponentAbstract orderByClause = super._generateOrderBy();
        this.orderByClauses.put(this._dataSelection, (SQLOrderByAbstract)orderByClause);
        return new SQLEmptyOrderBy();
    }
}

