/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFactoryInterface;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLLimitAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringAdapterComponent;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcDataSets;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.CreateViewOrTableStatement;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.DropTableStatement;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SQLStatementFactory {
    private static final Logger _logger = LogManager.getLogger(SQLStatementFactory.class);

    public static void addText(List<SQLComponentAbstract> compositeList, String text) {
        compositeList.add(new CodeStringAdapterComponent(text));
    }

    public static void addText(List<SQLComponentAbstract> compositeList, StringBuffer text) {
        compositeList.add(new CodeStringAdapterComponent(text));
    }

    public static void addText(List<SQLComponentAbstract> compositeList, StringBuilder text) {
        compositeList.add(new CodeStringAdapterComponent(text));
    }

    public static String getProcSqlOptions(boolean isTsSql, DataSelection dataSelection) {
        return SQLStatementFactory.getProcSqlOptions(isTsSql, dataSelection, true, true);
    }

    public static String getProcSqlOptions(boolean isTsSql, DataSelection dataSelection, boolean useInObs, boolean useOutObs) {
        List<Governing> governingOptions;
        StringBuffer options = new StringBuffer();
        if (dataSelection != null && !(governingOptions = dataSelection.getEffectiveRules(Governing.class)).isEmpty()) {
            int inObs;
            int outObs;
            Governing governing = governingOptions.get(0);
            int n = outObs = !isTsSql && useOutObs ? governing.getOutputObservations() : -1;
            if (outObs != -1) {
                options.append("Outobs=" + outObs);
            }
            int n2 = inObs = !isTsSql && useInObs ? governing.getInputObservations() : -1;
            if (outObs != -1 && inObs != -1) {
                options.append(" ");
            }
            if (inObs != -1) {
                options.append("Inobs=" + inObs);
            }
        }
        return options.toString();
    }

    public static void addStartProcSql(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, boolean allowTsSql, String options) throws GenerationException {
        boolean useConnectTo = false;
        boolean useResetOptions = false;
        boolean useProcSqlOptions = false;
        if (options != null) {
            options = options.trim();
        }
        if (options != null && options.length() > 0) {
            useProcSqlOptions = true;
        }
        if (_logger.isDebugEnabled()) {
            SQLStatementFactory.addText(compositeList, "/* start proc sql */");
        }
        StringBuffer startProcText = new StringBuffer();
        boolean useTsSql = false;
        if (dsProcessor != null && allowTsSql && dsProcessor.isTSSQL()) {
            useTsSql = true;
        }
        if (dsProcessor != null && (dsProcessor.isSPDS() || dsProcessor.isUseConnectionTo())) {
            useConnectTo = true;
            if (options != null && options.length() > 0) {
                useResetOptions = true;
                useProcSqlOptions = false;
            }
        }
        if (useTsSql) {
            startProcText.append("PROC TSSQL");
        } else {
            startProcText.append("PROC SQL");
        }
        if (useProcSqlOptions) {
            startProcText.append(' ').append(options);
        }
        startProcText.append(";\n");
        SQLStatementFactory.addText(compositeList, startProcText.toString());
        if (useConnectTo) {
            String connectStatement = dsProcessor.getSPDSConnectStatement();
            SQLStatementFactory.addText(compositeList, connectStatement);
            SQLStatementFactory.addText(compositeList, "\n");
        }
        if (useResetOptions) {
            SQLStatementFactory.addText(compositeList, " execute(reset " + options + ") by sasspds;\n");
        }
    }

    public static void addEndProcSql(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        if (_logger.isDebugEnabled()) {
            SQLStatementFactory.addText(compositeList, "/* quit proc sql */");
        }
        if (dsProcessor == null || dsProcessor.isSPDS() || dsProcessor.isUseConnectionTo()) {
            // empty if block
        }
        SQLStatementFactory.addText(compositeList, "quit;\n");
    }

    public static void addStartSqlStatement(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        if (_logger.isDebugEnabled()) {
            SQLStatementFactory.addText(compositeList, "/* start sql */");
        }
        if (dsProcessor != null && dsProcessor.isSPDS() && !dsProcessor.isUseConnectionTo()) {
            SQLStatementFactory.addText(compositeList, " execute(\n");
        }
    }

    public static void addEndSqlStatement(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        if (_logger.isDebugEnabled()) {
            SQLStatementFactory.addText(compositeList, "/* end sql */");
        }
        if (dsProcessor == null) {
            SQLStatementFactory.addText(compositeList, ";\n");
        } else if (dsProcessor.isUseConnectionTo()) {
            SQLStatementFactory.addText(compositeList, ");\n");
        } else if (dsProcessor.isSPDS()) {
            SQLStatementFactory.addText(compositeList, ") by sasspds;\n");
        } else {
            SQLStatementFactory.addText(compositeList, ";\n");
        }
    }

    public static String addCreateTableAs(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, String tableName) throws GenerationException {
        return SQLStatementFactory.addCreateAs(compositeList, dsProcessor, tableName, false);
    }

    public static String addCreateViewAs(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, String viewName) throws GenerationException {
        return SQLStatementFactory.addCreateAs(compositeList, dsProcessor, viewName, true);
    }

    public static String addCreateAs(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, String viewOrTableName, boolean isView) throws GenerationException {
        if (viewOrTableName == null) {
            DataSelection dataSelection = dsProcessor.getDataSelection();
            viewOrTableName = dsProcessor.getTempTableName(dataSelection);
            dsProcessor.setTempTableIsView(dataSelection, isView);
        }
        CreateViewOrTableStatement createStatement = new CreateViewOrTableStatement(viewOrTableName, isView);
        createStatement.setDataSelectionProcessor(dsProcessor);
        createStatement.prepareSQL();
        compositeList.add(createStatement);
        if (dsProcessor != null && dsProcessor.isUseConnectionTo()) {
            SQLStatementFactory.addText(compositeList, "\n SELECT * FROM CONNECTION TO SASSPDS (\n");
        }
        return viewOrTableName;
    }

    public static void addDropTableByName(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, String tableName) throws GenerationException {
        SQLStatementFactory.addDropTableOrViewByName(compositeList, dsProcessor, tableName, false);
    }

    public static void addDropViewByName(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, String viewName) throws GenerationException {
        SQLStatementFactory.addDropTableOrViewByName(compositeList, dsProcessor, viewName, true);
    }

    public static void addDropTableOrViewByName(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, String tableOrViewName, boolean isView) throws GenerationException {
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        if (isView) {
            SQLStatementFactory.addText(compositeList, "Drop view " + tableOrViewName);
        } else {
            SQLStatementFactory.addText(compositeList, "Drop table " + tableOrViewName);
        }
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
    }

    public static void addDropTableStatement(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection targetDataSelection) throws GenerationException {
        DropTableStatement dropStatement = new DropTableStatement();
        dropStatement.setDataSelection(targetDataSelection);
        dropStatement.setDataSelectionProcessor(dsProcessor);
        dropStatement.prepareSQL();
        if (dropStatement.writeSQL().trim().length() > 0) {
            compositeList.add(dropStatement);
        }
    }

    public static void addProcDataSetsRename(List<SQLComponentAbstract> compositeList, String fromTableName, String toTableName) throws GenerationException {
        SQLStatementFactory.addText(compositeList, ProcDataSets.generateRename(fromTableName, toTableName));
    }

    public static void addProcDeleteDataByName(List<SQLComponentAbstract> code, DataSelectionProcessorAbstract dsProcessor, String dataTableName) {
        StringBuffer procDelete = new StringBuffer();
        procDelete.append("PROC Delete data = " + dataTableName + ";run;\n");
        SQLStatementFactory.addText(code, procDelete);
    }

    public static void addNewLine(List<SQLComponentAbstract> code) {
        SQLStatementFactory.addText(code, "\n");
    }

    public static void addLimit(List compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, SQLFactoryInterface factory, boolean isTsSQL, int limit) throws GenerationException {
        if (isTsSQL) {
            SQLLimitAbstract sqlLimit = (SQLLimitAbstract)factory.createSQLLimit();
            sqlLimit.setDataSelection(dataSelection);
            sqlLimit.setDataSelectionProcessor(dsProcessor);
            if (limit != -1) {
                sqlLimit.setLimit(limit);
            }
            sqlLimit.prepareSQL();
            compositeList.add(sqlLimit);
        }
    }
}

