/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFactoryInterface;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcSQLDecorator;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.ApplyForcedFormattingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.CreateTablePostProcessingStatement;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.CreateTablePreProcessingStatement;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.DistinctDataStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SPDSCompositeAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class RelationalSASComposite
extends SPDSCompositeAbstract {
    public RelationalSASComposite() {
    }

    public RelationalSASComposite(DataSelectionProcessorAbstract dataSelectionProcessor) {
        this.setDataSelectionProcessor(dataSelectionProcessor);
    }

    @Override
    public void prepareSQL() throws GenerationException {
        if (this._dataSelection instanceof CreateTableDataSelection) {
            CreateTablePreProcessingStatement preStatement = new CreateTablePreProcessingStatement();
            preStatement.setDataSelection(this._dataSelection);
            preStatement.prepareSQL();
            this._preprocessingCompositeList.add(preStatement);
        }
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        DataSelection dataSelection = dsProcessor.getDataSelection();
        LinkedHashSet<DataSelection> childQueries = new LinkedHashSet<DataSelection>(dsProcessor.getAllSubqueries());
        LinkedHashSet<DataSelection> dsrqs = new LinkedHashSet<DataSelection>(dsProcessor.getDSRQSubqueries());
        Iterator iterator = childQueries.iterator();
        while (iterator.hasNext()) {
            boolean childNeedsTempTable;
            DataSelection childQuery = (DataSelection)iterator.next();
            if (dsrqs.contains(childQuery) || (childNeedsTempTable = dsProcessor.isTempTable(childQuery))) continue;
            iterator.remove();
        }
        String options = SQLStatementFactory.getProcSqlOptions(this._dataSelectionProcessor.isTSSQL(), this._dataSelection);
        SQLStatementFactory.addStartProcSql(this._startProcSql, dsProcessor, true, options);
        boolean inProcSQL = true;
        List<SQLComponentAbstract> compositeList = this.getCompositeList();
        SQLFactoryInterface factory = this.getSQLFactory();
        for (DataSelection childDataSelection : childQueries) {
            boolean isFFStepNeeded;
            boolean isDistinctNeeded;
            boolean createTable = dsProcessor.isTempTable(childDataSelection);
            if (!createTable) continue;
            String outputTableName = dsProcessor.getTempTableName(childDataSelection);
            SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, outputTableName);
            SQLComponentAbstract sqlChildComposite = factory.createSQLChildComposite(childDataSelection);
            sqlChildComposite.setDataSelectionProcessor(dsProcessor);
            sqlChildComposite.prepareSQL();
            compositeList.add(sqlChildComposite);
            List<SQLColumnAbstract> sqlColumns = sqlChildComposite.getSQLColumns();
            SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addDropTableStatement(compositeList, dsProcessor, childDataSelection);
            if (dsProcessor.isTSSQL()) {
                SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                inProcSQL = false;
                ProcSQLDecorator tsSqlFixup = new ProcSQLDecorator(childDataSelection, outputTableName);
                tsSqlFixup.setSQLColumns(sqlColumns);
                tsSqlFixup.setDataSelectionProcessor(dsProcessor);
                tsSqlFixup.setSQLFactory(factory);
                tsSqlFixup.prepareSQL();
                compositeList.add(tsSqlFixup);
            }
            if (isDistinctNeeded = DistinctDataStep.isNeeded(childDataSelection, true)) {
                SQLStatementFactory.addText(compositeList, "\n/* enforcing distinct output for child query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
                inProcSQL = DistinctDataStep.addCode(compositeList, dsProcessor, childDataSelection, true, outputTableName, outputTableName, inProcSQL);
            }
            if (!(isFFStepNeeded = ApplyForcedFormattingStep.isNeeded(childDataSelection, true))) continue;
            SQLStatementFactory.addText(compositeList, "\n/* creating formatted output for child query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
            inProcSQL = ApplyForcedFormattingStep.addCode(compositeList, dsProcessor, childDataSelection, true, outputTableName, outputTableName, inProcSQL, false);
        }
        if (!inProcSQL) {
            String options2 = SQLStatementFactory.getProcSqlOptions(dsProcessor.isTSSQL(), dataSelection);
            SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, options2);
            inProcSQL = true;
        }
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        String tableName = null;
        boolean isView = false;
        if (this._dataSelection instanceof CreateTableDataSelection) {
            CreateTableDataSelection parentDataSelection = (CreateTableDataSelection)this._dataSelection;
            RelationalSchema schema = parentDataSelection.getRelationalSchemaForCreation();
            if (!(schema instanceof SASLibrary)) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("RelationalSASComposite.prepareSQL.NonSAS.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            SASLibrary tempSasLibrary = (SASLibrary)schema;
            String libname = null;
            try {
                libname = tempSasLibrary.getLibref();
            }
            catch (MetadataException e) {
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("RelationalSASComposite.prepareSQL.MetadataException.txt", new Object[0]), (Throwable)e);
            }
            tableName = libname + "." + dsProcessor.generateTableIdentifier(parentDataSelection.getName());
            isView = parentDataSelection.isView();
            dsProcessor.putTempTableName(this._dataSelection, tableName);
            dsProcessor.setTempTableIsView(this._dataSelection, isView);
        } else {
            tableName = dsProcessor.getTempTableName(this._dataSelection);
            isView = dsProcessor.getTempTableIsView(this._dataSelection);
        }
        if (dsProcessor.isSPDS() && !dsProcessor.isTempViewAllowed()) {
            isView = false;
            dsProcessor.setTempTableIsView(this._dataSelection, isView);
        }
        SQLStatementFactory.addCreateAs(compositeList, dsProcessor, tableName, isView);
        SQLComponentAbstract sqlChildComposite = factory.createSQLChildComposite(dataSelection);
        sqlChildComposite.setDataSelectionProcessor(dsProcessor);
        sqlChildComposite.prepareSQL();
        compositeList.add(sqlChildComposite);
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addDropTableStatement(compositeList, dsProcessor, dataSelection);
        SQLStatementFactory.addEndProcSql(this._endProcSql, dsProcessor);
        this._postprocessingCompositeListInProcSQL = false;
        boolean isChildQuery = this.getDataSelectionProcessor().getAllSubqueries().contains(dataSelection);
        if (!isChildQuery) {
            if (dsProcessor.isTSSQL()) {
                if (this._postprocessingCompositeListInProcSQL) {
                    SQLStatementFactory.addEndProcSql(this._postprocessingCompositeList, dsProcessor);
                    this._postprocessingCompositeListInProcSQL = false;
                }
                List<SQLColumnAbstract> sqlColumns = sqlChildComposite.getSQLColumns();
                ProcSQLDecorator tsSqlFixup = new ProcSQLDecorator(dataSelection, tableName);
                tsSqlFixup.setSQLColumns(sqlColumns);
                tsSqlFixup.setDataSelectionProcessor(dsProcessor);
                tsSqlFixup.setSQLFactory(factory);
                tsSqlFixup.prepareSQL();
                this._postprocessingCompositeList.add(tsSqlFixup);
            }
            boolean isDistinctNeeded = DistinctDataStep.isNeeded(this._dataSelection, isChildQuery);
            boolean isFFStepNeeded = ApplyForcedFormattingStep.isNeeded(dataSelection, isChildQuery);
            if (isDistinctNeeded) {
                SQLStatementFactory.addText((List<SQLComponentAbstract>)this._postprocessingCompositeList, "\n/* enforcing distinct output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
                this._postprocessingCompositeListInProcSQL = DistinctDataStep.addCode(this._postprocessingCompositeList, this.getDataSelectionProcessor(), dataSelection, isChildQuery, tableName, tableName, this._postprocessingCompositeListInProcSQL);
            }
            if (isFFStepNeeded) {
                SQLStatementFactory.addText((List<SQLComponentAbstract>)this._postprocessingCompositeList, "\n/* creating formatted output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
                this._postprocessingCompositeListInProcSQL = ApplyForcedFormattingStep.addCode(this._postprocessingCompositeList, this.getDataSelectionProcessor(), dataSelection, isChildQuery, tableName, tableName, this._postprocessingCompositeListInProcSQL, false);
            }
        }
        if (this._postprocessingCompositeListInProcSQL) {
            SQLStatementFactory.addEndProcSql(this._postprocessingCompositeList, this.getDataSelectionProcessor());
            this._postprocessingCompositeListInProcSQL = false;
        }
        if (this._dataSelection instanceof CreateTableDataSelection) {
            CreateTablePostProcessingStatement postStatement = new CreateTablePostProcessingStatement();
            postStatement.setDataSelection(this._dataSelection);
            postStatement.prepareSQL();
            this._postprocessingCompositeList.add(postStatement);
        }
    }
}

