/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.FilterSetMember;
import com.sas.iquery.metadata.business.FilterSetRuleItems;
import com.sas.iquery.metadata.business.FilterSetRules;
import com.sas.iquery.metadata.business.FilterSetRulesContainer;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.RequiredDataSources;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.business.impl.FilterSetRuleItemsImpl;
import com.sas.iquery.metadata.business.impl.FilterSetRulesImpl;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.business.impl.JoinPathGeneratorImpl;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGenerationInterface;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.PrefilteredDataSelectionDecorator;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.PrefilteredDsrqDecorator;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilterSetQueryGeneration {
    private List<DataSource> _effectiveDataSources;
    private DataSelection _dataSelection;
    private Map<DataSourceTable, DataSourceRelationalQuery> _dataSourceSubQueryDataSourceMap = new LinkedHashMap<DataSourceTable, DataSourceRelationalQuery>();
    private FilterSetRules _explicitFilterListMap = new FilterSetRulesImpl();
    private FilterSetRules _completePreFilterListMap = new FilterSetRulesImpl();
    private DataSelection _generatedDataSelection;
    private Map _referencedColumns = new WeakHashMap();
    private int _countOfSubs = 0;
    private Map _pcValuesByModel = new IdentityHashMap();
    private static final Logger _logger = LogManager.getLogger(FilterSetQueryGeneration.class);

    public void setEffectiveDataSources(List<DataSource> effectiveDataSources) {
        this._effectiveDataSources = effectiveDataSources;
    }

    public void setDataSelection(DataSelection ds) {
        block2: {
            try {
                this.setDataSelection(ds, false);
            }
            catch (MetadataException me) {
                if (!_logger.isEnabled(Level.ERROR)) break block2;
                _logger.error(me.getLocalizedMessage());
            }
        }
    }

    public List<FilterItem> getPostFilters() throws GenerationException, MetadataException {
        ArrayList<FilterItem> filters = new ArrayList<FilterItem>();
        for (DataSource dataSource : this._effectiveDataSources) {
            if (dataSource instanceof FilterSetMember) {
                FilterSetMember fsm = (FilterSetMember)((Object)dataSource);
                FilterSetRuleItems postfilters = this._getExplicitDataSourcePostFilters(fsm);
                FilterSetRuleItemsImpl.mergeIntoFilterList(this._dataSelection, filters, postfilters);
                continue;
            }
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("getPostFilters: " + dataSource + " is not a FilterSetMember.");
        }
        return filters;
    }

    public void setDataSelection(DataSelection ds, boolean overrideEffectiveDataSources) throws MetadataException {
        this._dataSelection = ds;
        this._explicitFilterListMap.clear();
        this._completePreFilterListMap.clear();
        this._dataSourceSubQueryDataSourceMap.clear();
        if (overrideEffectiveDataSources) {
            this._effectiveDataSources = ds.getEffectiveDataSources();
        }
    }

    public DataSelection getDataSelection() {
        return this._dataSelection;
    }

    public DataSelection getGeneratedDataSelection() throws GenerationException, MetadataException {
        if (this._generatedDataSelection == null) {
            this._generatedDataSelection = this._generateFilteredDataSelection();
        }
        return this._generatedDataSelection;
    }

    public static boolean canHandle(DataSelection selection, List effectiveDataSources) throws GenerationException, MetadataException {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Testing canHandle for prefiltered: " + selection);
        }
        if (selection instanceof PrefilteredDsrqDecorator) {
            return false;
        }
        if (selection instanceof PrefilteredDataSelectionDecorator) {
            return false;
        }
        ArrayList pcValues = new ArrayList();
        for (BusinessModel model = selection; model != null; model = model.getParentBusinessModel()) {
            pcValues.clear();
            if (model instanceof InformationMapImpl2) {
                ((InformationMapImpl2)model).getOmrPermissionConditions(pcValues);
            }
            for (DataSource dataSource : effectiveDataSources) {
                List<Object> prefilters;
                if (!(dataSource instanceof FilterSetMember)) continue;
                FilterSetRuleItems prefilterList = null;
                if (model instanceof FilterSetRulesContainer) {
                    prefilterList = ((FilterSetRulesContainer)((Object)model)).getCombinedFilterSetRuleList((FilterSetMember)((Object)dataSource), pcValues);
                }
                if (prefilterList == null || (prefilters = prefilterList.getList()) == null || prefilters.size() <= 0) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("canHandle: Found PreFilter: " + prefilters);
                }
                return true;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Not prefiltered - ignore");
        }
        return false;
    }

    private DataSelection _generateFilteredDataSelection() throws GenerationException, MetadataException {
        DataSelection selection = null;
        if (this._effectiveDataSources == null) {
            this._effectiveDataSources = this._dataSelection == null ? this.getDataSelection().getEffectiveDataSources() : this._dataSelection.getEffectiveDataSources();
        }
        selection = this._generateFilteredDataSelection(this._effectiveDataSources);
        return selection;
    }

    private DataSelection _generateFilteredDataSelection(List<? extends DataSource> effectiveDataSources) throws GenerationException, MetadataException {
        this._dataSourceSubQueryDataSourceMap.clear();
        this._explicitFilterListMap.clear();
        this._completePreFilterListMap.clear();
        DataSelection selection = this.getDataSelection();
        this._initializeReferencedColumns(selection);
        Model newDS = null;
        try {
            for (DataSource dataSource : this._effectiveDataSources) {
                FilterSetRuleItems prefilters;
                if (!(dataSource instanceof FilterSetMember) || (prefilters = this._getExplicitDataSourcePreFilters((FilterSetMember)((Object)dataSource))) == null || prefilters.size() <= 0) continue;
                if (newDS == null) {
                    List<Prompt> prompts = prefilters.getResources(Prompt.class, -1);
                    for (Prompt prompt : prompts) {
                        PromptDefinitionInterface pd = prompt.getPromptDefinition();
                        List di = pd.getReferencedResources(DataItem.class, true);
                        if (di == null || di.isEmpty()) continue;
                        throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("FilterSetQueryGeneration._generateFilteredDataSelection.DynamicPromptCannotBaseOnDateItem.txt", new Object[0]));
                    }
                    newDS = DataSelectionFactory.newDataSelection(selection);
                    String newDS_ID = selection.generateIntraModelID(selection.getID() + "_newDS" + this._countOfSubs++);
                    newDS.setID(newDS_ID);
                    newDS.setLabel(newDS_ID);
                    this._copyPromptValues(this.getDataSelection(), (DataSelection)newDS);
                }
                if (dataSource instanceof DataSourceTable) {
                    DataSelection filteredSubQuery = this._createFilteredSubQuery((DataSelection)newDS, (DataSourceTable)dataSource, (FilterSetMember)((Object)dataSource), prefilters);
                    PrefilteredDataSelectionDecorator decoratedSubQuery = new PrefilteredDataSelectionDecorator(filteredSubQuery);
                    DataSourceRelationalQuery dsrq = this._createDataSourceRelationalQuery((DataSelection)newDS, decoratedSubQuery);
                    this._copyPromptValues(this.getDataSelection(), (DataSelection)newDS);
                    PrefilteredDsrqDecorator decoratedDsrq = new PrefilteredDsrqDecorator(dsrq);
                    this._dataSourceSubQueryDataSourceMap.put((DataSourceTable)dataSource, decoratedDsrq);
                    continue;
                }
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FilterSetQueryGeneration._generateFilteredDataSelection.CannotFilterNonRelationalTables.fmt.txt", dataSource.getLabel());
                throw new GenerationException(mft);
            }
        }
        catch (MetadataException e) {
            if (newDS != null) {
                newDS.dispose();
            }
            throw e;
        }
        catch (GenerationException e) {
            if (newDS != null) {
                newDS.dispose();
            }
            throw e;
        }
        if (newDS != null) {
            return newDS;
        }
        return selection;
    }

    private void _initializeReferencedColumns(DataSelection selection) throws MetadataException {
        this._referencedColumns.clear();
        this._fillInReferencedColumns(selection, this._referencedColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _fillInReferencedColumns(DataSelection selection, Map referencedColumnsMap) throws MetadataException {
        EffectiveObjectsCache effectiveObjectsCache = new EffectiveObjectsCache();
        try {
            List<QualifiedColumn> qColumns;
            List<DataItem> effectiveResultItems = effectiveObjectsCache.getEffectiveResultItems(selection);
            List<DataItem> effectiveSortOrderPrecedence = effectiveObjectsCache.getEffectiveSortOrderPrecedence(selection);
            List<FilterItem> effectiveFilters = effectiveObjectsCache.getEffectiveFilters(selection);
            List<Join> effectiveJoinPath = effectiveObjectsCache.getEffectiveJoinPath(selection);
            LinkedHashSet<QualifiedColumn> qualifiedColumns = new LinkedHashSet<QualifiedColumn>();
            for (FilterItem filterItem : effectiveFilters) {
                qColumns = filterItem.getResources(QualifiedColumn.class, 65531);
                qualifiedColumns.addAll(qColumns);
            }
            for (DataItem dataItem : effectiveResultItems) {
                qColumns = dataItem.getResources(QualifiedColumn.class, 65535);
                qualifiedColumns.addAll(qColumns);
            }
            for (Join join : effectiveJoinPath) {
                qColumns = join.getResources(QualifiedColumn.class, 65535);
                qualifiedColumns.addAll(qColumns);
            }
            for (DataItem dataItem : effectiveSortOrderPrecedence) {
                qColumns = dataItem.getResources(QualifiedColumn.class, 65535);
                qualifiedColumns.addAll(qColumns);
            }
            for (QualifiedColumn qualifiedColumn : qualifiedColumns) {
                DataSourceTable dst = qualifiedColumn.getDataSource();
                ArrayList<QualifiedColumn> referencedColumns = (ArrayList<QualifiedColumn>)this._referencedColumns.get(dst);
                if (referencedColumns == null) {
                    referencedColumns = new ArrayList<QualifiedColumn>();
                    referencedColumnsMap.put(dst, referencedColumns);
                }
                if (referencedColumns.contains(qualifiedColumn)) continue;
                referencedColumns.add(qualifiedColumn);
            }
        }
        finally {
            effectiveObjectsCache.clear();
        }
    }

    private DataSelection _createFilteredSubQuery(DataSelection parentQuery, DataSourceTable dataSourceTable, FilterSetMember filterSetMember, FilterSetRuleItems prefilters) throws GenerationException, MetadataException {
        Iterator<QualifiedColumn> additionalPrefilterList;
        boolean bl;
        if (_logger.isDebugEnabled()) {
            _logger.debug("FilterSetQueryGeneration._createFilteredSubQuery(" + parentQuery + "): dst=" + dataSourceTable + " fsm=" + filterSetMember + " fsri=" + prefilters);
        }
        DataSelection subQuery = DataSelectionFactory.newDataSelection(parentQuery);
        RelationalDataSelectionProcessor psuedoQueryDsp = null;
        if (_logger.isDebugEnabled()) {
            psuedoQueryDsp = new RelationalDataSelectionProcessor(subQuery);
        }
        subQuery.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        subQuery.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, true);
        String subQuery_ID = parentQuery.generateIntraModelID(parentQuery.getID() + "_subQuery" + this._countOfSubs++);
        subQuery.setID(subQuery_ID);
        subQuery.setLabel(subQuery_ID);
        if (_logger.isDebugEnabled()) {
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): initially removing all required DS from subQuery");
        }
        RequiredDataSources subQuerysRds = subQuery.newRequiredDataSources();
        subQuerysRds.setDataSources(Collections.emptyList());
        subQuery.addBusinessRule(subQuerysRds);
        this._copyPromptValues(this.getDataSelection(), subQuery);
        LinkedHashMap testForDistinctMap = new LinkedHashMap();
        this._fillInReferencedColumns(parentQuery, testForDistinctMap);
        if (testForDistinctMap.containsKey(dataSourceTable)) {
            subQuery.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        }
        AbstractBusinessModel model = (AbstractBusinessModel)((Object)subQuery);
        List<Column> referencedColumns = (List<Column>)this._referencedColumns.get(dataSourceTable);
        if (referencedColumns == null || referencedColumns.size() == 0) {
            referencedColumns = dataSourceTable.getColumns();
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): adding result items to " + subQuery);
        }
        for (QualifiedColumn qualifiedColumn : referencedColumns) {
            RootDataItem item = subQuery.newDataItem();
            String item_id = subQuery.generateIntraModelID("qry_refs_" + qualifiedColumn.getDataSource() + "_" + qualifiedColumn);
            item.setIntraModelID(item_id);
            item.setExpression(qualifiedColumn);
            item.setLabel(null);
            item.setFormat(null);
            String name = qualifiedColumn.getSasName();
            item.setResultSetID(name);
            subQuery.addBusinessItem(item);
            subQuery.addResultItem(item, Role.COLUMN);
            if (!_logger.isDebugEnabled()) continue;
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): added qc=" + qualifiedColumn.getIdentityString());
            _logger.debug("FSQG._cFSQ(" + parentQuery + "):       name=" + name);
            _logger.debug("FSQG._cFSQ(" + parentQuery + "):       table=" + qualifiedColumn.getDataSource());
        }
        ArrayList filters = new ArrayList();
        FilterSetRuleItemsImpl.mergeIntoFilterList(subQuery, filters, prefilters);
        subQuery.setFilters(filters);
        boolean bl2 = false;
        do {
            FilterSetMember[] members;
            List<DataSource> dataSources = subQuery.getEffectiveDataSources();
            FilterSetRules resultingDataSourcesAndFilterLists = this._getDataSourcesWithFilterLists(dataSources);
            for (FilterSetMember member : members = resultingDataSourcesAndFilterLists.getMembers()) {
                additionalPrefilterList = resultingDataSourcesAndFilterLists.get(member);
                additionalPrefilterList = FilterSetRuleItemsImpl.flattenFilterSetRuleItems((FilterSetRuleItems)((Object)additionalPrefilterList));
                bl = FilterSetRuleItemsImpl.mergeIntoFilterList(subQuery, filters, (FilterSetRuleItems)((Object)additionalPrefilterList));
            }
            if (!bl) continue;
            subQuery.setFilters(filters);
        } while (bl);
        if (_logger.isDebugEnabled()) {
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): query to check for data sources used after filters applied:\n " + this.toPseudoQuery(psuedoQueryDsp, subQuery));
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): filters found = " + filters);
        }
        FilterSetRuleItemsImpl newPfl = new FilterSetRuleItemsImpl(filters, false);
        this._completePreFilterListMap.put(filterSetMember, newPfl);
        JoinPathGeneratorImpl joinPathGenerator = new JoinPathGeneratorImpl(subQuery);
        List<BusinessModelObject> joinPath = joinPathGenerator.generateJoinPath();
        boolean isManySources = false;
        if (joinPath.size() > 0 && (joinPath.size() > 1 || joinPath.get(0) instanceof Join)) {
            isManySources = true;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): path=" + joinPath);
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): isManySources=" + isManySources);
        }
        if (isManySources) {
            subQuery.setFilters(Collections.emptyList());
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): subQuery query filters cleared");
            }
            DataSelection filterDS = DataSelectionFactory.newDataSelection(model);
            String filterDS_ID = subQuery.generateIntraModelID(parentQuery.getID() + "_filterDS" + this._countOfSubs++);
            filterDS.setID(filterDS_ID);
            filterDS.setLabel(filterDS_ID);
            filterDS.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
            filterDS.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
            filterDS.setQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA, true);
            this._copyPromptValues(this.getDataSelection(), filterDS);
            filterDS.setFilters(filters);
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): Filter query filters=" + filters);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): Original Data Source columns referenced in joins: ");
            }
            ArrayList<QualifiedColumn> usedColumns = new ArrayList<QualifiedColumn>();
            for (BusinessModelObject bmo : joinPath) {
                if (!(bmo instanceof Join)) continue;
                Join join = (Join)bmo;
                ConditionalExpression conditionalExpression = join.getJoinCondition();
                List<QualifiedColumn> columns = conditionalExpression.getResources(QualifiedColumn.class, 65535);
                for (int i = 0; i < columns.size(); ++i) {
                    QualifiedColumn qc = columns.get(i);
                    DataSourceTable dst = qc.getDataSource();
                    if (dst == null || !dst.equals(dataSourceTable) || usedColumns.contains(qc)) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("FSQG._cFSQ(" + parentQuery + "): " + i + ". " + dst + "." + qc + ", sasname=" + qc.getSasName() + ", dbmsname=" + qc.getDbmsName());
                    }
                    usedColumns.add(qc);
                }
            }
            for (QualifiedColumn qcFiltered : dataSourceTable.getQualifiedColumns()) {
                for (QualifiedColumn qualifiedColumn : referencedColumns) {
                    DataSourceTable dst = qualifiedColumn.getDataSource();
                    if (dst == null || !dst.getSasName().equals(dataSourceTable.getSasName()) || !qualifiedColumn.getSasName().equals(qcFiltered.getSasName()) || usedColumns.contains(qcFiltered)) continue;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("FSQG._cFSQ(" + parentQuery + "): adding because its referenced by filtering " + dataSourceTable + "." + qcFiltered + ", sasname=" + qcFiltered.getSasName() + ", dbmsname=" + qcFiltered.getDbmsName());
                    }
                    usedColumns.add(qcFiltered);
                }
            }
            additionalPrefilterList = usedColumns.iterator();
            while (additionalPrefilterList.hasNext()) {
                QualifiedColumn element;
                QualifiedColumn qc = element = additionalPrefilterList.next();
                DataSourceTable dataSourceTable2 = qc.getDataSource();
                RootDataItem di = filterDS.newDataItem();
                String di_id = filterDS.generateIntraModelID("join_refs_" + dataSourceTable2 + "_" + qc);
                di.setIntraModelID(di_id);
                di.setLabel(di_id);
                di.setExpression(qc);
                di.setUsage(DataItemActionType.USAGE_DETAIL);
                filterDS.addBusinessItem(di);
                DataItemReference dir = filterDS.newDataItemReference(di);
                filterDS.addBusinessItem(dir);
                dir.setLabel(qc.getSasName());
                dir.setResultSetID(qc.getSasName());
                filterDS.addResultItem(dir, Role.COLUMN);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): creating decoratedSubQuery2");
            }
            PrefilteredDataSelectionDecorator decoratedSubQuery2 = new PrefilteredDataSelectionDecorator(filterDS);
            DataSourceRelationalQuery dsrq = this._createDataSourceRelationalQuery(subQuery, decoratedSubQuery2);
            dsrq.setLabel(dsrq.getIntraModelID());
            ArrayList<DataSourceTable> subQuerysRequiredDataSources = new ArrayList<DataSourceTable>();
            subQuerysRequiredDataSources.add(dataSourceTable);
            subQuerysRequiredDataSources.add(dsrq);
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): assigning required DS to subQuery=" + subQuerysRequiredDataSources);
            }
            subQuerysRds.setDataSources(subQuerysRequiredDataSources);
            subQuery.addBusinessRule(subQuerysRds);
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): removing all required DS from filterDs");
            }
            RequiredDataSources requiredDataSources = filterDS.newRequiredDataSources();
            requiredDataSources.setDataSources(Collections.emptyList());
            filterDS.addBusinessRule(requiredDataSources);
            this._copyPromptValues(this.getDataSelection(), filterDS);
            if (_logger.isDebugEnabled()) {
                JoinPathGeneratorImpl joinPathGenerator2 = new JoinPathGeneratorImpl(filterDS);
                List<DataSource> uds = joinPathGenerator2.getUniqueDataSources();
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): Filter query unique data sources: " + uds);
                List<BusinessModelObject> path2 = joinPathGenerator2.generateJoinPath();
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): Filter query join path: " + path2);
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): Filter query:\n " + this.toPseudoQuery(psuedoQueryDsp, filterDS));
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): DSRQ of Filter query: " + dsrq);
            }
            List<QualifiedColumn> filterQueryColumns = dsrq.getQualifiedColumns();
            ArrayList<SimpleConditionalExpression_Comparison> joinConditionsList = new ArrayList<SimpleConditionalExpression_Comparison>();
            for (int i = 0; i < filterQueryColumns.size(); ++i) {
                QualifiedColumn column = filterQueryColumns.get(i);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("FSQG._cFSQ(" + parentQuery + "): " + i + ". " + column + ", sasname=" + column.getSasName() + ", dbmsname=" + column.getDbmsName());
                }
                SimpleConditionalExpression_Comparison comp = new SimpleConditionalExpression_Comparison();
                comp.setRightExpression(column);
                comp.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
                QualifiedColumn oldColumn = null;
                for (int j = 0; j < usedColumns.size(); ++j) {
                    QualifiedColumn tmp = (QualifiedColumn)usedColumns.get(j);
                    if (!tmp.getSasName().equals(column.getSasName())) continue;
                    oldColumn = tmp;
                    break;
                }
                if (oldColumn == null) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FilterSetQueryGeneration._createFilteredSubQuery.ColumnNotFoundInTable.fmt.txt", column.getSasName(), dataSourceTable.getSasName());
                    throw new GenerationException(mft);
                }
                comp.setLeftExpression(oldColumn);
                joinConditionsList.add(comp);
            }
            Join join = subQuery.newJoin();
            String joinID = subQuery.generateIntraModelID(subQuery.getID() + "_Join");
            join.setIntraModelID(joinID);
            join.setLabel(joinID);
            join.setType(JoinType.INNER);
            join.setLeftDataSource(dataSourceTable);
            join.setRightDataSource(dsrq);
            MultipleConditionalExpression mce = new MultipleConditionalExpression();
            mce.setRelationType(ConditionalRelationType.AND);
            mce.setExpressionList(joinConditionsList);
            join.setJoinCondition(mce);
            if (_logger.isDebugEnabled()) {
                _logger.debug("FSQG._cFSQ(" + parentQuery + "): new join=" + joinID);
                _logger.debug("FSQG._cFSQ(" + parentQuery + "):         from=" + dataSourceTable.getIdentityString());
                _logger.debug("FSQG._cFSQ(" + parentQuery + "):         to=" + dsrq.getIdentityString());
                _logger.debug("FSQG._cFSQ(" + parentQuery + "):         on=" + mce);
            }
            subQuery.addBusinessRule(join);
        }
        this._copyPromptValues(this.getDataSelection(), subQuery);
        if (_logger.isDebugEnabled()) {
            _logger.debug("FSQG._cFSQ(" + parentQuery + "): Final SubQuery:\n " + this.toPseudoQuery(psuedoQueryDsp, subQuery));
        }
        return subQuery;
    }

    private void _copyPromptValues(DataSelection parentQuery, DataSelection subQuery) throws GenerationException {
        PromptValuesInterface fromPromptValues = parentQuery.getPromptValues();
        PromptValuesInterface toPromptValues = subQuery.getPromptValues();
        Map fromValues = fromPromptValues.getPromptValues();
        for (PromptDefinitionInterface promptDefinition : fromValues.keySet()) {
            try {
                if (promptDefinition.isFixed() || !toPromptValues.getPromptGroup().hasPromptDefinition(promptDefinition)) continue;
                toPromptValues.setPromptValue(promptDefinition, fromValues.get(promptDefinition));
            }
            catch (InvalidPromptValueException e) {
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("FilterSetQueryGeneration._copyPromptValues.InvalidPromptValue.txt", new Object[0]), (Throwable)e);
            }
        }
    }

    private DataSourceRelationalQuery _createDataSourceRelationalQuery(DataSelection parentQuery, DataSelection subQuery) throws GenerationException, MetadataException {
        DataSourceRelationalQuery dsrq = parentQuery.newDataSourceRelationalQuery(subQuery);
        parentQuery.addDataSource(dsrq);
        return dsrq;
    }

    private FilterSetRules _getDataSourcesWithFilterLists(List dataSources) throws GenerationException, MetadataException {
        FilterSetRulesImpl dataSourcesWithFilters = new FilterSetRulesImpl();
        for (int i = 0; i < dataSources.size(); ++i) {
            FilterSetRuleItems addMoreFilters;
            DataSource dataSource = (DataSource)dataSources.get(i);
            if (!(dataSource instanceof FilterSetMember) || (addMoreFilters = this._getExplicitDataSourcePreFilters((FilterSetMember)((Object)dataSource))) == null || addMoreFilters.size() <= 0) continue;
            FilterSetRuleItems currentList = dataSourcesWithFilters.get((FilterSetMember)((Object)dataSource));
            if (currentList == null) {
                dataSourcesWithFilters.put((FilterSetMember)((Object)dataSource), addMoreFilters);
                continue;
            }
            ArrayList<Object> intersect = new ArrayList<Object>();
            if (currentList.isUnionList()) {
                intersect.add(currentList);
                intersect.add(addMoreFilters);
            } else {
                intersect.addAll(currentList.getList());
                if (addMoreFilters.isUnionList()) {
                    intersect.add(addMoreFilters);
                } else {
                    intersect.addAll(addMoreFilters.getList());
                }
            }
            dataSourcesWithFilters.put((FilterSetMember)((Object)dataSource), new FilterSetRuleItemsImpl(intersect, false));
        }
        return dataSourcesWithFilters;
    }

    private FilterSetRuleItems _getExplicitDataSourceFilters(FilterSetMember filterSetMember) throws GenerationException, MetadataException {
        FilterSetRuleItems filters = null;
        if (this._completePreFilterListMap.containsMember(filterSetMember)) {
            filters = this._completePreFilterListMap.get(filterSetMember);
        } else {
            ArrayList<FilterSetRuleItems> allFilterSetLists = new ArrayList<FilterSetRuleItems>();
            for (BusinessModel model = this.getDataSelection(); model != null; model = model.getParentBusinessModel()) {
                List<Object> prefilters;
                ArrayList pcValues = (ArrayList)this._pcValuesByModel.get(model);
                if (pcValues == null) {
                    pcValues = new ArrayList();
                    this._pcValuesByModel.put(model, pcValues);
                    if (model instanceof InformationMapImpl2) {
                        ((InformationMapImpl2)model).getOmrPermissionConditions(pcValues);
                    }
                }
                FilterSetRuleItems modelCombinedFilterSets = null;
                if (model instanceof FilterSetRulesContainer) {
                    modelCombinedFilterSets = ((FilterSetRulesContainer)((Object)model)).getCombinedFilterSetRuleList(filterSetMember, pcValues);
                }
                if (modelCombinedFilterSets == null || (prefilters = modelCombinedFilterSets.getList()) == null || prefilters.size() <= 0) continue;
                allFilterSetLists.add(modelCombinedFilterSets);
            }
            if (allFilterSetLists != null && allFilterSetLists.size() > 0) {
                if (allFilterSetLists.size() == 1) {
                    filters = (FilterSetRuleItems)allFilterSetLists.get(0);
                } else {
                    filters = new FilterSetRuleItemsImpl(allFilterSetLists, false);
                    filters = FilterSetRuleItemsImpl.flattenFilterSetRuleItems(filters);
                }
                this._completePreFilterListMap.put(filterSetMember, filters);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("explicit filters on: " + filterSetMember + " = " + filters);
        }
        return filters;
    }

    private FilterSetRuleItems _getExplicitDataSourcePreFilters(FilterSetMember filterSetMember) throws GenerationException, MetadataException {
        FilterSetRuleItems filters = this._getExplicitDataSourceFilters(filterSetMember);
        filters = FilterSetRuleItemsImpl.removePreOrPostFilters(filters, false);
        return filters;
    }

    private FilterSetRuleItems _getExplicitDataSourcePostFilters(FilterSetMember filterSetMember) throws GenerationException, MetadataException {
        FilterSetRuleItems filters = this._getExplicitDataSourceFilters(filterSetMember);
        if (filters != null) {
            filters = FilterSetRuleItemsImpl.removePreOrPostFilters(filters, true);
        }
        return filters;
    }

    public void fixupJoins(List originalJoins, JoinGenerationInterface joinGeneration) throws MetadataException, GenerationException, CloneNotSupportedException {
        for (int i = 0; i < originalJoins.size(); ++i) {
            DataSourceTable oldSourceRight;
            DataSourceTable newSourceRight;
            Object element = originalJoins.get(i);
            if (element instanceof DataSource) {
                DataSource newSource = this._dataSourceSubQueryDataSourceMap.get(element);
                if (newSource == null) continue;
                originalJoins.set(i, newSource);
                continue;
            }
            if (!(element instanceof Join)) continue;
            Join join = (Join)element;
            DataSourceTable oldSourceLeft = join.getLeftDataSource();
            DataSourceTable newSourceLeft = this._dataSourceSubQueryDataSourceMap.get(oldSourceLeft);
            Join replacementJoin = null;
            if (newSourceLeft != null && oldSourceLeft != newSourceLeft) {
                replacementJoin = (Join)join.clone();
                replacementJoin.setLeftDataSource(newSourceLeft);
            }
            if ((newSourceRight = (DataSourceTable)this._dataSourceSubQueryDataSourceMap.get(oldSourceRight = join.getRightDataSource())) != null && oldSourceRight != newSourceRight) {
                if (replacementJoin == null) {
                    replacementJoin = (Join)join.clone();
                }
                replacementJoin.setRightDataSource(newSourceRight);
            }
            if (replacementJoin == null) continue;
            originalJoins.set(i, replacementJoin);
        }
        for (Map.Entry<DataSourceTable, DataSourceRelationalQuery> entry : this._dataSourceSubQueryDataSourceMap.entrySet()) {
            DataSourceTable origTable = entry.getKey();
            DataSourceTable newSubQuery = entry.getValue();
            String origLabel = joinGeneration.getCorrelatedTableName(origTable);
            joinGeneration.addDuplicateCorrelatedTable(newSubQuery, origLabel);
        }
    }

    private String toPseudoQuery(DataSelectionProcessorAbstract dsp, DataSelection ds) {
        List<FilterItem> filters;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        if (ds.getQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES)) {
            stringBuffer.append("DISTINCT ");
        }
        ArrayList<DataItem> groupByList = new ArrayList<DataItem>();
        List<SelectedItem> items = ds.getSelectedItems();
        Iterator<SelectedItem> iter = items.iterator();
        while (iter.hasNext()) {
            SelectedItem si = iter.next();
            DataItem di = si.getItem();
            ExpressionInterface expr = di.getExpression();
            String text = this._expressionToText(expr);
            stringBuffer.append(text);
            String label = di.getLabel();
            if (label != null) {
                stringBuffer.append(" AS ");
                stringBuffer.append(label.indexOf(32) != -1 ? "'" + label + "'" : label);
            }
            if (di.getUsage() == DataItemActionType.USAGE_CATEGORY) {
                groupByList.add(di);
            }
            if (!iter.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM ");
        List<BusinessModelObject> path = null;
        try {
            JoinPathGeneratorImpl joinPathGenerator = new JoinPathGeneratorImpl(ds);
            path = joinPathGenerator.generateJoinPath(dsp.getEffectiveObjectsCache());
        }
        catch (MetadataException e) {
            stringBuffer.append("" + e);
        }
        if (path != null && path.size() > 0) {
            if (path.get(0) instanceof Join) {
                String joinText = null;
                HashMap<DataSourceTable, String> joinTexts = new HashMap<DataSourceTable, String>();
                for (BusinessModelObject obj : path) {
                    Join join = (Join)obj;
                    DataSourceTable left = join.getLeftDataSource();
                    DataSourceTable right = join.getRightDataSource();
                    String leftText = (String)joinTexts.get(left);
                    String rightText = (String)joinTexts.get(right);
                    if (leftText == null) {
                        leftText = this._dataSourceTableToText(dsp, left);
                    }
                    if (rightText == null) {
                        rightText = this._dataSourceTableToText(dsp, right);
                    }
                    joinText = leftText + " " + join.getType() + " " + rightText + " ON (" + this._expressionToText(join.getJoinCondition()) + ")";
                    joinTexts.put(left, joinText);
                    joinTexts.put(right, joinText);
                }
                if (joinText != null) {
                    stringBuffer.append(joinText);
                }
            } else {
                Iterator<BusinessModelObject> iter2 = path.iterator();
                while (iter2.hasNext()) {
                    BusinessModelObject obj = iter2.next();
                    String text = null;
                    text = obj instanceof DataSourceTable ? this._dataSourceTableToText(dsp, (DataSourceTable)obj) : "" + obj;
                    stringBuffer.append(text);
                    if (!iter2.hasNext()) continue;
                    stringBuffer.append(",");
                }
            }
        }
        if (!(filters = ds.getFilters()).isEmpty()) {
            stringBuffer.append(" WHERE ");
            Iterator<FilterItem> iter3 = filters.iterator();
            while (iter3.hasNext()) {
                FilterItem fi = iter3.next();
                ExpressionInterface expr = fi.getExpression();
                String text = this._expressionToText(expr);
                stringBuffer.append(text);
                if (!iter3.hasNext()) continue;
                stringBuffer.append(" AND ");
            }
        }
        boolean firstOne = true;
        List<DataItem> sortItems = ds.getEffectiveSortOrderPrecedence();
        if (!sortItems.isEmpty()) {
            for (DataItem di : sortItems) {
                DataItemActionType direction = di.getSortDirection();
                if (direction == null || direction == DataItemActionType.SORT_NONE) continue;
                if (firstOne) {
                    stringBuffer.append(" ORDER BY ");
                    firstOne = false;
                } else {
                    stringBuffer.append(",");
                }
                String label = di.getLabel();
                if (label == null) {
                    ExpressionInterface expr = di.getExpression();
                    String text = this._expressionToText(expr);
                    stringBuffer.append(text);
                } else {
                    stringBuffer.append(label.indexOf(32) != -1 ? "'" + label + "'" : label);
                }
                if (direction == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(direction);
            }
        }
        for (DataItem di : groupByList) {
            if (di.getUsage() != DataItemActionType.USAGE_CATEGORY) continue;
            if (firstOne) {
                stringBuffer.append(" GROUP BY ");
                firstOne = false;
            } else {
                stringBuffer.append(",");
            }
            String label = di.getLabel();
            if (label == null) {
                ExpressionInterface expr = di.getExpression();
                String text = this._expressionToText(expr);
                stringBuffer.append(text);
                continue;
            }
            stringBuffer.append(label.indexOf(32) != -1 ? "'" + label + "'" : label);
        }
        return stringBuffer.toString();
    }

    private String _dataSourceTableToText(DataSelectionProcessorAbstract dsp, DataSourceTable dst) {
        String text = null;
        try {
            String id;
            String sasTable = dsp.generateTableIdentifier(dst);
            if (dst instanceof DataSourceRelationalQuery) {
                DataSourceRelationalQuery dsrq = (DataSourceRelationalQuery)dst;
                sasTable = "(" + dsrq.getBusinessQuery() + ")";
            }
            text = !(id = dst.getIntraModelID()).equals(sasTable) ? sasTable + " AS " + (id.indexOf(32) != -1 ? "'" + id + "'" : id) : (id.indexOf(32) != -1 ? "'" + id + "'" : id);
        }
        catch (GenerationException e) {
            text = "" + e;
            _logger.warn((Object)e);
        }
        return text;
    }

    private String _expressionToText(ExpressionInterface expr) {
        String text = null;
        try {
            text = StringExpressionUtil.getInstance().getReadableText(expr);
        }
        catch (MetadataException e) {
            text = "" + e;
            _logger.warn((Object)e);
        }
        return text;
    }
}

