/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringAdapterComponent;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CommentStatement;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.ApplyForcedFormattingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DistinctDataStep {
    private static final int MAX_SIZE = 79;
    private static final Object UNIQUE_BY_ROW = "Unique By Rows";
    private static final Object UNIQUE_BY_GROUP = "Unique By Groups";
    private static final Logger _logger = LogManager.getLogger(DistinctDataStep.class);

    public static boolean isNeeded(DataSelection dataSelection, boolean isChildQuery) {
        boolean isNeeded = false;
        boolean isDistinctQuery = dataSelection.getQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES);
        try {
            Object uniqueByType = DistinctDataStep.getUniqueByType(dataSelection, isDistinctQuery, null, false, isChildQuery);
            isNeeded = uniqueByType != null;
        }
        catch (GenerationException e) {
            _logger.error("Error evaluating query for distinct data step usage.", (Throwable)e);
        }
        return isNeeded;
    }

    public static boolean addCode(List compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, boolean isChildQuery, String inputTableName, String outputTableName, boolean alreadyInProcSql) throws GenerationException {
        Object uniqueByType;
        boolean isNeeded;
        boolean inProcSql = alreadyInProcSql;
        boolean isVerboseProc = IQSystemProperties.isVerboseProcCommentsEnabled(DistinctDataStep.class);
        CommentStatement introComment = null;
        boolean isDistinctQuery = dataSelection.getQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES);
        if (isVerboseProc) {
            introComment = new CommentStatement("DistinctDataStep");
            introComment.append(" * Data Selection: " + dataSelection.getID() + " (" + (isChildQuery ? "child" : "main") + " query), ReturnsDistinctValues=" + isDistinctQuery);
        }
        boolean bl = isNeeded = (uniqueByType = DistinctDataStep.getUniqueByType(dataSelection, isDistinctQuery, introComment, isVerboseProc, isChildQuery)) != null;
        if (isNeeded && compositeList != null) {
            ArrayList uniqueByIdentifiers = new ArrayList();
            LinkedHashMap ffColumnSources = new LinkedHashMap();
            LinkedHashMap ffColumnFormats = new LinkedHashMap();
            DistinctDataStep.getDistinctByColumns(dataSelection, uniqueByType, uniqueByIdentifiers, ffColumnSources, ffColumnFormats, introComment, isVerboseProc, isChildQuery);
            if (introComment != null) {
                compositeList.add(introComment);
            }
            if (isNeeded) {
                if (inProcSql) {
                    SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                    inProcSql = false;
                }
                StringBuffer dataStep = DistinctDataStep.generateDistinctValuesDataStep(dsProcessor, inputTableName, outputTableName, uniqueByIdentifiers, ffColumnSources, ffColumnFormats);
                compositeList.add(new CodeStringAdapterComponent(dataStep));
                if (!inputTableName.equalsIgnoreCase(outputTableName)) {
                    SQLStatementFactory.addProcDeleteDataByName(compositeList, dsProcessor, outputTableName);
                }
            } else {
                compositeList.add(introComment);
                if (!inputTableName.equalsIgnoreCase(outputTableName)) {
                    if (inProcSql) {
                        SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                        inProcSql = false;
                    }
                    SQLStatementFactory.addProcDataSetsRename(compositeList, inputTableName, outputTableName);
                }
            }
        } else {
            compositeList.add(introComment);
        }
        return inProcSql;
    }

    private static StringBuffer generateDistinctValuesDataStep(DataSelectionProcessorAbstract dsProcessor, String inputTableName, String outputTableName, List uniqueByIdentifiers, Map ffColumnSources, Map ffColumnFormats) throws GenerationException {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append("data ").append(outputTableName);
        if (ffColumnSources.size() > 0) {
            dataStep.append('(').append("\n   drop=");
            ApplyForcedFormattingStep.writeOutputColumns(dataStep, dsProcessor, ffColumnSources.keySet(), 8);
            dataStep.append("\n   );");
        } else {
            dataStep.append(";");
        }
        dataStep.append("\n   set ").append(inputTableName).append(";\n");
        if (ffColumnSources.size() > 0) {
            dataStep.append("\n   /* calculate formatted output column values */");
            for (String uniqueById : uniqueByIdentifiers) {
                String oldColumnAlias = (String)ffColumnSources.get(uniqueById);
                if (oldColumnAlias == null) continue;
                String newOutputIdentifier = dsProcessor.generateDataStepVar(uniqueById);
                String format = (String)ffColumnFormats.get(uniqueById);
                String oldColumnIdentifier = dsProcessor.generateDataStepVar(oldColumnAlias);
                String code = GenerationUtil.generateDataStepPut(oldColumnIdentifier, format);
                dataStep.append("\n   ").append(newOutputIdentifier).append(" = ").append(code).append(';');
            }
            dataStep.append("\n");
        }
        dataStep.append("\n   /* use a hash object to perform distinct processing */");
        dataStep.append("\n   if _N_ = 1 then do;").append("\n      declare hash h1();").append("\n      h1.definekey(");
        DistinctDataStep.writeHashKeyDefs(dataStep, uniqueByIdentifiers, 19);
        dataStep.append(");");
        dataStep.append("\n      h1.definedone();");
        dataStep.append("\n      end;\n");
        dataStep.append("\n   if (h1.find()) then do;").append("\n      h1.add();").append("\n      output;").append("\n      end;");
        dataStep.append("\nrun;");
        return dataStep;
    }

    private static Object getUniqueByType(DataSelection dataSelection, boolean isDistinctQuery, CommentStatement introComment, boolean isVerboseProc, boolean isChildQuery) throws GenerationException {
        boolean hasSortOnHiddenColumn = false;
        boolean hasCategories = false;
        boolean hasMeasures = false;
        boolean hasDetails = false;
        boolean hasFfOutputColumn = false;
        for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
            boolean isOutputResultItem;
            boolean isInactive;
            DataItem dataItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            DataItemActionType usage = dataItem.getUsage();
            DataItemActionType sort = dataItem.getSortDirection();
            boolean ffOutput = GenerationUtil.isOutputDataFormatted(dataSelection, selectedItem, isChildQuery);
            if (isVerboseProc && introComment != null) {
                boolean ffSort = GenerationUtil.useFormattedValueForSorting(dataItem);
                boolean ffGroup = GenerationUtil.useFormattedValueForGrouping(dataItem);
                String label = dataItem.getLabel();
                String alias = dataItem.getResultSetID();
                introComment.append("\n *   ");
                DistinctDataStep.commentAppendItem(introComment, label, alias, role, usage, sort, ffOutput, ffSort, ffGroup);
            }
            if (usage == DataItemActionType.USAGE_AGGREGATE) {
                hasMeasures = true;
            } else if (usage == DataItemActionType.USAGE_CATEGORY) {
                hasCategories = true;
            } else if (usage == DataItemActionType.USAGE_DETAIL) {
                hasDetails = true;
            }
            if (!hasFfOutputColumn && ffOutput && !(isInactive = Role.isInactiveRole(dataSelection, role))) {
                hasFfOutputColumn = true;
            }
            if (hasSortOnHiddenColumn || (isInactive = Role.isInactiveRole(dataSelection, role)) || (isOutputResultItem = Role.isOutputResultRole(dataSelection, role)) || sort == null || sort.equals(DataItemActionType.SORT_NONE)) continue;
            hasSortOnHiddenColumn = true;
        }
        boolean byRows1 = hasSortOnHiddenColumn && !hasCategories && !hasMeasures && hasDetails && isDistinctQuery;
        boolean byRows2 = hasFfOutputColumn && !hasCategories && !hasMeasures && hasDetails && isDistinctQuery;
        boolean byGroups = hasSortOnHiddenColumn && hasCategories && !hasMeasures && !hasDetails;
        Object uniqueByType = null;
        if (byRows1 || byRows2) {
            uniqueByType = UNIQUE_BY_ROW;
            if (introComment != null) {
                introComment.append("\n * Calculate distinct rows:");
            }
        } else if (byGroups) {
            uniqueByType = UNIQUE_BY_GROUP;
            if (introComment != null) {
                introComment.append("\n * Calculate distinct by groups categories:");
            }
        } else if (introComment != null) {
            introComment.append("\n * Do not do distinct values processing.");
        }
        return uniqueByType;
    }

    private static void getDistinctByColumns(DataSelection dataSelection, Object uniqueByType, List uniqueByIdentifiers, Map ffColumnSources, Map ffColumnFormats, CommentStatement introComment, boolean isVerboseProc, boolean isChildQuery) throws GenerationException {
        HashMap<String, String> tooLongAlias = new HashMap<String, String>();
        for (SelectedItem si : dataSelection.getSelectedItems()) {
            boolean isInactiveResultItem;
            Role role = si.getRole();
            DataItem dataItem = si.getItem();
            DataItemActionType usage = dataItem.getUsage();
            boolean ffOutput = GenerationUtil.isOutputDataFormatted(dataSelection, si, isChildQuery);
            boolean isPartialUniqueKey = false;
            if (uniqueByType == UNIQUE_BY_ROW) {
                isPartialUniqueKey = Role.isOutputResultRole(dataSelection, role);
            } else if (uniqueByType == UNIQUE_BY_GROUP && !(isInactiveResultItem = Role.isInactiveRole(dataSelection, role))) {
                boolean bl = isPartialUniqueKey = usage == DataItemActionType.USAGE_CATEGORY;
            }
            if (!isPartialUniqueKey) continue;
            String label = dataItem.getLabel();
            String alias = dataItem.getResultSetID();
            if (isVerboseProc && introComment != null) {
                DataItemActionType sort = dataItem.getSortDirection();
                boolean ffSort = GenerationUtil.useFormattedValueForSorting(dataItem);
                boolean ffGroup = GenerationUtil.useFormattedValueForGrouping(dataItem);
                introComment.append("\n *   using ");
                DistinctDataStep.commentAppendItem(introComment, label, alias, role, usage, sort, ffOutput, ffSort, ffGroup);
            }
            if (uniqueByType == UNIQUE_BY_ROW && ffOutput) {
                boolean useFormat;
                String format = GenerationUtil.generateFormat(dataItem);
                boolean bl = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    if ("$.".equals(format)) {
                        format = "$char.";
                    }
                    String ffColumnAlias = ApplyForcedFormattingStep.createAlias(tooLongAlias, "", alias, "_ff");
                    uniqueByIdentifiers.add(ffColumnAlias);
                    ffColumnSources.put(ffColumnAlias, alias);
                    ffColumnFormats.put(ffColumnAlias, format);
                    continue;
                }
                uniqueByIdentifiers.add(alias);
                continue;
            }
            uniqueByIdentifiers.add(alias);
        }
    }

    private static void commentAppendItem(CommentStatement introComment, String label, String alias, Role role, DataItemActionType usage, DataItemActionType sort, boolean ffOutput, boolean ffSort, boolean ffGroup) {
        introComment.append("item: '" + label + "' (" + alias + ") on " + role + " with " + usage);
        if (usage == DataItemActionType.USAGE_CATEGORY && ffGroup) {
            introComment.append("[Formatted]");
        }
        if (sort != null && sort != DataItemActionType.SORT_NONE) {
            introComment.append(" and sort " + sort + (ffSort ? "[Formatted]" : ""));
        }
        if (ffOutput) {
            introComment.append(", output is formatted");
        }
    }

    private static void writeHashKeyDefs(StringBuffer dataStep, List uniqueByIdentifiers, int len) {
        for (int i = 0; i < uniqueByIdentifiers.size(); ++i) {
            String identifier = GenerationUtil.generateQuotedLiteral((String)uniqueByIdentifiers.get(i));
            if ((len += identifier.length()) > 79) {
                dataStep.append("\n         ");
                len = 9 + identifier.length();
            } else if (i > 0) {
                dataStep.append(' ');
                ++len;
            }
            dataStep.append(identifier);
            if (i >= uniqueByIdentifiers.size() - 1) continue;
            dataStep.append(',');
            ++len;
        }
    }
}

