/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage.rank;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalItem;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;

public final class ProcRankStatement
extends SQLComponentAbstract {
    static final boolean allowTsSqlInProcRankStatement = false;
    private String _baseTableName = null;
    private String _outputTableName = null;
    private static final String RANKVARSUFFIX = "R";
    private static final String OBSNUM = "_OBSNUM_";
    private List<RelationalItem> _rankSortingItems;
    private List<RelationalItem> _querySortingItems;
    private boolean _doSortHere;
    private List<SQLComponentAbstract> _rankCode;

    public ProcRankStatement(DataSelection dataSelection, String baseTableName, String outputTableName, List<RelationalItem> querySortingItems, boolean doSortHere) {
        this._dataSelection = dataSelection;
        this._baseTableName = baseTableName;
        this._outputTableName = outputTableName;
        this._querySortingItems = querySortingItems;
        this._doSortHere = doSortHere;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        List<RankAttributesHolder> attributes = this.determineRankAttributes(this._dataSelection, this._dataSelection.getEffectiveResultItems());
        if (attributes == null || attributes.isEmpty()) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ProcRankStatement.generateVarListSuffix.Length.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        this._rankSortingItems = this.getRankBasedSortingItems(attributes);
        this._rankSortingItems.add(this.getObsNumSortingItem());
        ArrayList<SQLComponentAbstract> compositeList = new ArrayList<SQLComponentAbstract>();
        this.addProcRank(compositeList, this._baseTableName, attributes, this._querySortingItems);
        if (this._doSortHere) {
            this.addSort(compositeList, this._baseTableName, this._querySortingItems, this._rankSortingItems);
        }
        this._rankCode = compositeList;
    }

    @Override
    public String writeSQL() {
        return ProcRankStatement.writeCompositeList(this._rankCode);
    }

    private void addProcRank(List<SQLComponentAbstract> compositeList, String inputTableName, List<RankAttributesHolder> attributes, List<RelationalItem> querySortingItems) throws GenerationException {
        String obsNumDataSetName;
        String rankByMeasureN;
        String rankByMeasureRsidN;
        RankAttributesHolder attributesHolderN;
        int i;
        String rankedTableName = inputTableName + "r1";
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        RankAttributesHolder attributesHolder = attributes.get(0);
        boolean isTop = attributesHolder.isTopN();
        int count = attributesHolder.getNValue();
        boolean includeTies = attributesHolder.isIncludeTies();
        String rankMeasureRSID = attributesHolder.getRankRSID();
        String rankMeasure = dsProcessor.generateDataStepVar(rankMeasureRSID);
        String rankByValueRSID = attributesHolder.getRankByValueRSID();
        String rankByValue = dsProcessor.generateDataStepVar(rankByValueRSID);
        StringBuffer comment1 = new StringBuffer();
        comment1.append("\n").append("/* Filter by ranking ").append(rankMeasure).append(" and keeping the ").append(isTop ? "top" : "bottom").append(" ").append(count).append(" ").append(includeTies ? "with" : "without").append(" ties. */\n");
        SQLStatementFactory.addText(compositeList, comment1);
        String rankDirection = isTop ? " descending" : "";
        StringBuffer comment2 = new StringBuffer();
        comment2.append("/* Rank and output all non-null observations with a rank <= ").append(count).append(" */\n");
        SQLStatementFactory.addText(compositeList, comment2);
        StringBuffer rankCode = new StringBuffer();
        rankCode.append("PROC RANK data=").append(inputTableName);
        rankCode.append("\n    (where=(");
        rankCode.append(rankMeasure).append(" is not null");
        for (i = 1; i < attributes.size(); ++i) {
            attributesHolderN = attributes.get(i);
            rankByMeasureRsidN = attributesHolderN.getRankRSID();
            rankByMeasureN = dsProcessor.generateDataStepVar(rankByMeasureRsidN);
            rankCode.append("\n        and ").append(rankByMeasureN).append(" is not null");
        }
        rankCode.append("))\n");
        rankCode.append("    out=").append(rankedTableName).append("(where=(").append(rankByValue).append("<=").append(count).append(")").append(")").append(rankDirection).append(" ties=low;\n");
        rankCode.append("    var ").append(rankMeasure);
        for (i = 1; i < attributes.size(); ++i) {
            attributesHolderN = attributes.get(i);
            rankByMeasureRsidN = attributesHolderN.getRankRSID();
            rankByMeasureN = dsProcessor.generateDataStepVar(rankByMeasureRsidN);
            rankCode.append(" ").append(rankByMeasureN);
        }
        rankCode.append(";\n");
        rankCode.append("    ranks ").append(dsProcessor.generateDataStepVar(rankByValueRSID));
        for (i = 1; i < attributes.size(); ++i) {
            attributesHolderN = attributes.get(i);
            String rankByValueRsidN = attributesHolderN.getRankByValueRSID();
            String rankByValueN = dsProcessor.generateDataStepVar(rankByValueRsidN);
            rankCode.append(" ").append(rankByValueN);
        }
        rankCode.append(";\n");
        rankCode.append("run;\n");
        SQLStatementFactory.addText(compositeList, rankCode);
        boolean isView = false;
        if (!includeTies) {
            obsNumDataSetName = inputTableName + "r2";
            isView = !dsProcessor.isSPDS();
        } else {
            obsNumDataSetName = this._outputTableName;
        }
        SQLStatementFactory.addText(compositeList, "/* Record the original order of that output */\n");
        StringBuffer addObsNumCode = new StringBuffer();
        addObsNumCode.append("DATA ").append(obsNumDataSetName);
        if (isView) {
            addObsNumCode.append(" / view=").append(obsNumDataSetName);
        }
        addObsNumCode.append(";\n");
        addObsNumCode.append("    SET ").append(rankedTableName).append(";\n");
        addObsNumCode.append("    ").append(OBSNUM).append("=_N_;\n");
        addObsNumCode.append("run;\n");
        SQLStatementFactory.addText(compositeList, addObsNumCode);
        if (!includeTies) {
            String withoutTiesTableName = this._outputTableName;
            StringBuffer comment4 = new StringBuffer();
            comment4.append("/* Sort and eliminate any ties outside of the ").append(isTop ? "top" : "bottom").append(" ").append(count).append(" observations */\n");
            SQLStatementFactory.addText(compositeList, comment4);
            StringBuffer comment5 = new StringBuffer();
            comment5.append("/*   (use the query's sort order as the first tie breaker and ").append(OBSNUM).append(" as the second) */\n");
            SQLStatementFactory.addText(compositeList, comment5);
            StringBuffer comment6 = new StringBuffer();
            comment6.append("/*   Resolve the ties by truncating after ").append(count).append(" observations. */\n");
            SQLStatementFactory.addText(compositeList, comment6);
            SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, false, "OutObs=" + count);
            SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, withoutTiesTableName);
            StringBuffer noTiesQuery = new StringBuffer();
            noTiesQuery.append("    select * from " + obsNumDataSetName);
            noTiesQuery.append("\n    order by\n\t");
            noTiesQuery.append(rankByValue).append(",");
            for (int i2 = 1; i2 < attributes.size(); ++i2) {
                RankAttributesHolder attributesHolderN2 = attributes.get(i2);
                String rankByValueRsidN = attributesHolder.getRankByValueRSID();
                String rankByValueN = dsProcessor.generateColumnIdentifier(rankByValueRsidN);
                boolean isTopN = attributesHolderN2.isTopN();
                String tiesSortDir = isTopN == isTop ? "" : " desc";
                noTiesQuery.append("\n\t").append(rankByValueN).append(tiesSortDir).append(",");
            }
            boolean invertSortDirections = !isTop;
            int nRankSortItems = RelationalSortingStep.writeSQLSortItems(noTiesQuery, dsProcessor, querySortingItems, invertSortDirections, true);
            if (nRankSortItems > 0) {
                noTiesQuery.append(",");
            }
            noTiesQuery.append("\n");
            String withoutTiesObsNumSort = OBSNUM + (isTop ? "" : " desc");
            noTiesQuery.append("\t").append(withoutTiesObsNumSort);
            SQLStatementFactory.addText(compositeList, noTiesQuery);
            SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addDropTableOrViewByName(compositeList, dsProcessor, obsNumDataSetName, isView);
            SQLStatementFactory.addDropTableByName(compositeList, dsProcessor, rankedTableName);
            SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        } else {
            SQLStatementFactory.addProcDeleteDataByName(compositeList, dsProcessor, rankedTableName);
        }
        StringBuffer commentLast = new StringBuffer();
        commentLast.append("/* Filter and Rank by ").append(rankMeasure).append(" complete */\n");
        SQLStatementFactory.addText(compositeList, commentLast);
    }

    private void addSort(List<SQLComponentAbstract> compositeList, String inputTableName, List<RelationalItem> querySortingItems, List<RelationalItem> rankSortingItems) throws GenerationException {
        String sortOrder;
        String sortComment;
        String tempSortTableName = inputTableName + "s1";
        DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
        StringBuffer sortOrderQueryText = new StringBuffer();
        boolean hasQuerySortings = querySortingItems != null && querySortingItems.size() > 0;
        int sortOrderQueryItems = 0;
        if (hasQuerySortings) {
            sortOrderQueryItems = RelationalSortingStep.writeSQLSortItems(sortOrderQueryText, dsp, querySortingItems, false, false);
        }
        StringBuffer sortOrderRankText = new StringBuffer();
        boolean hasRankSortings = rankSortingItems != null && rankSortingItems.size() > 0;
        int sortOrderRankItems = 0;
        if (hasRankSortings) {
            sortOrderRankItems = RelationalSortingStep.writeSQLSortItems(sortOrderRankText, dsp, rankSortingItems, false, false);
        }
        if (sortOrderQueryItems > 0) {
            if (sortOrderRankItems > 0) {
                sortComment = " /* query sort items and preserve ranked order */";
                sortOrder = sortOrderQueryText + "," + sortOrderRankText;
            } else {
                sortComment = " /* query sort items */";
                sortOrder = sortOrderQueryText.toString();
            }
        } else if (sortOrderRankItems > 0) {
            sortComment = " /* no query sort items, preserve ranked order */";
            sortOrder = sortOrderRankText.toString();
        } else {
            return;
        }
        SQLStatementFactory.addText(compositeList, "/* Sort the results by query sort orders and further by rank and ObsNum */\n");
        RelationalSortingStep.addRelationalSort(compositeList, dsp, this._dataSelection, inputTableName, tempSortTableName, sortComment, sortOrder);
        SQLStatementFactory.addText(compositeList, "/* Sorting ranked query results complete */\n");
    }

    public List<RelationalItem> getRankSortingItems() {
        return this._rankSortingItems;
    }

    private RelationalItem getObsNumSortingItem() {
        RelationalItem obsnumSortingItem = new RelationalItem(OBSNUM, DataItemActionType.SORT_ASCENDING);
        return obsnumSortingItem;
    }

    private List<RelationalItem> getRankBasedSortingItems(List<RankAttributesHolder> attributes) {
        ArrayList<RelationalItem> rankAttrSortingItems = new ArrayList<RelationalItem>();
        RankAttributesHolder attributesHolder = attributes.get(0);
        boolean isTop = attributesHolder.isTopN();
        String rankByValue = attributesHolder.getRankByValueRSID();
        DataItemActionType finalRankedValueSortDir = this.finalRankedValueSortDir(isTop);
        RelationalItem rankAttrSortingItem = new RelationalItem(rankByValue, finalRankedValueSortDir);
        rankAttrSortingItems.add(rankAttrSortingItem);
        for (int i = 1; i < attributes.size(); ++i) {
            RankAttributesHolder attributesHolderN = attributes.get(i);
            String rankByValueN = attributesHolderN.getRankByValueRSID();
            boolean isTopN = attributesHolderN.isTopN();
            isTopN = isTopN == isTop ? isTopN : !isTopN;
            DataItemActionType finalRankedValueSortDirN = this.finalRankedValueSortDir(isTopN);
            RelationalItem rankAttrSortingItemN = new RelationalItem(rankByValueN, finalRankedValueSortDirN);
            rankAttrSortingItems.add(rankAttrSortingItemN);
        }
        return rankAttrSortingItems;
    }

    private List<RankAttributesHolder> determineRankAttributes(DataSelection dataSelection, List<DataItem> effectiveResultItems) throws GenerationException {
        List<String> usedRSIDs = this.getUsedRSIDs(dataSelection, effectiveResultItems);
        ArrayList<RankAttributesHolder> attributes = new ArrayList<RankAttributesHolder>();
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        block0: for (SelectedItem si : selectedItems) {
            DataItem item = si.getItem();
            List<StepInterface> steps = item.getSteps();
            for (StepInterface step : steps) {
                if (!(step instanceof DataItemRankFilter)) continue;
                DataItemRankFilter rankStep = (DataItemRankFilter)step;
                if (FractionOfTotalUtil.isFractionOfTotalItem(item)) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ProcRankStatement.ItemUnusablePercentTotal.fmt.txt", item.getLabel());
                    throw new GenerationException(mft);
                }
                String resultSetID = item.getResultSetID();
                String rankingResultSetID = this.createNewRSID(usedRSIDs, resultSetID);
                RankAttributesHolder attributeHolder = new RankAttributesHolder();
                attributeHolder.setRankRSID(resultSetID);
                attributeHolder.setRankByValueRSID(rankingResultSetID);
                attributeHolder.setNValue(rankStep.getValue());
                attributeHolder.setIncludeTies(rankStep.isIncludeTies());
                attributeHolder.setRankType(rankStep.getRankType());
                if (rankStep.getRankOrder() == 1) {
                    attributeHolder.setTopN(false);
                } else {
                    attributeHolder.setTopN(true);
                }
                attributes.add(attributeHolder);
                continue block0;
            }
        }
        return attributes;
    }

    private DataItemActionType finalRankedValueSortDir(boolean isTop) {
        int sqlRankOrder = IQSystemProperties.getSqlRankOrder();
        switch (sqlRankOrder) {
            case 1: 
            case 4: {
                return isTop ? DataItemActionType.SORT_DESCENDING : DataItemActionType.SORT_ASCENDING;
            }
            case 2: {
                return isTop ? DataItemActionType.SORT_ASCENDING : DataItemActionType.SORT_DESCENDING;
            }
            case 3: {
                return DataItemActionType.SORT_DESCENDING;
            }
        }
        return DataItemActionType.SORT_ASCENDING;
    }

    private String createNewRSID(List<String> usedRSIDs, String rankMeasure) {
        String attempt = rankMeasure + RANKVARSUFFIX;
        int i1 = 1;
        while (usedRSIDs.contains(attempt.toUpperCase())) {
            attempt = rankMeasure + RANKVARSUFFIX + ++i1;
        }
        usedRSIDs.add(attempt);
        return attempt;
    }

    private List<String> getUsedRSIDs(DataSelection dataSelection, List<DataItem> dataItems) {
        ArrayList<String> usedRSIDs = new ArrayList<String>(dataItems.size());
        for (DataItem di : dataItems) {
            String alias = di.getResultSetID();
            usedRSIDs.add(alias.toUpperCase());
        }
        return usedRSIDs;
    }

    static class RankAttributesHolder {
        boolean topN = true;
        int nValue = 5;
        int rankType = 0;
        boolean includeTies = true;
        private String rankVar = null;
        private String rankByValueVar = null;

        RankAttributesHolder() {
        }

        public int getNValue() {
            return this.nValue;
        }

        public boolean isTopN() {
            return this.topN;
        }

        public void setNValue(int nValue) {
            this.nValue = nValue;
        }

        public void setTopN(boolean topN) {
            this.topN = topN;
        }

        public boolean isIncludeTies() {
            return this.includeTies;
        }

        public void setIncludeTies(boolean includeTies) {
            this.includeTies = includeTies;
        }

        public int getRankType() {
            return this.rankType;
        }

        public void setRankType(int rankType) {
            this.rankType = rankType;
        }

        public void setRankRSID(String var) {
            this.rankVar = var;
        }

        public String getRankRSID() {
            return this.rankVar;
        }

        public void setRankByValueRSID(String var) {
            this.rankByValueVar = var;
        }

        public String getRankByValueRSID() {
            return this.rankByValueVar;
        }
    }
}

