/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtil;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalItem;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelationalSortingStep {
    private static final Logger _logger = LogManager.getLogger(RelationalSortingStep.class);

    public static String generate(DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, String tableName, List<RelationalItem> sortingItems) throws GenerationException {
        String sortOrder;
        String sortComment;
        String tempTableName = tableName + "s1";
        ArrayList<SQLComponentAbstract> compositeList = new ArrayList<SQLComponentAbstract>();
        StringBuffer sortItemsClause = new StringBuffer();
        int countOfSortItems = RelationalSortingStep.writeSQLSortItems(sortItemsClause, dsProcessor, sortingItems, false, false);
        if (countOfSortItems > 0) {
            sortComment = null;
            sortOrder = sortItemsClause.toString();
        } else {
            sortComment = "\t/* no query or rank sort items, results are un-ordered */";
            sortOrder = null;
        }
        if (countOfSortItems > 0) {
            SQLStatementFactory.addText(compositeList, "/* Sort the results by query sort orders */\n");
        } else {
            SQLStatementFactory.addText(compositeList, "/* Reorder columns and drop temporary columns */\n");
        }
        RelationalSortingStep.addRelationalSort(compositeList, dsProcessor, dataSelection, tableName, tempTableName, sortComment, sortOrder);
        return SQLComponentAbstract.writeCompositeList(compositeList);
    }

    public static void addRelationalSort(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, String tableName, String tempTableName, String sortComment, String sortOrder) throws GenerationException {
        SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, null);
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, tempTableName);
        StringBuffer sortQuery = new StringBuffer();
        sortQuery.append("    select \n");
        RelationalSortingStep.appendSQLOutputItems(sortQuery, dsProcessor, dataSelection);
        sortQuery.append("\n    from " + tableName);
        if (sortOrder != null) {
            sortQuery.append("\n    order by");
            if (sortComment != null) {
                sortQuery.append(sortComment);
            }
            sortQuery.append(sortOrder);
        } else if (sortComment != null) {
            sortQuery.append(sortComment);
        }
        SQLStatementFactory.addText(compositeList, sortQuery);
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addDropTableByName(compositeList, dsProcessor, tableName);
        SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        SQLStatementFactory.addText(compositeList, "/* rename the output */\n");
        SQLStatementFactory.addProcDataSetsRename(compositeList, tempTableName, tableName);
    }

    private static void appendSQLOutputItems(StringBuffer sql, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection) throws GenerationException {
        sql.append("\t");
        String delim = "";
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            Role role = selectedItem.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
            if (!isOutputResultItem) continue;
            DataItem resultItem = selectedItem.getItem();
            String resultid = dsProcessor.generateColumnIdentifier(resultItem.getResultSetID());
            sql.append(delim).append(resultid);
            delim = ",\n\t";
        }
    }

    public static int writeSQLSortItems(StringBuffer sql, DataSelectionProcessorAbstract dataSelectionProcessor, List<RelationalItem> sortingItems, boolean invertSortDirections, boolean ignoreFotSorts) throws GenerationException {
        int numSortItems = 0;
        String delim = "";
        for (RelationalItem sortingItem : sortingItems) {
            String strAlias = dataSelectionProcessor.generateColumnIdentifier(sortingItem.getResultSetID());
            boolean isSortByFotItem = sortingItem.isFotItem();
            if (isSortByFotItem && ignoreFotSorts) {
                sql.append("\n\t/* FoT item sort ignored while ranking. ResultSetID = ").append(strAlias).append(" */");
                continue;
            }
            sql.append(delim).append("\n\t");
            String sortingItemSql = sortingItem.generate(dataSelectionProcessor, invertSortDirections);
            sql.append(sortingItemSql);
            if (_logger.isDebugEnabled()) {
                if (sortingItem.isSortByFormattedValue()) {
                    sql.append(" /* biq-030: sort by formatted values using alias */");
                } else {
                    sql.append(" /* biq-030: sort by unformatted values using alias */");
                }
            }
            delim = ",";
            ++numSortItems;
        }
        return numSortItems;
    }

    public static List<RelationalItem> getRelationalSortingItems(DataSelection dataSelection, boolean isRolap) throws GenerationException {
        ArrayList<RelationalItem> sortingItems = new ArrayList<RelationalItem>();
        List<DataItem> dataItems = dataSelection.getEffectiveSortOrderPrecedence();
        for (DataItem sortItem : dataItems) {
            RelationalItem sortingItem = RelationalSortingStep.newSortingItem(dataSelection, sortItem, isRolap);
            if (sortingItem == null) continue;
            sortingItems.add(sortingItem);
        }
        return sortingItems;
    }

    public static boolean isModelSortedByHiddenAggregates(DataSelection dataSelection) throws GenerationException {
        boolean hasSortsOnHiddenAggregates = false;
        if (dataSelection != null) {
            List<DataItem> sortItems = dataSelection.getEffectiveSortOrderPrecedence();
            for (int index = 0; index < sortItems.size(); ++index) {
                boolean isOutputResultItem;
                boolean notDetail;
                DataItem sortItem = sortItems.get(index);
                if (sortItem.getSortDirection() == DataItemActionType.SORT_NONE) continue;
                boolean bl = notDetail = sortItem.getUsage() != DataItemActionType.USAGE_DETAIL;
                if (!notDetail) continue;
                Role role = null;
                for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
                    DataItem dataItem = selectedItem.getItem();
                    if (!dataItem.equals(sortItem)) continue;
                    role = selectedItem.getRole();
                    break;
                }
                if ((isOutputResultItem = Role.isOutputResultRole(dataSelection, role)) || Role.isInactiveRole(dataSelection, role)) continue;
                hasSortsOnHiddenAggregates = true;
                break;
            }
        }
        return hasSortsOnHiddenAggregates;
    }

    public static RelationalItem newSortingItem(DataSelection dataSelection, DataItem sortItem, boolean isRolap) throws GenerationException {
        StructureOfDataItem structure;
        DataItemActionType usage;
        boolean groupByFormattedValue;
        boolean isInactiveResultItem;
        Role resultItemRole;
        boolean isOutputResultItem;
        RelationalItem sortingItem = null;
        DataItemActionType sortDirection = sortItem.getSortDirection();
        boolean useInSort = RelationalSortingStep.isValidInSort(dataSelection, sortItem, sortDirection, isOutputResultItem = Role.isOutputResultRole(dataSelection, resultItemRole = RelationalSortingStep.getRole(dataSelection, sortItem)), isInactiveResultItem = Role.isInactiveRole(dataSelection, resultItemRole), groupByFormattedValue = GenerationUtil.useFormattedValueForGrouping(sortItem), usage = sortItem.getUsage(), structure = sortItem.getStructure(), isRolap);
        if (useInSort) {
            String resultSetID = sortItem.getResultSetID();
            boolean isSortByFotItem = FractionOfTotalUtil.isFractionOfTotalItem(sortItem);
            String format = GenerationUtil.generateFormat(sortItem);
            boolean sortByFormattedValue = GenerationUtil.useFormattedValueForSorting(sortItem);
            if (sortByFormattedValue) {
                sortByFormattedValue = format != null && format.trim().length() > 0 && !format.equals("$.");
            }
            sortingItem = new RelationalItem(resultSetID, sortDirection, isSortByFotItem, sortByFormattedValue, format, isOutputResultItem, isInactiveResultItem, usage, groupByFormattedValue);
        }
        return sortingItem;
    }

    private static Role getRole(DataSelection dataSelection, DataItem sortItem) {
        Role resultItemRole = null;
        for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
            DataItem dataItem = selectedItem.getItem();
            if (!dataItem.equals(sortItem)) continue;
            resultItemRole = selectedItem.getRole();
            break;
        }
        return resultItemRole;
    }

    public static boolean isValidInSort(DataSelection dataSelection, DataItem sortItem) throws GenerationException {
        Role role = RelationalSortingStep.getRole(dataSelection, sortItem);
        boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
        boolean isInactiveResultItem = role == Role.BACKGROUND || Role.isInactiveRole(dataSelection, role);
        boolean useInSort = RelationalSortingStep.isValidInSort(dataSelection, sortItem, isOutputResultItem, isInactiveResultItem);
        return useInSort;
    }

    public static boolean isValidInSort(DataSelection dataSelection, DataItem item, boolean isOutputItem, boolean isInactiveItem) throws GenerationException {
        boolean isRolap;
        DataItemActionType itemDirection = item.getSortDirection();
        DataItemActionType itemUsage = item.getUsage();
        StructureOfDataItem itemStructure = item.getStructure();
        try {
            isRolap = dataSelection.getResultItems(Role.ROW).size() > 0;
        }
        catch (MetadataException e) {
            isRolap = false;
        }
        boolean groupByFormattedValue = GenerationUtil.useFormattedValueForGrouping(item);
        boolean isValidSortItem = RelationalSortingStep.isValidInSort(dataSelection, item, itemDirection, isOutputItem, isInactiveItem, groupByFormattedValue, itemUsage, itemStructure, isRolap);
        return isValidSortItem;
    }

    public static boolean isValidInSort(DataSelection dataSelection, DataItem sortItem, DataItemActionType sortDirection, boolean isOutputResultItem, boolean isInactiveResultItem, boolean groupByFormattedValue, DataItemActionType usage, StructureOfDataItem structure, boolean isRolap) {
        boolean useInSort = false;
        if (sortDirection == DataItemActionType.SORT_ASCENDING || sortDirection == DataItemActionType.SORT_DESCENDING) {
            if (isOutputResultItem) {
                useInSort = true;
            } else {
                boolean isHidden;
                boolean bl = isHidden = !isInactiveResultItem;
                if (isHidden && (useInSort = true)) {
                    boolean isCategory;
                    boolean bl2 = isCategory = usage == DataItemActionType.USAGE_CATEGORY;
                    if (isCategory && !groupByFormattedValue && isRolap) {
                        useInSort = false;
                    }
                }
            }
        }
        return useInSort;
    }
}

