/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.SQLGeneration;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalPostProcessFactory;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;

public class RelationalPostProcessGeneration
extends SQLGeneration {
    public RelationalPostProcessGeneration(DataSelection model) throws GenerationException {
        this._factory = new RelationalPostProcessFactory(model);
    }

    @Override
    protected void checkValid(DataSelection selection) throws GenerationException {
        super.checkValid(selection);
        if (DataRetrievalUtil.getRankedItemCount(selection) > 1) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("RelationalPostProcessGeneration.checkValid.RankedItemsCount.txt", new Object[0]);
            throw new GenerationException(mft);
        }
    }

    public static boolean canHandle(DataSelection model) throws GenerationException {
        boolean usesPostProcess = false;
        boolean isModelRanked = DataRetrievalUtil.isModelRanked(model);
        if (isModelRanked) {
            usesPostProcess = true;
        } else {
            Export export;
            boolean isGrandTotaled = DataRetrievalUtil.isModelGrandTotal(model);
            if (isGrandTotaled) {
                usesPostProcess = true;
            } else {
                boolean itemsCompareToTotal = FractionOfTotalUtilImpl.checkGrandTotalComparisonItems(model);
                if (itemsCompareToTotal) {
                    usesPostProcess = true;
                } else {
                    boolean isSortingStepNeeded = RelationalSortingStep.isModelSortedByHiddenAggregates(model);
                    if (isSortingStepNeeded) {
                        usesPostProcess = true;
                    }
                }
            }
            List<ExportRule> returnList = model.getEffectiveRules(ExportRule.class);
            if (!returnList.isEmpty() && ((export = returnList.get(0).getExport()).getUsage() == ExportType.CSV || export.getUsage() == ExportType.JSON || export.getUsage() == ExportType.LASR_RESULT_SET || export.getUsage() == ExportType.EXPORT_AND_LASR_SAS_LIBNAME || export.getUsage() == ExportType.EXPORT_AND_LASR_SAS_OMALIB || export.isMetalibInEffect())) {
                usesPostProcess = true;
            }
        }
        return usesPostProcess;
    }
}

