/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFactoryInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class NonVisualTotalsSQLWhere
extends SQLComponentAbstract {
    private SQLComponentAbstract _where;
    private List _selectedItemCategories;
    private boolean _hasRankings = false;
    private List _dropKeys = new ArrayList();
    private StringBuffer _rejoinWhereClause = new StringBuffer();
    private static final Logger _logger = LogManager.getLogger(NonVisualTotalsSQLWhere.class);

    public List getDropKeys() {
        return this._dropKeys;
    }

    NonVisualTotalsSQLWhere(SQLComponentAbstract where, List selectedItemCategories, boolean hasRankings) {
        this._where = where;
        this._selectedItemCategories = selectedItemCategories;
        this._hasRankings = hasRankings;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        SQLFactoryInterface factory = this._where.getSQLFactory();
        DataSelectionProcessorAbstract dsProcessor = this._where.getDataSelectionProcessor();
        if (this._selectedItemCategories.size() > 0) {
            Iterator iterator = this._selectedItemCategories.iterator();
            while (iterator.hasNext()) {
                boolean joinByFormattedValue;
                SelectedItem selectedItem = (SelectedItem)iterator.next();
                DataItem category = selectedItem.getItem();
                String rsid = category.getResultSetID();
                String rankTableCategory = "rankTable." + dsProcessor.generateColumnIdentifier(rsid);
                SQLExpressionAbstract sqlExpression = factory.createSQLExpression();
                sqlExpression.setSQLFactory(this.getSQLFactory());
                sqlExpression.setDataSelection(this._dataSelection);
                sqlExpression.setDataSelectionProcessor(dsProcessor);
                sqlExpression.setJoinGenerator(this.m_joinGenerator);
                String nvtQueryCategory = sqlExpression.generateDataItemShortDeclarationSQL(category, null, false);
                if (_logger.isDebugEnabled()) {
                    this._rejoinWhereClause.append("/* biq-016: calculate NVT total by matching values for " + rankTableCategory + " with values of " + category.getResultSetID() + " in the original query results");
                }
                if (joinByFormattedValue = GenerationUtil.useFormattedValueForGrouping(category)) {
                    boolean useFormat;
                    String format = GenerationUtil.generateFormat(category);
                    boolean bl = useFormat = format != null && format.trim().length() > 0;
                    if (useFormat) {
                        if (_logger.isDebugEnabled()) {
                            this._rejoinWhereClause.append(" using the " + format + " format */\n    ");
                        }
                        rankTableCategory = GenerationUtil.generatePut(dsProcessor, rankTableCategory, format);
                        nvtQueryCategory = GenerationUtil.generatePut(dsProcessor, nvtQueryCategory, format);
                    } else if (_logger.isDebugEnabled()) {
                        this._rejoinWhereClause.append(" without using invalid format */\n    ");
                    }
                } else if (_logger.isDebugEnabled()) {
                    this._rejoinWhereClause.append(" without using a format */\n    ");
                }
                this._rejoinWhereClause.append("(").append(nvtQueryCategory).append(" = ").append(rankTableCategory);
                this._rejoinWhereClause.append(" or (").append(nvtQueryCategory).append(" is null and ").append(rankTableCategory).append(" is null");
                this._rejoinWhereClause.append("))");
                if (!iterator.hasNext()) continue;
                this._rejoinWhereClause.append("\nAND ");
            }
        }
    }

    @Override
    public String writeSQL() {
        String whereText = this._where.writeSQL();
        if (this._rejoinWhereClause.length() == 0) {
            return whereText;
        }
        if (whereText.trim().length() == 0) {
            return "\nwhere " + this._rejoinWhereClause;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(whereText);
        sql.append("\nAND ");
        sql.append(this._rejoinWhereClause);
        return sql.toString();
    }
}

