/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.strategies.sas.oma.CloneDataSelectionFactory;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLEmptyGroupBy;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLEmptyHaving;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLEmptyOrderBy;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringAdapterComponent;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CommentStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FractionOfGrandTotalStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsSQLFrom;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsSQLWhere;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcSQLDecorator;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalPostProcessComposite;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NonVisualTotalsComposite
extends SQLSASComposite {
    private static int _uniqueCloneID = 1;
    private String _resultsTableName;
    String _inputTableName;
    private String _why = "";
    private boolean _isAggPreFiltered = false;
    private boolean _isRanked = false;
    private boolean _isDetails = false;
    private final List<SelectedItem> _selectedItemCategories = new ArrayList<SelectedItem>();
    private final Set<String> _dropKeys = new LinkedHashSet<String>();
    private static final int ACTION_KEEP = 1;
    private static final int ACTION_HIDE = 2;
    private static final int ACTION_REPLACE = 3;
    private static final int ACTION_HIDE_REPLACE = 4;
    private static final int ACTION_FOT_KEEP = 5;
    private static final int ACTION_FOT_HIDE = 6;
    private static final int ACTION_FOT_REPLACE = 7;
    private static final int ACTION_FOT_HIDE_REPLACE = 8;
    DataSelection _originalDataSelection = null;
    DataSelectionProcessorAbstract _originalDsProcessor = null;
    boolean _isOriginalRanked = false;
    boolean _isOriginalDetailed = false;
    private static final Logger _logger = LogManager.getLogger(NonVisualTotalsComposite.class);

    public NonVisualTotalsComposite(DataSelection originalDataSelection, boolean isOriginalRanked, boolean isOriginalDetailed) throws GenerationException {
        this._originalDataSelection = originalDataSelection;
        this._isOriginalRanked = isOriginalRanked;
        this._isOriginalDetailed = isOriginalDetailed;
    }

    @Override
    public void setDataSelectionProcessor(DataSelectionProcessorAbstract selectionProcessor) {
        this._originalDsProcessor = selectionProcessor;
    }

    private DataSelection setupNonVisualTotalsDataSelection(DataSelectionProcessorAbstract originalDsProcessor, boolean isOriginalRanked, boolean isOriginalDetails) throws GenerationException {
        StringBuffer why = null;
        if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
            why = new StringBuffer();
        }
        DataSelection originalDataSelection = originalDsProcessor.getDataSelection();
        this._isRanked = isOriginalRanked;
        this._isDetails = isOriginalDetails;
        DataSelection query = null;
        query = this._isDetails ? (this._isRanked ? this.setupRankedDetailsQuery(originalDataSelection, why) : this.setupDetailsQuery(originalDataSelection, why)) : (this._isRanked || this._isAggPreFiltered ? this.setupFilteredByRankedQuery(originalDataSelection, why) : this.setupNonRankedQuery(originalDataSelection, why));
        return query;
    }

    private DataSelection setupDetailsQuery(DataSelection originalDataSelection, StringBuffer why) throws GenerationException {
        return this.setupNonRankedQuery(originalDataSelection, why);
    }

    private DataSelection setupRankedDetailsQuery(DataSelection originalDataSelection, StringBuffer why) throws GenerationException {
        return this.setupNonRankedQuery(originalDataSelection, why);
    }

    private DataSelection setupFilteredByRankedQuery(DataSelection originalDataSelection, StringBuffer why) throws GenerationException {
        List<SelectedItem> selectedItems = originalDataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            Role role = selectedItem.getRole();
            if (item.getUsage() != DataItemActionType.USAGE_CATEGORY || role == null || !Role.isOutputResultRole(originalDataSelection, role)) continue;
            this._selectedItemCategories.add(selectedItem);
        }
        return this.setupNonRankedQuery(originalDataSelection, why);
    }

    private DataSelection setupNonRankedQuery(DataSelection originalDataSelection, StringBuffer why) throws GenerationException {
        SelectedItem oldSelectedItem;
        int i;
        List<SelectedItem> originalSelectedItems = originalDataSelection.getSelectedItems();
        int[] actions = new int[originalSelectedItems.size()];
        int index = 0;
        for (SelectedItem selectedItem : originalSelectedItems) {
            boolean isFotTotalItem;
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            String alias = resultItem.getResultSetID();
            DataItemActionType usage = resultItem.getUsage();
            StringBuffer reason = why == null ? null : new StringBuffer();
            boolean needed = NonVisualTotalsComposite.isNonVisualTotalCalcNeeded(originalDataSelection, resultItem, role, reason);
            if (needed) {
                if (why != null) {
                    why.append("\n *    calculating ").append(alias).append(" : ").append(reason);
                }
                isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem);
                actions[index] = usage == DataItemActionType.USAGE_DETAIL ? (isFotTotalItem ? 7 : 3) : (isFotTotalItem ? 5 : 1);
            } else {
                if (why != null) {
                    why.append("\n *    ignoring ").append(alias).append(" : ").append(reason);
                }
                isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem);
                actions[index] = usage == DataItemActionType.USAGE_DETAIL ? (isFotTotalItem ? 8 : 4) : (isFotTotalItem ? 6 : 2);
            }
            ++index;
        }
        DataSelection cloneDS = CloneDataSelectionFactory.createCloneDataSelection(originalDataSelection);
        try {
            cloneDS.setID(originalDataSelection.getID() + "_NVT_clone_" + _uniqueCloneID++);
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        HashMap<DataItem, DataItem> reassigned = new HashMap<DataItem, DataItem>();
        block17: for (i = 0; i < actions.length; ++i) {
            oldSelectedItem = cloneDS.getSelectedItems().get(i);
            DataItem oldDi = oldSelectedItem.getItem();
            int action = actions[i];
            switch (action) {
                case 4: {
                    this.replaceWithAggregate(cloneDS, i);
                    SelectedItem newSelectedItem = cloneDS.getSelectedItems().get(i);
                    DataItem newDi = newSelectedItem.getItem();
                    reassigned.put(oldDi, newDi);
                    newSelectedItem.setRole(Role.HIDDEN);
                    continue block17;
                }
                case 3: {
                    this.replaceWithAggregate(cloneDS, i);
                    SelectedItem newSelectedItem = cloneDS.getSelectedItems().get(i);
                    DataItem newDi = newSelectedItem.getItem();
                    reassigned.put(oldDi, newDi);
                    continue block17;
                }
                case 2: {
                    oldSelectedItem.setRole(Role.HIDDEN);
                    continue block17;
                }
                case 1: {
                    continue block17;
                }
            }
        }
        block18: for (i = 0; i < actions.length; ++i) {
            oldSelectedItem = cloneDS.getSelectedItems().get(i);
            int action = actions[i];
            switch (action) {
                case 8: {
                    this.replaceFotWithAggregate(cloneDS, i, reassigned);
                    SelectedItem newSelectedItem = cloneDS.getSelectedItems().get(i);
                    newSelectedItem.setRole(Role.HIDDEN);
                    continue block18;
                }
                case 7: {
                    this.replaceFotWithAggregate(cloneDS, i, reassigned);
                    continue block18;
                }
                case 6: {
                    oldSelectedItem.setRole(Role.HIDDEN);
                    continue block18;
                }
                case 5: {
                    continue block18;
                }
            }
        }
        try {
            ((ExplicitJoinPathSupport)((Object)cloneDS)).setExplicitJoinPath(originalDataSelection.getEffectiveJoinPath());
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        if (why != null) {
            this._why = why.toString();
        }
        return cloneDS;
    }

    private void replaceFotWithAggregate(DataSelection cloneDS, int index, Map reassigned) throws GenerationException {
        this.replaceWithAggregate(cloneDS, index);
        SelectedItem newSelectedItem = cloneDS.getSelectedItems().get(index);
        DataItem newDi = newSelectedItem.getItem();
        FractionOfTotalExpression fote = (FractionOfTotalExpression)newDi.getExpression();
        DataItem updateNum = (DataItem)reassigned.get(fote.getNumerator());
        if (updateNum != null) {
            try {
                fote.setNumerator(updateNum);
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
        }
    }

    private void replaceWithAggregate(DataSelection cloneDS, int index) throws GenerationException {
        SelectedItem selectedItem = cloneDS.getSelectedItems().get(index);
        DataItem resultItem = selectedItem.getItem();
        Role role = selectedItem.getRole();
        try {
            DataItemReference ref = cloneDS.newDataItemReference(resultItem);
            cloneDS.addBusinessItem(ref);
            ref.setResultSetID(resultItem.getResultSetID());
            if (!ref.isActionSupported(DataItemActionType.USAGE_AGGREGATE)) {
                ref.setActionSupported(DataItemActionType.USAGE_AGGREGATE, true);
            }
            ref.setUsage(DataItemActionType.USAGE_AGGREGATE);
            cloneDS.removeSelectedItem(selectedItem);
            cloneDS.insertResultItemsAt(ref, role, index);
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        SelectedItem newSelectedItem = cloneDS.getSelectedItems().get(index);
        newSelectedItem.setFormatType(selectedItem.getFormatType());
        newSelectedItem.setJoinBehavior(selectedItem.getJoinBehavior());
    }

    public static boolean isNonVisualTotalsCalcNeeded(DataSelection dataSelection) throws GenerationException {
        boolean needed = false;
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        Iterator<SelectedItem> iterator = selectedItems.iterator();
        while (iterator.hasNext() && !needed) {
            SelectedItem selectedItem = iterator.next();
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            needed = NonVisualTotalsComposite.isNonVisualTotalCalcNeeded(dataSelection, resultItem, role, null);
        }
        return needed;
    }

    private static boolean isNonVisualTotalCalcNeeded(DataSelection dataSelection, DataItem resultItem, Role role, StringBuffer reason) throws GenerationException {
        DataItemActionType usage = resultItem.getUsage();
        boolean needed = false;
        if (usage == DataItemActionType.USAGE_CATEGORY) {
            if (reason != null) {
                reason.append("Category item not applicable to grand total calculations.");
            }
        } else {
            boolean isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem);
            if (isFotTotalItem) {
                StringBuffer reasonFoGT = reason != null ? new StringBuffer() : null;
                needed = FractionOfGrandTotalStep.needsNonVisualTotalCalc(dataSelection, resultItem, role, reasonFoGT);
                if (needed) {
                    boolean isInactive;
                    Role numeratorRole = FractionOfTotalUtilImpl.getNumeratorRoleInQuery(dataSelection, resultItem);
                    boolean bl = isInactive = numeratorRole == Role.BACKGROUND || Role.isInactiveRole(dataSelection, numeratorRole);
                    if (isInactive || numeratorRole == null) {
                        if (reason != null) {
                            DataItem numerator = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(resultItem);
                            reason.append("Fraction-of-Total Item (alias=").append(resultItem.getResultSetID()).append(", type=").append(resultItem.getAggregationType()).append(") has a Numerator (alias=").append(numerator.getResultSetID()).append(", type=").append(numerator.getAggregationType()).append(") with a non-visible role.");
                            if (numeratorRole != null) {
                                reason.append(" of ").append(numeratorRole);
                            }
                            reason.append('.');
                        }
                    } else {
                        needed = false;
                        if (reason != null) {
                            DataItem numerator = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(resultItem);
                            reason.append("Numerator (alias=").append(numerator.getResultSetID()).append(", type=").append(numerator.getAggregationType()).append(") will be used to calculate Fraction-of-Total Item (alias=").append(resultItem.getResultSetID()).append(", type=").append(resultItem.getAggregationType()).append(").");
                        }
                    }
                } else if (reason != null) {
                    reason.append(reasonFoGT);
                }
            } else {
                boolean isUsedByFoT = FractionOfTotalUtilImpl.isUsedByFractionOfTotalInQuery(dataSelection, resultItem);
                if (isUsedByFoT) {
                    boolean nonAdditiveNumerator = DataRetrievalUtil.isNonAdditiveMeasure(resultItem);
                    if (nonAdditiveNumerator) {
                        needed = true;
                        if (reason != null) {
                            reason.append("Item is a Fraction-of-Total numerator (alias=").append(resultItem.getResultSetID()).append(", agg=").append(resultItem.getAggregationType()).append(") and is non-additive.");
                        }
                    } else {
                        needed = RelationalPostProcessComposite.isNeededForNvtTotalsUpdate(dataSelection, resultItem, role, reason);
                    }
                } else {
                    needed = RelationalPostProcessComposite.isNeededForNvtTotalsUpdate(dataSelection, resultItem, role, reason);
                }
            }
        }
        return needed;
    }

    protected void finalize() throws Throwable {
        super.setDataSelectionProcessor(null);
        this._originalDsProcessor = null;
        this._originalDataSelection = null;
        if (this._dataSelection != null) {
            CloneDataSelectionFactory.removeOldClonesOfRelational(this._dataSelection);
            this._dataSelection = null;
        }
        super.finalize();
    }

    protected void setResultsTableName(String resultsTableName) {
        this._resultsTableName = resultsTableName;
    }

    public void setInputTableName(String inputTableName) {
        this._inputTableName = inputTableName;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        DataSelection cloneDS = this.setupNonVisualTotalsDataSelection(this._originalDsProcessor, this._isOriginalRanked, this._isOriginalDetailed);
        this.setDataSelection(cloneDS);
        NonVisualTotalsDataSelectionProcessor dsProcessor = new NonVisualTotalsDataSelectionProcessor(cloneDS);
        try {
            dsProcessor.populate();
        }
        catch (GenerationException ge) {
            _logger.debug("Intentionally ignoring during setup", (Throwable)ge);
        }
        super.setDataSelectionProcessor(dsProcessor);
        this.addComponent(new CommentStatement(2, 1).append(" start: calculate non-visual totals table ").append(this._resultsTableName).append(this._why).append(' '));
        if (this._isDetails) {
            if (this._isRanked) {
                this.addComponent(new CommentStatement(0, 1).append(" calculated using ranked detail data in ").append(this._inputTableName).append(' '));
            } else {
                this.addComponent(new CommentStatement(0, 1).append(" calculated using detail data in ").append(this._inputTableName).append(' '));
            }
        } else if (this._isRanked) {
            this.addComponent(new CommentStatement(0, 1).append(" calculated using summarized data from original query\n").append(" * filtered by ranked categories in ").append(this._inputTableName).append(' '));
        } else if (this._isAggPreFiltered) {
            this.addComponent(new CommentStatement(0, 1).append(" calculated using summarized data from original query\n").append(" * filtered by categories in ").append(this._inputTableName).append(' '));
        }
        List<SQLComponentAbstract> compositeList = this.getCompositeList();
        boolean useTsSql = dsProcessor.isTSSQL();
        String options = SQLStatementFactory.getProcSqlOptions(useTsSql, this._dataSelection);
        SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, options);
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, this._resultsTableName);
        super.prepareSQL();
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        if (useTsSql) {
            ProcSQLDecorator tsSqlFixup = new ProcSQLDecorator(this._dataSelection, this._resultsTableName);
            tsSqlFixup.setSQLColumns(this.getSQLColumns());
            tsSqlFixup.setDataSelectionProcessor(dsProcessor);
            tsSqlFixup.setSQLFactory(this.getSQLFactory());
            tsSqlFixup.prepareSQL();
            this.getCompositeList().add(tsSqlFixup);
        }
        if (!this._dropKeys.isEmpty()) {
            StringBuffer dropColumns = new StringBuffer();
            Iterator<String> iterator = this._dropKeys.iterator();
            while (iterator.hasNext()) {
                if (dropColumns.length() > 0) {
                    dropColumns.append('\t');
                }
                String dropKeyRsid = iterator.next();
                String dropKeyIdentifier = this.getDataSelectionProcessor().generateDataStepVar(dropKeyRsid);
                dropColumns.append(dropKeyIdentifier).append('\n');
            }
            StringBuffer code = new StringBuffer();
            code.append("\nData ").append(this._inputTableName);
            code.append("\n(drop=").append(dropColumns).append(");");
            code.append("\nset ").append(this._inputTableName).append(";");
            code.append("\nrun;\n");
            this.addComponent(new CodeStringAdapterComponent(code));
        }
        this.addComponent(new CommentStatement(1, 1).append(" end: calculate non-visual totals to ").append(this._resultsTableName).append(' '));
    }

    @Override
    protected SQLComponentAbstract _generateFrom() throws GenerationException {
        SQLComponentAbstract from = super._generateFrom();
        if ((this._isRanked || this._isAggPreFiltered) && !this._isDetails) {
            from = new NonVisualTotalsSQLFrom(from, this._inputTableName);
            from.prepareSQL();
        }
        return from;
    }

    @Override
    protected SQLComponentAbstract _generateWhere() throws GenerationException {
        SQLComponentAbstract where = super._generateWhere();
        if ((this._isRanked || this._isAggPreFiltered) && !this._isDetails) {
            where = new NonVisualTotalsSQLWhere(where, this._selectedItemCategories, this._isRanked);
            where.setSQLFactory(this.getSQLFactory());
            where.setDataSelection(this._dataSelection);
            where.setDataSelectionProcessor(this.getDataSelectionProcessor());
            where.setJoinGenerator(this.m_joinGenerator);
            where.prepareSQL();
            this._dropKeys.addAll(((NonVisualTotalsSQLWhere)where).getDropKeys());
        }
        return where;
    }

    @Override
    protected SQLComponentAbstract _generateGroupBy() throws GenerationException {
        return new SQLEmptyGroupBy();
    }

    @Override
    protected SQLComponentAbstract _generateOrderBy() throws GenerationException {
        return new SQLEmptyOrderBy();
    }

    @Override
    protected SQLComponentAbstract _generateHaving() throws GenerationException {
        return new SQLEmptyHaving();
    }

    protected void setIsAggPreFiltered(boolean hasAggFilters) {
        this._isAggPreFiltered = hasAggFilters;
    }
}

