/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFactoryInterface;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.AbstractSASStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CommentStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsUpdateStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcSQLDecorator;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalItem;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FractionOfGrandTotalStep {
    static final boolean allowTsSqlInFractionOfGrandTotalStep = true;
    public static int GEN_FOT_WITH_SORTING = 1;
    public static int GEN_FOT_IGNORING_ORDER = 2;
    public static int GEN_FOT_PERSERVING_ORDER = 3;

    public static void addCode(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, SQLFactoryInterface sqlFactory, String tableName, List<RelationalItem> postProcessSortingItems, int applySort) throws GenerationException {
        boolean hasSort;
        boolean isInactive;
        boolean isOutputResultItem;
        String outputColAlias;
        Role role;
        DataItem resultItem;
        String grandTotalTableName = tableName + "gt";
        String outputComparisonTableName = tableName + "comp";
        CommentStatement comment1 = null;
        if (IQSystemProperties.isVerboseProcCommentsEnabled(FractionOfGrandTotalStep.class)) {
            comment1 = new CommentStatement("Generating Fraction-of-Totals");
        }
        ArrayList<String> columnVarList = new ArrayList<String>();
        CommentStatement comment2 = null;
        if (IQSystemProperties.isVerboseProcCommentsEnabled(FractionOfGrandTotalStep.class)) {
            comment2 = new CommentStatement();
        }
        if (!DataRetrievalUtil.isModelDetailed(dataSelection)) {
            for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
                DataItem resultItem2 = selectedItem.getItem();
                Role role2 = selectedItem.getRole();
                String alias = resultItem2.getResultSetID();
                StringBuffer reason = comment2 != null ? new StringBuffer() : null;
                boolean needsNonVisualTotalCalc = FractionOfGrandTotalStep.needsNonVisualTotalCalc(dataSelection, resultItem2, role2, reason);
                if (needsNonVisualTotalCalc) {
                    String aliasGt = FractionOfGrandTotalStep.generateFoTInputVarName(alias, dsProcessor, dataSelection, resultItem2);
                    columnVarList.add(aliasGt);
                    if (comment2 == null) continue;
                    comment2.append("\n *    updating ").append(alias).append(" : ").append(reason);
                    continue;
                }
                if (comment2 == null) continue;
                comment2.append("\n *    ignoring ").append(alias).append(" : ").append(reason);
            }
        }
        boolean sumGroupValues = true;
        boolean isModelDetailed = DataRetrievalUtil.isModelDetailed(dataSelection);
        if (isModelDetailed) {
            sumGroupValues = false;
        }
        ArrayList<DataItem> usedFractionOfTotals = new ArrayList<DataItem>();
        ArrayList<String> sqlDefs = new ArrayList<String>();
        StringBuffer denomDefs = new StringBuffer();
        StringBuffer columnDefs = new StringBuffer();
        ArrayList<ProcSQLDecorator.SQLDecoratorColumn> sqlColumns = new ArrayList<ProcSQLDecorator.SQLDecoratorColumn>();
        if (applySort == GEN_FOT_WITH_SORTING || applySort == GEN_FOT_IGNORING_ORDER) {
            LinkedHashSet<RelationalItem> keepSortItems = new LinkedHashSet<RelationalItem>();
            if (applySort != GEN_FOT_WITH_SORTING) {
                keepSortItems.addAll(postProcessSortingItems);
            }
            for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
                resultItem = selectedItem.getItem();
                role = selectedItem.getRole();
                outputColAlias = resultItem.getResultSetID();
                isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
                isInactive = Role.isInactiveRole(dataSelection, role);
                boolean bl = hasSort = resultItem.getSortDirection() != DataItemActionType.SORT_NONE;
                if (isOutputResultItem || !isInactive && hasSort) {
                    String outputColIdentifier = dsProcessor.generateColumnIdentifier(outputColAlias, true);
                    if (FractionOfTotalUtilImpl.isFractionOfGrandTotalItem(resultItem)) {
                        String inputColAlias = FractionOfGrandTotalStep.generateFoTInputVarName(outputColAlias, dsProcessor, dataSelection, resultItem);
                        String numAlias = "dat." + dsProcessor.generateColumnIdentifier(inputColAlias);
                        String demAlias = "gt." + dsProcessor.generateColumnIdentifier(inputColAlias);
                        String def = "\t" + numAlias + " / " + demAlias + " as " + outputColIdentifier;
                        if (!dsProcessor.isTSSQL()) {
                            String fogtFormat = GenerationUtil.generateFormatEqStatement(resultItem);
                            String fogtLabel = GenerationUtil.generateLabelEqStatement(resultItem);
                            def = def + fogtFormat + fogtLabel;
                        }
                        sqlDefs.add(def);
                        sqlColumns.add(ProcSQLDecorator.newSQLDecoratorColumn(resultItem));
                        FractionOfGrandTotalStep.removedSortItem(keepSortItems, outputColAlias);
                        if (outputColAlias.equals(inputColAlias)) {
                            if (comment1 != null) {
                                comment1.append("\n *  ").append(outputColAlias).append(" : using as FoGT item");
                            }
                            usedFractionOfTotals.add(resultItem);
                            continue;
                        }
                        if (comment1 == null) continue;
                        comment1.append("\n *  ").append(outputColAlias).append(" : calculated as Fraction of Grand Total item using ").append(inputColAlias);
                        continue;
                    }
                    sqlDefs.add("\tdat." + outputColIdentifier);
                    FractionOfGrandTotalStep.removedSortItem(keepSortItems, outputColAlias);
                    sqlColumns.add(ProcSQLDecorator.newSQLDecoratorColumn(resultItem));
                    if (!FractionOfTotalUtilImpl.isUsedByFractionOfTotalInQuery(dataSelection, resultItem)) continue;
                    usedFractionOfTotals.add(resultItem);
                    continue;
                }
                if (FractionOfTotalUtilImpl.isUsedByFractionOfTotalInQuery(dataSelection, resultItem)) {
                    usedFractionOfTotals.add(resultItem);
                    if (comment1 == null) continue;
                    comment1.append("\n *  ").append(outputColAlias).append(" : used by Fraction of Total item, but dropping during FoT calc because role is ").append(role);
                    continue;
                }
                if (comment1 == null) continue;
                comment1.append("\n *  ").append(outputColAlias).append(" : ignored because its role is ").append(role).append(" and it is not used in post process sorting or ranking");
            }
            for (RelationalItem relationalSortingItem : keepSortItems) {
                String resultSetId = relationalSortingItem.getResultSetID();
                sqlDefs.add("\tdat." + dsProcessor.generateColumnIdentifier(resultSetId));
                if (comment1 == null) continue;
                comment1.append("\n *  ").append(resultSetId).append(" : passing thru unchanged");
            }
        } else {
            int denomCount = 0;
            for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
                resultItem = selectedItem.getItem();
                role = selectedItem.getRole();
                outputColAlias = resultItem.getResultSetID();
                isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
                isInactive = Role.isInactiveRole(dataSelection, role);
                boolean bl = hasSort = resultItem.getSortDirection() != DataItemActionType.SORT_NONE;
                if (isOutputResultItem || !isInactive && hasSort) {
                    if (FractionOfTotalUtilImpl.isFractionOfGrandTotalItem(resultItem)) {
                        ++denomCount;
                        String inputColAlias = FractionOfGrandTotalStep.generateFoTInputVarName(outputColAlias, dsProcessor, dataSelection, resultItem);
                        String fogtAlias = dsProcessor.generateDataStepVar(outputColAlias);
                        String fogtFormat = GenerationUtil.generateFormatEqStatement(resultItem);
                        String fogtLabel = GenerationUtil.generateLabelEqStatement(resultItem);
                        String numAlias = dsProcessor.generateDataStepVar(inputColAlias);
                        String denomAlias = "_denom_" + denomCount;
                        denomDefs.append("   /* denominator for ").append(fogtAlias).append(" */\n").append("   retain ").append(denomAlias).append(" 1.00;\n   if _totals_ then ").append(denomAlias).append(" = ").append(numAlias).append(";\n");
                        columnDefs.append("  /* calculate FoGT for ").append(fogtAlias).append(" */\n").append("   attrib ").append(fogtAlias).append(fogtFormat).append(fogtLabel).append(";\n   if ").append(denomAlias).append(" = 0 then\n      ").append(fogtAlias).append(" = .;\n   else\n");
                        boolean disabledGT = DisabledTotalsBuilder.isDisabledTotaling(dataSelection, resultItem, TotalingType.AXISTOTAL);
                        if (disabledGT) {
                            columnDefs.append("   if _totals_ then\n      ").append(fogtAlias).append(" = .;\n   else\n      ");
                        }
                        columnDefs.append("      ").append(fogtAlias).append(" = ").append(numAlias).append(" / ").append(denomAlias).append(";\n");
                        if (outputColAlias.equals(inputColAlias)) {
                            if (comment1 != null) {
                                comment1.append("\n *  ").append(outputColAlias).append(" : using as FoGT item");
                            }
                            usedFractionOfTotals.add(resultItem);
                            continue;
                        }
                        if (comment1 == null) continue;
                        comment1.append("\n *  ").append(outputColAlias).append(" : calculated as Fraction of Grand Total item using ").append(inputColAlias);
                        continue;
                    }
                    usedFractionOfTotals.add(resultItem);
                    continue;
                }
                if (!FractionOfTotalUtilImpl.isUsedByFractionOfTotalInQuery(dataSelection, resultItem)) continue;
                usedFractionOfTotals.add(resultItem);
                if (comment1 == null) continue;
                comment1.append("\n *  ").append(outputColAlias).append(" : used by Fraction of Total item, but dropping during FoT calc because role is ").append(role);
            }
            if (comment1 != null) {
                comment1.append("\n */\n");
            }
        }
        if (comment1 != null) {
            compositeList.add(comment1);
        }
        SQLStatementFactory.addText(compositeList, "\n\n/* Grand total comparison step begin */\n");
        ArrayList<DataItem> measures = new ArrayList<DataItem>();
        for (int i = 0; i < usedFractionOfTotals.size(); ++i) {
            DataItem usedItem = (DataItem)usedFractionOfTotals.get(i);
            boolean isItemToSummarize = DataRetrievalUtil.isSummarizableItem(usedItem);
            if (!isItemToSummarize) continue;
            measures.add(usedItem);
        }
        boolean isAsync = IQSystemProperties.isSasSubmitAsync();
        ExpandedProcSummaryStatement statement = new ExpandedProcSummaryStatement(dataSelection, tableName, true, false, null, measures, grandTotalTableName, true, true, true, !isAsync, sumGroupValues, null, true, false, true);
        statement.setDataSelectionProcessor(dsProcessor);
        statement.setSQLFactory(sqlFactory);
        ((AbstractSASStatement)statement).prepareSQL();
        compositeList.add(statement);
        SQLStatementFactory.addNewLine(compositeList);
        boolean inProcSQL = false;
        if (columnVarList.size() > 0) {
            inProcSQL = NonVisualTotalsUpdateStep.addCode(compositeList, dsProcessor, columnVarList, null, tableName + "_nvt", grandTotalTableName, "during FoT GrandTotal step", inProcSQL);
            SQLStatementFactory.addNewLine(compositeList);
        }
        if ((applySort == GEN_FOT_WITH_SORTING || applySort == GEN_FOT_IGNORING_ORDER) && IQSystemProperties.isVerboseProcCommentsEnabled(FractionOfGrandTotalStep.class)) {
            if (applySort == GEN_FOT_WITH_SORTING) {
                SQLStatementFactory.addText(compositeList, "/* calculate the grand totals for the FoGT columns (and sort results) */\n");
            } else {
                SQLStatementFactory.addText(compositeList, "/* calculate the grand totals for the FoGT columns (without preserving record order) */\n");
            }
        }
        if (comment2 != null) {
            compositeList.add(comment2);
        }
        if (applySort == GEN_FOT_WITH_SORTING || applySort == GEN_FOT_IGNORING_ORDER) {
            if (!inProcSQL) {
                SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, null);
                inProcSQL = true;
            }
            SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addCreateTableAs(compositeList, dsProcessor, outputComparisonTableName);
            StringBuffer sql = FractionOfGrandTotalStep.generateFotComputationQuery(dsProcessor, tableName, postProcessSortingItems, applySort, grandTotalTableName, sqlDefs);
            SQLStatementFactory.addText(compositeList, sql);
            SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
            SQLStatementFactory.addNewLine(compositeList);
        } else {
            if (inProcSQL) {
                SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                SQLStatementFactory.addNewLine(compositeList);
                inProcSQL = false;
            }
            StringBuffer dataStep = FractionOfGrandTotalStep.generateFotComputationDataStep(tableName, grandTotalTableName, outputComparisonTableName, denomDefs, columnDefs);
            SQLStatementFactory.addText(compositeList, dataStep);
        }
        if (!inProcSQL) {
            SQLStatementFactory.addProcDeleteDataByName(compositeList, dsProcessor, tableName);
        } else {
            SQLStatementFactory.addDropTableByName(compositeList, dsProcessor, tableName);
            SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
            inProcSQL = false;
        }
        SQLStatementFactory.addProcDataSetsRename(compositeList, outputComparisonTableName, tableName);
        SQLStatementFactory.addText(compositeList, "\n/* Grand total comparison step end */\n");
    }

    private static StringBuffer generateFotComputationQuery(DataSelectionProcessorAbstract dsProcessor, String tableName, List<RelationalItem> postProcessSortingItems, int applySort, String grandTotalTableName, List<String> sqlDefs) throws GenerationException {
        StringBuffer sortItemsClause;
        int countOfSortItems;
        StringBuffer sql = new StringBuffer();
        sql.append("  select\n");
        boolean written = false;
        for (String sqlDef : sqlDefs) {
            if (written) {
                sql.append(", \n");
            }
            sql.append(sqlDef);
            written = true;
        }
        sql.append("\n    from " + tableName + " as dat, " + grandTotalTableName + " as gt");
        if (postProcessSortingItems != null && postProcessSortingItems.size() > 0 && applySort == GEN_FOT_WITH_SORTING && (countOfSortItems = RelationalSortingStep.writeSQLSortItems(sortItemsClause = new StringBuffer(), dsProcessor, postProcessSortingItems, false, false)) > 0) {
            sql.append("\n   order by" + sortItemsClause);
        }
        return sql;
    }

    private static StringBuffer generateFotComputationDataStep(String tableName, String grandTotalTableName, String outputComparisonTableName, StringBuffer denomDefs, StringBuffer columnDefs) {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append("/* calculate the grand totals for the FoGT columns (while preserving record order) */\n");
        dataStep.append("data " + outputComparisonTableName + ";\n");
        dataStep.append("   set " + grandTotalTableName + " " + tableName + ";\n");
        dataStep.append("   drop _denom_:;\n");
        dataStep.append("   _totals_ = (_n_ = 1);\n\n");
        dataStep.append(denomDefs);
        dataStep.append("\n   if _totals_ = 0;\n");
        dataStep.append(columnDefs);
        dataStep.append("run;\n");
        return dataStep;
    }

    public static boolean needsNonVisualTotalsCalc(DataSelection dataSelection) throws GenerationException {
        boolean needsNonVisualTotalCalc = false;
        Iterator<SelectedItem> iterator = dataSelection.getSelectedItems().iterator();
        while (iterator.hasNext() && !needsNonVisualTotalCalc) {
            SelectedItem selectedItem = iterator.next();
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            needsNonVisualTotalCalc = FractionOfGrandTotalStep.needsNonVisualTotalCalc(dataSelection, resultItem, role, null);
        }
        return needsNonVisualTotalCalc;
    }

    public static boolean needsNonVisualTotalCalc(DataSelection dataSelection, DataItem resultItem, Role role, StringBuffer reason) throws GenerationException {
        boolean needsNonVisualTotalCalc = false;
        boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
        if (isOutputResultItem) {
            if (FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem)) {
                Function fotItemAggType = resultItem.getAggregationType();
                DataItem numerator = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(resultItem);
                String aliasNum = numerator.getResultSetID();
                Function numAggType = numerator.getAggregationType();
                boolean nonAdditiveNumerator = DataRetrievalUtil.isNonAdditiveMeasure(numerator);
                if (nonAdditiveNumerator) {
                    needsNonVisualTotalCalc = true;
                    String aliasFoT = resultItem.getResultSetID();
                    if (reason != null) {
                        reason.append("Aggregations for Fraction-of-Total (alias=").append(aliasFoT).append(", agg=").append(fotItemAggType).append(") and it's numerator (alias=").append(aliasNum).append(", agg=").append(numAggType).append(") are non-additive.");
                    }
                } else if (reason != null) {
                    reason.append("Aggregation for Fraction-of-Total's numerator (alias=").append(aliasNum).append(", agg=").append(numAggType).append(") is additive.");
                }
            } else if (reason != null) {
                reason.append("Item is not a Fraction-of-Total");
            }
        } else if (reason != null) {
            reason.append("Item has a non-output result role '").append(role).append('\'');
        }
        return needsNonVisualTotalCalc;
    }

    private static void removedSortItem(Set<RelationalItem> keepSortItems, String outputColAlias) {
        Iterator<RelationalItem> iterator = keepSortItems.iterator();
        while (iterator.hasNext()) {
            RelationalItem relationalSortingItem = iterator.next();
            if (!relationalSortingItem.getResultSetID().trim().equals(outputColAlias.trim())) continue;
            iterator.remove();
        }
    }

    public static String generateFoTInputVarName(String aliasFoT, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, DataItem item) throws GenerationException {
        String varName = aliasFoT;
        DataItem numeratorItem = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(item);
        boolean useNumeratorItemInstead = FractionOfGrandTotalStep.useNumeratorAliasForInputVar(dsProcessor, dataSelection, item, numeratorItem);
        if (useNumeratorItemInstead) {
            String aliasNum;
            varName = aliasNum = numeratorItem.getResultSetID();
        }
        return varName;
    }

    public static boolean useNumeratorAliasForInputVar(DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, DataItem item, DataItem numeratorItem) throws GenerationException {
        boolean useNumeratorItemInstead = false;
        Role numeratorRole = FractionOfTotalUtilImpl.getNumeratorRoleInQuery(dataSelection, item);
        if (numeratorRole != null) {
            Map<DataItem, Set<TotalingType>> disabledTotalsByItem = DisabledTotalsBuilder.getDisabledTotalingByItem(dataSelection, true);
            Set<TotalingType> numeratorDisabledTotals = disabledTotalsByItem.get(numeratorItem);
            if (numeratorDisabledTotals != null) {
                numeratorDisabledTotals.remove(TotalingType.TOTAL_NONE);
            }
            if (numeratorDisabledTotals == null || numeratorDisabledTotals.isEmpty()) {
                useNumeratorItemInstead = dsProcessor.isNeededForPostProcess(dataSelection, numeratorItem, numeratorRole);
            }
        }
        return useNumeratorItemInstead;
    }
}

