/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.IMStat;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.relational.SQLGeneration;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringFactory;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class CodeStringGeneration
extends SQLGeneration {
    static final Logger _logger = LogManager.getLogger(CodeStringGeneration.class);

    public CodeStringGeneration(DataSelection model) throws GenerationException {
        this._factory = new CodeStringFactory(model);
    }

    @Override
    protected void checkValid(DataSelection selection) throws GenerationException {
    }

    public static boolean canHandle(DataSelection dataSelection) {
        Export export;
        List<ExportRule> exportRules = dataSelection.getEffectiveRules(ExportRule.class);
        Export export2 = export = exportRules.isEmpty() ? null : exportRules.get(0).getExport();
        if (export != null && export.getUsage() == ExportType.LASR_OMA_TABLE) {
            return true;
        }
        boolean imStatEnabled = IMStat.isImStatEnabled();
        List<DataSourceTable> dsList = dataSelection.getObjects(true, DataSourceTable.class);
        if (imStatEnabled && dsList.size() == 1) {
            boolean hasLasrEngine;
            DataSourceTable dataSourceTable = dsList.get(0);
            try {
                hasLasrEngine = IMStat.hasLasrEngine(dataSourceTable);
            }
            catch (MetadataException e) {
                _logger.warn((Object)e);
                return false;
            }
            if (hasLasrEngine) {
                Set<FunctionNameID> supportedFunctions;
                boolean canHandle = true;
                try {
                    supportedFunctions = IMStat.getSupportedFunctions(dataSelection);
                }
                catch (MetadataException e) {
                    _logger.warn((Object)e);
                    return false;
                }
                boolean hasMeasure = false;
                for (SelectedItem si : dataSelection.getSelectedItems()) {
                    Role role = si.getRole();
                    DataItem di = si.getItem();
                    boolean isOutputResultRole = Role.isOutputResultRole(dataSelection, role);
                    if (!isOutputResultRole) {
                        canHandle = false;
                        break;
                    }
                    boolean isInactiveRole = Role.isInactiveRole(dataSelection, role);
                    if (isInactiveRole) continue;
                    try {
                        String columnNm = IMStat.generateColumnName(dataSelection, di.getExpression());
                        if (columnNm == null) {
                            canHandle = false;
                            break;
                        }
                    }
                    catch (GenerationException e) {
                        _logger.warn((Object)e);
                        canHandle = false;
                    }
                    if (di.getUsage() == DataItemActionType.USAGE_DETAIL) {
                        canHandle = false;
                        break;
                    }
                    if (di.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
                    hasMeasure = true;
                    Function aggregationType = di.getAggregationType();
                    if (aggregationType == null) {
                        canHandle = false;
                        break;
                    }
                    FunctionNameID function = aggregationType.getFunctionNameID();
                    if (supportedFunctions.contains(function)) continue;
                    canHandle = false;
                    break;
                }
                if (!hasMeasure) {
                    canHandle = false;
                }
                return canHandle;
            }
        }
        return false;
    }
}

