/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLSelectAbstract;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLSASSelect
extends SQLSelectAbstract {
    @Override
    public void prepareSQL() throws GenerationException {
        this.setGroupByIdentifierPositions(new HashMap<String, Object>());
        this.addSelectedItemsToColumnList(this._dataSelection.getSelectedItems());
    }

    protected void addSelectedItemsToColumnList(List<SelectedItem> selectedItems) throws GenerationException {
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            if (this.skipSelectedItem(selectedItem)) continue;
            SQLColumnAbstract sqlColumn = this._generateSelectColumn(item);
            this.addToColumnList(sqlColumn, true);
            if (sqlColumn.getItem().getExpressionType() != 9) continue;
            this.getDataSelectionProcessor().disableTSSQL();
        }
    }

    protected boolean skipSelectedItem(SelectedItem selectedItem) throws GenerationException {
        DataItem item = selectedItem.getItem();
        Role role = selectedItem.getRole();
        boolean isNeededForPostProcess = this.getDataSelectionProcessor().isNeededForPostProcess(this._dataSelection, item, role);
        boolean skip = !isNeededForPostProcess;
        return skip;
    }

    protected void addToColumnList(SQLColumnAbstract sqlColumn, boolean canGroupBy) {
        List<SQLColumnAbstract> sqlColumns = this.getSQLColumns();
        sqlColumns.add(sqlColumn);
        if (canGroupBy && sqlColumn.getItem() != null) {
            Map<String, Object> mapIdentifiersToPosition = this.getGroupByIdentifierPositions();
            String resultSetID = sqlColumn.getItem().getResultSetID();
            Integer groupByOrdinal = sqlColumns.size();
            mapIdentifiersToPosition.put(resultSetID, groupByOrdinal);
        }
    }

    protected void applyDistinct(StringBuffer sql) {
        if (this.isDistinct()) {
            sql.append(" DISTINCT ");
        }
    }

    @Override
    public String writeSQL() {
        StringBuffer sqlColumn = new StringBuffer();
        this.appendSelect(sqlColumn);
        this.appendColumns(sqlColumn, this.getSQLColumns(), ",\n\t", " ");
        return sqlColumn.toString();
    }

    protected void appendSelect(StringBuffer sql) {
        if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
            String label = this._dataSelection.getLabel();
            if (label == null || label.trim().length() == 0) {
                label = this._dataSelection.getID();
            }
            label = label.replaceAll("[*][/]", "* /");
            sql.append("/* " + label + " */\n");
        }
        sql.append("SELECT ");
        this.applyDistinct(sql);
        sql.append("\n\t");
    }

    protected void appendColumns(StringBuffer sqlColumn, List<SQLColumnAbstract> columnList, String colSep, String termSep) {
        Iterator<SQLColumnAbstract> columnIterator = columnList.iterator();
        while (columnIterator.hasNext()) {
            SQLColumnAbstract sqlColumnAbstract = columnIterator.next();
            sqlColumn.append(sqlColumnAbstract.writeSQL());
            if (columnIterator.hasNext()) {
                sqlColumn.append(colSep);
                continue;
            }
            sqlColumn.append(termSep);
        }
    }
}

