/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.relational.AbstractComparisonWithQueryResultsExpression;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFilterExaminerAbstract;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class SQLSASFilterExaminer
extends SQLFilterExaminerAbstract {
    public static final String HAVING = "HAVING";
    public static final String WHERE = "WHERE";

    @Override
    public void examineFilters() throws GenerationException {
        ExpressionInterface expression;
        List<FilterItem> filters = this._dataSelectionProcessor == null ? this._dataSelection.getEffectiveFilters() : this._dataSelectionProcessor.getEffectiveFilters(this._dataSelection);
        ArrayList<FilterItem> splitFilters = new ArrayList<FilterItem>();
        for (FilterItem filterItem : filters) {
            expression = filterItem.getExpression();
            this.splitApartConjunctions(expression, splitFilters);
        }
        for (FilterItem filterItem : splitFilters) {
            expression = filterItem.getExpression();
            String filterType = SQLSASFilterExaminer.examineFilterExpression(this._dataSelection, expression);
            if (HAVING.equals(filterType)) {
                this._havingFilters.add(filterItem);
                continue;
            }
            if (WHERE.equals(filterType)) {
                this._whereFilters.add(filterItem);
                continue;
            }
            throw new AssertionError((Object)("unknown filter type " + filterType));
        }
    }

    private void splitApartConjunctions(ExpressionInterface expression, List<FilterItem> splitFilters) throws GenerationException {
        ConditionalExpression exp;
        boolean insertExpression = false;
        if (expression instanceof CompoundConditionalExpression) {
            boolean notNegated;
            exp = (CompoundConditionalExpression)expression;
            boolean usesAND = ConditionalRelationType.AND.equals(((CompoundConditionalExpression)exp).getRelationType());
            boolean bl = notNegated = !exp.isNegated();
            if (usesAND && notNegated) {
                this.splitApartConjunctions(((CompoundConditionalExpression)exp).getLeftExpression(), splitFilters);
                this.splitApartConjunctions(((CompoundConditionalExpression)exp).getRightExpression(), splitFilters);
            } else {
                insertExpression = true;
            }
        } else if (expression instanceof MultipleConditionalExpression) {
            boolean notNegated;
            exp = (MultipleConditionalExpression)expression;
            boolean singleton = ((MultipleConditionalExpression)exp).getExpressionCount() == 1;
            boolean usesAND = ConditionalRelationType.AND.equals(((MultipleConditionalExpression)exp).getRelationType());
            boolean bl = notNegated = !exp.isNegated();
            if ((singleton || usesAND) && notNegated) {
                for (int i = 0; i < ((MultipleConditionalExpression)exp).getExpressionCount(); ++i) {
                    this.splitApartConjunctions(((MultipleConditionalExpression)exp).getExpression(i), splitFilters);
                }
            } else {
                insertExpression = true;
            }
        } else if (expression instanceof ConditionalExpressionAdapter) {
            ConditionalExpressionAdapter cea = (ConditionalExpressionAdapter)expression;
            ExpressionInterface innerExpr = cea.getExpression();
            if (innerExpr instanceof MultipleConditionalExpression || innerExpr instanceof CompoundConditionalExpression || innerExpr instanceof ConditionalExpressionAdapter) {
                this.splitApartConjunctions(innerExpr, splitFilters);
            } else {
                insertExpression = true;
            }
        } else {
            insertExpression = true;
        }
        if (insertExpression) {
            try {
                FilterItem splitFilter = this._dataSelection.newFilterItem();
                splitFilter.setExpression(expression);
                splitFilters.add(splitFilter);
            }
            catch (MetadataException e) {
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLSASFilterExaminer.splitApartConjunctions.MetadataException.txt", new Object[0]), (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String examineFilterExpression(BusinessModel model, @Nullable ExpressionInterface expression) throws GenerationException {
        returnFilterType = "WHERE";
        if (expression instanceof MultipleConditionalExpression) {
            conditional = (MultipleConditionalExpression)expression;
            return SQLSASFilterExaminer.examineFilterExpressions(model, conditional.getExpressionList());
        }
        leftFilterType = null;
        middleFilterType = null;
        rightFilterType = null;
        if (expression instanceof SimpleConditionalExpression_Comparison) {
            comparison = (SimpleConditionalExpression_Comparison)expression;
            left = comparison.getLeftExpression();
            right = comparison.getRightExpression();
            leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
            rightFilterType = SQLSASFilterExaminer.examineFilterExpression(model, right);
        } else if (expression instanceof SimpleConditionalExpression_Between) {
            between = (SimpleConditionalExpression_Between)expression;
            left = between.getLeftExpression();
            right = between.getRightExpression();
            middle = between.getWhatToCompare();
            leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
            middleFilterType = SQLSASFilterExaminer.examineFilterExpression(model, middle);
            rightFilterType = SQLSASFilterExaminer.examineFilterExpression(model, right);
        } else if (expression instanceof SimpleConditionalExpression_In) {
            in = (SimpleConditionalExpression_In)expression;
            middle = in.getWhatToCompare();
            middleFilterType = SQLSASFilterExaminer.examineFilterExpression(model, middle);
        } else if (expression instanceof SimpleConditionalExpression_TestForNull) {
            left = ((SimpleConditionalExpression_TestForNull)expression).getWhatToCompare();
            leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
        } else if (expression instanceof ConditionalExpressionAdapter) {
            cea = (ConditionalExpressionAdapter)expression;
            returnFilterType = SQLSASFilterExaminer.examineFilterExpression(model, cea.getExpression());
        } else if (!(expression instanceof Prompt || expression instanceof ConstantExpression || expression instanceof AbstractTimeValueExpression || expression instanceof AbstractRelativeTimeValueExpression)) {
            if (expression instanceof SimpleConditionalExpression_Like) {
                like = (SimpleConditionalExpression_Like)expression;
                left = like.getWhatToCompare();
                right = like.getPatternExpression();
                leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
                rightFilterType = SQLSASFilterExaminer.examineFilterExpression(model, right);
            } else if (expression instanceof SimpleConditionalExpression_Contains) {
                contains = (SimpleConditionalExpression_Contains)expression;
                left = contains.getWhatToCompare();
                right = contains.getWhatToContain();
                leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
                rightFilterType = SQLSASFilterExaminer.examineFilterExpression(model, right);
            } else if (expression instanceof CompoundConditionalExpression) {
                conditional = (CompoundConditionalExpression)expression;
                left = conditional.getLeftExpression();
                right = conditional.getRightExpression();
                leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
                rightFilterType = SQLSASFilterExaminer.examineFilterExpression(model, right);
            } else if (expression instanceof ResourceAwareStringExpression) {
                rase = (ResourceAwareStringExpression)expression;
                try {
                    if (rase.containsUserTypedAggregation()) {
                        returnFilterType = "HAVING";
                    }
                    left = rase.getResources(DataItem.class, 65535).iterator();
                    while (left.hasNext() && !"HAVING".equals(returnFilterType = SQLSASFilterExaminer.examineFilterExpression(model, item = left.next()))) {
                    }
                }
                catch (MetadataException e) {
                    throw new GenerationException(e);
                }
            } else if (expression instanceof StringExpression) {
                try {
                    props = model.getServerProperties();
                    text = StringExpressionUtil.getInstance().getText(expression);
                    aggInExpression = props.containsAggregateFunction(text);
                    if (!aggInExpression) ** GOTO lbl128
                    returnFilterType = "HAVING";
                }
                catch (MetadataException e) {
                    throw new GenerationException(e);
                }
            } else if (expression instanceof FunctionCall) {
                call = (FunctionCall)expression;
                args = call.getArguments();
                for (index = 0; index < args.size(); ++index) {
                    argType = SQLSASFilterExaminer.examineFilterExpression(model, args.get(index));
                    if (!"HAVING".equals(argType)) continue;
                    returnFilterType = "HAVING";
                }
            } else if (expression instanceof DataItem) {
                item = (DataItem)expression;
                if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                    returnFilterType = "HAVING";
                } else {
                    try {
                        if (!item.containsUserTypedAggregation()) ** GOTO lbl128
                        returnFilterType = "HAVING";
                    }
                    catch (MetadataException e) {
                        throw new GenerationException(e);
                    }
                }
            } else if (!(expression instanceof Column)) {
                if (expression instanceof DataItemFormattingExpression) {
                    item = ((DataItemFormattingExpression)expression).getDataItem();
                    returnFilterType = SQLSASFilterExaminer.examineFilterExpression(model, item);
                } else if (expression instanceof AbstractComparisonWithQueryResultsExpression) {
                    comparison = (AbstractComparisonWithQueryResultsExpression)expression;
                    left = comparison.getWhatToCompare();
                    leftFilterType = SQLSASFilterExaminer.examineFilterExpression(model, left);
                } else if (expression instanceof DataBasedFilterExpression) {
                    dbfe = (DataBasedFilterExpression)expression;
                    whatToCompareType = SQLSASFilterExaminer.examineFilterExpression(model, dbfe.getWhatToCompare());
                    if ("HAVING".equals(whatToCompareType)) {
                        returnFilterType = "HAVING";
                    } else {
                        leftFiltersType = SQLSASFilterExaminer.examineFilterExpressions(model, dbfe.getLeftExpression());
                        if ("HAVING".equals(leftFiltersType)) {
                            returnFilterType = "HAVING";
                        } else {
                            rightFiltersType = SQLSASFilterExaminer.examineFilterExpressions(model, dbfe.getRightExpression());
                            if ("HAVING".equals(rightFiltersType)) {
                                returnFilterType = "HAVING";
                            }
                        }
                    }
                } else if (expression != null) {
                    mft = IQDataServicesResourceBundle.getMessageFormatter("SQLSASFilterExaminer._examineFilterExpressions.UnknownExpression.fmt.txt", new Object[]{expression.getClass().getName()});
                    throw new GenerationException(mft);
                }
            }
        }
lbl128:
        // 27 sources

        if ("HAVING".equals(leftFilterType)) {
            returnFilterType = "HAVING";
        }
        if ("HAVING".equals(middleFilterType)) {
            returnFilterType = "HAVING";
        }
        if ("HAVING".equals(rightFilterType)) {
            returnFilterType = "HAVING";
        }
        return returnFilterType;
    }

    private static String examineFilterExpressions(BusinessModel model, List<? extends ExpressionInterface> expressions) throws GenerationException {
        String returnFilterType = WHERE;
        for (ExpressionInterface expressionInterface : expressions) {
            String filterType = SQLSASFilterExaminer.examineFilterExpression(model, expressionInterface);
            if (!HAVING.equals(filterType)) continue;
            returnFilterType = HAVING;
            break;
        }
        return returnFilterType;
    }

    @Override
    public void prepareSQL() throws GenerationException {
    }

    @Override
    public String writeSQL() {
        return null;
    }
}

