/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.Cardinality;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinBehavior;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.JoinTypeList;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SQLJoinPathFormatter {
    static final String SQL_JOINTYPE_INNER = "Inner join";
    static final String SQL_JOINTYPE_FULL = "Full join";
    static final String SQL_JOINTYPE_LEFT = "Left join";
    static final String SQL_JOINTYPE_RIGHT = "Right join";
    static final String SQL_JOINTYPE_CROSS = "Cross join";
    static final String SQL_SUFFIX_JOINTYPE = " ";
    static final String SQL_PREFIX_ON_PREDICATE = "on ";
    static final String SQL_START_NESTED_JOIN = "( ";
    static final String SQL_END_NESTED_JOIN = ") ";
    static final String SQL_IMPLICIT_CROSS_JOIN = ", ";
    static final String SQL_COMPOUND_CROSS_JOIN_CONDS = " and ";
    static final String SQL_FORMATTING_NEWLINE = "";
    static final String SQL_FORMATTING_INDENT = "";
    static final String SQL_COMPOUND_MULTI_JOIN_CONDS = "  and ";
    static final String SQL_SUFFIX_ON_PREDICATE = " ";
    static final String SQL_NULL_OBJECT = "/* null */";
    private static final Logger _logger = LogManager.getLogger(SQLJoinPathFormatter.class);
    private boolean _optimizingSQL = true;
    private static final String NEWLINE = "\n\t";
    private int MAX_LINE_SIZE = 600;

    public boolean isOptimizingSQL() {
        return this._optimizingSQL;
    }

    public void setOptimizingSQL(boolean enableOptimizingSQL) {
        this._optimizingSQL = enableOptimizingSQL;
    }

    public abstract String formatTable(DataSourceTable var1) throws GenerationException;

    public abstract String formatPredicate(ExpressionInterface var1) throws GenerationException;

    private void smartAppend(StringBuffer dbmsStringStringBuffer, String value) {
        int sbLen = dbmsStringStringBuffer.length();
        int valueLen = value.length();
        int lastIndex = dbmsStringStringBuffer.lastIndexOf(NEWLINE);
        if (lastIndex != -1) {
            sbLen -= lastIndex;
        }
        if (sbLen + valueLen >= this.MAX_LINE_SIZE) {
            dbmsStringStringBuffer.append(NEWLINE);
        }
        dbmsStringStringBuffer.append(value);
    }

    public PathNode[] format(StringBuffer fromClause, StringBuffer whereClause, List joins) throws MetadataException, GenerationException {
        return this.format(fromClause, whereClause, joins, null);
    }

    public PathNode[] format(StringBuffer fromClause, StringBuffer whereClause, List joins, List<? extends SelectedItem> selectedItems) throws MetadataException, GenerationException {
        PathNode[] joinTrees = this.createJoinTrees(joins);
        if (selectedItems == null) {
            selectedItems = new ArrayList<SelectedItem>();
        }
        Map<DataSourceTable, JoinBehavior> joinBehaviors = this.getJoinWideningBehaviors(selectedItems);
        this.format(fromClause, whereClause, joinTrees, joinBehaviors);
        return joinTrees;
    }

    public JoinType getJoinTypeAfterWidening(List selectedItems, JoinNode node) throws MetadataException, GenerationException {
        Map<DataSourceTable, JoinBehavior> joinWideningBehaviors = this.getJoinWideningBehaviors(selectedItems);
        JoinType joinType = node.getJoinTypeAfterWidening(joinWideningBehaviors);
        return joinType;
    }

    public PathNode[] createJoinTrees(List joins) {
        ArrayList<JoinNode> joinTreeHeads = new ArrayList<JoinNode>();
        for (Join join : joins) {
            JoinNode newHead;
            DataSourceTable leftTable = join.getLeftDataSource();
            DataSourceTable rightTable = join.getRightDataSource();
            JoinType joinType = join.getType();
            ConditionalExpression cond = join.getJoinCondition();
            JoinTypeList allowedTypes = join.getAllowedTypes();
            Cardinality cardinality = join.getCardinality();
            PathNode leftNode = null;
            int leftIndex = 0;
            while (leftIndex < joinTreeHeads.size() && leftNode == null) {
                PathNode node = (PathNode)joinTreeHeads.get(leftIndex);
                if (node.contains(leftTable)) {
                    leftNode = node;
                    continue;
                }
                ++leftIndex;
            }
            PathNode rightNode = null;
            int rightIndex = 0;
            while (rightIndex < joinTreeHeads.size() && rightNode == null) {
                PathNode node = (PathNode)joinTreeHeads.get(rightIndex);
                if (node.contains(rightTable)) {
                    rightNode = node;
                    continue;
                }
                ++rightIndex;
            }
            if (leftNode == null && rightNode == null) {
                newHead = new JoinNode(leftTable, rightTable, joinType, cond, allowedTypes, cardinality);
                joinTreeHeads.add(newHead);
                continue;
            }
            if (leftNode == null) {
                newHead = new JoinNode(leftTable, rightNode, joinType, cond, allowedTypes, cardinality);
                joinTreeHeads.set(rightIndex, newHead);
                continue;
            }
            if (rightNode == null) {
                newHead = new JoinNode(leftNode, rightTable, joinType, cond, allowedTypes, cardinality);
                joinTreeHeads.set(leftIndex, newHead);
                continue;
            }
            if (leftIndex != rightIndex) {
                newHead = new JoinNode(leftNode, rightNode, joinType, cond, allowedTypes, cardinality);
                int removeFirst = Math.min(leftIndex, rightIndex);
                int removeSecond = Math.max(leftIndex, rightIndex);
                joinTreeHeads.remove(removeSecond);
                joinTreeHeads.remove(removeFirst);
                joinTreeHeads.add(newHead);
                continue;
            }
            leftNode.merge(leftTable, rightTable, joinType, cond, allowedTypes, cardinality);
        }
        return joinTreeHeads.toArray(new PathNode[joinTreeHeads.size()]);
    }

    public Map<DataSourceTable, JoinBehavior> getJoinWideningBehaviors(List<? extends SelectedItem> selectedItems) throws MetadataException, GenerationException {
        LinkedHashMap<DataSourceTable, JoinBehavior> dataSourcesJoinBehavior = new LinkedHashMap<DataSourceTable, JoinBehavior>();
        for (SelectedItem selectedItem : selectedItems) {
            int itemJoinBehavior = selectedItem.getJoinBehavior();
            if (itemJoinBehavior == 3) continue;
            JoinBehavior joinBehavior = itemJoinBehavior == 4 ? JoinBehavior.ALL : JoinBehavior.MATCHING;
            DataItem dataItem = selectedItem.getItem();
            ExpressionInterface expression = dataItem.getExpression();
            List<QualifiedColumn> qColumns = expression.getResources(QualifiedColumn.class, 0);
            if (qColumns.size() == 0 && expression instanceof QualifiedColumn) {
                qColumns.add((QualifiedColumn)expression);
            }
            for (QualifiedColumn qc : qColumns) {
                DataSourceTable dst = qc.getDataSource();
                if (dataSourcesJoinBehavior.containsKey(dst)) {
                    if (dataSourcesJoinBehavior.get(dst).equals(joinBehavior) || !joinBehavior.equals(JoinBehavior.ALL)) continue;
                    dataSourcesJoinBehavior.put(dst, joinBehavior);
                    continue;
                }
                dataSourcesJoinBehavior.put(dst, joinBehavior);
            }
        }
        return dataSourcesJoinBehavior;
    }

    public void format(StringBuffer fromClause, StringBuffer whereClause, PathNode[] joinTrees, Map joinBehaviors) throws GenerationException {
        ArrayList condsToMoveToWhereClause = new ArrayList();
        for (int i = 0; i < joinTrees.length; ++i) {
            PathNode node = joinTrees[i];
            if (i > 0) {
                this.newLine(fromClause, 0);
                fromClause.append(SQL_IMPLICIT_CROSS_JOIN);
                this.newLine(fromClause, 0);
            }
            node.format(fromClause, condsToMoveToWhereClause, joinBehaviors);
        }
        if (whereClause != null) {
            for (String exprText : condsToMoveToWhereClause) {
                if (whereClause.toString().trim().length() > 0) {
                    this.newLine(whereClause, 2);
                    whereClause.append(SQL_COMPOUND_CROSS_JOIN_CONDS);
                }
                whereClause.append(exprText);
            }
        }
    }

    public String formatJoinType(JoinType joinType) {
        String sqlJoinType = null;
        if (joinType == JoinType.INNER) {
            sqlJoinType = SQL_JOINTYPE_INNER;
        } else if (joinType == JoinType.FULL) {
            sqlJoinType = SQL_JOINTYPE_FULL;
        } else if (joinType == JoinType.LEFT) {
            sqlJoinType = SQL_JOINTYPE_LEFT;
        } else if (joinType == JoinType.RIGHT) {
            sqlJoinType = SQL_JOINTYPE_RIGHT;
        } else if (joinType == JoinType.CROSS) {
            sqlJoinType = SQL_JOINTYPE_CROSS;
        } else if (joinType != null) {
            sqlJoinType = joinType.toString();
            if (_logger.isEnabled(Level.WARN)) {
                _logger.warn("Unknown JoinType = " + sqlJoinType);
            }
        }
        return sqlJoinType;
    }

    void newLine(StringBuffer buffer, int indent) {
        buffer.append("");
        for (int x = 0; x < indent; ++x) {
            buffer.append("");
        }
    }

    public abstract class PathNode
    implements Cloneable {
        public abstract boolean contains(DataSourceTable var1);

        public abstract void merge(DataSourceTable var1, DataSourceTable var2, JoinType var3, ConditionalExpression var4, JoinTypeList var5, Cardinality var6);

        public abstract List getJoinedTables();

        public abstract JoinBehavior getJoinBehavior(Map var1);

        abstract void format(int var1, StringBuffer var2, List var3, Map var4) throws GenerationException;

        public void format(StringBuffer sqlString, List condsToMoveToWhereClause, Map joinBehaviors) throws GenerationException {
            this.format(0, sqlString, condsToMoveToWhereClause, joinBehaviors);
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public class JoinNode
    extends PathNode {
        protected PathNode _left = null;
        protected PathNode _right = null;
        protected JoinType _defaultType = null;
        protected JoinTypeList _allowedTypes = null;
        protected Cardinality _cardinality;
        protected List _conds = null;

        JoinNode(PathNode left, PathNode right, JoinType type, ConditionalExpression cond, JoinTypeList allowedTypes, Cardinality cardinality) {
            this._left = left;
            this._right = right;
            this._conds = new ArrayList();
            if (this._conds != null) {
                this._conds.add(cond);
            }
            this._allowedTypes = new JoinTypeList();
            if (allowedTypes != null) {
                this._allowedTypes.addAll((Collection)allowedTypes);
            }
            this._defaultType = type;
            this._cardinality = cardinality;
        }

        JoinNode(PathNode left, DataSourceTable right, JoinType type, ConditionalExpression cond, JoinTypeList allowedTypes, Cardinality cardinality) {
            this(left, (PathNode)this$0.new TableNode(right), type, cond, allowedTypes, cardinality);
        }

        JoinNode(DataSourceTable left, PathNode right, JoinType type, ConditionalExpression cond, JoinTypeList allowedTypes, Cardinality cardinality) {
            this((PathNode)this$0.new TableNode(left), right, type, cond, allowedTypes, cardinality);
            if (this$0.isOptimizingSQL()) {
                this._flip();
            }
        }

        JoinNode(DataSourceTable left, DataSourceTable right, JoinType type, ConditionalExpression cond, JoinTypeList allowedTypes, Cardinality cardinality) {
            this((PathNode)this$0.new TableNode(left), (PathNode)this$0.new TableNode(right), type, cond, allowedTypes, cardinality);
        }

        @Override
        public boolean contains(DataSourceTable lookForTable) {
            boolean found = false;
            if (lookForTable != null && !(found = this._left.contains(lookForTable))) {
                found = this._right.contains(lookForTable);
            }
            return found;
        }

        @Override
        public List getJoinedTables() {
            ArrayList tables = new ArrayList();
            tables.addAll(this._left.getJoinedTables());
            tables.addAll(this._right.getJoinedTables());
            return tables;
        }

        public List getCondTables() {
            ArrayList<DataSourceTable> tables = new ArrayList<DataSourceTable>();
            if (this._conds != null && this._conds.size() > 0) {
                for (int i = 0; i < this._conds.size(); ++i) {
                    List<QualifiedColumn> resources = ((ExpressionInterface)this._conds.get(i)).getResources(QualifiedColumn.class, 65535);
                    for (int j = 0; j < resources.size(); ++j) {
                        QualifiedColumn qc = resources.get(j);
                        try {
                            DataSourceTable table = qc.getDataSource();
                            if (tables.contains(table)) continue;
                            tables.add(table);
                            continue;
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                    }
                }
            }
            return tables;
        }

        @Override
        public JoinBehavior getJoinBehavior(Map joinBehaviors) {
            JoinBehavior joinBehavior = null;
            JoinBehavior leftJoinBehavior = null;
            if (this._left != null) {
                leftJoinBehavior = this._left.getJoinBehavior(joinBehaviors);
            }
            if (leftJoinBehavior != null) {
                joinBehavior = leftJoinBehavior;
            }
            JoinBehavior rightJoinBehavior = null;
            if (this._right != null) {
                rightJoinBehavior = this._right.getJoinBehavior(joinBehaviors);
            }
            if (rightJoinBehavior != null) {
                if (rightJoinBehavior.equals(JoinBehavior.ALL)) {
                    joinBehavior = rightJoinBehavior;
                } else if (joinBehavior == null) {
                    joinBehavior = rightJoinBehavior;
                }
            }
            return joinBehavior;
        }

        @Override
        public void merge(DataSourceTable leftTable, DataSourceTable rightTable, JoinType type, ConditionalExpression cond, JoinTypeList allowedTypes, Cardinality cardinality) {
            boolean addHere = false;
            boolean updateType = false;
            boolean flipType = false;
            if (this._left != null && this._left.contains(leftTable) && this._right != null && this._right.contains(rightTable)) {
                addHere = true;
                updateType = this._defaultType == null && type != null;
            } else if (this._left != null && this._left.contains(rightTable) && this._right != null && this._right.contains(leftTable)) {
                addHere = true;
                updateType = this._defaultType == null && type != null;
                flipType = updateType && (type == JoinType.LEFT || type == JoinType.RIGHT);
            } else if (this._left != null && this._left.contains(leftTable) && this._left.contains(rightTable)) {
                this._left.merge(leftTable, rightTable, type, cond, allowedTypes, cardinality);
            } else if (this._right != null && this._right.contains(leftTable) && this._right.contains(rightTable)) {
                this._right.merge(leftTable, rightTable, type, cond, allowedTypes, cardinality);
            }
            if (addHere) {
                this._conds.add(cond);
                if (updateType) {
                    this._allowedTypes.clear();
                    if (allowedTypes != null) {
                        this._allowedTypes.addAll((Collection)allowedTypes);
                    }
                    this._defaultType = type;
                    if (flipType) {
                        this._defaultType = this._flip(this._defaultType);
                        this._flip(this._allowedTypes);
                    }
                }
            }
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            JoinNode clone = (JoinNode)super.clone();
            JoinTypeList copy = new JoinTypeList();
            copy.addAll((Collection)this._allowedTypes);
            clone._allowedTypes = copy;
            clone._conds = new ArrayList(this._conds);
            return clone;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('{');
            buffer.append(this._left);
            buffer.append(' ');
            buffer.append(SQLJoinPathFormatter.this.formatJoinType(this._defaultType));
            buffer.append(' ');
            buffer.append(this._right);
            buffer.append(" on ");
            buffer.append(this._conds);
            buffer.append(", validTypes=[");
            for (int i = 0; i < this._allowedTypes.size(); ++i) {
                if (i > 0) {
                    buffer.append(',');
                }
                buffer.append(SQLJoinPathFormatter.this.formatJoinType((JoinType)this._allowedTypes.get(i)));
            }
            buffer.append("], carinality=");
            buffer.append(this._cardinality);
            buffer.append("}");
            return buffer.toString();
        }

        @Override
        void format(int indent, StringBuffer sqlString, List condsToMoveToWhereClause, Map joinBehaviors) throws GenerationException {
            JoinType typeToFormat = this.getJoinTypeAfterWidening(joinBehaviors);
            PathNode rotatedNode = this._rotateForFormatting(typeToFormat, joinBehaviors);
            if (rotatedNode != null) {
                rotatedNode.format(indent, sqlString, condsToMoveToWhereClause, joinBehaviors);
            } else {
                if (this._left == null) {
                    SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.SQL_NULL_OBJECT);
                } else {
                    this._left.format(indent, sqlString, condsToMoveToWhereClause, joinBehaviors);
                }
                SQLJoinPathFormatter.this.newLine(sqlString, indent + 1);
                SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.this.formatJoinType(typeToFormat));
                SQLJoinPathFormatter.this.smartAppend(sqlString, " ");
                if (this._right == null) {
                    SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.SQL_NULL_OBJECT);
                } else {
                    if (this._right instanceof JoinNode) {
                        SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.SQL_START_NESTED_JOIN);
                    }
                    this._right.format(indent + 1, sqlString, condsToMoveToWhereClause, joinBehaviors);
                    if (this._right instanceof JoinNode) {
                        SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.SQL_END_NESTED_JOIN);
                    }
                }
                boolean sendToWhereClause = typeToFormat == JoinType.CROSS || typeToFormat == null;
                StringBuffer condString = new StringBuffer();
                for (int i = 0; i < this._conds.size(); ++i) {
                    ConditionalExpression joinexp = (ConditionalExpression)this._conds.get(i);
                    String exprText = SQLJoinPathFormatter.this.formatPredicate(joinexp);
                    if (sendToWhereClause) {
                        if (condsToMoveToWhereClause.contains(exprText)) continue;
                        condsToMoveToWhereClause.add(exprText);
                        continue;
                    }
                    if (condString.toString().trim().length() > 0) {
                        SQLJoinPathFormatter.this.newLine(condString, indent + 2);
                        condString.append(SQLJoinPathFormatter.SQL_COMPOUND_MULTI_JOIN_CONDS);
                    }
                    condString.append(exprText);
                }
                if (condString.toString().trim().length() > 0) {
                    SQLJoinPathFormatter.this.newLine(sqlString, indent + 2);
                    SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.SQL_PREFIX_ON_PREDICATE);
                    SQLJoinPathFormatter.this.smartAppend(sqlString, condString.toString());
                    SQLJoinPathFormatter.this.smartAppend(sqlString, " ");
                }
            }
        }

        private PathNode _rotateForFormatting(JoinType typeToFormat, Map joinBehaviors) throws GenerationException {
            JoinNode rotatedNode = null;
            if (SQLJoinPathFormatter.this.isOptimizingSQL()) {
                boolean okToRotate = false;
                boolean flipBeforeRotate = false;
                if (this._right instanceof JoinNode && (typeToFormat == JoinType.INNER || typeToFormat == JoinType.FULL)) {
                    JoinType rightType = ((JoinNode)this._right).getJoinTypeAfterWidening(joinBehaviors);
                    if (typeToFormat == rightType) {
                        List thisLeftTables = this._left.getJoinedTables();
                        List rightsLeftTables = ((JoinNode)this._right)._left.getJoinedTables();
                        List rightsRightTables = ((JoinNode)this._right)._right.getJoinedTables();
                        List thisCondsTables = this.getCondTables();
                        ArrayList postRotateTables = new ArrayList();
                        postRotateTables.addAll(thisLeftTables);
                        postRotateTables.addAll(rightsLeftTables);
                        if (postRotateTables.containsAll(thisCondsTables)) {
                            okToRotate = true;
                        } else {
                            postRotateTables.clear();
                            postRotateTables.addAll(thisLeftTables);
                            postRotateTables.addAll(rightsRightTables);
                            if (postRotateTables.containsAll(thisCondsTables)) {
                                okToRotate = true;
                                flipBeforeRotate = true;
                            }
                        }
                    }
                    if (okToRotate) {
                        JoinNode rotDownLeft = null;
                        try {
                            rotatedNode = (JoinNode)this._right.clone();
                            if (flipBeforeRotate) {
                                rotatedNode._flip();
                            }
                            rotDownLeft = (JoinNode)this.clone();
                            rotDownLeft._right = rotatedNode._left;
                            rotatedNode._left = rotDownLeft;
                        }
                        catch (CloneNotSupportedException e) {
                            rotatedNode = null;
                        }
                    }
                }
            }
            return rotatedNode;
        }

        public JoinType getJoinTypeAfterWidening(Map joinBehaviors) throws GenerationException {
            JoinType proposedJoinType = this._defaultType;
            JoinBehavior leftJoinBehavior = null;
            if (this._left != null) {
                leftJoinBehavior = this._left.getJoinBehavior(joinBehaviors);
            }
            if (leftJoinBehavior == null) {
                leftJoinBehavior = (proposedJoinType == JoinType.LEFT || proposedJoinType == JoinType.CROSS || proposedJoinType == JoinType.FULL) && this._isAllowed(proposedJoinType) ? JoinBehavior.ALL : JoinBehavior.MATCHING;
            }
            JoinBehavior rightJoinBehavior = null;
            if (this._right != null) {
                rightJoinBehavior = this._right.getJoinBehavior(joinBehaviors);
            }
            if (rightJoinBehavior == null) {
                rightJoinBehavior = (proposedJoinType == JoinType.RIGHT || proposedJoinType == JoinType.CROSS || proposedJoinType == JoinType.FULL) && this._isAllowed(proposedJoinType) ? JoinBehavior.ALL : JoinBehavior.MATCHING;
            }
            JoinType behaviorBasedJoinType = proposedJoinType;
            if (leftJoinBehavior == JoinBehavior.MATCHING && rightJoinBehavior == JoinBehavior.MATCHING) {
                behaviorBasedJoinType = JoinType.INNER;
            } else if (leftJoinBehavior == JoinBehavior.MATCHING && rightJoinBehavior == JoinBehavior.ALL) {
                behaviorBasedJoinType = JoinType.RIGHT;
            } else if (leftJoinBehavior == JoinBehavior.ALL && rightJoinBehavior == JoinBehavior.MATCHING) {
                behaviorBasedJoinType = JoinType.LEFT;
            } else if (leftJoinBehavior == JoinBehavior.ALL && rightJoinBehavior == JoinBehavior.ALL) {
                behaviorBasedJoinType = this._conds.isEmpty() ? JoinType.CROSS : JoinType.FULL;
            }
            JoinType adjustedJoinType = null;
            boolean isAllowed = this._isAllowed(behaviorBasedJoinType);
            if (isAllowed) {
                adjustedJoinType = behaviorBasedJoinType;
            } else if (this._allowedTypes.size() >= 1) {
                if (this._allowedTypes.size() == 1) {
                    adjustedJoinType = (JoinType)this._allowedTypes.firstElement();
                } else if (behaviorBasedJoinType == JoinType.FULL) {
                    if (this._isAllowed(JoinType.LEFT)) {
                        adjustedJoinType = JoinType.LEFT;
                    } else if (this._isAllowed(JoinType.RIGHT)) {
                        adjustedJoinType = JoinType.RIGHT;
                    } else if (this._isAllowed(JoinType.INNER)) {
                        adjustedJoinType = JoinType.INNER;
                    } else if (this._isAllowed(JoinType.CROSS)) {
                        adjustedJoinType = JoinType.CROSS;
                    }
                } else if (behaviorBasedJoinType == JoinType.LEFT || behaviorBasedJoinType == JoinType.RIGHT) {
                    if (this._isAllowed(JoinType.FULL)) {
                        adjustedJoinType = JoinType.FULL;
                    } else if (this._isAllowed(JoinType.INNER)) {
                        adjustedJoinType = JoinType.INNER;
                    } else if (this._isAllowed(JoinType.CROSS)) {
                        adjustedJoinType = JoinType.CROSS;
                    }
                } else if (behaviorBasedJoinType == JoinType.INNER) {
                    if (this._isAllowed(JoinType.LEFT)) {
                        adjustedJoinType = JoinType.LEFT;
                    } else if (this._isAllowed(JoinType.RIGHT)) {
                        adjustedJoinType = JoinType.RIGHT;
                    } else if (this._isAllowed(JoinType.FULL)) {
                        adjustedJoinType = JoinType.FULL;
                    } else if (this._isAllowed(JoinType.CROSS)) {
                        adjustedJoinType = JoinType.CROSS;
                    }
                }
            }
            if (adjustedJoinType == null) {
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLJoinPathFormatter.JoinNode.getJoinTypeAfterWidening.invalid.fmt.txt", SQLJoinPathFormatter.this.formatJoinType(behaviorBasedJoinType), this));
            }
            return adjustedJoinType;
        }

        private boolean _isAllowed(JoinType type) {
            return this._allowedTypes.contains(type);
        }

        private void _flip() {
            this._flip(this._allowedTypes);
            this._defaultType = this._flip(this._defaultType);
            this._cardinality = this._flip(this._cardinality);
            PathNode tmp = this._left;
            this._left = this._right;
            this._right = tmp;
        }

        private Cardinality _flip(Cardinality cardinality) {
            if (cardinality == Cardinality.MANY_TO_ONE) {
                cardinality = Cardinality.ONE_TO_MANY;
            } else if (cardinality == Cardinality.ONE_TO_MANY) {
                cardinality = Cardinality.MANY_TO_ONE;
            }
            return cardinality;
        }

        private JoinType _flip(JoinType type) {
            if (type == JoinType.LEFT) {
                type = JoinType.RIGHT;
            } else if (type == JoinType.RIGHT) {
                type = JoinType.LEFT;
            }
            return type;
        }

        private void _flip(JoinTypeList allowed) {
            if (this._isAllowed(JoinType.LEFT) && !this._isAllowed(JoinType.RIGHT)) {
                allowed.remove(JoinType.LEFT);
                allowed.add(JoinType.RIGHT);
            } else if (this._isAllowed(JoinType.RIGHT) && !this._isAllowed(JoinType.LEFT)) {
                allowed.remove(JoinType.RIGHT);
                allowed.add(JoinType.LEFT);
            }
        }
    }

    public class TableNode
    extends PathNode {
        protected DataSourceTable _table = null;

        TableNode(DataSourceTable table) {
            this._table = table;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            TableNode clone = (TableNode)super.clone();
            return clone;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this._table);
            return buffer.toString();
        }

        @Override
        public void merge(DataSourceTable leftTable, DataSourceTable rightTable, JoinType type, ConditionalExpression cond, JoinTypeList allowedTypes, Cardinality cardinality) {
        }

        @Override
        public boolean contains(DataSourceTable lookForTable) {
            boolean found = false;
            if (lookForTable != null) {
                found = this._table == lookForTable;
            }
            return found;
        }

        @Override
        public List getJoinedTables() {
            ArrayList<DataSourceTable> tables = new ArrayList<DataSourceTable>();
            tables.add(this._table);
            return tables;
        }

        @Override
        void format(int indent, StringBuffer sqlString, List condsToMoveToWhereClause, Map joinBehaviors) throws GenerationException {
            SQLJoinPathFormatter.this.smartAppend(sqlString, SQLJoinPathFormatter.this.formatTable(this._table));
        }

        @Override
        public JoinBehavior getJoinBehavior(Map joinBehaviors) {
            JoinBehavior joinBehavior = (JoinBehavior)joinBehaviors.get(this._table);
            return joinBehavior;
        }
    }
}

