/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFactoryInterface;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLSetOperatorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGenerationInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class SQLComponentAbstract {
    private SQLFactoryInterface _sqlFactory;
    protected DataSelection _dataSelection;
    public static final int EXP_GEN_DECLARATION = 1;
    public static final int EXP_GEN_REFERENCE = 2;
    public static final int EXP_GEN_DECLARATION_SHORT = 3;
    public static final int EXP_GEN_DECLARATION_SHORT_SUPPRESS_TABLE = 4;
    protected Map<String, String> m_startQuoteMap;
    protected Map<String, String> m_endQuoteMap;
    protected JoinGenerationInterface m_joinGenerator;
    List<DataItem> byGroupItems = null;
    protected DataSelectionProcessorAbstract _dataSelectionProcessor;
    private List<SQLColumnAbstract> _sqlColumns = new ArrayList<SQLColumnAbstract>();
    private String _crossJoinConditionsText;
    private Map<String, Object> _groupByIdentifierPositions = null;

    public abstract void prepareSQL() throws GenerationException;

    public abstract String writeSQL();

    public void setSQLFactory(SQLFactoryInterface sqlFactory) {
        this._sqlFactory = sqlFactory;
    }

    public SQLFactoryInterface getSQLFactory() {
        return this._sqlFactory;
    }

    public void setDataSelection(DataSelection dataSelection) {
        if (dataSelection != this._dataSelection) {
            this._dataSelection = dataSelection;
        }
    }

    protected SQLColumnAbstract _generateSelectColumn(DataItem item) throws GenerationException {
        SQLColumnAbstract sqlColumn = this.getSQLFactory().createSQLSelectColumn();
        sqlColumn.setJoinGenerator(this.m_joinGenerator);
        sqlColumn.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlColumn.setDataSelection(this._dataSelection);
        sqlColumn.setItem(item);
        sqlColumn.prepareSQL();
        return sqlColumn;
    }

    protected SQLColumnAbstract _generateOrderByColumn(DataItem item) throws GenerationException {
        SQLColumnAbstract sqlColumn = this.getSQLFactory().createSQLOrderByColumn();
        sqlColumn.setJoinGenerator(this.m_joinGenerator);
        sqlColumn.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlColumn.setDataSelection(this._dataSelection);
        sqlColumn.setItem(item);
        sqlColumn.prepareSQL();
        return sqlColumn;
    }

    protected SQLColumnAbstract _generateGroupByColumn(DataItem item) throws GenerationException {
        SQLColumnAbstract sqlColumn = this.getSQLFactory().createSQLGroupByColumn();
        sqlColumn.setJoinGenerator(this.m_joinGenerator);
        sqlColumn.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlColumn.setDataSelection(this._dataSelection);
        sqlColumn.setItem(item);
        sqlColumn.prepareSQL();
        return sqlColumn;
    }

    protected SQLComponentAbstract _generateSetOperator() throws GenerationException {
        SQLSetOperatorAbstract sqlSetOperator = (SQLSetOperatorAbstract)this.getSQLFactory().createSQLSetOperator();
        sqlSetOperator.setDataSelection(this._dataSelection);
        sqlSetOperator.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlSetOperator.setJoinGenerator(this.m_joinGenerator);
        sqlSetOperator.prepareSQL();
        return sqlSetOperator;
    }

    protected SQLComponentAbstract generateExpression() throws GenerationException {
        DataSelectionProcessorAbstract dataSelectionProcessor = this.getDataSelectionProcessor();
        SQLFactoryInterface factory = this.getSQLFactory();
        SQLExpressionAbstract sqlExpression = factory.createSQLExpression();
        sqlExpression.setSQLFactory(factory);
        sqlExpression.setJoinGenerator(this.m_joinGenerator);
        sqlExpression.setDataSelection(this._dataSelection);
        sqlExpression.setDataSelectionProcessor(dataSelectionProcessor);
        return sqlExpression;
    }

    protected String _generateExpressionSQL(ExpressionInterface expression, int declareOrReference) throws GenerationException {
        return this._generateExpressionSQL(expression, declareOrReference, null);
    }

    public String _generateExpressionSQL(ExpressionInterface expression, int declareOrReference, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        SQLExpressionAbstract sqlExpression = (SQLExpressionAbstract)this.generateExpression();
        return sqlExpression.generateExpressionSQL(expression, declareOrReference, exprValues);
    }

    public static final String writeCompositeList(List<? extends SQLComponentAbstract> compositeList) {
        StringBuffer sqlComposite = new StringBuffer();
        for (SQLComponentAbstract sQLComponentAbstract : compositeList) {
            sqlComposite.append(sQLComponentAbstract.writeSQL());
        }
        return sqlComposite.toString();
    }

    public Map<String, String> getEndQuoteMap() {
        return this.m_endQuoteMap;
    }

    public JoinGenerationInterface getJoinGenerator() {
        return this.m_joinGenerator;
    }

    public Map<String, String> getStartQuoteMap() {
        return this.m_startQuoteMap;
    }

    public void setEndQuoteMap(Map<String, String> endQuoteMap) {
        this.m_endQuoteMap = endQuoteMap;
    }

    public void setJoinGenerator(JoinGenerationInterface joinGenerator) {
        this.m_joinGenerator = joinGenerator;
    }

    public void setStartQuoteMap(Map<String, String> startQuoteMap) {
        this.m_startQuoteMap = startQuoteMap;
    }

    public List<DataItem> getByGroupItems() {
        return this.byGroupItems;
    }

    public void setByGroupItems(List<DataItem> byGroupList) {
        this.byGroupItems = byGroupList;
    }

    public void addByGroupItems(DataItem item) {
        this.byGroupItems.add(item);
    }

    public String getCrossJoinConditionsText() {
        return this._crossJoinConditionsText;
    }

    public void setCrossJoinConditionsText(String text) {
        this._crossJoinConditionsText = text;
    }

    public void setGroupByIdentifierPositions(Map<String, Object> identifiersToPositions) {
        this._groupByIdentifierPositions = identifiersToPositions;
    }

    public Map<String, Object> getGroupByIdentifierPositions() {
        return this._groupByIdentifierPositions;
    }

    public void setSQLColumns(List<SQLColumnAbstract> columnList) {
        this._sqlColumns = columnList;
    }

    public List<SQLColumnAbstract> getSQLColumns() {
        return this._sqlColumns;
    }

    public void setDataSelectionProcessor(DataSelectionProcessorAbstract selectionProcessor) {
        this._dataSelectionProcessor = selectionProcessor;
    }

    public DataSelectionProcessorAbstract getDataSelectionProcessor() {
        return this._dataSelectionProcessor;
    }
}

