/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational;

import com.sas.MissingValues;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Association;
import com.sas.iquery.metadata.business.AssociationLevel;
import com.sas.iquery.metadata.business.AssociationMatrix;
import com.sas.iquery.metadata.business.AssociationType;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.ExplicitJoinPathSupport;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.strategies.sas.oma.relational.AssociationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UQuery {
    private final List<SelectedItem> _controlMeasures;
    private final List<DataSourceTable> _measureTables;
    private DataSourceTable _mxTable;
    private boolean _multipleMxTables = false;
    private AssociationStrategy _associationStrategy;
    private int _listNum;
    private static final Logger _logger = LogManager.getLogger(UQuery.class);

    public UQuery(List<SelectedItem> controlMeasureList, List<DataSourceTable> dataSourceTableList, int listNum, AssociationStrategy associationStrategy) throws MetadataException, GenerationException {
        this._controlMeasures = Collections.unmodifiableList(new ArrayList<SelectedItem>(controlMeasureList));
        this._measureTables = Collections.unmodifiableList(new ArrayList<DataSourceTable>(dataSourceTableList));
        if (dataSourceTableList.size() > 1) {
            this._multipleMxTables = true;
            associationStrategy.throwExceptionWithReason(0, this._measureTables);
        }
        this._listNum = listNum;
        this._associationStrategy = associationStrategy;
    }

    public DataSelection buildDataModel(ArrayList<SelectedItem> originalSelectedItems, DataSelection outerQuery, List<Join> effectiveJoins, AssociationMatrix matrix) throws MetadataException {
        DataSelection dataSelection = (DataSelection)((Object)((ExplicitJoinPathSupport)((Object)DataSelectionFactory.newDataSelection(outerQuery))));
        dataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        this._mxTable = this._multipleMxTables ? this.buildMXSegment(dataSelection, outerQuery) : this._measureTables.get(0);
        LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> dependentTables = this.getDependentTables(matrix, originalSelectedItems);
        ArrayList<FilterItem> uQueryFilterItems = this.findPreAggFiltersFromMxTable();
        if (dependentTables.isEmpty() && !this._multipleMxTables) {
            this.buildDataSelection(dataSelection, originalSelectedItems);
        } else {
            LinkedHashMap<DataSourceTable, Join> otherSideOfMxTable = new LinkedHashMap<DataSourceTable, Join>();
            LinkedHashMap<ArrayList<Join>, Join> u0JoinPaths = this.getJoinPathsFromMxTable(otherSideOfMxTable, effectiveJoins);
            ArrayList<SelectedItem> categories = this.getCategories(originalSelectedItems);
            ArrayList<DataSourceRelationalQuery> u0DSRQ = new ArrayList<DataSourceRelationalQuery>();
            this.buildU0Segment(dataSelection, outerQuery, categories, u0JoinPaths, u0DSRQ, otherSideOfMxTable);
            this.buildDataSelection(dataSelection, originalSelectedItems, u0DSRQ);
        }
        this.generatePreAggFilters(dataSelection, uQueryFilterItems);
        return dataSelection;
    }

    private ArrayList<Join> findOtherSideOfMxTableJoins(LinkedHashMap<DataSourceTable, Join> otherSideOfMxTable, List<Join> effectiveJoins) throws MetadataException {
        ArrayList<Join> copyOfJoins = new ArrayList<Join>(effectiveJoins);
        for (Join join : effectiveJoins) {
            if (join.getLeftDataSource() == this._mxTable) {
                otherSideOfMxTable.put(join.getRightDataSource(), join);
                copyOfJoins.remove(join);
                continue;
            }
            if (join.getRightDataSource() != this._mxTable) continue;
            otherSideOfMxTable.put(join.getLeftDataSource(), join);
            copyOfJoins.remove(join);
        }
        return copyOfJoins;
    }

    private LinkedHashMap<ArrayList<Join>, Join> getJoinPathsFromMxTable(LinkedHashMap<DataSourceTable, Join> otherSideOfMxTable, List<Join> effectiveJoins) throws MetadataException {
        ArrayList<Join> joinList = this.findOtherSideOfMxTableJoins(otherSideOfMxTable, effectiveJoins);
        LinkedHashMap<ArrayList<Join>, Join> u0JoinPaths = new LinkedHashMap<ArrayList<Join>, Join>();
        Iterator<Map.Entry<DataSourceTable, Join>> iterator = otherSideOfMxTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DataSourceTable, Join> e = iterator.next();
            DataSourceTable otherSideMxTable = e.getKey();
            boolean singleTable = true;
            ArrayList<Join> thisJoinPath = new ArrayList<Join>();
            ArrayList<DataSourceTable> otherSideOfThisTable = this.findOtherSideOfThisTableJoins(otherSideMxTable, joinList);
            for (DataSourceTable otherSideTable : otherSideOfThisTable) {
                Iterator<Join> joinIterator = joinList.iterator();
                while (joinIterator.hasNext()) {
                    Join join = joinIterator.next();
                    if (join.getLeftDataSource() == otherSideMxTable && join.getRightDataSource() == otherSideTable && join.getRightDataSource() != this._mxTable) {
                        thisJoinPath.add(join);
                        joinIterator.remove();
                        singleTable = false;
                        this.findJoinPathForU0Segment(join.getRightDataSource(), thisJoinPath, joinList);
                        continue;
                    }
                    if (join.getRightDataSource() != otherSideMxTable || join.getLeftDataSource() != otherSideTable || join.getLeftDataSource() == this._mxTable) continue;
                    thisJoinPath.add(join);
                    joinIterator.remove();
                    singleTable = false;
                    this.findJoinPathForU0Segment(join.getLeftDataSource(), thisJoinPath, joinList);
                }
            }
            if (singleTable) continue;
            u0JoinPaths.put(thisJoinPath, otherSideOfMxTable.get(otherSideMxTable));
            iterator.remove();
        }
        return u0JoinPaths;
    }

    private void findJoinPathForU0Segment(DataSourceTable thisJoinTable, ArrayList<Join> thisJoinPath, ArrayList<Join> masterJoinList) throws MetadataException {
        ArrayList<Join> copyOfMasterJoinList = new ArrayList<Join>();
        copyOfMasterJoinList.addAll(masterJoinList);
        ArrayList<DataSourceTable> otherSideOfThisTable = this.findOtherSideOfThisTableJoins(thisJoinTable, masterJoinList);
        for (DataSourceTable otherSideTable : otherSideOfThisTable) {
            for (Join join : masterJoinList) {
                if (join.getLeftDataSource() == thisJoinTable && join.getRightDataSource() == otherSideTable && join.getRightDataSource() != this._mxTable) {
                    thisJoinPath.add(join);
                    copyOfMasterJoinList.remove(join);
                    this.findJoinPathForU0Segment(join.getRightDataSource(), thisJoinPath, copyOfMasterJoinList);
                    continue;
                }
                if (join.getRightDataSource() != thisJoinTable || join.getLeftDataSource() != otherSideTable || join.getLeftDataSource() == this._mxTable) continue;
                thisJoinPath.add(join);
                copyOfMasterJoinList.remove(join);
                this.findJoinPathForU0Segment(join.getLeftDataSource(), thisJoinPath, copyOfMasterJoinList);
            }
        }
    }

    private ArrayList<DataSourceTable> findOtherSideOfThisTableJoins(DataSourceTable thisTable, ArrayList<Join> thisJoinPath) throws MetadataException {
        ArrayList<DataSourceTable> otherSideOfThisTable = new ArrayList<DataSourceTable>();
        for (Join join : thisJoinPath) {
            if (join.getLeftDataSource() == thisTable) {
                otherSideOfThisTable.add(join.getRightDataSource());
                continue;
            }
            if (join.getRightDataSource() != thisTable) continue;
            otherSideOfThisTable.add(join.getLeftDataSource());
        }
        return otherSideOfThisTable;
    }

    private ArrayList<FilterItem> findPreAggFiltersFromMxTable() throws MetadataException {
        List<FilterItem> effectiveFilters = this._associationStrategy.getWhereFilters();
        ArrayList<FilterItem> uQueryFilterItems = new ArrayList<FilterItem>();
        for (FilterItem originalFilterItem : effectiveFilters) {
            boolean dataItemFound = this.findMxFiltersBasedOnDataItems(originalFilterItem, uQueryFilterItems);
            if (dataItemFound) continue;
            this.findMxFiltersBasedOnColumns(originalFilterItem, uQueryFilterItems);
        }
        return uQueryFilterItems;
    }

    private ArrayList<FilterItem> findPreAggFiltersForThisU0Segment(List<DataSourceTable> u0TableList) throws MetadataException {
        List<FilterItem> effectiveFilters = this._associationStrategy.getWhereFilters();
        ArrayList<FilterItem> u0FilterItems = new ArrayList<FilterItem>();
        for (FilterItem originalFilterItem : effectiveFilters) {
            boolean dataItemFound = this.findU0FiltersBasedOnDataItems(originalFilterItem, u0FilterItems, u0TableList);
            if (dataItemFound) continue;
            this.findU0FiltersBasedOnColumns(originalFilterItem, u0FilterItems, u0TableList);
        }
        return u0FilterItems;
    }

    private boolean findMxFiltersBasedOnDataItems(FilterItem originalFilterItem, List<FilterItem> uQueryFilterItems) throws MetadataException {
        boolean dataItemFound;
        block1: {
            dataItemFound = false;
            List<DataItem> dataItemsForThisFilter = originalFilterItem.getDataItems(0);
            Iterator<DataItem> iterator = dataItemsForThisFilter.iterator();
            if (!iterator.hasNext()) break block1;
            DataItem dataItem = iterator.next();
            if (this._associationStrategy.findDataSourceTable(dataItem) == this._mxTable) {
                uQueryFilterItems.add(originalFilterItem);
            }
            dataItemFound = true;
        }
        return dataItemFound;
    }

    private boolean findU0FiltersBasedOnDataItems(FilterItem originalFilterItem, List<FilterItem> u0FilterItems, List<DataSourceTable> u0TableList) throws MetadataException {
        boolean dataItemFound = false;
        List<DataItem> dataItemsForThisFilter = originalFilterItem.getDataItems(0);
        block0: for (DataItem dataItem : dataItemsForThisFilter) {
            if (this._associationStrategy.findDataSourceTable(dataItem) == this._mxTable) continue;
            for (DataSourceTable thisU0Table : u0TableList) {
                if (this._associationStrategy.findDataSourceTable(dataItem) != thisU0Table) continue;
                u0FilterItems.add(originalFilterItem);
                dataItemFound = true;
                continue block0;
            }
        }
        return dataItemFound;
    }

    private void findMxFiltersBasedOnColumns(FilterItem originalFilterItem, List<FilterItem> uQueryFilterItems) throws MetadataException {
        List<QualifiedColumn> thisFilterQualifiedColumns = originalFilterItem.getResources(QualifiedColumn.class, 0);
        List<QualifiedColumn> columnList = this._mxTable.getQualifiedColumns();
        Iterator<QualifiedColumn> iterator = thisFilterQualifiedColumns.iterator();
        if (iterator.hasNext()) {
            QualifiedColumn filterColumn = iterator.next();
            for (QualifiedColumn measureTableColumn : columnList) {
                if (filterColumn != measureTableColumn) continue;
                uQueryFilterItems.add(originalFilterItem);
                break;
            }
        }
    }

    private void findU0FiltersBasedOnColumns(FilterItem originalFilterItem, List<FilterItem> u0FilterItems, List<DataSourceTable> u0TableList) throws MetadataException {
        List<QualifiedColumn> thisFilterQualifiedColumns = originalFilterItem.getResources(QualifiedColumn.class, 0);
        List<QualifiedColumn> columnList = this._mxTable.getQualifiedColumns();
        for (QualifiedColumn filterColumn : thisFilterQualifiedColumns) {
            for (QualifiedColumn measureTableColumn : columnList) {
                if (filterColumn != measureTableColumn) continue;
                return;
            }
            block2: for (DataSourceTable thisU0Table : u0TableList) {
                List<QualifiedColumn> thisU0TableColumnList = thisU0Table.getQualifiedColumns();
                for (QualifiedColumn thisU0TableColumn : thisU0TableColumnList) {
                    if (!filterColumn.getSasName().equals(thisU0TableColumn.getSasName())) continue;
                    u0FilterItems.add(originalFilterItem);
                    continue block2;
                }
            }
        }
    }

    private ArrayList<SelectedItem> getCategories(List<SelectedItem> originalSelectedItems) throws MetadataException {
        ArrayList<SelectedItem> categories = new ArrayList<SelectedItem>();
        for (SelectedItem item : originalSelectedItems) {
            if (item.getItem().getUsage() != DataItemActionType.USAGE_CATEGORY) continue;
            categories.add(item);
        }
        return categories;
    }

    private void buildDataSelection(DataSelection dataSelection, List<SelectedItem> originalSelectedItems) throws MetadataException {
        for (SelectedItem item : originalSelectedItems) {
            if (item.getItem().getUsage() == DataItemActionType.USAGE_AGGREGATE && this.itemIsNotAControlMeasure(item)) {
                this.generateNewMissingDataItem(dataSelection, item.getItem());
                continue;
            }
            this.generateNewDataItem(item.getItem(), dataSelection);
        }
    }

    private void buildDataSelection(DataSelection dataSelection, List<SelectedItem> originalSelectedItems, List<DataSourceRelationalQuery> u0DSRQ) throws MetadataException {
        block0: for (SelectedItem item : originalSelectedItems) {
            List<QualifiedColumn> originalQualifiedColumn = item.getResources(QualifiedColumn.class, 65535);
            if (item.getItem().getUsage() == DataItemActionType.USAGE_AGGREGATE && this.itemIsNotAControlMeasure(item)) {
                this.generateNewMissingDataItem(dataSelection, item.getItem());
                continue;
            }
            if (item.getItem().getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                if (!this._multipleMxTables) {
                    this.generateNewDataItem(item.getItem(), dataSelection);
                    continue;
                }
                List<Column> mxDSRQColumns = this._mxTable.getColumns();
                for (Column mxColumn : mxDSRQColumns) {
                    if (!mxColumn.getSasName().equals(originalQualifiedColumn.get(0).getSasName())) continue;
                    this.generateNewDataItem(mxColumn, dataSelection, Role.COLUMN);
                    continue block0;
                }
                continue;
            }
            if (u0DSRQ.isEmpty()) {
                this.generateNewDataItem(item.getItem(), dataSelection);
                continue;
            }
            boolean categoryFound = false;
            Iterator<Cloneable> iterator = u0DSRQ.iterator();
            while (iterator.hasNext()) {
                DataSourceRelationalQuery dsrq;
                DataSourceRelationalQuery dsTable = dsrq = (DataSourceRelationalQuery)iterator.next();
                List<Column> dsrqColumns = dsTable.getColumns();
                for (Column column : dsrqColumns) {
                    if (item.getItem().isCalculatedItem()) {
                        String UNumMatchingSASName = "U" + this._listNum + item.getItem().getResultSetID();
                        if (!column.getSasName().equals(UNumMatchingSASName)) continue;
                        this.generateNewDataItem(column, dataSelection, Role.COLUMN);
                        categoryFound = true;
                        break;
                    }
                    if (!column.getSasName().equals(originalQualifiedColumn.get(0).getSasName())) continue;
                    this.generateNewDataItem(column, dataSelection, Role.COLUMN);
                    categoryFound = true;
                    break;
                }
                if (!categoryFound) continue;
                break;
            }
            if (categoryFound) continue;
            this.generateNewDataItem(item.getItem(), dataSelection);
        }
    }

    private void generatePreAggFilters(DataSelection dataSelection, List<FilterItem> originalFilterItems) throws MetadataException {
        ArrayList<FilterItem> filterItems = new ArrayList<FilterItem>();
        for (FilterItem filterItem : originalFilterItems) {
            FilterItem newFI = dataSelection.newFilterItem();
            newFI.setExpression(filterItem.getExpression());
            dataSelection.addBusinessItem(newFI);
            filterItems.add(newFI);
        }
        dataSelection.setFilters(filterItems);
    }

    private DataSourceTable buildMXSegment(DataSelection dataSelection, DataSelection outerQuery) throws MetadataException {
        DataSelection mxDataSelection = (DataSelection)((Object)((ExplicitJoinPathSupport)((Object)DataSelectionFactory.newDataSelection(outerQuery))));
        mxDataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        for (SelectedItem measureItem : this._controlMeasures) {
            List<QualifiedColumn> measureColumnList = measureItem.getResources(QualifiedColumn.class, 65535);
            this.generateNewDataItem(measureColumnList.get(0), mxDataSelection, Role.COLUMN);
        }
        DataSourceRelationalQuery mxDSRQ = dataSelection.newDataSourceRelationalQuery(mxDataSelection);
        mxDSRQ.setLabel("Mx1");
        dataSelection.addDataSource(mxDSRQ);
        return mxDSRQ;
    }

    private void buildU0Segment(DataSelection dataSelection, DataSelection outerQuery, ArrayList<SelectedItem> categories, LinkedHashMap<ArrayList<Join>, Join> joinMap, ArrayList<DataSourceRelationalQuery> u0DSRQ, LinkedHashMap<DataSourceTable, Join> otherSideOfMxTable) throws MetadataException {
        ArrayList<Join> newJoinPath = new ArrayList<Join>();
        ArrayList<SelectedItem> remainingCategories = new ArrayList<SelectedItem>(categories);
        this.buildU0SegmentFromJoinPaths(dataSelection, outerQuery, categories, remainingCategories, joinMap, newJoinPath, u0DSRQ);
        this.buildU0SegmentFromSingleTables(dataSelection, outerQuery, categories, remainingCategories, newJoinPath, u0DSRQ, otherSideOfMxTable);
        ((ExplicitJoinPathSupport)((Object)dataSelection)).setExplicitJoinPath(newJoinPath);
    }

    private void buildU0SegmentFromJoinPaths(DataSelection dataSelection, DataSelection outerQuery, ArrayList<SelectedItem> categories, ArrayList<SelectedItem> remainingCategories, LinkedHashMap<ArrayList<Join>, Join> u0JoinPaths, List<Join> newJoinPath, ArrayList<DataSourceRelationalQuery> u0DSRQ) throws MetadataException {
        for (Map.Entry<ArrayList<Join>, Join> e : u0JoinPaths.entrySet()) {
            Join u0Join;
            DataSelection u0DataSelection;
            ArrayList<Join> thisJoinPath = e.getKey();
            if (!this.buildu0DataSelection(categories, remainingCategories, thisJoinPath, u0DataSelection = (DataSelection)((Object)((ExplicitJoinPathSupport)((Object)DataSelectionFactory.newDataSelection(outerQuery)))), u0Join = u0JoinPaths.get(thisJoinPath))) continue;
            DataSourceRelationalQuery thisU0dsrq = dataSelection.newDataSourceRelationalQuery(u0DataSelection);
            dataSelection.addDataSource(thisU0dsrq);
            u0DSRQ.add(thisU0dsrq);
            Join dsrqJoin = u0DataSelection.newJoin();
            u0DataSelection.addBusinessRule(dsrqJoin);
            try {
                ConditionalExpression condition = (ConditionalExpression)u0Join.getJoinCondition().clone();
                if (u0Join.getLeftDataSource() == this._mxTable) {
                    this.replaceColumns(condition, u0Join.getLeftDataSource(), this._mxTable, dsrqJoin.getBusinessModel());
                    this.replaceColumns(condition, u0Join.getRightDataSource(), thisU0dsrq, dsrqJoin.getBusinessModel());
                } else {
                    this.replaceColumns(condition, u0Join.getRightDataSource(), this._mxTable, dsrqJoin.getBusinessModel());
                    this.replaceColumns(condition, u0Join.getLeftDataSource(), thisU0dsrq, dsrqJoin.getBusinessModel());
                }
                dsrqJoin.setLeftDataSource(this._mxTable);
                dsrqJoin.setRightDataSource(thisU0dsrq);
                dsrqJoin.setJoinCondition(condition);
                newJoinPath.add(dsrqJoin);
            }
            catch (CloneNotSupportedException er) {
                er.printStackTrace();
            }
        }
    }

    private void buildU0SegmentFromSingleTables(DataSelection dataSelection, DataSelection outerQuery, ArrayList<SelectedItem> categories, ArrayList<SelectedItem> remainingCategories, List<Join> newJoinPath, ArrayList<DataSourceRelationalQuery> u0DSRQ, LinkedHashMap<DataSourceTable, Join> otherSideOfMxTableMap) throws MetadataException {
        for (Map.Entry<DataSourceTable, Join> e : otherSideOfMxTableMap.entrySet()) {
            Join u0Join;
            DataSelection u0DataSelection;
            DataSourceTable otherSideOfMxTable = e.getKey();
            if (!this.buildu0DataSelection(categories, remainingCategories, otherSideOfMxTable, u0DataSelection = (DataSelection)((Object)((ExplicitJoinPathSupport)((Object)DataSelectionFactory.newDataSelection(outerQuery)))), u0Join = otherSideOfMxTableMap.get(otherSideOfMxTable))) continue;
            DataSourceRelationalQuery thisU0dsrq = dataSelection.newDataSourceRelationalQuery(u0DataSelection);
            dataSelection.addDataSource(thisU0dsrq);
            u0DSRQ.add(thisU0dsrq);
            Join dsrqJoin = u0DataSelection.newJoin();
            u0DataSelection.addBusinessRule(dsrqJoin);
            try {
                ConditionalExpression condition = (ConditionalExpression)u0Join.getJoinCondition().clone();
                if (u0Join.getLeftDataSource() == this._mxTable) {
                    this.replaceColumns(condition, u0Join.getLeftDataSource(), this._mxTable, dsrqJoin.getBusinessModel());
                    this.replaceColumns(condition, u0Join.getRightDataSource(), thisU0dsrq, dsrqJoin.getBusinessModel());
                } else {
                    this.replaceColumns(condition, u0Join.getRightDataSource(), this._mxTable, dsrqJoin.getBusinessModel());
                    this.replaceColumns(condition, u0Join.getLeftDataSource(), thisU0dsrq, dsrqJoin.getBusinessModel());
                }
                dsrqJoin.setLeftDataSource(this._mxTable);
                dsrqJoin.setRightDataSource(thisU0dsrq);
                dsrqJoin.setJoinCondition(condition);
                newJoinPath.add(dsrqJoin);
            }
            catch (CloneNotSupportedException er) {
                er.printStackTrace();
            }
        }
    }

    private boolean buildu0DataSelection(ArrayList<SelectedItem> categories, ArrayList<SelectedItem> remainingCategories, List<Join> thisJoinPath, DataSelection u0DataSelection, Join mxJoin) throws MetadataException {
        u0DataSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        u0DataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        List<DataSourceTable> joinTables = this.findTablesInThisJoinPath(thisJoinPath);
        boolean categoryItemRemoved = false;
        Iterator<SelectedItem> iterator = remainingCategories.iterator();
        block0: while (iterator.hasNext()) {
            SelectedItem categoryItem = iterator.next();
            List<QualifiedColumn> categoryColumns = categoryItem.getResources(QualifiedColumn.class, 65535);
            int i = 0;
            block1: for (QualifiedColumn categoryColumn : categoryColumns) {
                if (++i == 2 && categoryItem.getItem().isCalculatedItem()) continue block0;
                for (DataSourceTable joinTable : joinTables) {
                    if (categoryColumn.getDataSource() != joinTable) continue;
                    if (categoryItem.getItem().isCalculatedItem()) {
                        this.generateNewDataItem(categoryItem.getItem(), u0DataSelection);
                    } else {
                        this.generateNewDataItem(categoryColumn, u0DataSelection, Role.COLUMN);
                    }
                    iterator.remove();
                    categoryItemRemoved = true;
                    continue block1;
                }
            }
        }
        if (!categoryItemRemoved && this.categoriesInThisJoinPath(categories, joinTables)) {
            return false;
        }
        this.generateCategoryKeyColumnSubQuery(u0DataSelection, mxJoin);
        ArrayList<FilterItem> u0FilterItems = this.findPreAggFiltersForThisU0Segment(joinTables);
        this.generatePreAggFilters(u0DataSelection, u0FilterItems);
        ((ExplicitJoinPathSupport)((Object)u0DataSelection)).setExplicitJoinPath(thisJoinPath);
        return true;
    }

    private boolean categoriesInThisJoinPath(ArrayList<SelectedItem> categories, List<DataSourceTable> joinTables) throws MetadataException {
        for (SelectedItem categoryItem : categories) {
            List<QualifiedColumn> categoryColumns = categoryItem.getResources(QualifiedColumn.class, 65535);
            for (QualifiedColumn categoryColumn : categoryColumns) {
                for (DataSourceTable joinTable : joinTables) {
                    if (categoryColumn.getDataSource() != joinTable) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean buildu0DataSelection(ArrayList<SelectedItem> categories, ArrayList<SelectedItem> remainingCategories, DataSourceTable otherSideOfMxTable, DataSelection u0DataSelection, Join MxJoin) throws MetadataException {
        boolean removeCategoryOccured = false;
        u0DataSelection.setQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES, true);
        u0DataSelection.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        Iterator<SelectedItem> iterator = remainingCategories.iterator();
        block0: while (iterator.hasNext()) {
            SelectedItem categoryItem = iterator.next();
            List<QualifiedColumn> categoryColumns = categoryItem.getResources(QualifiedColumn.class, 65535);
            int i = 0;
            for (QualifiedColumn categoryColumn : categoryColumns) {
                if (++i == 2 && categoryItem.getItem().isCalculatedItem()) continue block0;
                if (categoryColumn.getDataSource() != otherSideOfMxTable) continue;
                if (categoryItem.getItem().isCalculatedItem()) {
                    this.generateNewDataItem(categoryItem.getItem(), u0DataSelection);
                } else {
                    this.generateNewDataItem(categoryColumn, u0DataSelection, Role.COLUMN);
                }
                iterator.remove();
                removeCategoryOccured = true;
            }
        }
        if (!removeCategoryOccured) {
            ArrayList<DataSourceTable> joinTables = new ArrayList<DataSourceTable>();
            joinTables.add(otherSideOfMxTable);
            if (this.categoriesInThisJoinPath(categories, joinTables)) {
                return false;
            }
        }
        ArrayList<DataSourceTable> singleJoinTable = new ArrayList<DataSourceTable>();
        singleJoinTable.add(otherSideOfMxTable);
        this.generateCategoryKeyColumnSubQuery(u0DataSelection, MxJoin);
        ArrayList<FilterItem> u0FilterItems = this.findPreAggFiltersForThisU0Segment(singleJoinTable);
        this.generatePreAggFilters(u0DataSelection, u0FilterItems);
        return true;
    }

    private void replaceColumns(ConditionalExpression condition, DataSourceTable oldDataSource, DataSourceTable newDataSource, BusinessModel businessModel) throws MetadataException {
        List<QualifiedColumn> columnList = condition.getResources(QualifiedColumn.class, 0);
        for (QualifiedColumn oldColumn : columnList) {
            QualifiedColumn newColumn;
            if (oldColumn.getDataSource() != oldDataSource || (newColumn = this.findColumnInDataSource(oldColumn, newDataSource)) == null) continue;
            condition.replaceResource(oldColumn, newColumn, businessModel, true);
        }
    }

    private QualifiedColumn findColumnInDataSource(QualifiedColumn oldColumn, DataSourceTable newDataSource) throws MetadataException {
        QualifiedColumn newColumn = null;
        for (QualifiedColumn column : newDataSource.getQualifiedColumns()) {
            if (!column.getSasName().equals(oldColumn.getSasName())) continue;
            newColumn = column;
            break;
        }
        return newColumn;
    }

    private List<DataSourceTable> findTablesInThisJoinPath(List<Join> thisJoinPath) {
        ArrayList<DataSourceTable> joinTables = new ArrayList<DataSourceTable>();
        for (Join join : thisJoinPath) {
            if (!joinTables.contains(join.getLeftDataSource())) {
                joinTables.add(join.getLeftDataSource());
            }
            if (joinTables.contains(join.getRightDataSource())) continue;
            joinTables.add(join.getRightDataSource());
        }
        return joinTables;
    }

    private void generateCategoryKeyColumnSubQuery(DataSelection u0DataSelection, Join MxJoin) throws MetadataException {
        ArrayList<String> alreadySelected = new ArrayList<String>();
        ConditionalExpression MxJoinCondition = MxJoin.getJoinCondition();
        List<QualifiedColumn> MxKeyColumns = MxJoinCondition.getResources(QualifiedColumn.class, 0);
        for (QualifiedColumn mxKeyQualifiedColumn : MxKeyColumns) {
            if (mxKeyQualifiedColumn.getDataSource().equals(this._mxTable) || alreadySelected.contains(mxKeyQualifiedColumn.getSasName())) continue;
            this.generateNewDataItem(mxKeyQualifiedColumn, u0DataSelection, Role.COLUMN);
            alreadySelected.add(mxKeyQualifiedColumn.getSasName());
        }
    }

    private LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> getDependentTables(AssociationMatrix matrix, List<SelectedItem> originalSelectedItems) throws MetadataException {
        LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> dependentTables = new LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>>();
        if (matrix != null && !matrix.getDefaultMeasureToMeasureType().equals((Object)AssociationType.DEPENDENT)) {
            DataItem sItem = this._controlMeasures.get(0).getItem();
            if (sItem instanceof DataItemReference) {
                sItem = ((DataItemReference)sItem).getBaseDataItem();
            }
            List<Association> associationList = matrix.getAssociations(sItem, AssociationLevel.USER_SET);
            for (Association association : associationList) {
                if (association.getAssociationType() != AssociationType.DEPENDENT) continue;
                DataSourceTable dataSourceTable = this._associationStrategy.findDataSourceTable((DataItem)association.getTargetItem());
                ArrayList nonConformedDimensions = new ArrayList();
                dependentTables.put(dataSourceTable, nonConformedDimensions);
            }
        } else {
            this.findDependentMeasureTables(dependentTables, originalSelectedItems);
            this.findDependentFilterTables(dependentTables);
        }
        return dependentTables;
    }

    private void findDependentFilterTables(LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> dependentTables) throws MetadataException {
        List<FilterItem> filterItems = this._associationStrategy.getWhereFilters();
        for (FilterItem filterItem : filterItems) {
            boolean filterHasDataItems = false;
            List<DataItem> dataItemsForThisFilter = filterItem.getDataItems(0);
            for (DataItem filterDataItem : dataItemsForThisFilter) {
                filterHasDataItems = true;
                if (filterDataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
                this.checkColumnsForDependentFilterTables(dependentTables, filterDataItem);
            }
            if (filterHasDataItems) continue;
            this.checkColumnsForDependentFilterTables(dependentTables, filterItem);
        }
    }

    private void checkColumnsForDependentFilterTables(LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> dependentTables, BusinessItem item) throws MetadataException {
        List<QualifiedColumn> qualifiedColumnList = item.getResources(QualifiedColumn.class, 0);
        for (QualifiedColumn qualifiedColumn : qualifiedColumnList) {
            this.checkDataSource(dependentTables, qualifiedColumn.getDataSource());
        }
    }

    private void findDependentMeasureTables(LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> dependentTables, List<SelectedItem> originalSelectedItems) throws MetadataException {
        for (SelectedItem item : originalSelectedItems) {
            if (item.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            for (SelectedItem controlMeasure : this._controlMeasures) {
                if (controlMeasure == item) continue;
                DataSourceTable dataSourceTable = this._associationStrategy.findDataSourceTable(item.getItem());
                this.checkDataSource(dependentTables, dataSourceTable);
            }
        }
    }

    private void checkDataSource(LinkedHashMap<DataSourceTable, ArrayList<SelectedItem>> dependentTables, DataSourceTable ds) throws MetadataException {
        boolean found = false;
        for (DataSourceTable dataSourceTable : this._measureTables) {
            if (dataSourceTable != ds) continue;
            found = true;
            break;
        }
        if (!found) {
            boolean redundant = false;
            for (DataSourceTable dependentTable : dependentTables.keySet()) {
                if (dependentTable != ds) continue;
                redundant = true;
                break;
            }
            if (!redundant) {
                ArrayList arrayList = new ArrayList();
                dependentTables.put(ds, arrayList);
            }
        }
    }

    private boolean itemIsNotAControlMeasure(SelectedItem item) {
        for (SelectedItem controlMeasure : this._controlMeasures) {
            if (controlMeasure != item) continue;
            return false;
        }
        return true;
    }

    private void generateNewDataItem(DataItem originalDataItem, DataSelection dataSelection) {
        try {
            DataItemReference dir = dataSelection.newDataItemReference(originalDataItem);
            dir.setLabel(originalDataItem.getLabel());
            String UQueryResultSetID = this._associationStrategy.getUqueryResultSetId(originalDataItem, this._listNum);
            dir.setResultSetID(UQueryResultSetID);
            dir.setUsage(DataItemActionType.USAGE_DETAIL);
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
        }
        catch (MetadataException e) {
            _logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private void generateNewMissingDataItem(DataSelection dataSelection, DataItem originalDataItem) {
        try {
            RootDataItem item = dataSelection.newDataItem();
            item.setExpression(new ConstantExpression(MissingValues.toQueryString((MissingValues)MissingValues.Dot), 2));
            item.setLabel(originalDataItem.getLabel());
            item.setUsage(DataItemActionType.USAGE_DETAIL);
            dataSelection.addBusinessItem(item);
            DataItemReference dir = dataSelection.newDataItemReference(item);
            String UQueryResultSetID = this._associationStrategy.getUqueryResultSetId(originalDataItem, this._listNum);
            dir.setResultSetID(UQueryResultSetID);
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
        }
        catch (MetadataException e) {
            _logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    private void generateNewDataItem(Column column, DataSelection dataSelection, Role role) {
        try {
            RootDataItem item = dataSelection.newDataItem();
            item.setExpression(column);
            item.setUsage(DataItemActionType.USAGE_DETAIL);
            dataSelection.addBusinessItem(item);
            DataItemReference dir = dataSelection.newDataItemReference(item);
            dir.setResultSetID(column.getSasName());
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, role);
        }
        catch (MetadataException e) {
            _logger.debug(e.getMessage(), (Throwable)e);
        }
    }
}

