/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational;

import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.strategies.sas.oma.relational.ExpressionMacroMapping;
import java.util.ArrayList;
import java.util.List;

public class IndependentExpressionGeneration {
    private static final int COUNT_MAXIMUM = 99999;
    private static final int COUNT_NUMBER_OF_DIGITS = 5;
    private final ArrayList<ExpressionMacroMapping> mappings = new ArrayList();
    private static int _count = 0;

    public String addMapping(ExpressionInterface exp, String expValue) {
        ExpressionMacroMapping expmap = null;
        if (!this.isMapped(expValue)) {
            String var = IndependentExpressionGeneration.createVariable();
            expmap = new ExpressionMacroMapping(exp, var, expValue);
            this.mappings.add(expmap);
        } else {
            expmap = this.getMapping(expValue);
            expmap.addExpression(exp);
        }
        String returnValue = null;
        returnValue = this.isCharacterExpression(exp) ? "\"&" + expmap.getVariable() + "\"" : "&" + expmap.getVariable();
        return returnValue;
    }

    public boolean isCharacterExpression(ExpressionInterface exp) {
        boolean returnValue = false;
        if (exp.getExpressionType() == 3 || exp.getExpressionType() == 11) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isMapped(String expValue) {
        boolean returnValue = false;
        for (ExpressionMacroMapping mapping : this.mappings) {
            if (!mapping.getExpressionValue().equals(expValue)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public boolean isMapped(ExpressionInterface expValue) {
        boolean returnValue = false;
        for (ExpressionMacroMapping mapping : this.mappings) {
            if (!mapping.containsExpression(expValue)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public ExpressionMacroMapping getMapping(ExpressionInterface expValue) {
        ExpressionMacroMapping returnValue = null;
        for (ExpressionMacroMapping mapping : this.mappings) {
            if (!mapping.containsExpression(expValue)) continue;
            returnValue = mapping;
            break;
        }
        return returnValue;
    }

    private ExpressionMacroMapping getMapping(String expValue) {
        ExpressionMacroMapping returnValue = null;
        for (ExpressionMacroMapping mapping : this.mappings) {
            if (!mapping.getExpressionValue().equals(expValue)) continue;
            returnValue = mapping;
            break;
        }
        return returnValue;
    }

    private static String createVariable() {
        StringBuffer macroName = new StringBuffer(String.valueOf(_count));
        int iLength = macroName.length();
        for (int i = 5; i > iLength; --i) {
            macroName.insert(0, "0");
        }
        macroName.insert(0, "IQV");
        if (++_count > 99999) {
            _count = 0;
        }
        return macroName.toString();
    }

    public List<ExpressionMacroMapping> getMappings() {
        return this.mappings;
    }

    public boolean isReplaceable(ExpressionInterface exp) {
        boolean returnValue = true;
        if (exp instanceof QualifiedColumn) {
            returnValue = false;
        } else {
            List<QualifiedColumn> resources;
            if (exp instanceof AbstractRelativeTimeValueExpression) {
                AbstractRelativeTimeValueExpression exp1 = (AbstractRelativeTimeValueExpression)exp;
                if (this.isReplaceable(exp1.getShiftingFrom())) {
                    returnValue = true;
                }
            } else if (exp instanceof FunctionCall) {
                returnValue = this.isValidInputFunctionCall((FunctionCall)exp);
            }
            if (returnValue && (resources = exp.getResources(QualifiedColumn.class, 65531)).size() > 0) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    private boolean isValidInputFunctionCall(FunctionCall input) {
        boolean returnValue = true;
        Function call = input.getFunction();
        if (call != null) {
            if (returnValue && !call.isIndependentlyEvaluatable()) {
                returnValue = false;
            }
            if (returnValue) {
                returnValue = this.isValidFunctionArguements(input);
            }
        }
        return returnValue;
    }

    private boolean isValidFunctionArguements(FunctionCall input) {
        boolean returnValue = true;
        for (ExpressionInterface expr : input.getArguments()) {
            assert (expr != null);
            if (this.isReplaceable(expr)) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public boolean isMappedTo(String returnSQL) {
        boolean returnValue = false;
        int amperIndx = returnSQL.indexOf(38);
        if (amperIndx == 0) {
            for (ExpressionMacroMapping mapping : this.mappings) {
                if (!mapping.getVariable().equals(returnSQL.substring(1))) continue;
                returnValue = true;
                break;
            }
        }
        return returnValue;
    }
}

