/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.strategies.sas.oma.CloneDataSelectionFactory;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.IndependentExpressionGeneration;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.TempLibnameGeneration;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataSelectionProcessorAbstract {
    protected EffectiveObjectsCache _effectiveObjectsCache = new EffectiveObjectsCache();
    protected final DataSelection _dataSelection;
    protected final DataSelection _actualDataSelection;
    protected Collection<DataSelection> _dsrqSubqueries = null;
    protected Collection<DataSelection> _allSubqueries = null;
    protected final TempLibnameGeneration tempLibnameGeneration;
    private final Map<DataSelection, String> _tempTableNameMap = new HashMap<DataSelection, String>();
    private final Map<DataSelection, Boolean> _tempTableIsViewMap = new HashMap<DataSelection, Boolean>();
    private int _nameCount = 0;
    private int _language_id = 0;
    private boolean _disableTsSQL = false;
    private boolean _disableExplicitSPDS = false;
    private static final Logger _logger = LogManager.getLogger(DataSelectionProcessorAbstract.class);
    private int _aliasCounter = 0;
    protected IndependentExpressionGeneration _independentExpressionGenerator = new IndependentExpressionGeneration();
    private boolean _useValidVarNameAny = false;
    private boolean _useValidMemNameExtend = false;
    private boolean tempLibnameGenerationPopulated;

    public synchronized int getNameCounter() {
        return this._nameCount++;
    }

    public synchronized int getAliasCounter() {
        return this._aliasCounter++;
    }

    public DataSelectionProcessorAbstract(DataSelection dataSelection) {
        this.tempLibnameGeneration = new TempLibnameGeneration(this);
        this._actualDataSelection = dataSelection;
        this._dataSelection = this.extractCreateTableDataSelection(dataSelection);
    }

    public DataSelection getDataSelection() {
        return this._dataSelection;
    }

    public DataSelection getActualDataSelection() {
        return this._actualDataSelection;
    }

    public DataSelection populateClonedDataSelection(DataSelection dataSelection) throws GenerationException {
        return CloneDataSelectionFactory.createCloneDataSelection(dataSelection);
    }

    public Collection<DataSelection> getDSRQSubqueries() {
        if (this._dsrqSubqueries == null) {
            this._dsrqSubqueries = new ArrayList<DataSelection>();
        }
        return this._dsrqSubqueries;
    }

    public Collection<String> getLibnameStatements() throws GenerationException {
        Collection<String> libnameStatements = this.tempLibnameGeneration.getLibnameStatements();
        return libnameStatements;
    }

    @Nonnull
    public List<String> getQueryTablesTexts() throws GenerationException {
        return this.tempLibnameGeneration.getQueryTablesTexts();
    }

    @Nonnull
    public List<String> getQueryTablesPrepareLogs() throws GenerationException {
        return this.tempLibnameGeneration.getQueryTablesPrepareLogs();
    }

    public void populate() throws GenerationException {
        boolean hasNonTsSqlAggregations;
        if (this._dataSelection == null) {
            MessageFormatter mft = DataSelectionProcessorAbstract.getMessageFormatter("RelationalDataSelectionProcessor.populate.NoDataSelection.txt");
            throw new GenerationException(mft);
        }
        boolean hasSelectDistinctHiddenOrderBy = this.hasSelectDistinctHiddenOrderBy(this._dataSelection);
        if (hasSelectDistinctHiddenOrderBy) {
            this._disableTsSQL = true;
        }
        if (hasNonTsSqlAggregations = this.hasUnsupportedAggregations(this._dataSelection)) {
            this._disableTsSQL = true;
        }
        if (!this.tempLibnameGenerationPopulated) {
            this.tempLibnameGeneration.populateTempLibnames(this._dataSelection);
            this.tempLibnameGenerationPopulated = true;
            if (this.tempLibnameGeneration.usesView()) {
                this._disableTsSQL = true;
            }
            if (this.tempLibnameGeneration.hasSPDSLibrary()) {
                this._disableTsSQL = true;
            }
            if (this.tempLibnameGeneration.isIMLE()) {
                this._disableTsSQL = true;
            }
        }
        boolean isView = this.getTempTableIsView(this._dataSelection);
        if (this.tempLibnameGeneration.usesView() || isView) {
            this._disableTsSQL = true;
        }
        this.calcLanguageId();
        this._dsrqSubqueries = this.populateMultipleDataSelections(this._dataSelection);
    }

    private void calcLanguageId() throws GenerationException {
        if (this._language_id == 0) {
            boolean isView;
            boolean hasNonTsSqlAggregations;
            boolean hasSelectDistinctHiddenOrderBy;
            boolean useTSSQL;
            int language = 1;
            if (this.isUseExplicitSPDS() || this.isUseConnectionTo()) {
                if (!this._disableExplicitSPDS) {
                    language = 2;
                }
            } else if (!(this._disableTsSQL || !(useTSSQL = GenerationUtil.useTSSQL()) || this._dataSelection == null || (hasSelectDistinctHiddenOrderBy = this.hasSelectDistinctHiddenOrderBy(this._dataSelection)) || (hasNonTsSqlAggregations = this.hasUnsupportedAggregations(this._dataSelection)) || (isView = this.getTempTableIsView(this._dataSelection)))) {
                if (!this.tempLibnameGenerationPopulated) {
                    this.tempLibnameGeneration.populateTempLibnames(this._dataSelection);
                    this.tempLibnameGenerationPopulated = true;
                }
                if (!(this.tempLibnameGeneration.usesView() || this.tempLibnameGeneration.hasSPDSLibrary() || this.tempLibnameGeneration.isIMLE())) {
                    language = 4;
                }
            }
            this._language_id = language;
        }
    }

    public boolean isSPDS() throws GenerationException {
        this.calcLanguageId();
        return this.getLanguageID() == 2;
    }

    public boolean isTSSQL() throws GenerationException {
        this.calcLanguageId();
        return this.getLanguageID() == 4;
    }

    public boolean isUseExplicitSPDS() {
        return this.tempLibnameGeneration.isUseExplicitSPDS();
    }

    public boolean isUseConnectionTo() {
        return this.tempLibnameGeneration.isUseConnectionTo();
    }

    public String getSPDSConnectStatement() {
        return this.tempLibnameGeneration.getSPDSConnectStatement();
    }

    public void disableTSSQL() throws GenerationException, TSSQLGenerationDisabledException {
        this._disableTsSQL = true;
        this.calcLanguageId();
        int languageID = this.getLanguageID();
        if (languageID == 4) {
            this._language_id = this.isUseExplicitSPDS() || this.isUseConnectionTo() ? (this._disableExplicitSPDS ? 1 : 2) : 1;
            TSSQLGenerationDisabledException e = new TSSQLGenerationDisabledException();
            _logger.warn((Object)e);
            throw e;
        }
    }

    public boolean isTempTable(DataSelection dataSelection) {
        return this.tempLibnameGeneration.isTempTable(dataSelection);
    }

    public String getTempLibname() throws GenerationException {
        return this.tempLibnameGeneration.getTempLibname();
    }

    public boolean isTempViewAllowed() throws GenerationException {
        boolean allowed = true;
        boolean writtingSpdsSql = this.isSPDS();
        if (writtingSpdsSql && this.isUseConnectionTo()) {
            allowed = false;
        } else if (!writtingSpdsSql) {
            this.tempLibnameGeneration.isCreateViewAllowed();
        }
        return allowed;
    }

    public String getTempTableName(DataSelection dataSelection) throws GenerationException {
        if (!this._tempTableNameMap.containsKey(dataSelection)) {
            String tempTableName = this.generateTempTableName(dataSelection);
            this.putTempTableName(dataSelection, tempTableName);
        }
        return this._tempTableNameMap.get(dataSelection);
    }

    public String putTempTableName(DataSelection dataSelection, String tempTableName) {
        return this._tempTableNameMap.put(dataSelection, tempTableName);
    }

    public boolean getTempTableIsView(DataSelection dataSelection) throws GenerationException {
        if (!this._tempTableIsViewMap.containsKey(dataSelection)) {
            boolean isView = false;
            if (dataSelection instanceof CreateTableDataSelection) {
                CreateTableDataSelection ctds = (CreateTableDataSelection)dataSelection;
                isView = ctds.isView();
            } else {
                isView = dataSelection != null && dataSelection.getQueryProperty(BusinessQueryProperty.TEMP_IS_VIEW);
            }
            this.setTempTableIsView(dataSelection, isView);
        }
        return this._tempTableIsViewMap.get(dataSelection);
    }

    public void setTempTableIsView(DataSelection dataSelection, boolean isView) throws GenerationException {
        this._tempTableIsViewMap.put(dataSelection, isView);
    }

    private String generateTempTableName(DataSelection dataSelection) throws GenerationException {
        Export export;
        List<ExportRule> exportRules = dataSelection.getEffectiveRules(ExportRule.class);
        Export export2 = export = exportRules.isEmpty() ? null : exportRules.get(0).getExport();
        if (export != null && !export.getResultSetTableName().isEmpty()) {
            return export.getResultSetTableName();
        }
        String tempLibName = this.tempLibnameGeneration.getTempLibname();
        int nameCounter = this.getNameCounter();
        String suffix = "";
        if (nameCounter > 0) {
            suffix = Integer.toString(nameCounter);
        }
        return tempLibName + "." + DataSelectionProcessorAbstract.getTempTablePattern() + suffix;
    }

    public static final String getTempTablePattern() {
        return "%RESULT_TABLE_NAME%";
    }

    protected DataSelection extractCreateTableDataSelection(DataSelection dataSelection) {
        if (dataSelection instanceof CreateTableDataSelection) {
            dataSelection = ((CreateTableDataSelection)dataSelection).getDataSelection();
        }
        return dataSelection;
    }

    @Nonnull
    public abstract Collection<DataSelection> populateMultipleDataSelections(DataSelection var1) throws GenerationException;

    public int getLanguageID() {
        return this._language_id;
    }

    public void setLanguageID(int lang) {
        this._language_id = lang;
    }

    public String[] getSQLReservedWords() throws GenerationException {
        this.calcLanguageId();
        int langID = this.getLanguageID();
        String[] values = GenerationUtil.getReservedWords(langID);
        return values;
    }

    public IndependentExpressionGeneration getIndependentExpressionGenerator() {
        return this._independentExpressionGenerator;
    }

    public void setIndependentExpressionGenerator(IndependentExpressionGeneration independentExpressionGenerator) {
        this._independentExpressionGenerator = independentExpressionGenerator;
    }

    public Collection<DataSelection> getAllSubqueries() {
        if (this._allSubqueries == null) {
            this._allSubqueries = new ArrayList<DataSelection>();
        }
        return this._allSubqueries;
    }

    public boolean getUseValidVarNameAny() {
        return this._useValidVarNameAny;
    }

    public boolean getUseValidMemNameExtend() {
        return this._useValidMemNameExtend;
    }

    public String generateColumnIdentifier(String identifier) throws GenerationException {
        this.calcLanguageId();
        int langID = this.getLanguageID();
        return this.generateColumnIdentifier(identifier, null, langID);
    }

    public String generateColumnIdentifier(String identifier, Table table) throws GenerationException {
        this.calcLanguageId();
        int langID = this.getLanguageID();
        return this.generateColumnIdentifier(identifier, table, langID);
    }

    public String generateColumnIdentifier(String identifier, boolean allowTsSql) throws GenerationException {
        this.calcLanguageId();
        int langID = this.getLanguageID();
        if (!allowTsSql && langID == 4) {
            if (this.isUseExplicitSPDS() || this.isUseConnectionTo()) {
                this._language_id = !this._disableExplicitSPDS ? 1 : 2;
            } else {
                langID = 1;
            }
        }
        return this.generateColumnIdentifier(identifier, null, langID);
    }

    public String generateColumnIdentifier(String identifier, Table table, int langID) throws GenerationException {
        try {
            DataSourceTableImpl2 tableImp;
            boolean mustQuoteTableColumns = false;
            if ((langID != 2 || this._disableExplicitSPDS) && table instanceof DataSourceTableImpl2 && ((tableImp = (DataSourceTableImpl2)table).isCaseEnabled() || tableImp.isSpecialCharEnabled())) {
                mustQuoteTableColumns = true;
            }
            boolean needsEscaping = GenerationUtil.columnNeedsEscaping(identifier, langID);
            if (mustQuoteTableColumns || needsEscaping) {
                identifier = GenerationUtil.generateEscapedIdentifier(identifier, langID);
                if (langID != 2 || this._disableExplicitSPDS) {
                    this._useValidVarNameAny = true;
                }
            }
            return identifier;
        }
        catch (MetadataException e) {
            throw new GenerationException(DataSelectionProcessorAbstract.getMessageFormatter("DataSelectionProcessorAbstract.generateQuotedIdentifier.MetadataException.txt"), (Throwable)e);
        }
    }

    public String generateTableIdentifier(String tableIdentifier) throws GenerationException {
        this.calcLanguageId();
        int langID = this.getLanguageID();
        return this.generateTableIdentifier(tableIdentifier, langID);
    }

    public String generateTableIdentifier(String tableIdentifier, int langID) throws GenerationException {
        boolean needsEscaping = GenerationUtil.tableNeedsEscaping(tableIdentifier, langID);
        if (needsEscaping) {
            tableIdentifier = GenerationUtil.generateEscapedIdentifier(tableIdentifier, langID);
            switch (langID) {
                case 4: {
                    break;
                }
                case 2: {
                    if (!this._disableExplicitSPDS) break;
                    this._useValidMemNameExtend = true;
                    break;
                }
                default: {
                    this._useValidMemNameExtend = true;
                }
            }
        }
        return tableIdentifier;
    }

    public String generateTableIdentifier(DataSourceTable table) throws GenerationException {
        this.calcLanguageId();
        int langID = this.getLanguageID();
        return this.generateTableIdentifier(table, langID);
    }

    public String generateTableIdentifier(DataSourceTable table, int langID) throws GenerationException {
        try {
            DataSourceTableImpl2 tableImp;
            String tableIdentifier = null;
            boolean mustQuoteTableColumns = false;
            if ((langID != 2 || this._disableExplicitSPDS) && table instanceof DataSourceTableImpl2 && ((tableImp = (DataSourceTableImpl2)table).isCaseEnabled() || tableImp.isSpecialCharEnabled())) {
                mustQuoteTableColumns = true;
            }
            tableIdentifier = table.getSasName();
            boolean needsEscaping = GenerationUtil.tableNeedsEscaping(tableIdentifier, langID);
            if (mustQuoteTableColumns || needsEscaping) {
                tableIdentifier = GenerationUtil.generateEscapedIdentifier(tableIdentifier, langID);
                switch (langID) {
                    case 4: {
                        break;
                    }
                    case 2: {
                        if (!this._disableExplicitSPDS) break;
                        this._useValidMemNameExtend = true;
                        break;
                    }
                    default: {
                        this._useValidMemNameExtend = true;
                    }
                }
            }
            return tableIdentifier;
        }
        catch (MetadataException e) {
            throw new GenerationException(DataSelectionProcessorAbstract.getMessageFormatter("DataSelectionProcessorAbstract.generateQuotedIdentifier.MetadataException.txt"), (Throwable)e);
        }
    }

    public String generateDataStepVar(String identifier) throws GenerationException {
        boolean needsEscaping;
        boolean bl = needsEscaping = !identifier.matches("[\\w&&\\D][\\w]*");
        if (needsEscaping) {
            String identifierQuoteStart = "'";
            String identifierQuoteEnd = "'n";
            String escaped = identifier.replaceAll(identifierQuoteStart, identifierQuoteStart + identifierQuoteStart);
            identifier = identifierQuoteStart + escaped + identifierQuoteEnd;
            this._useValidVarNameAny = true;
        }
        return identifier;
    }

    public boolean getUsesPostProcess() {
        return false;
    }

    public abstract boolean isNeededForPostProcess(DataSelection var1, DataItem var2, Role var3) throws GenerationException;

    protected static String getMessage(String key, Object[] args) {
        return IQDataServicesResourceBundle.getMessageString(key, args);
    }

    protected static MessageFormatter getMessageFormatter(String key) {
        return IQDataServicesResourceBundle.getMessageFormatter(key, new Object[0]);
    }

    protected static MessageFormatter getMessageFormatter(String key, Object[] args) {
        return IQDataServicesResourceBundle.getMessageFormatter(key, args);
    }

    public void dispose() {
    }

    public boolean isDistinct(DataSelection selection) {
        boolean returnBoolean = false;
        if (selection.getQueryProperty(BusinessQueryProperty.RETURN_DISTINCT_VALUES)) {
            returnBoolean = true;
        } else {
            int groupItems = 0;
            int detailOrAnalysisItems = 0;
            List<SelectedItem> selectedItems = selection.getSelectedItems();
            for (SelectedItem selectedItem : selectedItems) {
                DataItem dataItem = selectedItem.getItem();
                Role role = selectedItem.getRole();
                DataItemActionType usage = dataItem.getUsage();
                if (role == Role.BACKGROUND || role == Role.getInactiveRole(selection)) continue;
                if (usage == DataItemActionType.USAGE_CATEGORY) {
                    ++groupItems;
                    continue;
                }
                if (usage == DataItemActionType.USAGE_AGGREGATE) {
                    List<QualifiedColumn> cols = dataItem.getResources(QualifiedColumn.class, 65535);
                    if (cols.size() == 0) continue;
                    ++detailOrAnalysisItems;
                    continue;
                }
                if (usage != DataItemActionType.USAGE_DETAIL) continue;
                ++detailOrAnalysisItems;
            }
            if (groupItems > 0 && detailOrAnalysisItems == 0) {
                returnBoolean = true;
            }
        }
        return returnBoolean;
    }

    public void setDisableExplicitSPDS(boolean disable) throws GenerationException {
        this._disableExplicitSPDS = disable;
        if (disable) {
            if (this._language_id == 2) {
                this._language_id = 1;
            }
        } else if (this.isUseExplicitSPDS() || this.isUseConnectionTo()) {
            this._language_id = 2;
        }
    }

    public boolean getDisableExplicitSPDS() {
        return this._disableExplicitSPDS;
    }

    private boolean hasUnsupportedAggregations(DataSelection dataSelection) throws GenerationException {
        boolean found = false;
        List<DataItem> items = this.getEffectiveResultItems(dataSelection);
        for (DataItem di : items) {
            if (!GenerationUtil.isInvalidTSSQL(dataSelection, di)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean hasSelectDistinctHiddenOrderBy(DataSelection dataSelection) throws GenerationException {
        boolean ret = false;
        if (this.isDistinct(dataSelection)) {
            List<DataItem> effectiveSortOrderPrecedence = this.getEffectiveSortOrderPrecedence(dataSelection);
            for (DataItem item : effectiveSortOrderPrecedence) {
                try {
                    Role role = dataSelection.getResultItemRole(item);
                    if (!Role.isOutputResultRole(dataSelection, role)) {
                        ret = true;
                    }
                }
                catch (MetadataException e) {
                    ret = true;
                }
                if (!ret) continue;
                break;
            }
        }
        return ret;
    }

    public void setEffectiveObjectsCache(EffectiveObjectsCache effectiveObjectsCache) {
        this._effectiveObjectsCache = effectiveObjectsCache;
    }

    public EffectiveObjectsCache getEffectiveObjectsCache() {
        return this._effectiveObjectsCache;
    }

    public List<DataItem> getEffectiveSortOrderPrecedence(BusinessQuery query) {
        return this._effectiveObjectsCache.getEffectiveSortOrderPrecedence(query);
    }

    public List<DataSource> getEffectiveDataSources(BusinessQuery query) throws MetadataException {
        return this._effectiveObjectsCache.getEffectiveDataSources(query);
    }

    public List<DataItem> getEffectiveResultItems(BusinessQuery query) {
        return this._effectiveObjectsCache.getEffectiveResultItems(query);
    }

    public List<FilterItem> getEffectiveFilters(BusinessQuery query) {
        return this._effectiveObjectsCache.getEffectiveFilters(query);
    }

    public List<Join> getEffectiveJoinPath(BusinessQuery query) throws MetadataException {
        return this._effectiveObjectsCache.getEffectiveJoinPath(query);
    }

    static class TSSQLGenerationDisabledException
    extends GenerationException {
        private static final long serialVersionUID = 1L;

        public TSSQLGenerationDisabledException() {
            super(IQDataServicesResourceBundle.getMessageFormatter("TSSqlGenerationDisabled.txt", new Object[0]));
        }
    }
}

