/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.AssociationMatrix;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.JoinType;
import com.sas.iquery.metadata.business.ModelItemWithIdentity;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.SetOperationType;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.LookThroughDataSelectionImpl;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.strategies.sas.oma.AbstractStrategy;
import com.sas.iquery.strategies.sas.oma.relational.RelationalStrategy;
import com.sas.iquery.strategies.sas.oma.relational.UQuery;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFilterExaminerAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFactory;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGeneration;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssociationStrategy
extends AbstractStrategy
implements StrategyInterface {
    private DataSelection _businessQuery;
    private List<FilterItem> _havingFilters;
    private List<FilterItem> _whereFilters;
    private int _UQueryCount = 0;
    private static final Logger _logger = LogManager.getLogger(AssociationStrategy.class);
    static final int MULTIPLE_MEASURE_TABLES_IN_SAME_UQUERY = 0;
    static final int EXPRESSION_NOT_SUPPORTED_IN_THIS_JOIN_MODEL = 1;
    static final int OUTER_JOINS_NOT_IMPLEMENTED_IN_THIS_JOIN_MODEL = 2;
    static final int NESTED_CALCULATED_MEASURES_NOT_CURRENTLY_IMPLEMENTED = 3;

    @Override
    public ExecutionInstructionInterface createInstructions(DataSelection businessQuery, EntityInterface entity) throws IQueryServicesException {
        ExecutionInstructionInterface instructions;
        boolean createTable = false;
        RelationalSchema createTableRelationalSchema = null;
        List<Join> effectiveJoins = null;
        if (businessQuery instanceof CreateTableDataSelection) {
            createTable = true;
            createTableRelationalSchema = ((CreateTableDataSelection)businessQuery).getRelationalSchemaForCreation();
            this._businessQuery = ((CreateTableDataSelection)businessQuery).getDataSelection();
        } else {
            this._businessQuery = businessQuery;
        }
        List<SelectedItem> originalSelectedItems = this._businessQuery.getSelectedItems();
        if (!this.isExportOMATable()) {
            effectiveJoins = this._businessQuery.getEffectiveJoinPath();
            this.checkForPreMFTValid(effectiveJoins);
        }
        if (!this.MFTDataSelection(originalSelectedItems)) {
            RelationalStrategy relStrategy = new RelationalStrategy();
            instructions = relStrategy.createInstructions(businessQuery, entity);
            this.addAuxDataSelections(relStrategy.getAuxDataSelections());
        } else {
            try {
                this.separateFilters();
            }
            catch (GenerationException e) {
                e.printStackTrace();
            }
            DataSelection model = DataSelectionFactory.newDataSelection(businessQuery);
            this.addAuxDataSelection(model);
            this.convertToAssociationDataModel(model, effectiveJoins, originalSelectedItems);
            CreateTableDataSelection createTableDataSelection = null;
            if (createTable) {
                createTableDataSelection = DataSelectionFactory.getInstance().newCreateTableDataSelection(model);
                this.addAuxDataSelection(createTableDataSelection);
                createTableDataSelection.setRelationalSchemaForCreation(createTableRelationalSchema);
                createTableDataSelection.setID(((CreateTableDataSelection)businessQuery).getID());
                createTableDataSelection.setName(((CreateTableDataSelection)businessQuery).getName());
                RelationalStrategy relStrategy = new RelationalStrategy();
                instructions = relStrategy.createInstructions(createTableDataSelection, entity);
            } else {
                RelationalStrategy relStrategy = new RelationalStrategy();
                instructions = relStrategy.createInstructions(model, entity);
                this.addAuxDataSelections(relStrategy.getAuxDataSelections());
            }
        }
        return instructions;
    }

    private boolean isExportOMATable() {
        Export export;
        List<ExportRule> rules = this._businessQuery.getEffectiveRules(ExportRule.class);
        Export export2 = export = rules.isEmpty() ? null : rules.get(0).getExport();
        boolean isOmaTable = export == null ? false : export.getUsage() == ExportType.LASR_OMA_TABLE;
        return isOmaTable;
    }

    public void throwExceptionWithReason(int subreason, List textableObjects) throws GenerationException {
        Reason reason = this.createReasonNotValid(subreason, textableObjects);
        if (_logger.isEnabled(Level.ERROR)) {
            _logger.error(" ... reasons are: " + reason.toString());
        }
        MessageFormatter baseMessage = IQDataServicesResourceBundle.getMessageFormatter("SQLGeneration.checkValid.invalid.txt", new Object[0]);
        MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, Collections.singletonList(reason), false);
        GenerationException e = new GenerationException(reasonListFormatter, Collections.singletonList(reason));
        throw e;
    }

    private boolean MFTDataSelection(List<SelectedItem> selectedItems) {
        if (!this.allSelectedItemsAreCategories(selectedItems) && !this.anySelectedItemIsDetail(selectedItems)) {
            if (!this.allCalculatedMeasuresInSameTable(selectedItems)) {
                return true;
            }
            DataSourceTable singleMeasureTable = this.allMeasuresInSameTable(selectedItems);
            if (singleMeasureTable == null) {
                return true;
            }
            try {
                if (!this.allMeasureFiltersReferenceSingleTable(singleMeasureTable)) {
                    return true;
                }
            }
            catch (MetadataException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean anySelectedItemIsDetail(List<SelectedItem> selectedItems) {
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem.getUsage() != DataItemActionType.USAGE_DETAIL) continue;
            return true;
        }
        return false;
    }

    private boolean allSelectedItemsAreCategories(List<SelectedItem> selectedItems) {
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem.getUsage() == DataItemActionType.USAGE_CATEGORY) continue;
            return false;
        }
        return true;
    }

    private boolean allMeasureFiltersReferenceSingleTable(DataSourceTable singleMeasureTable) throws MetadataException {
        List<FilterItem> filterItems = this._businessQuery.getEffectiveFilters();
        for (FilterItem filterItem : filterItems) {
            boolean filterHasDataItems = false;
            List<DataItem> dataItemsForThisFilter = filterItem.getDataItems(0);
            for (DataItem filterDataItem : dataItemsForThisFilter) {
                filterHasDataItems = true;
                if (filterDataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
                List<QualifiedColumn> qualifiedColumnList = filterDataItem.getResources(QualifiedColumn.class, 0);
                for (QualifiedColumn qualifiedColumn : qualifiedColumnList) {
                    if (qualifiedColumn.getDataSource() == singleMeasureTable) continue;
                    return false;
                }
            }
            if (filterHasDataItems) continue;
            List<QualifiedColumn> filterColumnList = filterItem.getResources(QualifiedColumn.class, 0);
            for (QualifiedColumn filterColumn : filterColumnList) {
                if (filterColumn.getDataSource() == singleMeasureTable) continue;
                return false;
            }
        }
        return true;
    }

    private boolean allCalculatedMeasuresInSameTable(List<SelectedItem> selectedItems) {
        DataSourceTable dataSourceTable = null;
        DataSourceTable lastDataSourceTable = null;
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE || !dataItem.isCalculatedItem()) continue;
            List<QualifiedColumn> measureColumnList = this.findQualifiedColumnsInCalculatedMeasure(dataItem.getExpression());
            for (QualifiedColumn measureColumn : measureColumnList) {
                try {
                    dataSourceTable = measureColumn.getDataSource();
                    if (lastDataSourceTable != null && dataSourceTable != lastDataSourceTable) {
                        return false;
                    }
                    lastDataSourceTable = dataSourceTable;
                }
                catch (MetadataException e) {
                    _logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    private DataSourceTable allMeasuresInSameTable(List<SelectedItem> selectedItems) {
        DataSourceTable dataSourceTable = null;
        DataSourceTable lastDataSourceTable = null;
        for (SelectedItem selectedItem : selectedItems) {
            DataItem dataItem = selectedItem.getItem();
            if (dataItem.getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            try {
                dataSourceTable = this.findDataSourceTable(dataItem);
                if (lastDataSourceTable != null && dataSourceTable != lastDataSourceTable) {
                    return null;
                }
                lastDataSourceTable = dataSourceTable;
            }
            catch (MetadataException e) {
                _logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        return dataSourceTable;
    }

    private void separateFilters() throws GenerationException {
        SQLSASFactory tempSQLFactory = new SQLSASFactory();
        SQLFilterExaminerAbstract tempFilterExaminer = (SQLFilterExaminerAbstract)tempSQLFactory.createSQLFilterExaminer();
        tempFilterExaminer.setDataSelection(this._businessQuery);
        tempFilterExaminer.examineFilters();
        this._whereFilters = tempFilterExaminer.getWhereFilters();
        this._havingFilters = tempFilterExaminer.getHavingFilters();
    }

    private void processPostAggFilters(DataSelection outerQuery, List<SelectedItem> selectedItems, ArrayList<DataItem> tempDataItemsToRemoveFromOuterQuery, LinkedHashMap<DataItem, Integer> havingMap) {
        DataItem tempDataItem = null;
        int addToEnd = 0;
        SQLExpressionAbstract sqlExpression = null;
        SQLSASFactory tempSQLFactory = new SQLSASFactory();
        JoinGeneration joinGeneration = new JoinGeneration();
        joinGeneration.setDataSelectionProcessor(new RelationalDataSelectionProcessor(outerQuery));
        joinGeneration.setDataSelection(outerQuery);
        try {
            sqlExpression = tempSQLFactory.createSQLExpression();
            sqlExpression.setDataSelection(outerQuery);
            sqlExpression.setDataSelectionProcessor(new RelationalDataSelectionProcessor(outerQuery));
            sqlExpression.setJoinGenerator(joinGeneration);
        }
        catch (GenerationException e) {
            _logger.debug(e.getMessage(), (Throwable)e);
        }
        for (FilterItem originalFilterItem : this._havingFilters) {
            List<DataItem> dataItemsForThisFilter = originalFilterItem.getDataItems(0);
            for (DataItem filterDataItem : dataItemsForThisFilter) {
                boolean found = false;
                int i = 0;
                for (SelectedItem selectedItem : selectedItems) {
                    DataItem originalDataItem = selectedItem.getItem();
                    ++i;
                    try {
                        String sql2;
                        String sql1 = sqlExpression.generateComparableExpressionSQL(originalDataItem, null);
                        if (!sql1.equals(sql2 = sqlExpression.generateComparableExpressionSQL(filterDataItem, null))) continue;
                        havingMap.put(filterDataItem, i);
                        found = true;
                        break;
                    }
                    catch (GenerationException e) {
                        _logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                if (found) continue;
                tempDataItem = this.generateNewDataItem(filterDataItem, this._businessQuery, selectedItems);
                havingMap.put(filterDataItem, selectedItems.size() + addToEnd);
                tempDataItemsToRemoveFromOuterQuery.add(tempDataItem);
                ++addToEnd;
            }
        }
    }

    private Reason createReasonNotValid(int subreason, List textableObjects) {
        Reason reason;
        switch (subreason) {
            case 0: {
                String args = this.reasonObjectListToString(textableObjects, 0);
                reason = new Reason((Object)this, 11, 244, "DataSelectionImpl.JoinModel.MultipleMxTablesInUQuery.fmt.txt", args);
                break;
            }
            case 1: {
                reason = new Reason((Object)this, 11, 245, "DataSelectionImpl.JoinModel.ExpressionNotImplementedInMFT.txt", new Object[0]);
                break;
            }
            case 2: {
                String reasonObjectsText = this.reasonObjectListToString(textableObjects, 2);
                reason = new Reason((Object)this, 11, 246, "DataSelectionImpl.JoinModel.OuterJoinsNotImplementedInMFT.fmt.txt", reasonObjectsText);
                break;
            }
            case 3: {
                DataItem calcDataItem = (DataItem)textableObjects.get(0);
                reason = new Reason((Object)this, 11, 247, "DataSelectionImpl.JoinModel.NestedCalcMeasuresNotImplementedInMFT.fmt.txt", calcDataItem.getLabel());
                break;
            }
            default: {
                reason = null;
            }
        }
        return reason;
    }

    private void checkForPreMFTValid(List<Join> effectiveJoins) throws MetadataException, GenerationException {
        this.checkForOuterJoins(effectiveJoins);
    }

    private void checkForOuterJoins(List<Join> effectiveJoins) throws MetadataException, GenerationException {
        for (Join join : effectiveJoins) {
            if (join.getType() == JoinType.INNER) continue;
            ArrayList<DataSourceTable> joinTables = new ArrayList<DataSourceTable>();
            joinTables.add(join.getLeftDataSource());
            joinTables.add(join.getRightDataSource());
            this.throwExceptionWithReason(2, joinTables);
        }
    }

    private String reasonObjectListToString(List<DataSourceTable> textableObjects, int which) {
        StringBuffer sb = new StringBuffer();
        switch (which) {
            case 0: 
            case 2: {
                Iterator<DataSourceTable> iter = textableObjects.iterator();
                while (iter.hasNext()) {
                    DataSourceTable dataSourceTable = iter.next();
                    sb.append(iter.hasNext() ? dataSourceTable + ", " : dataSourceTable);
                }
                break;
            }
        }
        return sb.toString();
    }

    private void convertToAssociationDataModel(DataSelection outerQuery, List<Join> effectiveJoins, List<SelectedItem> originalSelectedItems) throws MetadataException, GenerationException {
        ArrayList<UQuery> UQueries = new ArrayList<UQuery>();
        if (this._businessQuery instanceof DataSelectionImpl && outerQuery instanceof DataSelectionImpl) {
            Map<BusinessQueryProperty, Boolean> fromProperties = ((DataSelectionImpl)this._businessQuery).getProperties();
            Map<BusinessQueryProperty, Boolean> toProperties = ((DataSelectionImpl)outerQuery).getProperties();
            toProperties.clear();
            toProperties.putAll(fromProperties);
            if (this._businessQuery instanceof LookThroughDataSelectionImpl) {
                toProperties.putAll(((LookThroughDataSelectionImpl)this._businessQuery).getOverriddenQueryProperties());
            }
        } else {
            _logger.debug("Was not able to preserve query properties because the original or outer query are not a DataSelectionImpl object");
        }
        SetOperationDataSelection unionQuery = DataSelectionFactory.getInstance().newSetOperationDataSelection(outerQuery);
        ArrayList<SelectedItem> selectedItems = this.reorderOriginalDataSelection(originalSelectedItems);
        ArrayList<DataItem> tempDataItemsToRemoveFromOuterQuery = new ArrayList<DataItem>();
        LinkedHashMap<SelectedItem, Map<DataItem, String>> tempColumnCalcMeasuresToAddToOuterQuery = new LinkedHashMap<SelectedItem, Map<DataItem, String>>();
        LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery = new LinkedHashMap<SelectedItem, Map<DataItem, String>>();
        LinkedHashMap<DataItem, Integer> havingMap = new LinkedHashMap<DataItem, Integer>();
        this.processPostAggFilters(outerQuery, selectedItems, tempDataItemsToRemoveFromOuterQuery, havingMap);
        this.processCalculatedMeasuresBasedOnAggregates(selectedItems, tempDataItemsToRemoveFromOuterQuery, tempCalcMeasuresToAddToOuterQuery);
        this.processCalculatedMeasuresBasedOnColumns(selectedItems, tempDataItemsToRemoveFromOuterQuery, tempColumnCalcMeasuresToAddToOuterQuery);
        ArrayList<DataSelection> unionSelections = this.buildUQueryModel(outerQuery, selectedItems, UQueries, effectiveJoins, tempColumnCalcMeasuresToAddToOuterQuery);
        DataSelection outerQuerySelection = null;
        assert (this._UQueryCount > 0) : "AssociationStrategy was incorrectly chosen - no measures associated with data selection";
        if (this._UQueryCount > 1) {
            unionQuery.setLabel("UnionQuery");
            unionQuery.setQueryProperty(BusinessQueryProperty.INLINE_SETOPERATIONDATASELECTION, true);
            unionQuery.setSetOperation(SetOperationType.UNION_ALL);
            unionQuery.setDataSelections(unionSelections);
            outerQuerySelection = unionQuery;
        } else {
            outerQuerySelection = (DataSelection)unionSelections.get(0);
        }
        DataSourceRelationalQuery dsrq = outerQuery.newDataSourceRelationalQuery(outerQuerySelection);
        this.buildOuterQuery(outerQuery, selectedItems, originalSelectedItems, dsrq, tempDataItemsToRemoveFromOuterQuery, tempColumnCalcMeasuresToAddToOuterQuery, tempCalcMeasuresToAddToOuterQuery, havingMap);
    }

    private void processCalculatedMeasuresBasedOnColumns(List<SelectedItem> selectedItems, ArrayList<DataItem> tempDataItemsToRemoveFromOuterQuery, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempColumnCalcMeasuresToAddToOuterQuery) throws MetadataException {
        ArrayList<SelectedItem> calcMeasureRemoveList = new ArrayList<SelectedItem>();
        ArrayList<QualifiedColumn> createDIFromQualifiedColumn = new ArrayList<QualifiedColumn>();
        ArrayList calcMeasureMap = new ArrayList();
        DataItem tempDataItem = null;
        for (SelectedItem originalItem : selectedItems) {
            DataItem originalMeasureDataItem;
            if (originalItem.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE || !(originalMeasureDataItem = originalItem.getItem()).isCalculatedItem()) continue;
            List<QualifiedColumn> measureColumnList = this.findQualifiedColumnsInCalculatedMeasure(originalMeasureDataItem.getExpression());
            LinkedHashMap<DataItem, String> measureColumnDIList = new LinkedHashMap<DataItem, String>();
            if (!measureColumnList.isEmpty()) {
                tempColumnCalcMeasuresToAddToOuterQuery.put(originalItem, measureColumnDIList);
                calcMeasureRemoveList.add(originalItem);
            }
            for (QualifiedColumn measureColumn : measureColumnList) {
                boolean found = false;
                block4: for (SelectedItem selectedItem : selectedItems) {
                    DataItem selectedDataItem = selectedItem.getItem();
                    if (selectedDataItem.isCalculatedItem() || selectedDataItem.getUsage() == DataItemActionType.USAGE_CATEGORY) continue;
                    List<QualifiedColumn> DIColumnList = selectedDataItem.getResources(QualifiedColumn.class, 2);
                    for (QualifiedColumn DIColumn : DIColumnList) {
                        try {
                            if (!measureColumn.getSasName().equals(DIColumn.getSasName())) continue;
                            measureColumnDIList.put(selectedDataItem, selectedDataItem.getResultSetID());
                            found = true;
                            continue block4;
                        }
                        catch (MetadataException e) {
                            _logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (found) continue;
                createDIFromQualifiedColumn.add(measureColumn);
                calcMeasureMap.add(measureColumnDIList);
            }
        }
        for (SelectedItem selectedCalcItemToRemove : calcMeasureRemoveList) {
            selectedItems.remove(selectedCalcItemToRemove);
        }
        int j = 0;
        for (QualifiedColumn measureColumn : createDIFromQualifiedColumn) {
            tempDataItem = this.generateNewDataItem(measureColumn, this._businessQuery, selectedItems);
            ((Map)calcMeasureMap.get(++j - 1)).put(tempDataItem, tempDataItem.getResultSetID());
            tempDataItemsToRemoveFromOuterQuery.add(tempDataItem);
        }
    }

    private List<QualifiedColumn> findQualifiedColumnsInCalculatedMeasure(ExpressionInterface calcMeasureExpr) {
        List<QualifiedColumn> resources = calcMeasureExpr.getResources(QualifiedColumn.class, 0);
        ArrayList<QualifiedColumn> columnList = new ArrayList<QualifiedColumn>();
        for (QualifiedColumn embeddedItem : resources) {
            columnList.add(embeddedItem);
        }
        return columnList;
    }

    private void processCalculatedMeasuresBasedOnAggregates(List<SelectedItem> selectedItems, ArrayList<DataItem> tempDataItemsToRemoveFromOuterQuery, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws GenerationException {
        ArrayList<SelectedItem> calcMeasureRemoveList = new ArrayList<SelectedItem>(0);
        DataItem tempDataItem = null;
        ArrayList<SelectedItem> newSelectedItems = new ArrayList<SelectedItem>(0);
        for (SelectedItem originalItem : selectedItems) {
            DataItem originalMeasureDataItem;
            if (originalItem.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE || !(originalMeasureDataItem = originalItem.getItem()).isCalculatedItem()) continue;
            Map<DataItem, String> calcMeasureComponentList = this.findDataItemsInCalculatedMeasure(originalMeasureDataItem.getExpression());
            if (!calcMeasureComponentList.isEmpty()) {
                tempCalcMeasuresToAddToOuterQuery.put(originalItem, calcMeasureComponentList);
                calcMeasureRemoveList.add(originalItem);
            }
            for (DataItem componentDataItem : calcMeasureComponentList.keySet()) {
                if (componentDataItem.isCalculatedItem()) {
                    this.throwExceptionWithReason(3, Collections.singletonList(originalMeasureDataItem));
                }
                boolean found = false;
                for (SelectedItem c2SelectedItem : selectedItems) {
                    DataItem selectedDataItem = c2SelectedItem.getItem();
                    DataItem sItem = null;
                    sItem = selectedDataItem instanceof DataItemReference ? ((DataItemReference)selectedDataItem).getBaseDataItem() : selectedDataItem;
                    if (componentDataItem != sItem) continue;
                    calcMeasureComponentList.put(componentDataItem, selectedDataItem.getResultSetID());
                    found = true;
                    break;
                }
                if (found) continue;
                tempDataItem = this.generateNewDataItem(componentDataItem, this._businessQuery, newSelectedItems);
                calcMeasureComponentList.put(componentDataItem, tempDataItem.getResultSetID());
                tempDataItemsToRemoveFromOuterQuery.add(tempDataItem);
            }
        }
        selectedItems.addAll(newSelectedItems);
        selectedItems.removeAll(calcMeasureRemoveList);
    }

    private Map<DataItem, String> findDataItemsInCalculatedMeasure(ExpressionInterface calcMeasureExpr) {
        List<DataItem> resources = calcMeasureExpr.getResources(DataItem.class, 0);
        LinkedHashMap<DataItem, String> calcMeasureComponentList = new LinkedHashMap<DataItem, String>();
        for (DataItem embeddedItem : resources) {
            calcMeasureComponentList.put(embeddedItem, null);
        }
        return calcMeasureComponentList;
    }

    DataSourceTable findDataSourceTable(DataItem dataItem) throws MetadataException {
        List<QualifiedColumn> qcs;
        ExpressionInterface expr = dataItem.getExpression();
        DataSourceTable dataSourceTable = null;
        if (expr instanceof QualifiedColumn) {
            QualifiedColumn qc = (QualifiedColumn)expr;
            dataSourceTable = qc.getDataSource();
        } else if (expr != null && (qcs = expr.getResources(QualifiedColumn.class, 2)) != null && qcs.size() > 0) {
            dataSourceTable = qcs.get(0).getDataSource();
        }
        if (dataSourceTable == null) {
            _logger.debug("Table not found for data item " + dataItem.getLabel());
        }
        return dataSourceTable;
    }

    private ArrayList<DataSelection> buildUQueryModel(DataSelection outerQuery, ArrayList<SelectedItem> selectedItems, ArrayList<UQuery> UQueries, List<Join> effectiveJoins, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempColumnCalcMeasuresToAddToOuterQuery) throws MetadataException, GenerationException {
        ArrayList<List<SelectedItem>> measureListArray = new ArrayList<List<SelectedItem>>();
        ArrayList<SelectedItem> remainingSingleMeasureSelectedItems = new ArrayList<SelectedItem>();
        remainingSingleMeasureSelectedItems.addAll(selectedItems);
        this.consolidateCalcMeasuresBasedOnColumns(remainingSingleMeasureSelectedItems, selectedItems, measureListArray, tempColumnCalcMeasuresToAddToOuterQuery);
        this.consolidateMeasures(remainingSingleMeasureSelectedItems, measureListArray);
        return this.buildUQueries(measureListArray, UQueries, selectedItems, outerQuery, effectiveJoins);
    }

    private void consolidateCalcMeasuresBasedOnColumns(List<SelectedItem> remainingSingleMeasureSelectedItems, List<SelectedItem> selectedItems, List<List<SelectedItem>> measureListArray, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempColumnCalcMeasuresToAddToOuterQuery) throws MetadataException {
        ArrayList<SelectedItem> measureList = null;
        for (SelectedItem originalCalcMeasureItem : tempColumnCalcMeasuresToAddToOuterQuery.keySet()) {
            DataSourceTable previousDataSourceTable = null;
            DataSourceTable dataSourceTable = null;
            Map<DataItem, String> mapping = tempColumnCalcMeasuresToAddToOuterQuery.get(originalCalcMeasureItem);
            if (mapping == null) continue;
            for (DataItem dataItem : mapping.keySet()) {
                SelectedItem[] items;
                dataSourceTable = this.findDataSourceTable(dataItem);
                if (previousDataSourceTable == null || !dataSourceTable.equals(previousDataSourceTable)) {
                    measureList = new ArrayList<SelectedItem>();
                    measureListArray.add(measureList);
                }
                for (SelectedItem selectedItem : selectedItems) {
                    if (selectedItem.getItem() != dataItem) continue;
                    measureList.add(selectedItem);
                    remainingSingleMeasureSelectedItems.remove(selectedItem);
                    break;
                }
                for (SelectedItem selectedItem : items = remainingSingleMeasureSelectedItems.toArray(new SelectedItem[remainingSingleMeasureSelectedItems.size()])) {
                    DataSourceTable origItemDataSourceTable;
                    if (selectedItem.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE || !(origItemDataSourceTable = this.findDataSourceTable(selectedItem.getItem())).equals(dataSourceTable)) continue;
                    measureList.add(selectedItem);
                    remainingSingleMeasureSelectedItems.remove(selectedItem);
                }
                previousDataSourceTable = dataSourceTable;
            }
        }
    }

    private void consolidateMeasures(List<SelectedItem> remainingSingleMeasureSelectedItems, List<List<SelectedItem>> measureListArray) throws MetadataException {
        ArrayList<SelectedItem> dontSearchList = new ArrayList<SelectedItem>();
        for (SelectedItem remainingItem : remainingSingleMeasureSelectedItems) {
            if (remainingItem.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE || dontSearchList.contains(remainingItem)) continue;
            DataSourceTable dataSourceTable1 = this.findDataSourceTable(remainingItem.getItem());
            ArrayList<SelectedItem> measureList = new ArrayList<SelectedItem>();
            measureList.add(remainingItem);
            for (SelectedItem copyOfRemainingItem : remainingSingleMeasureSelectedItems) {
                DataSourceTable dataSourceTable2;
                if (copyOfRemainingItem.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE || copyOfRemainingItem == remainingItem || dontSearchList.contains(copyOfRemainingItem) || dataSourceTable1 != (dataSourceTable2 = this.findDataSourceTable(copyOfRemainingItem.getItem()))) continue;
                measureList.add(copyOfRemainingItem);
                dontSearchList.add(copyOfRemainingItem);
            }
            measureListArray.add(measureList);
        }
    }

    private ArrayList<DataSelection> buildUQueries(List<List<SelectedItem>> measureListArray, List<UQuery> UQueries, ArrayList<SelectedItem> selectedItems, DataSelection outerQuery, List<Join> effectiveJoins) throws MetadataException, GenerationException {
        int uqueryCount = 0;
        ArrayList<DataSourceTable> dataSourceTables = new ArrayList<DataSourceTable>();
        ArrayList<DataSelection> unionSelections = new ArrayList<DataSelection>();
        AssociationMatrix matrix = null;
        List<AssociationMatrix> returnList = this._businessQuery.getEffectiveRules(AssociationMatrix.class);
        if (!returnList.isEmpty()) {
            matrix = returnList.get(0);
        }
        for (List<SelectedItem> measureList : measureListArray) {
            DataSourceTable lastDataSourceTable = null;
            dataSourceTables.clear();
            for (SelectedItem si : measureList) {
                DataItem measure = si.getItem();
                DataSourceTable dataSourceTable = this.findDataSourceTable(measure);
                if (lastDataSourceTable != null && dataSourceTable == lastDataSourceTable) continue;
                dataSourceTables.add(dataSourceTable);
                lastDataSourceTable = dataSourceTable;
            }
            this._UQueryCount = ++uqueryCount;
            UQuery uQuery = new UQuery(measureList, dataSourceTables, uqueryCount, this);
            DataSelection uQueryDS = uQuery.buildDataModel(selectedItems, outerQuery, effectiveJoins, matrix);
            unionSelections.add(uQueryDS);
            UQueries.add(uQuery);
        }
        return unionSelections;
    }

    private void buildOuterQuery(DataSelection outerQuery, List<SelectedItem> selectedItems, List<SelectedItem> originalSelectedItems, DataSourceRelationalQuery dsrq, ArrayList<DataItem> tempDataItemsToRemoveFromOuterQuery, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempColumnCalcMeasuresToAddToOuterQuery, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery, LinkedHashMap<DataItem, Integer> havingMap) throws MetadataException {
        dsrq.setLabel("DSRQ_UnionQuery");
        outerQuery.setLabel("OuterQuery");
        outerQuery.setQueryProperty(BusinessQueryProperty.EFFECTIVE_RESULT_ITEMS_IGNORE_PARENT_ITEMS, true);
        outerQuery.addDataSource(dsrq);
        List<Column> dsrqColumns = dsrq.getColumns();
        DataItemReference outDir = null;
        int i = 0;
        for (Column column : dsrqColumns) {
            DataItem dataItem = selectedItems.get(++i - 1).getItem();
            DataItem outItemColumn = this.newOuterItem(outerQuery, dataItem, column);
            outDir = outerQuery.newDataItemReference(outItemColumn);
            outDir.setResultSetID(dataItem.getResultSetID());
            outerQuery.addBusinessItem(outDir);
            outerQuery.addResultItem(outDir, Role.COLUMN);
        }
        this.addTempCalcMeasuresToOuterQuery(outerQuery, selectedItems, dsrq, tempColumnCalcMeasuresToAddToOuterQuery, tempCalcMeasuresToAddToOuterQuery);
        this.generatePostAggFilters(outerQuery, havingMap);
        this.removeTempDataItemsFromOuterQuery(outerQuery, selectedItems, tempDataItemsToRemoveFromOuterQuery);
        this.restoreOriginalDataSelectionOrder(outerQuery, originalSelectedItems);
    }

    private void addTempCalcMeasuresToOuterQuery(DataSelection outerQuery, List<SelectedItem> selectedItems, DataSourceTable dsTable, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempColumnCalcMeasuresToAddToOuterQuery, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws MetadataException {
        for (SelectedItem calcMeasureSelectedItem : tempCalcMeasuresToAddToOuterQuery.keySet()) {
            selectedItems.add(calcMeasureSelectedItem);
            this._businessQuery.setSelectedItems(selectedItems);
            this.generateNewDataItemForOuterQuery(outerQuery, calcMeasureSelectedItem.getItem(), dsTable, tempCalcMeasuresToAddToOuterQuery);
        }
        for (SelectedItem columnCalcMeasureSelectedItem : tempColumnCalcMeasuresToAddToOuterQuery.keySet()) {
            selectedItems.add(columnCalcMeasureSelectedItem);
            this._businessQuery.setSelectedItems(selectedItems);
            DataItem thisDataItem = columnCalcMeasureSelectedItem.getItem();
            List<QualifiedColumn> columnList = thisDataItem.getResources(QualifiedColumn.class, 2);
            Map<DataItem, String> mapping = tempColumnCalcMeasuresToAddToOuterQuery.get(columnCalcMeasureSelectedItem);
            ResourceAwareStringExpression newRASE = null;
            try {
                newRASE = (ResourceAwareStringExpression)thisDataItem.getExpression().clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
            }
            int i = 0;
            block4: for (DataItem DIFromQC : mapping.keySet()) {
                String matchU1SasName = this.getUqueryResultSetId(DIFromQC, 1);
                ++i;
                for (QualifiedColumn dsrqColumn : dsTable.getQualifiedColumns()) {
                    if (!matchU1SasName.equals(dsrqColumn.getSasName())) continue;
                    newRASE.replaceResource(columnList.get(i - 1), dsrqColumn, outerQuery.getBusinessModel(), false);
                    continue block4;
                }
            }
            DataItem newDataItem = this.newOuterItem(outerQuery, thisDataItem, newRASE);
            DataItemReference outDir = null;
            outerQuery.addBusinessItem(newDataItem);
            outDir = outerQuery.newDataItemReference(newDataItem);
            outDir.setResultSetID(thisDataItem.getResultSetID());
            outerQuery.addBusinessItem(outDir);
            outerQuery.addResultItem(outDir, Role.COLUMN);
        }
    }

    private void generateNewDataItemForOuterQuery(DataSelection outerQuery, DataItem item, DataSourceTable dsTable, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws MetadataException {
        DataItemReference outDir = null;
        DataItem outItemColumn = this.getEquivDataItem(outerQuery, item, tempCalcMeasuresToAddToOuterQuery);
        outerQuery.addBusinessItem(outItemColumn);
        outDir = outerQuery.newDataItemReference(outItemColumn);
        outDir.setResultSetID(item.getResultSetID());
        outerQuery.addBusinessItem(outDir);
        outerQuery.addResultItem(outDir, Role.COLUMN);
    }

    private DataItem getEquivDataItem(DataSelection outerQuery, DataItem item, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws MetadataException {
        DataItem newItem = this.getEquivalentResultItem(outerQuery, item, tempCalcMeasuresToAddToOuterQuery);
        if (newItem == null) {
            ExpressionInterface oldExpression = item.getExpression();
            ExpressionInterface newExpression = this.getEquivalentExpression(outerQuery, oldExpression, tempCalcMeasuresToAddToOuterQuery);
            newItem = this.newOuterItem(outerQuery, item, newExpression);
        }
        return newItem;
    }

    private DataItem newOuterItem(DataSelection outerQuery, DataItem item, ExpressionInterface newExpression) throws MetadataException {
        RootDataItem newItem = outerQuery.newDataItem();
        outerQuery.addBusinessItem(newItem);
        newItem.setExpression(newExpression);
        newItem.setLabel(item.getLabel());
        if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
            newItem.setAggregationType(item.getAggregationType());
        }
        newItem.setUsage(item.getUsage());
        newItem.setFormat(item.getFormat());
        newItem.setResultSetID(newItem.getResultSetID() + "_" + item.getResultSetID());
        return newItem;
    }

    private DataItem getEquivalentResultItem(DataSelection outerQuery, DataItem item, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws MetadataException {
        ModelItemWithIdentity returnDataItem = null;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Match item=" + item.getIdentityString());
        }
        String resultSetID = null;
        Iterator<SelectedItem> iterator = tempCalcMeasuresToAddToOuterQuery.keySet().iterator();
        while (resultSetID == null && iterator.hasNext()) {
            SelectedItem selectedItem = iterator.next();
            Map<DataItem, String> mapping = tempCalcMeasuresToAddToOuterQuery.get(selectedItem);
            if (mapping == null || !mapping.containsKey(item) || (resultSetID = mapping.get(item)) != null || !_logger.isDebugEnabled()) continue;
            _logger.debug("    *** item's child in U queries has not yet been created ***");
        }
        if (resultSetID != null) {
            String matchU1SasName = "U1" + resultSetID;
            if (_logger.isDebugEnabled()) {
                _logger.debug("    matchU1SasName=[" + matchU1SasName + "]");
            }
            List<DataSourceRelationalQuery> tables = outerQuery.getObjects(true, DataSourceRelationalQuery.class);
            Iterator<DataSourceRelationalQuery> tableIt = tables.iterator();
            while (tableIt.hasNext() && returnDataItem == null) {
                DataSourceRelationalQuery dsrq = tableIt.next();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("TABLE=" + dsrq.getIdentityString());
                }
                List<QualifiedColumn> columns = dsrq.getQualifiedColumns();
                Iterator<QualifiedColumn> iterator2 = columns.iterator();
                while (returnDataItem == null && iterator2.hasNext()) {
                    QualifiedColumn qualifiedColumn = iterator2.next();
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("  COLUMN=" + qualifiedColumn.getIdentityString());
                        _logger.debug("    getSasName=[" + qualifiedColumn.getSasName() + "]");
                        _logger.debug("    getDbmsName=[" + qualifiedColumn.getDbmsName() + "]");
                    }
                    if (!qualifiedColumn.getSasName().equals(matchU1SasName)) continue;
                    returnDataItem = this.newOuterItem(outerQuery, item, qualifiedColumn);
                }
            }
        }
        if (returnDataItem != null && _logger.isDebugEnabled()) {
            _logger.debug("*** FOUND: " + returnDataItem.getIdentityString() + ", rsid=" + returnDataItem.getResultSetID() + " ***");
        }
        return returnDataItem;
    }

    private ExpressionInterface getEquivalentExpression(DataSelection selection, ExpressionInterface oldExpression, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws MetadataException, InvalidIDException {
        ExpressionInterface newExpression = null;
        if (oldExpression instanceof DataItem) {
            newExpression = this.getEquivDataItem(selection, (DataItem)oldExpression, tempCalcMeasuresToAddToOuterQuery);
            return newExpression;
        }
        if (oldExpression instanceof ConstantExpression) {
            newExpression = oldExpression;
            return newExpression;
        }
        if (oldExpression instanceof FunctionCall) {
            FunctionCall func = (FunctionCall)oldExpression;
            FunctionCall newFunc = null;
            try {
                newFunc = (FunctionCall)func.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
            }
            newExpression = newFunc;
            return newExpression;
        }
        if (!(oldExpression instanceof QualifiedColumn)) {
            if (oldExpression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)oldExpression;
                List<QualifiedColumn> resources = rase.getResources(QualifiedColumn.class, 65535);
                if (resources == null || resources.isEmpty()) {
                    newExpression = oldExpression;
                    return newExpression;
                }
                newExpression = this.createRASEExpression(selection, (ResourceAwareStringExpression)oldExpression, tempCalcMeasuresToAddToOuterQuery);
                return newExpression;
            }
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataSelectionUtilitiesSortSimpleExpression.fmt.txt", oldExpression.getClass().getName(), oldExpression));
        }
        BusinessModel businessModel = selection.getBusinessModel();
        List<DataSourceTable> tables = businessModel.getObjects(true, DataSourceTable.class);
        List<Join> joins = businessModel.getObjects(true, Join.class);
        ArrayList<DataSourceTable> joinSources = new ArrayList<DataSourceTable>();
        for (Join join : joins) {
            DataSourceTable leftTable = join.getLeftDataSource();
            DataSourceTable rightTable = join.getRightDataSource();
            joinSources.add(leftTable);
            joinSources.add(rightTable);
        }
        AssociationStrategy.addButNoDuplicates(tables, joinSources);
        QualifiedColumn qualifiedColumnFromItem = (QualifiedColumn)oldExpression;
        Iterator<DataSourceTable> tableIt = tables.iterator();
        while (tableIt.hasNext() && newExpression == null) {
            DataSourceTable table = tableIt.next();
            if (!table.getID().equals(qualifiedColumnFromItem.getDataSource().getID())) continue;
            QualifiedColumn newExpression1 = null;
            List<QualifiedColumn> columns = table.getQualifiedColumns();
            for (QualifiedColumn qualifiedColumnFromSelection : columns) {
                QualifiedColumn found = AssociationStrategy.getInnerQueryColumn(qualifiedColumnFromItem, qualifiedColumnFromSelection);
                if (found == null) continue;
                newExpression1 = found;
                break;
            }
            newExpression = newExpression1;
        }
        if (newExpression == null) {
            Object[] msgArgs = new Object[]{oldExpression.toString()};
            MessageFormatter msg = IQMetadataResourceBundle.getMessageFormatter("DataSelectionUtilitiesCantFindExpression.fmt.txt", msgArgs);
            throw new MetadataException(msg);
        }
        return newExpression;
    }

    private static QualifiedColumn getInnerQueryColumn(QualifiedColumn outerItemQualifiedColumn, QualifiedColumn dsrqQualfiedColumn) throws MetadataException {
        String qcFromItemName;
        QualifiedColumn found = null;
        String qcFromSelectionName = dsrqQualfiedColumn.getSasName();
        boolean match = qcFromSelectionName.equals(qcFromItemName = outerItemQualifiedColumn.getSasName());
        if (match) {
            found = dsrqQualfiedColumn;
        }
        return found;
    }

    protected static void addButNoDuplicates(List<DataSourceTable> targetList, List<DataSourceTable> sourceList) {
        if (targetList != null && sourceList != null) {
            for (DataSourceTable obj : sourceList) {
                if (targetList.contains(obj)) continue;
                targetList.add(obj);
            }
        }
    }

    private ResourceAwareStringExpression createRASEExpression(DataSelection selection, ResourceAwareStringExpression oldExpression, LinkedHashMap<SelectedItem, Map<DataItem, String>> tempCalcMeasuresToAddToOuterQuery) throws MetadataException {
        List<DataItem> oldDataItems = oldExpression.getResources(DataItem.class, 0);
        ResourceAwareStringExpression newRASE = null;
        try {
            newRASE = (ResourceAwareStringExpression)oldExpression.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new MetadataException(IQMetadataResourceBundle.getMessageFormatter("DataSelectionUtilitiesUnableToCloneExpression.txt", new Object[0]), (Throwable)e);
        }
        BusinessModel model = selection.getBusinessModel();
        for (DataItem oldDataItem : oldDataItems) {
            DataItem newDataItem = (DataItem)this.getEquivalentExpression(selection, oldDataItem, tempCalcMeasuresToAddToOuterQuery);
            newRASE.replaceResource(oldDataItem, newDataItem, model, false);
        }
        return newRASE;
    }

    private void removeTempDataItemsFromOuterQuery(DataSelection outerQuery, List<SelectedItem> selectedItems, ArrayList<DataItem> tempDataItemsToRemoveFromOuterQuery) throws MetadataException {
        List<SelectedItem> outerQuerySelectedItems = outerQuery.getSelectedItems();
        ArrayList<SelectedItem> outerQueryRemoveList = new ArrayList<SelectedItem>();
        ArrayList<SelectedItem> originalQueryRemoveList = new ArrayList<SelectedItem>();
        block0: for (DataItem tempDataItem : tempDataItemsToRemoveFromOuterQuery) {
            int i = 0;
            for (SelectedItem selectedItem : selectedItems) {
                ++i;
                if (selectedItem.getItem() != tempDataItem) continue;
                outerQueryRemoveList.add(outerQuerySelectedItems.get(i - 1));
                originalQueryRemoveList.add(selectedItem);
                continue block0;
            }
        }
        for (SelectedItem selectedItemToRemove : outerQueryRemoveList) {
            outerQuerySelectedItems.remove(selectedItemToRemove);
            this._businessQuery.setSelectedItems(outerQuerySelectedItems);
        }
        for (SelectedItem selectedItemToRemove : originalQueryRemoveList) {
            selectedItems.remove(selectedItemToRemove);
            this._businessQuery.setSelectedItems(selectedItems);
        }
    }

    private void generatePostAggFilters(DataSelection outerQuery, LinkedHashMap<DataItem, Integer> havingMap) throws MetadataException {
        ArrayList<FilterItem> filterItems = new ArrayList<FilterItem>();
        DataItem newDataItem = null;
        Integer i = 0;
        for (FilterItem originalFilterItem : this._havingFilters) {
            FilterItem newFI = outerQuery.newFilterItem();
            ExpressionInterface newExpression = null;
            try {
                newExpression = (ExpressionInterface)originalFilterItem.getExpression().clone();
            }
            catch (CloneNotSupportedException e1) {
                e1.printStackTrace();
            }
            List<DataItem> dataItemsForThisFilter = originalFilterItem.getDataItems(0);
            for (DataItem filterDataItem : dataItemsForThisFilter) {
                if (havingMap.containsKey(filterDataItem)) {
                    i = havingMap.get(filterDataItem);
                    newDataItem = outerQuery.getSelectedItems().get(i - 1).getItem();
                }
                newExpression.replaceResource(filterDataItem, newDataItem, outerQuery.getBusinessModel(), true);
            }
            newFI.setExpression(newExpression);
            outerQuery.addBusinessItem(newFI);
            filterItems.add(newFI);
        }
        outerQuery.setFilters(filterItems);
    }

    private DataItem generateNewDataItem(DataItem originalDataItem, DataSelection dataSelection, List<SelectedItem> selectedItems) {
        DataItemReference dir = null;
        try {
            dir = dataSelection.newDataItemReference(originalDataItem);
            dir.setLabel(originalDataItem.getLabel());
            String UQueryResultSetID = this.newNonUqueryResultSetID(originalDataItem);
            dir.setResultSetID(UQueryResultSetID);
            if (originalDataItem.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                dir.setUsage(DataItemActionType.USAGE_AGGREGATE);
            } else if (originalDataItem.getUsage() == DataItemActionType.USAGE_CATEGORY) {
                dir.setUsage(DataItemActionType.USAGE_CATEGORY);
            }
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
            SelectedItem selectedItem = new SelectedItem(dir, Role.COLUMN);
            selectedItems.add(selectedItem);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        return dir;
    }

    private DataItem generateNewDataItem(QualifiedColumn qualifiedColumn, DataSelection dataSelection, List<SelectedItem> selectedItems) {
        DataItemReference dir = null;
        try {
            RootDataItem item = dataSelection.newDataItem();
            item.setExpression(qualifiedColumn);
            item.setLabel(qualifiedColumn.getSasName());
            item.setUsage(DataItemActionType.USAGE_AGGREGATE);
            dataSelection.addBusinessItem(item);
            dir = dataSelection.newDataItemReference(item);
            dir.setResultSetID(qualifiedColumn.getSasName());
            dataSelection.addBusinessItem(dir);
            dataSelection.addResultItem(dir, Role.COLUMN);
            SelectedItem selectedItem = new SelectedItem(dir, Role.COLUMN);
            selectedItems.add(selectedItem);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        return dir;
    }

    private void restoreOriginalDataSelectionOrder(DataSelection outerQuery, List<SelectedItem> originalSelectedItems) throws MetadataException {
        List<SelectedItem> outerQuerySelectedItems = outerQuery.getSelectedItems();
        ArrayList<SelectedItem> tempSelectedItems = new ArrayList<SelectedItem>();
        block0: for (SelectedItem originalItem : originalSelectedItems) {
            for (SelectedItem outerQueryItem : outerQuerySelectedItems) {
                if (!originalItem.getItem().getResultSetID().equals(outerQueryItem.getItem().getResultSetID())) continue;
                tempSelectedItems.add(outerQueryItem);
                continue block0;
            }
        }
        outerQuery.setSelectedItems(tempSelectedItems);
    }

    private ArrayList<SelectedItem> reorderOriginalDataSelection(List<SelectedItem> originalSelectedItems) {
        ArrayList<SelectedItem> reorderedSelectionList = new ArrayList<SelectedItem>();
        for (SelectedItem originalItem : originalSelectedItems) {
            if (originalItem.getItem().getUsage() != DataItemActionType.USAGE_CATEGORY) continue;
            reorderedSelectionList.add(originalItem);
        }
        for (SelectedItem originalItem : originalSelectedItems) {
            if (originalItem.getItem().getUsage() != DataItemActionType.USAGE_AGGREGATE) continue;
            reorderedSelectionList.add(originalItem);
        }
        return reorderedSelectionList;
    }

    @Override
    public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
        return "Tabular";
    }

    private String newNonUqueryResultSetID(DataItem originalDataItem) {
        return "U" + originalDataItem.getResultSetID();
    }

    public String getUqueryResultSetId(DataItem originalDataItem, int listNum) {
        return "U" + listNum + originalDataItem.getResultSetID();
    }

    public List<FilterItem> getWhereFilters() {
        return this._whereFilters;
    }
}

