/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import java.util.Locale;

public class TimeNPeriodsFilter {
    public static String getMDXExpression(DataItemTimeNPeriodsFilter step, DataSelection dataSelection) throws GenerationException {
        return TimeNPeriodsFilter.getExpression(step.getMember(), step.getPeriods(), dataSelection, step.getSearchDirection(), step.getMemberLocale());
    }

    public static String getMDXExpression(TimeFilterNPeriodsExpression expression, DataSelection dataSelection) throws GenerationException {
        return TimeNPeriodsFilter.getExpression(expression.getDate(), expression.getPeriods(), dataSelection, expression.getSearchDirection(), expression.getMemberLocale());
    }

    private static String getExpression(ExpressionInterface dateI, ExpressionInterface periodsI, DataSelection dataSelection, String searchDirection, Locale locale) throws GenerationException {
        StringBuilder MDXExpression = new StringBuilder();
        String dateMember = MDXGenerationUtil.getExpressionValue(dateI, dataSelection, locale);
        String periodString = "0";
        if (periodsI != null) {
            periodString = MDXGenerationUtil.getExpressionValue(periodsI, dataSelection, locale);
        }
        int nPeriods = Integer.parseInt(periodString);
        MDXExpression.append("LASTPERIODS(");
        if (searchDirection.equalsIgnoreCase("FORWARD") && nPeriods > 0) {
            MDXExpression.append("-");
        }
        MDXExpression.append(nPeriods).append(", ").append(dateMember).append(")");
        return MDXExpression.toString();
    }
}

