/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import java.util.Locale;

public class TimeNParallelPeriodsFilter {
    private static String PARALLEL = "PARALLELPERIOD(";

    public static String getMDXExpression(DataItemTimeNParallelPeriodsFilter step, DataSelection dataSelection) throws GenerationException {
        return TimeNParallelPeriodsFilter.getExpression(step.getMember(), step.getLevel(), step.getPeriods(), step.getSearchDirection(), dataSelection, step.getMemberLocale());
    }

    public static String getMDXExpression(TimeFilterNParallelPeriodsExpression expression, DataSelection dataSelection) throws GenerationException {
        return TimeNParallelPeriodsFilter.getExpression(expression.getDate(), expression.getLevel(), expression.getPeriods(), expression.getSearchDirection(), dataSelection, expression.getMemberLocale());
    }

    private static String getExpression(ExpressionInterface dateI, ExpressionInterface levelI, ExpressionInterface nPeriodsI, String searchDirection, DataSelection dataSelection, Locale locale) throws GenerationException {
        StringBuilder MDXExpression = new StringBuilder();
        String levelName = MDXGenerationUtil.getExpressionValue(levelI, dataSelection, locale);
        String dateMember = MDXGenerationUtil.getExpressionValue(dateI, dataSelection, locale);
        String periodString = "0";
        if (nPeriodsI != null) {
            periodString = MDXGenerationUtil.getExpressionValue(nPeriodsI, dataSelection, locale);
        }
        int nPeriods = Integer.parseInt(periodString);
        MDXExpression.append("{");
        if (searchDirection.equalsIgnoreCase("FORWARD")) {
            int pctr = 1;
            MDXExpression.append(dateMember);
            if (nPeriods != 0) {
                MDXExpression.append(", ");
            }
            while (pctr <= Math.abs(nPeriods)) {
                if (pctr > 1) {
                    MDXExpression.append(", ");
                }
                MDXExpression.append(PARALLEL).append(levelName).append(", ");
                if (nPeriods > 0) {
                    MDXExpression.append("-");
                }
                MDXExpression.append(pctr).append(", ").append(dateMember).append(")");
                ++pctr;
            }
        } else if (searchDirection == "BACKWARD") {
            for (int pctr = nPeriods; pctr > 0; --pctr) {
                MDXExpression.append(PARALLEL).append(levelName).append(", ").append(MDXGenerationUtil.NEWLINE).append(pctr).append(", ").append(MDXGenerationUtil.NEWLINE).append(dateMember).append("), ");
            }
            MDXExpression.append(dateMember);
        }
        MDXExpression.append("}");
        return MDXExpression.toString();
    }
}

