/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RankFilter {
    private static final Logger _logger = LogManager.getLogger(RankFilter.class);

    public static String getMDXExpression(String currentExpression, DataItemRankFilter step, OLAPValues olapValues) throws GenerationException {
        if (step.isIncludeTies() && step.getRankType() != 0) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("RankFilterIncludeTiesError.txt"));
            }
            return currentExpression;
        }
        StringBuilder MDXExpression = new StringBuilder();
        block0 : switch (step.getRankOrder()) {
            case 0: {
                MDXExpression.append("Top");
                switch (step.getRankType()) {
                    case 0: {
                        MDXExpression.append("Count(");
                        break block0;
                    }
                    case 1: {
                        MDXExpression.append("Percent(");
                        break block0;
                    }
                    case 2: {
                        MDXExpression.append("Sum(");
                        break block0;
                    }
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("RankFilterRankTypeError.txt"));
                }
                return currentExpression;
            }
            case 1: {
                MDXExpression.append("Bottom");
                switch (step.getRankType()) {
                    case 0: {
                        MDXExpression.append("Count(");
                        break block0;
                    }
                    case 1: {
                        MDXExpression.append("Percent(");
                        break block0;
                    }
                    case 2: {
                        MDXExpression.append("Sum(");
                        break block0;
                    }
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("RankFilterRankTypeError.txt"));
                }
                return currentExpression;
            }
            default: {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("RankFilterRankOrderError.txt"));
                }
                return currentExpression;
            }
        }
        MDXExpression.append("{").append(currentExpression).append("}").append(", ");
        String[] byRankNames = null;
        ArrayList<String> byNames = null;
        byRankNames = step.getbyRankNames();
        if (byRankNames == null) {
            List<ExpressionInterface> byRankQualifier = step.getRankQualifiers();
            if (byRankQualifier != null && byRankQualifier.size() > 0) {
                byNames = new ArrayList();
                for (int i = 0; i < byRankQualifier.size(); ++i) {
                    ExpressionInterface object = byRankQualifier.get(i);
                    String core = MDXGenerationUtil.buildCoreExpression(object, olapValues);
                    if (core == null) continue;
                    byNames.add(core);
                }
            }
        } else {
            byNames = new ArrayList<String>();
            for (int i = 0; i < byRankNames.length; ++i) {
                String rankName = byRankNames[i];
                byNames.add(rankName);
            }
        }
        MDXExpression.append(step.getValue());
        if (byNames == null) {
            MDXExpression.append(",[Measures].CURRENTMEMBER");
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        if (byNames.size() == 0) {
            MDXExpression.append(",[Measures].CURRENTMEMBER");
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        MDXExpression.append(", ");
        if (byNames.size() == 1) {
            MDXExpression.append(byNames.get(0));
        } else {
            StringBuilder RankNameBuf = new StringBuilder();
            int numOfRankNames = 0;
            for (int i = 0; i < byNames.size(); ++i) {
                String rankName = (String)byNames.get(i);
                if (rankName == null) {
                    i = byNames.size();
                    continue;
                }
                if (i > 0) {
                    RankNameBuf.append(", ");
                }
                RankNameBuf.append((String)byNames.get(i));
                ++numOfRankNames;
            }
            if (numOfRankNames > 1) {
                MDXExpression.append("(");
            }
            MDXExpression.append(RankNameBuf.toString());
            if (numOfRankNames > 1) {
                MDXExpression.append(")");
            }
        }
        if (step.isIncludeTies()) {
            MDXExpression.append(", TRUE");
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }
}

