/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryTupleFilter;
import com.sas.iquery.metadata.business.step.olap.TupleFilterMemberQualifier;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusinessQueryFilterTuple {
    private static final Logger _logger = LogManager.getLogger(BusinessQueryFilterTuple.class);

    public static String createSingleBusinessQueryFilterTupleExpression(DataSelection model, Role role, BusinessQueryTupleFilter step, OLAPValues olapValues) throws GenerationException {
        List<TupleFilterMemberQualifier> memberQualifiers = step.getMemberQualifiers();
        DataItem measure = step.getMeasuresQualifier();
        if (memberQualifiers.isEmpty() && measure == null) {
            MDXGenerationUtil.applyDebugStatement("There is nothing inside this BusinessQueryTupleFilter", BusinessQueryFilterTuple.class);
            return null;
        }
        StringBuilder temporaryQueryString = new StringBuilder();
        HashMap<String, String> tupleSyncResults = new HashMap<String, String>();
        for (TupleFilterMemberQualifier dl : memberQualifiers) {
            if (dl == null) continue;
            DataItem item = dl.getMemberItem();
            if (item != null) {
                try {
                    tupleSyncResults.put(dl.getMemberItem().getID(), dl.getMemberExpression().getText());
                    continue;
                }
                catch (InvalidIDException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(dl.toString());
                    }
                    throw new GenerationException(e);
                }
                catch (MetadataException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(dl.toString());
                    }
                    throw new GenerationException(e);
                }
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryFilterTupleNoDataItem.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        if (measure != null) {
            Object objectMDX = olapValues.getOLAPValue(measure, OLAPItemType.MDXVARIABLE);
            MDXVariable mdxVariable = null;
            if (objectMDX == null) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryFilterTupleNoMDXCreated.txt", measure.getIdentityString());
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error((Object)formatter);
                }
                throw new GenerationException(formatter);
            }
            mdxVariable = (MDXVariable)objectMDX;
            try {
                tupleSyncResults.put(measure.getID(), mdxVariable.getLabel());
            }
            catch (InvalidIDException e1) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(measure.getIdentityString());
                }
                throw new GenerationException(e1);
            }
        }
        temporaryQueryString.append("     ").append("     ").append(MDXGenerationUtil.NEWLINE).append("{");
        boolean isUseNonNestedCJ = Boolean.valueOf(System.getProperty("SASQueryServices.useNonNestedCrossJoin", "true"));
        String crossjoin = "";
        crossjoin = isUseNonNestedCJ ? BusinessQueryFilterTuple.buildNonNestedCrossjoin(model, role, measure, tupleSyncResults) : BusinessQueryFilterTuple.buildNestedCrossjoin(model, role, measure, tupleSyncResults);
        temporaryQueryString.append(crossjoin);
        temporaryQueryString.append("     ").append("     ").append("     ").append("}");
        MDXGenerationUtil.applyDebugStatement("Filter Tuple: " + temporaryQueryString.toString(), BusinessQueryFilterTuple.class);
        return temporaryQueryString.toString();
    }

    private static String buildNestedCrossjoin(DataSelection model, Role role, DataItem measure, Map<String, String> tupleSyncResults) throws GenerationException {
        int numberOfCrossjoin = tupleSyncResults.values().size();
        int crossjoinParen = 0;
        StringBuilder temporaryQueryString = new StringBuilder();
        try {
            for (DataItem dataItem : model.getResultItems(role)) {
                String value = null;
                boolean isMeasure = false;
                if (measure != null && measure.getID().equals(dataItem.getID())) {
                    isMeasure = true;
                }
                boolean addDescendants = false;
                List<StepInterface> steps = dataItem.getSteps();
                if (steps.size() > 0) {
                    addDescendants = true;
                }
                if ((value = tupleSyncResults.get(dataItem.getID())) == null) continue;
                if (numberOfCrossjoin > 1) {
                    temporaryQueryString.append(MDXGenerationUtil.NEWLINE).append("     ").append("CROSSJOIN( ");
                }
                if (isMeasure) {
                    temporaryQueryString.append("{").append(value).append("}");
                } else if (addDescendants) {
                    temporaryQueryString.append("{DESCENDANTS(").append(value).append(")}");
                } else {
                    temporaryQueryString.append("{").append(value).append("}");
                }
                if (--numberOfCrossjoin <= 0) continue;
                ++crossjoinParen;
                temporaryQueryString.append(", ");
            }
        }
        catch (MetadataException e1) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(model.getIdentityString());
            }
            throw new GenerationException(e1, e1.getLocalizedMessage());
        }
        for (int i = 0; i < crossjoinParen; ++i) {
            temporaryQueryString.append(" )").append(MDXGenerationUtil.NEWLINE);
        }
        return temporaryQueryString.toString();
    }

    private static String buildNonNestedCrossjoin(DataSelection model, Role role, DataItem measure, Map<String, String> tupleSyncResults) throws GenerationException {
        StringBuilder temporaryQueryString = new StringBuilder();
        int numberOfCrossjoin = tupleSyncResults.values().size();
        try {
            Iterator<DataItem> it = model.getResultItems(role).iterator();
            if (numberOfCrossjoin > 1) {
                temporaryQueryString.append(MDXGenerationUtil.NEWLINE).append("     ").append("CROSSJOIN( ");
            }
            while (it.hasNext()) {
                DataItem dataItem = it.next();
                String value = null;
                boolean isMeasure = false;
                if (measure != null && measure.getID().equals(dataItem.getID())) {
                    isMeasure = true;
                }
                boolean addDescendants = false;
                List<StepInterface> steps = dataItem.getSteps();
                if (steps.size() > 0) {
                    addDescendants = true;
                }
                if ((value = tupleSyncResults.get(dataItem.getID())) == null) continue;
                if (isMeasure) {
                    temporaryQueryString.append("{").append(value).append("}");
                } else if (addDescendants) {
                    temporaryQueryString.append("{DESCENDANTS(").append(value).append(")}");
                } else {
                    temporaryQueryString.append("{").append(value).append("}");
                }
                temporaryQueryString.append(", ");
            }
            int lastCommaIndex = temporaryQueryString.lastIndexOf(",");
            temporaryQueryString.setLength(lastCommaIndex);
            if (numberOfCrossjoin > 1) {
                if (numberOfCrossjoin > 2) {
                    temporaryQueryString.append(", ").append(numberOfCrossjoin);
                }
                temporaryQueryString.append(" )").append(MDXGenerationUtil.NEWLINE);
            }
        }
        catch (MetadataException e1) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(model.getIdentityString());
            }
            throw new GenerationException(e1, e1.getLocalizedMessage());
        }
        return temporaryQueryString.toString();
    }

    public static String mergeEachTupleExceptExpression(String currentExpression, List listOfBQTupleExpression, String measures, boolean areMeasuresOnTop) throws GenerationException {
        int numberOfUnions = listOfBQTupleExpression.size();
        int unionParen = 0;
        if (numberOfUnions == 0) {
            return currentExpression;
        }
        StringBuilder returnBuffer = new StringBuilder();
        StringBuilder clause = new StringBuilder();
        if (measures != null) {
            clause.append(MDXGenerationUtil.NEWLINE).append("     ").append("CROSSJOIN").append("( ");
            if (!areMeasuresOnTop) {
                clause.append(measures).append(", ").append(MDXGenerationUtil.NEWLINE).append(currentExpression).append(" )");
            } else {
                clause.append(currentExpression).append(",").append(MDXGenerationUtil.NEWLINE).append(measures).append(" )");
            }
        } else {
            clause.append(currentExpression);
        }
        Iterator it = listOfBQTupleExpression.iterator();
        returnBuffer.append("EXCEPT({").append((CharSequence)clause).append("}, ").append(MDXGenerationUtil.NEWLINE).append(" {");
        while (it.hasNext()) {
            String singleExpression = (String)it.next();
            if (numberOfUnions > 1) {
                returnBuffer.append(MDXGenerationUtil.NEWLINE).append("UNION(");
            }
            returnBuffer.append(singleExpression).append(MDXGenerationUtil.NEWLINE);
            if (--numberOfUnions <= 0) continue;
            ++unionParen;
            returnBuffer.append(", ");
        }
        for (int i = 0; i < unionParen; ++i) {
            returnBuffer.append(" )").append(MDXGenerationUtil.NEWLINE);
        }
        returnBuffer.append("}  ").append("     ").append(")");
        return returnBuffer.toString();
    }
}

