/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.expr;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Iterator;
import java.util.List;

public class FractionTotalExpression {
    protected static final String AXISSUBTOTAL = " AxisSubTotal(";
    protected static final String AXISTOTAL = " AxisTotal(";
    protected static final String COLUMNAXIS = "COLUMN_AXIS";
    protected static final String GRANDAXIS = "GRAND_AXIS";
    protected static final String ROWAXIS = "ROW_AXIS";
    private String _axisApplied;
    private String _axisWrapper = null;
    private String _colString = "";
    private String _fractionalExpression;
    private String _fractionalNumerator = "";
    private boolean _isNumeratorOrphaned = false;
    private DataItem _numeratorDataItem = null;
    private DataSelection _model;
    private OLAPValues _olapValues;
    private List<DataItem> _resultItems;
    private Role _role;
    private String _rowString = "";
    private String _setWrapperLabel = "";
    private boolean _disableTotal = false;
    private String _firstHierarchy = null;
    private DataItem _fractionDataItem;

    public FractionTotalExpression(DataSelection model, OLAPValues olapValues, MDXVariable expressionVar, DataItem fractionDataItem, boolean noCols, boolean noRows, boolean disableTotal, String firstAxisDimension) throws GenerationException {
        this._resultItems = model.getResultItems();
        this.setOLAPValue(olapValues);
        this._model = model;
        this._disableTotal = disableTotal;
        this._firstHierarchy = firstAxisDimension;
        this._fractionDataItem = fractionDataItem;
        ExpressionInterface expression = fractionDataItem.getExpression();
        if (!(expression instanceof FractionOfTotalExpression)) {
            Object[] msgArgs2 = new Object[]{expression.toString()};
            GenerationException e = new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationNotFractionOfTotalExpression.fmt.txt", msgArgs2));
            throw e;
        }
        FractionOfTotalExpression fE = (FractionOfTotalExpression)expression;
        int denominatorType = fE.getDenominatorType();
        this._numeratorDataItem = fE.getNumerator();
        if (denominatorType == 3) {
            this._axisApplied = ROWAXIS;
            this._axisWrapper = AXISTOTAL;
            this._role = Role.ROW;
        } else if (denominatorType == 2) {
            this._axisApplied = COLUMNAXIS;
            this._axisWrapper = AXISTOTAL;
            this._role = Role.COLUMN;
        } else if (denominatorType == 5) {
            this._axisWrapper = AXISSUBTOTAL;
            this._axisApplied = ROWAXIS;
            this._role = Role.ROW;
        } else if (denominatorType == 4) {
            this._axisWrapper = AXISSUBTOTAL;
            this._axisApplied = COLUMNAXIS;
            this._role = Role.COLUMN;
        } else if (denominatorType == 0) {
            if (noRows) {
                this._axisApplied = COLUMNAXIS;
                this._role = Role.ROW;
            } else if (noCols) {
                this._axisApplied = ROWAXIS;
                this._role = Role.COLUMN;
            } else {
                DataItem dataItemForDemo = fE.getDenominator();
                try {
                    Role dataItemRole = this._model.getResultItemRole(dataItemForDemo);
                    this._axisApplied = dataItemRole.equals(Role.COLUMN) ? COLUMNAXIS : ROWAXIS;
                    this._role = dataItemRole;
                }
                catch (MetadataException ex) {
                    Object[] msgArgs2 = new Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("MDXGenerationNotSubTotalFractionOfTotalExpression.txt")};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    throw new GenerationException((MessageFormatter)msF, (Throwable)ex);
                }
            }
            this._axisWrapper = AXISSUBTOTAL;
        } else if (denominatorType == 1) {
            this._axisApplied = GRANDAXIS;
            this._role = Role.COLUMN;
            if (noRows) {
                this._axisApplied = COLUMNAXIS;
                this._role = Role.ROW;
            } else if (noCols) {
                this._axisApplied = ROWAXIS;
                this._role = Role.COLUMN;
            }
            this._axisWrapper = AXISTOTAL;
        } else {
            this._axisApplied = GRANDAXIS;
            this._role = Role.COLUMN;
            if (noRows) {
                this._axisApplied = COLUMNAXIS;
                this._role = Role.ROW;
            } else if (noCols) {
                this._axisApplied = ROWAXIS;
                this._role = Role.COLUMN;
            }
            this._axisWrapper = AXISTOTAL;
        }
        this.generateMDXExpression(expressionVar, model);
        this._fractionalExpression = expressionVar.getMDXPhrase();
    }

    public void setOLAPValue(OLAPValues olapValues) {
        this._olapValues = olapValues;
    }

    private String _toLabelPart() {
        String labelPart = "";
        if (this.getaxisApplied().equalsIgnoreCase(COLUMNAXIS)) {
            labelPart = "COL";
        } else if (this.getaxisApplied().equalsIgnoreCase(ROWAXIS)) {
            labelPart = "ROW";
        } else if (this.getaxisApplied().equalsIgnoreCase(GRANDAXIS)) {
            if (this._role.equals(Role.ROW)) {
                labelPart = "ROW";
            } else if (this._role.equals(Role.COLUMN)) {
                labelPart = "COL";
            }
        }
        return labelPart;
    }

    private void generateMDXExpression(MDXVariable expressionVar, DataSelection model) throws GenerationException {
        this._setWrapperLabel = "[&" + this._toLabelPart() + "]";
        this._isNumeratorOrphaned = this.isOrphanNumerator(this._numeratorDataItem);
        StringBuilder temp = new StringBuilder();
        String numeratorLabel = MDXGenerationUtil.buildCoreExpression(this._numeratorDataItem, this._olapValues);
        if (this.getaxisApplied().equalsIgnoreCase(GRANDAXIS)) {
            temp.append(numeratorLabel).append(" / ").append("Crossjoin(").append(this._axisWrapper).append(this.getSelectLabel(Role.ROW)).append(",").append(numeratorLabel).append("),").append(this._axisWrapper).append(this.getSelectLabel(Role.COLUMN)).append(")).item(0)");
        } else {
            temp.append(numeratorLabel).append(" / ").append(this._axisWrapper).append(this.getSelectLabel()).append(",").append(numeratorLabel).append(" )");
        }
        String currentMdx = temp.toString();
        String mdxWithDisabledClause = MDXGenerationUtil.buildDisabledTotalsClause(currentMdx, this._disableTotal, this._firstHierarchy, model, this._fractionDataItem);
        expressionVar.setMDXExpression(mdxWithDisabledClause);
    }

    public String getaxisApplied() {
        return this._axisApplied;
    }

    public String getFractionalSet(Role role) {
        if (this.getaxisApplied().equalsIgnoreCase(ROWAXIS)) {
            return this._rowString;
        }
        if (this.getaxisApplied().equalsIgnoreCase(COLUMNAXIS)) {
            return this._colString;
        }
        if (this.getaxisApplied().equalsIgnoreCase(GRANDAXIS)) {
            if (role.equals(Role.ROW)) {
                return this._colString;
            }
            return this._rowString;
        }
        return "";
    }

    public String getFractionTotalExpression() {
        return this._fractionalExpression;
    }

    private boolean isOrphanNumerator(DataItem _numeratorDataItem) {
        Iterator<DataItem> resultIterator = this._resultItems.iterator();
        boolean foundNumerator = false;
        while (resultIterator.hasNext()) {
            DataItem resultItem = resultIterator.next();
            if (!resultItem.equals(_numeratorDataItem)) continue;
            foundNumerator = true;
            break;
        }
        return foundNumerator;
    }

    public String getOrphanedNumerator() {
        return this._fractionalNumerator;
    }

    public boolean isNumeratorOrphaned() {
        return this._isNumeratorOrphaned;
    }

    public String getSelectLabel() {
        return this._setWrapperLabel;
    }

    public String getSelectLabel(Role role) {
        this._role = role;
        String specialWrapperLabel = "[&" + this._toLabelPart() + "]";
        return specialWrapperLabel;
    }

    public boolean isTotalsOn(Role role) {
        boolean isTotalsOn = true;
        TotalingType typeOfTotal = this._model.getTotalingType(role);
        if (typeOfTotal == TotalingType.TOTAL_NONE) {
            isTotalsOn = false;
        }
        return isTotalsOn;
    }

    public void setFractionalSet(String rowSelect, String colSelect) {
        String clause;
        StringBuilder mdx = new StringBuilder();
        this._rowString = rowSelect;
        this._colString = colSelect;
        if (this.getaxisApplied().equalsIgnoreCase(ROWAXIS)) {
            clause = this._rowString;
            mdx.append(" SET ").append(this._setWrapperLabel).append(" AS '").append(clause).append("'");
            this._rowString = mdx.toString();
        } else if (this.getaxisApplied().equalsIgnoreCase(COLUMNAXIS) && (clause = this._colString).length() > 0) {
            mdx.append(" SET ").append(this._setWrapperLabel).append(" AS '").append(clause).append("'");
            this._colString = mdx.toString();
        }
        if (this.getaxisApplied().equalsIgnoreCase(GRANDAXIS)) {
            if (rowSelect.length() > 0) {
                clause = this._rowString;
                if (clause.length() > 0) {
                    mdx.append(" SET ").append(this.getSelectLabel(Role.ROW)).append(" AS '").append(clause).append("'");
                    this._rowString = mdx.toString();
                }
                mdx.delete(0, mdx.length());
            }
            if (colSelect.length() > 0 && (clause = this._colString).length() > 0) {
                mdx.append(MDXGenerationUtil.NEWLINE).append("SET ").append(this.getSelectLabel(Role.COLUMN)).append(" AS '").append(clause).append("'");
                this._colString = mdx.toString();
            }
        }
    }
}

