/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASMDX.CommandFlag;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.ISession_1_1;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeFirstLastPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNParallelPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeRangeFilter;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.util.ChainedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

public class PreFilterDLLGeneration {
    private static final String PREFILTER_PREFIX = " FILTERED_TOTAL ";
    private StringBuilder _filterAddClause = new StringBuilder();
    private List<String> _filterDDLMemberList = new ArrayList<String>();
    private List _filterRemoveList = new ArrayList();
    private DataSelection _model;
    private OLAPValues _olapValues;
    private List _promptedDataItems = new ArrayList();
    private boolean _isFiltered = false;
    private String _root = null;
    private static final Logger _logger = LogManager.getLogger(PreFilterDLLGeneration.class);
    private static final Level ERROR_LEVEL = Level.ERROR;

    public void setModel(DataSelection model) {
        this._model = model;
    }

    public void applyFilter(ISession iSession, BusinessModel dataSelection) throws GenerationException {
        if (!(dataSelection instanceof DataSelection)) {
            _logger.error((java.lang.Object)dataSelection);
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("PreFilterDLLBadModel.txt", new java.lang.Object[0]);
            throw new GenerationException(mft);
        }
        this._model = (DataSelection)dataSelection;
        String cubeName = " [" + OLAPConnectionInfoUtil.getCubeName(this._model) + "] ";
        this.generateFullFilterMDX(cubeName);
        if (this.isFiltered()) {
            if (iSession == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadISession.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            ArrayList<String> commands = new ArrayList<String>();
            for (String text : this._filterDDLMemberList) {
                commands.add(this.generateFilterMDX(text));
            }
            this.applyFilterToISession(iSession, commands);
        }
    }

    public String getFilterMDXText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IQDataServicesResourceBundle.getMessageFormatter("PreFilterDLLCommentRoot.fmt.txt", this._root)).append(MDXGenerationUtil.NEWLINE);
        ArrayList<String> texts = new ArrayList<String>();
        for (String text : this._filterDDLMemberList) {
            String textParse = text.substring(text.indexOf("'") + 1);
            textParse = textParse.substring(0, textParse.indexOf("'"));
            texts.add(MDXGenerationUtil.NEWLINE + textParse);
        }
        stringBuilder.append(texts).append(MDXGenerationUtil.NEWLINE);
        return stringBuilder.toString();
    }

    private String generateFilterMDX(String text) {
        return " FILTERED_TOTAL  ADD " + text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFilterToISession(ISession iSession, List<String> commands) throws GenerationException {
        for (String builderString : commands) {
            ISession iSession2 = iSession;
            synchronized (iSession2) {
                try {
                    iSession.MDXCommand(builderString, CommandFlag.CommandFlagExecute);
                    MDXGenerationUtil.applyDebugStatement("Added parent filter:" + builderString, this.getClass());
                }
                catch (GenericError e) {
                    if (_logger.isEnabled(ERROR_LEVEL)) {
                        _logger.error(builderString + e.getLocalizedMessage(), (Throwable)e);
                    }
                    ISession_1_1 iSession_1_1 = IOMServerUtils.GetISession_1_1((Object)iSession);
                }
            }
        }
    }

    private String buildWrappedPromptMember(List memberNames, MemberFilterExpression expression) throws GenerationException {
        ArrayList<String> memberTrimStrings = new ArrayList<String>();
        OLAPDataSet olapDataSet = null;
        StringBuilder MDXExpression = new StringBuilder();
        try {
            olapDataSet = MDXGenerationUtil.buildResultSet(memberNames, this._model.getBusinessModel(), memberTrimStrings, expression.getMemberLocale());
            if (olapDataSet == null) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(expression.toString());
                }
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilNoOLAPDataSet.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            OLAPServerUtilities olapServerUtil = OLAPServerUtilities.getInstance();
            Iterator<MemberTuple> iterator = olapServerUtil.getFilterTupleList((OLAPDataSetInterface)olapDataSet, memberTrimStrings, true).iterator();
            if (!iterator.hasNext()) {
                _logger.error(olapDataSet.getQueryStatement());
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MemberFilterNoTuplesPrompts.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            ExpressionInterface whatToCompare = expression.getWhatToCompare();
            if (whatToCompare != null) {
                if (whatToCompare instanceof DataItem) {
                    String dataItemLabel = ((DataItem)whatToCompare).getLabel();
                    this._promptedDataItems.add(dataItemLabel);
                    this._olapValues.setPromptMemberLevelRoot(dataItemLabel, olapServerUtil.getFilterTupleAncestor());
                }
            } else {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(olapDataSet.getQueryStatement());
                }
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MemberFilterNoWhatToCompare.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            while (iterator.hasNext()) {
                MemberTuple objectMember;
                MemberTuple element = objectMember = iterator.next();
                String valueString = element.getName();
                MDXGenerationUtil.applyDebugStatement("Prompted tuple name: " + valueString, this.getClass());
                if (olapServerUtil.isFilterMemberNamesOrphaned() && expression.isOrphanMembersInFilterFixed()) {
                    MDXExpression.append(MDXGenerationUtil.fixOrphanFilterMember(element));
                }
                String valString = MDXGenerationUtil.applyFilterAttributes(valueString, element);
                MDXGenerationUtil.applyDebugStatement("Actual value entered" + valString, this.getClass());
                MDXExpression.append(valString);
                if (!iterator.hasNext()) continue;
                MDXExpression.append(",");
            }
            String string = MDXExpression.toString();
            return string;
        }
        catch (MetadataException ge) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error((CharSequence)MDXExpression, (Throwable)ge);
            }
            throw new GenerationException(ge);
        }
        catch (OLAPException ge) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error((CharSequence)MDXExpression, (Throwable)ge);
            }
            throw new GenerationException(ge);
        }
        finally {
            block22: {
                try {
                    if (olapDataSet != null) {
                        olapDataSet.close();
                    }
                }
                catch (OLAPException e) {
                    if (!_logger.isDebugEnabled()) break block22;
                    _logger.debug("Error while closing the OlapDataSet, just continue: " + e.getLocalizedMessage());
                }
            }
        }
    }

    private String generateAllForTotals(ExpressionInterface filterExpression, String coreExpression) {
        String returnValue = coreExpression;
        StringBuilder wrapperWithTotal = new StringBuilder();
        if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression) || filterExpression instanceof TimeFilterExpression || filterExpression instanceof TimeRangeFilterExpression) {
            String allTotalLabel;
            boolean shouldAddParentsToFilter = this.getAllOnGrandChildMembers(filterExpression);
            if (shouldAddParentsToFilter) {
                StringBuilder wrapperAddParents = new StringBuilder();
                wrapperAddParents.append(MDXGenerationUtil.NEWLINE).append("{AddParents({").append(MDXGenerationUtil.NEWLINE).append(coreExpression).append("}, POST)}");
                coreExpression = wrapperAddParents.toString();
            }
            if ((allTotalLabel = this._olapValues.getAllTotalLabelForDDL(filterExpression)) == null) {
                wrapperWithTotal.append(coreExpression);
            } else if (allTotalLabel.length() == 0) {
                wrapperWithTotal.append(coreExpression);
            } else {
                wrapperWithTotal.append(allTotalLabel).append(", ").append(coreExpression);
            }
            returnValue = wrapperWithTotal.toString();
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{"Total is applied and therefore, ALL is added to string: ", wrapperWithTotal.toString()};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            MDXGenerationUtil.applyDebugStatement(msF.toString(), this.getClass());
        }
        return returnValue;
    }

    private String generateFilterExpression(ExpressionInterface filterExpression, String coreExpression) throws GenerationException {
        String logInfo = filterExpression.toString();
        String returnValue = coreExpression;
        boolean isNegated = false;
        DataItem whatToCompare = null;
        String root = null;
        if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression) || filterExpression instanceof TimeFilterExpression || filterExpression instanceof TimeRangeFilterExpression) {
            ExpressionInterface whatToCompareObject;
            MDXGenerationUtil.applyDebugStatement(logInfo, this.getClass());
            if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression)) {
                MemberFilterExpression mfe = (MemberFilterExpression)filterExpression;
                root = mfe.getMemberLevelRoot();
                isNegated = mfe.isNegated();
                whatToCompareObject = mfe.getWhatToCompare();
                if (whatToCompareObject instanceof DataItem) {
                    whatToCompare = (DataItem)whatToCompareObject;
                }
            } else if (filterExpression instanceof TimeFilterExpression) {
                TimeFilterExpression tme = (TimeFilterExpression)filterExpression;
                isNegated = tme.isNegated();
                root = tme.getMemberLevelRoot();
                whatToCompareObject = tme.getWhatToCompare();
                if (whatToCompareObject instanceof DataItem) {
                    whatToCompare = (DataItem)whatToCompareObject;
                }
            } else if (filterExpression instanceof TimeRangeFilterExpression) {
                TimeRangeFilterExpression tre = (TimeRangeFilterExpression)filterExpression;
                isNegated = tre.isNegated();
                root = tre.getMemberLevelRoot();
                whatToCompareObject = tre.getWhatToCompare();
                if (whatToCompareObject instanceof DataItem) {
                    whatToCompare = (DataItem)whatToCompareObject;
                }
            }
            if (isNegated && whatToCompare != null) {
                String dimName = (String)this._olapValues.getOLAPValue(whatToCompare, OLAPItemType.HIERNAME);
                StringBuilder str = new StringBuilder(900);
                str.append("EXCEPT({UNION(  {DESCENDANTS (  ").append(dimName).append(".DEFAULTMEMBER)}, {").append(MDXGenerationUtil.NEWLINE).append(coreExpression).append("} )   }").append(MDXGenerationUtil.NEWLINE);
                coreExpression = str.toString();
            }
        }
        String filterExpressionString = "";
        if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression)) {
            if (((MemberFilterExpression)filterExpression).getResources(Prompt.class, 65535).size() > 0) {
                ArrayList promptList2 = new ArrayList();
                String memberFilterString = MemberFilter.getMDXExpression(this._model, coreExpression, (MemberFilterExpression)filterExpression, promptList2);
                filterExpressionString = promptList2.size() > 0 ? this.buildWrappedPromptMember(promptList2, (MemberFilterExpression)filterExpression) : memberFilterString;
            } else {
                filterExpressionString = MemberFilter.getMDXExpression(this._model, coreExpression, (MemberFilterExpression)filterExpression);
            }
            String temp = this.generateAllForTotals(filterExpression, filterExpressionString);
            if (temp != null && temp.length() > 0) {
                filterExpressionString = temp;
            }
            returnValue = filterExpressionString;
        } else if (filterExpression instanceof TimeFilterFirstLastPeriodsExpression) {
            MDXGenerationUtil.applyDebugStatement(logInfo, this.getClass());
            returnValue = this.applyTimeDescendants(TimeFirstLastPeriodsFilter.getMDXExpression((TimeFilterFirstLastPeriodsExpression)filterExpression, this._model), isNegated, whatToCompare, root);
        } else if (filterExpression instanceof TimeFilterNParallelPeriodsExpression) {
            MDXGenerationUtil.applyDebugStatement(logInfo, this.getClass());
            returnValue = this.applyTimeDescendants(TimeNParallelPeriodsFilter.getMDXExpression((TimeFilterNParallelPeriodsExpression)filterExpression, this._model), isNegated, whatToCompare, root);
        } else if (filterExpression instanceof TimeFilterNPeriodsExpression) {
            MDXGenerationUtil.applyDebugStatement(logInfo, this.getClass());
            returnValue = this.applyTimeDescendants(TimeNPeriodsFilter.getMDXExpression((TimeFilterNPeriodsExpression)filterExpression, this._model), isNegated, whatToCompare, root);
        } else if (filterExpression instanceof TimeRangeFilterExpression) {
            MDXGenerationUtil.applyDebugStatement(logInfo, this.getClass());
            returnValue = this.applyTimeDescendants(TimeRangeFilter.getMDXExpression((TimeRangeFilterExpression)filterExpression, this._model), isNegated, whatToCompare, root);
        } else {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("PreFilterDLLGenerationBadFilter.txt")};
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(filterExpression.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException ee = new GenerationException(msF);
            throw ee;
        }
        returnValue = MDXGenerationUtil.repairQuotes(returnValue);
        this._root = root;
        return returnValue;
    }

    private String applyTimeDescendants(String MDXExpression, boolean isNegate, DataItem whatToCompare, String root) {
        String returnValue = MDXExpression;
        if (root != null && whatToCompare != null && !isNegate) {
            StringBuilder wrapperDescendent = new StringBuilder();
            String dimName = (String)this._olapValues.getOLAPValue(whatToCompare, OLAPItemType.UNIQUENAME);
            String dimName2 = dimName.substring(0, dimName.lastIndexOf("."));
            wrapperDescendent.append(MDXGenerationUtil.NEWLINE).append("UNION({").append(MDXExpression).append("},{Descendants(").append(dimName2).append(".currentMember,").append(root).append(",AFTER)})");
            returnValue = wrapperDescendent.toString();
        }
        return returnValue;
    }

    public List getPromptList() {
        return this._promptedDataItems;
    }

    public void generateFullFilterMDX(String cubeName) throws GenerationException {
        Iterator<?> iterator = this._olapValues.getFilterListForDDL().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ArrayList<DataItem> dataItemFilter = new ArrayList<DataItem>();
        this._filterDDLMemberList.clear();
        this._filterRemoveList.clear();
        this._filterAddClause.delete(0, this._filterAddClause.length());
        this._promptedDataItems.clear();
        this._isFiltered = false;
        while (iterator.hasNext()) {
            FilterItem filter = (FilterItem)iterator.next();
            DataItem filterDataItem = null;
            try {
                filterDataItem = this._olapValues.getDataItemForDDLFilter(filter.getID());
            }
            catch (InvalidIDException e) {
                _logger.error((java.lang.Object)e);
                throw new GenerationException(e);
            }
            if (dataItemFilter.contains(filterDataItem)) continue;
            this._isFiltered = true;
            String preFilterLabel = this._olapValues.getOLAPValue(filterDataItem, OLAPItemType.PREFILTERLABEL).toString();
            if (preFilterLabel == null) {
                return;
            }
            if (preFilterLabel.length() == 0) {
                return;
            }
            String valueOf = this.generateFilterExpression(filter.getExpression(), MDXGenerationUtil.buildMembersDefinition(filterDataItem, this._olapValues, this._model));
            StringBuilder filterClause = new StringBuilder();
            filterClause.append(MDXGenerationUtil.NEWLINE).append(cubeName).append(preFilterLabel).append(" '").append("{ ").append(valueOf).append("} ").append("'");
            String text = filterClause.toString();
            this._filterDDLMemberList.add(text);
            this._filterAddClause.append(MDXGenerationUtil.NEWLINE).append("     ").append(this.generateFilterMDX(text)).append(MDXGenerationUtil.NEWLINE);
            StringBuilder filterRemoveClause = new StringBuilder();
            filterRemoveClause.append(cubeName).append(preFilterLabel).append(MDXGenerationUtil.NEWLINE);
            this._filterRemoveList.add(filterRemoveClause.toString());
            dataItemFilter.add(filterDataItem);
        }
    }

    public OLAPValues getOLAPValues() {
        return this._olapValues;
    }

    public String getPreFilterClause() {
        return this._filterAddClause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(ISession iSession) throws GenerationException {
        this._filterAddClause.delete(0, this._filterAddClause.length());
        if (this._filterRemoveList == null) {
            MDXGenerationUtil.applyDebugStatement("The parent filter remove list was empty. ", this.getClass());
            return;
        }
        Iterator iterator2 = this._filterRemoveList.iterator();
        while (iterator2.hasNext()) {
            String builderString = " FILTERED_TOTAL  REMOVE " + iterator2.next().toString();
            try {
                ISession iSession2 = iSession;
                synchronized (iSession2) {
                    iSession.MDXCommand(builderString, CommandFlag.CommandFlagExecute);
                }
                MDXGenerationUtil.applyDebugStatement("Filter removed: " + builderString, this.getClass());
            }
            catch (GenericError ge) {
                ArrayMessageFormatter msf;
                String trimmed = builderString.trim();
                Throwable targetException = ChainedException.getTargetException((Throwable)ge);
                if (ge != targetException) {
                    ConnectionUtil.LoggerErrorWithObjects(_logger, trimmed, new java.lang.Object[]{targetException, ge, iSession});
                    msf = new ArrayMessageFormatter(trimmed, targetException);
                } else {
                    ConnectionUtil.LoggerErrorWithObjects(_logger, trimmed, new java.lang.Object[]{ge, iSession});
                    msf = new ArrayMessageFormatter(trimmed, targetException);
                }
                throw new GenerationException((MessageFormatter)msf, (Throwable)ge);
            }
        }
        this._filterRemoveList.clear();
        if (this._filterDDLMemberList != null) {
            this._filterDDLMemberList.clear();
        }
    }

    private boolean getAllOnGrandChildMembers(ExpressionInterface filterExpression) {
        MemberFilterExpression memberFilter;
        ExpressionInterface expression;
        boolean dataItemOnTheInside = false;
        Role role = Role.ROW;
        boolean shouldAddParentsToFilter = false;
        if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression) && (expression = (memberFilter = (MemberFilterExpression)filterExpression).getWhatToCompare()) instanceof DataItem) {
            String memberRoot;
            String total;
            ExpressionInterface expressionOfDataItem;
            MDXGenerationUtil.applyDebugStatement("Edge case for parent filter where grandchildren with no direct parents were applied" + filterExpression.toString(), this.getClass());
            DataItem dataItem = (DataItem)expression;
            List<DataItem> results = this._model.getResultItems();
            Iterator<DataItem> resultsI = results.iterator();
            DataItem whatToCompare = null;
            DataItem dataItemInResultList = null;
            while (resultsI.hasNext()) {
                DataItem dataIt;
                dataItemInResultList = dataIt = resultsI.next();
                while (dataIt instanceof DataItemReference) {
                    dataIt = ((DataItemReference)dataIt).getBaseDataItem();
                }
                try {
                    String dataItID = dataIt.getID();
                    String dataItemID = dataItem.getID();
                    if (!dataItemID.equalsIgnoreCase(dataItID)) continue;
                    whatToCompare = dataIt;
                    break;
                }
                catch (InvalidIDException e) {
                    _logger.error((java.lang.Object)e);
                    return false;
                }
            }
            if (whatToCompare == null) {
                return false;
            }
            try {
                role = this._model.getResultItemRole(dataItemInResultList);
                MDXGenerationUtil.applyDebugStatement("Role for edge case check of parent filters" + role, this.getClass());
                if (role == null) {
                    return false;
                }
                if (role.equals(Role.BACKGROUND) || role.equals(Role.HIDDEN)) {
                    return false;
                }
                List<DataItem> resultsOnRow = this._model.getResultItems(role);
                Iterator<DataItem> resultsOnRowI = resultsOnRow.iterator();
                int locationOfDataItem = 0;
                while (resultsOnRowI.hasNext()) {
                    DataItem dataIt = resultsOnRowI.next();
                    ++locationOfDataItem;
                    if (!dataIt.getID().equalsIgnoreCase(dataItemInResultList.getID())) continue;
                    break;
                }
                if (locationOfDataItem > 1) {
                    dataItemOnTheInside = true;
                }
            }
            catch (MetadataException e) {
                _logger.error((java.lang.Object)e);
                return false;
            }
            if (dataItemOnTheInside && memberFilter != null && (expressionOfDataItem = whatToCompare.getExpression()) instanceof Hierarchy && ((total = this._model.getTotalType(role)).equalsIgnoreCase(BusinessQuery.SUBTOTAL) || total.equalsIgnoreCase(BusinessQuery.ALLTOTAL)) && (memberRoot = memberFilter.getMemberLevelRoot()) != null) {
                int location = memberRoot.lastIndexOf(".") + 1;
                String levelName = memberRoot.substring(location);
                levelName = levelName.replace('[', ' ');
                levelName = levelName.replace(']', ' ');
                levelName = levelName.trim();
                Hierarchy hierarchy = (Hierarchy)expressionOfDataItem;
                try {
                    com.sas.iquery.metadata.physical.Level level;
                    String levelObjectName;
                    List<com.sas.iquery.metadata.physical.Level> levels = hierarchy.getLevels(true);
                    int ct = 0;
                    Iterator<com.sas.iquery.metadata.physical.Level> iterator = levels.iterator();
                    while (iterator.hasNext() && !(levelObjectName = (level = iterator.next()).getLevelName()).equalsIgnoreCase(levelName)) {
                        ++ct;
                    }
                    if (ct > 1) {
                        shouldAddParentsToFilter = true;
                    }
                }
                catch (MetadataException e) {
                    _logger.error((java.lang.Object)e);
                    return false;
                }
            }
        }
        return shouldAddParentsToFilter;
    }

    public void setOLAPValues(OLAPValues olapValues) {
        this._olapValues = olapValues;
    }

    public boolean isFiltered() {
        return this._isFiltered;
    }
}

