/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.storage.olap.Filter;

public class OLAPGeneratedItem {
    private DataSelection _model = null;
    private boolean _isMeasure = false;
    private String _label = null;
    private String _dimName = null;
    private String _preFilterDimName = null;
    private String _memberName = null;
    private String _uName = null;
    private String _RASENAME = null;
    private boolean _isAccessible = true;
    private boolean _isVisible = true;
    private Filter _filter = null;
    private String _format = "";
    private String _hierName = null;
    private MDXVariable _mdxVariable = null;
    private boolean _formatDiff = false;
    private String _allMember = "[All]";
    private String _name = null;

    public OLAPGeneratedItem(DataSelection model, DataItem resultItem, String localMeasure) throws GenerationException {
        this._model = model;
        this._isMeasure = this.setMeasure(resultItem);
        if (this._isMeasure) {
            this._hierName = localMeasure;
        }
    }

    public Object getValue(OLAPItemType valueType) {
        Object value = null;
        if (valueType.equals(OLAPItemType.DIMNAME)) {
            return this._dimName;
        }
        if (valueType.equals(OLAPItemType.MEMBERNAME)) {
            return this._memberName;
        }
        if (valueType.equals(OLAPItemType.PREFILTERLABEL)) {
            return this._preFilterDimName;
        }
        if (valueType.equals(OLAPItemType.UNIQUENAME)) {
            return this._uName;
        }
        if (valueType.equals(OLAPItemType.ISACCESSIBLE)) {
            return MDXGenerationUtil.BooleanValue(this._isAccessible);
        }
        if (valueType.equals(OLAPItemType.RASENAME)) {
            return this._RASENAME;
        }
        if (valueType.equals(OLAPItemType.ISVISIBLE)) {
            return MDXGenerationUtil.BooleanValue(this._isVisible);
        }
        if (valueType.equals(OLAPItemType.FILTER)) {
            return this._filter;
        }
        if (valueType.equals(OLAPItemType.FORMAT)) {
            return this._format;
        }
        if (valueType.equals(OLAPItemType.HIERNAME)) {
            return this._hierName;
        }
        if (valueType.equals(OLAPItemType.LABEL)) {
            return this._label;
        }
        if (valueType.equals(OLAPItemType.NAME)) {
            return this._name;
        }
        if (valueType.equals(OLAPItemType.MDXVARIABLE)) {
            return this._mdxVariable;
        }
        if (valueType.equals(OLAPItemType.ISMEASURE)) {
            return MDXGenerationUtil.BooleanValue(this._isMeasure);
        }
        if (valueType.equals(OLAPItemType.ISFORMATDIFFERENCE)) {
            return MDXGenerationUtil.BooleanValue(this._formatDiff);
        }
        if (valueType.equals(OLAPItemType.ALL)) {
            return this._allMember;
        }
        return value;
    }

    public boolean isMeasure() {
        return this._isMeasure;
    }

    private boolean setMeasure(DataItem resultItem) throws GenerationException {
        ExpressionInterface expression = resultItem.getExpression();
        boolean isMeasure = false;
        if (expression instanceof Measure || expression instanceof TimeExpressionMeasure || expression instanceof FractionOfTotalExpression) {
            isMeasure = true;
        } else if (expression instanceof CalculatedMember) {
            isMeasure = false;
        } else if (expression instanceof NamedSet) {
            isMeasure = false;
        } else if (expression instanceof DataItem) {
            DataItem daItem = (DataItem)expression;
            expression = daItem.getExpression();
            StructureOfDataItem struct = daItem.getStructure();
            if (struct.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                isMeasure = true;
            }
        } else if (expression instanceof ResourceAwareStringExpression) {
            try {
                isMeasure = BusinessQueryOLAPUtil.isInMeasureDimension(this._model, resultItem);
            }
            catch (MetadataException me) {
                Object[] msgArgs2 = new Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("OLAPValuesNoMetadataForMeasure.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                e.initCause(me);
                throw e;
            }
        }
        return isMeasure;
    }

    public void setValue(OLAPItemType valueType, Object objectValue) {
        if (valueType.equals(OLAPItemType.DIMNAME)) {
            this._dimName = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.MEMBERNAME)) {
            this._memberName = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.PREFILTERLABEL)) {
            this._preFilterDimName = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.UNIQUENAME)) {
            this._uName = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.ISACCESSIBLE)) {
            this._isAccessible = MDXGenerationUtil.BooleanObjectValue(objectValue);
        } else if (valueType.equals(OLAPItemType.RASENAME)) {
            this._RASENAME = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.ISVISIBLE)) {
            this._isVisible = MDXGenerationUtil.BooleanObjectValue(objectValue);
        } else if (valueType.equals(OLAPItemType.FILTER)) {
            Filter filterIn;
            this._filter = filterIn = (Filter)objectValue;
        } else if (valueType.equals(OLAPItemType.FORMAT)) {
            this._format = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.HIERNAME)) {
            this._hierName = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.LABEL)) {
            this._label = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.NAME)) {
            this._name = (String)objectValue;
        } else if (valueType.equals(OLAPItemType.MDXVARIABLE)) {
            MDXVariable MDXVar;
            this._mdxVariable = MDXVar = (MDXVariable)objectValue;
        } else if (valueType.equals(OLAPItemType.ISMEASURE)) {
            this._isAccessible = MDXGenerationUtil.BooleanObjectValue(objectValue);
        } else if (valueType.equals(OLAPItemType.ISFORMATDIFFERENCE)) {
            this._formatDiff = MDXGenerationUtil.BooleanObjectValue(objectValue);
        } else if (valueType.equals(OLAPItemType.ALL)) {
            this._allMember = (String)objectValue;
        }
    }
}

