/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iom.SASMDX.ISession_1_1;
import com.sas.iom.SASMDX.ResultSetTypeSeqHolder;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.ConnectionConfiguration;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.UserSessionConnectionDecorator;
import com.sas.iquery.execution.instructions.OLAPDataSetFactory;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.Model;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.physical.Server;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSet;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.embedded.TupleElement;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

public class OLAPConnectionInfoUtil {
    public static final Logger _logger = LogManager.getLogger(OLAPConnectionInfoUtil.class);
    public static final Logger _perfDSLogger = LogManager.getLogger((String)"com.sas.iquery.perf.DataServer");
    public static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OLAPDataSet executeQuery(BusinessModel businessModel, String query, MetadataInterface inMetaI, int contextType, boolean throwErrorMessage) throws ExecutionException, MetadataException, GenerationException {
        IQOLAPDataSet olapDataSet = null;
        boolean cleanupConnection = false;
        MetadataInterface metadataInterface = inMetaI;
        Model dataSelection = null;
        boolean cleanupDataSelection = false;
        try {
            OLAPConnectionResource olapConnection = null;
            if (metadataInterface == null) {
                MDXGenerationUtil.applyDebugStatement("Metadata Interface was null, we will try to use the businesModel to get the connection: ", OLAPConnectionInfoUtil.class);
                Preconditions.ensureNonNull(businessModel, "businessModel", _logger);
                List<BusinessQuery> businessQueries = businessModel.getQueries();
                for (BusinessQuery businessQuery : businessQueries) {
                    if (!(businessQuery instanceof DataSelection)) continue;
                    dataSelection = (DataSelection)businessQuery;
                    break;
                }
                if (dataSelection == null) {
                    dataSelection = DataSelectionFactory.newDataSelection(businessModel);
                    cleanupDataSelection = true;
                }
                if (!dataSelection.getStructure().isOLAP()) {
                    MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new java.lang.Object[0]);
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(businessModel.getIdentityString());
                        _logger.error((java.lang.Object)msg);
                    }
                    throw new MetadataException(msg);
                }
                String constructor = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
                Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale((BusinessModel)dataSelection);
                RetrievalPolicy userSessionPolicy = new RetrievalPolicy();
                userSessionPolicy.setPolicyValue(0);
                ConnectionConfiguration connectionConfiguration = userSessionPolicy.getConnectionConfiguration();
                connectionConfiguration.setConnectionLifetime(1);
                DataSourceCube dataCube = OLAPUtilities.findDataSourceCube((BusinessModel)dataSelection);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                olapConnection = OLAPConnectionInfoUtil.getOLAPConnectionResource((DataSelection)dataSelection, logicalServer, userSessionPolicy, computationalLocale);
                metadataInterface = olapConnection.createMetadataInterface((BusinessModel)dataSelection, constructor, dataCube, true, true, null);
                cleanupConnection = true;
            }
            olapDataSet = ConnectionUtil.newOLAPDataSet(businessModel, query, contextType, metadataInterface, olapConnection);
            if (query != null) {
                olapDataSet.executeQuery();
            }
        }
        catch (OLAPException e) {
            MDXGenerationUtil.applyDebugStatement(query, OLAPConnectionInfoUtil.class);
            if (olapDataSet != null) {
                ConnectionResources.close(olapDataSet);
            }
            if (throwErrorMessage) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilQueryFailed.txt", new java.lang.Object[0]);
                throw new ExecutionException(formatter, (Throwable)e);
            }
            MDXGenerationUtil.applyDebugStatement("An error was throw from this query but it was not necessary to report." + query, OLAPConnectionInfoUtil.class);
        }
        finally {
            if (cleanupConnection && metadataInterface != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface(metadataInterface);
            }
            if (cleanupDataSelection && dataSelection != null) {
                dataSelection.dispose();
            }
        }
        return olapDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OLAPDataSet executeQuery(BusinessModel model, String mdxSet) throws GenerationException, IQueryServicesException {
        int contextType = 0;
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(model);
        if (computationalLocale == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("ConnectionRecycler.fetchPFSConnection.NoLocale.txt", new java.lang.Object[0]);
            throw new ExecutionException(msg);
        }
        RetrievalPolicy userSessionReleasePolicy = new RetrievalPolicy();
        userSessionReleasePolicy.getConnectionConfiguration().setConnectionLifetime(1);
        IntelligentQueryMetadataServiceInterface iqService = IntelligentQueryMetadataServiceFactory.newService();
        SessionContextInterface sessionContext = model.getSession();
        DataSelection dataSelection = DataSelectionFactory.newDataSelection(sessionContext, iqService);
        IQOLAPDataSet olapDataSet = null;
        ConnectionInterface userSessionReleaseConnection = null;
        try {
            DataSourceCube dataCube = OLAPUtilities.findDataSourceCube(model);
            SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
            LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
            ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
            UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
            userSessionReleaseConnection = ConnectionUtil.findConnection(recycler, dataSelection, logicalServer, userContext, userSessionReleasePolicy, computationalLocale);
            try {
                IMDXServer mdxServer = null;
                Object obj = userSessionReleaseConnection.getObject();
                mdxServer = IOMServerUtils.GetIMDXServer(obj);
                if (mdxServer == null) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(logicalServer.toString());
                    }
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadServerObj.txt", new java.lang.Object[0]);
                    throw new ExecutionException(formatter);
                }
                try {
                    olapDataSet = ConnectionResources.newOLAPDataSet(mdxServer, contextType);
                    olapDataSet.setBusinesModel(model);
                    olapDataSet.setLocale(computationalLocale);
                    olapDataSet.setQueryStatement(mdxSet, null);
                    if (mdxSet != null) {
                        olapDataSet.executeQuery();
                    }
                }
                catch (OLAPException oe) {
                    MDXGenerationUtil.applyDebugStatement(mdxSet, OLAPConnectionInfoUtil.class);
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(oe.getLocalizedMessage(), (Throwable)oe);
                    }
                    IQueryServicesException ge = new IQueryServicesException(IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilQueryFailed.txt", new java.lang.Object[0]), (Throwable)oe);
                    throw ge;
                }
                finally {
                    if (mdxServer != null) {
                        mdxServer._release();
                    }
                    if (olapDataSet == null && userSessionReleaseConnection != null) {
                        ConnectionResources.close(userSessionReleaseConnection);
                    }
                }
            }
            catch (IQueryServicesException e) {
                _logger.error((java.lang.Object)e);
                ConnectionResources.close(userSessionReleaseConnection);
                ConnectionResources.close(olapDataSet);
                throw e;
            }
        }
        finally {
            if (dataSelection != null) {
                dataSelection.dispose();
            }
        }
        return olapDataSet;
    }

    public static void cancelSingleQuery(DataSelection model, java.lang.Object connection) throws IQueryServicesException {
        String queryStmt = "";
        try {
            if (connection instanceof ISession) {
                ISession iSession = (ISession)connection;
                ISession_1_1 session = IOMServerUtils.GetISession_1_1((Object)iSession);
                Map<String, UUID> listOfQueryDSRunning = OLAPConnectionInfoUtil.getIndvidualQueriesRunningOnServer(session);
                for (String queryId : listOfQueryDSRunning.keySet()) {
                    if (!queryId.equalsIgnoreCase(model.getID())) continue;
                    long start = 0L;
                    if (_perfCLogger.isDebugEnabled()) {
                        ExtraLoggingContexts.debugLogConnectionPerformance("> Canceling query on server: " + connection.toString());
                        start = System.currentTimeMillis();
                    }
                    session.CloseResultSet(listOfQueryDSRunning.get(queryId));
                    if (!_perfCLogger.isDebugEnabled()) continue;
                    long end = System.currentTimeMillis();
                    ExtraLoggingContexts.debugLogConnectionPerformance("< Cancel done on server: (" + (end - start) + "ms)");
                }
            }
        }
        catch (GenericError e) {
            MDXGenerationUtil.applyDebugStatement("Cancel Query command on server failed.", OLAPConnectionInfoUtil.class);
            _logger.error(queryStmt);
            IQueryServicesException ee = new IQueryServicesException(e);
            throw ee;
        }
    }

    private static Map<String, UUID> getIndvidualQueriesRunningOnServer(ISession_1_1 session) throws IQueryServicesException {
        HashMap<String, UUID> queries = new HashMap<String, UUID>();
        UUIDSeqHolder queryID = new UUIDSeqHolder();
        StringSeqHolder queryStmt = new StringSeqHolder();
        ResultSetTypeSeqHolder type1 = new ResultSetTypeSeqHolder();
        StringSeqHolder lastUpdateTime = new StringSeqHolder();
        LongSeqHolder size1 = new LongSeqHolder();
        LongSeqHolder totalCells = new LongSeqHolder();
        LongSeqHolder readCells = new LongSeqHolder();
        try {
            session.ListQueries_2(queryID, queryStmt, type1, lastUpdateTime, size1, totalCells, readCells);
            MDXGenerationUtil.applyDebugStatement(queryStmt.toString(), OLAPConnectionInfoUtil.class);
        }
        catch (GenericError e) {
            IQueryServicesException ee = new IQueryServicesException(e);
            throw ee;
        }
        String[] valueOf = queryStmt.value;
        UUID[] queryOf = queryID.value;
        for (int i = 0; i < valueOf.length; ++i) {
            int beg = valueOf[i].indexOf("//&&&&");
            int end = valueOf[i].lastIndexOf("&&&&");
            String queryIdPortion = valueOf[i].substring(beg, end);
            queries.put(queryIdPortion, queryOf[i]);
        }
        return queries;
    }

    public static AxisInterface getAxisInQuery(OLAPDataSet olapDataSet) throws OLAPException {
        ResultSetMetadataInterface resultSetMeta = olapDataSet.getResultSetMetadata();
        AxisInterface[] axes = resultSetMeta.getAxes(0, -1);
        AxisInterface columnAxis = axes[0];
        return columnAxis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OLAPConnectionResource getConnection(BusinessModel businessModel, RetrievalPolicy policy, Locale computationalLocale) throws ExecutionException, MetadataException, GenerationException {
        Preconditions.ensureNonNull(businessModel, "businessModel", _logger);
        DataSelection dataSelection = OLAPUtilities.findDataSelection(null, businessModel);
        boolean disposeDataSelection = false;
        if (dataSelection == null) {
            disposeDataSelection = true;
            dataSelection = OLAPUtilities.createDataSelection(businessModel, null);
        }
        OLAPConnectionResource olapConnection = null;
        ConnectionInterface connection = null;
        boolean aquireRelease = policy.getConnectionConfiguration().getConnectionLifetime() == 0;
        try {
            if (!dataSelection.getStructure().isOLAP()) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new java.lang.Object[0]);
                ConnectionUtil.LoggerErrorWithObjects(_logger, msg, dataSelection);
                throw new MetadataException(msg);
            }
            DataSourceCube dataCube = OLAPUtilities.findDataSourceCube(dataSelection);
            SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
            LogicalServerInterface logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
            SessionContextInterface sessionContext = businessModel.getSession();
            ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
            UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
            connection = ConnectionUtil.findConnection(recycler, dataSelection, logicalServer, userContext, policy, computationalLocale);
            try {
                ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPConnectionInfoUtil.class, connection);
                ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(connection);
                olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
            }
            catch (ExecutionException e) {
                if (aquireRelease) {
                    ConnectionResources.close(connection);
                }
                throw e;
            }
        }
        finally {
            if (disposeDataSelection && dataSelection != null) {
                dataSelection.dispose();
            }
        }
        return olapConnection;
    }

    public static ConnectionRecycler getConnectionRecycler(BusinessModel businessModel) throws IQueryServicesException {
        Preconditions.ensureNonNull(businessModel, "businessModel", _logger);
        SessionContextInterface sessionContext = businessModel.getSession();
        ConnectionRecycler connectionRecycler = null;
        try {
            connectionRecycler = ConnectionUtil.getConnectionRecycler(sessionContext);
        }
        catch (IQueryServicesException e) {
            ConnectionUtil.LoggerErrorWithObjects(_logger, e, businessModel);
            throw e;
        }
        return connectionRecycler;
    }

    @Nonnull
    public static DataSourceCube getCube(BusinessModel bm) throws GenerationException {
        List<DataSourceCube> dataSourceCubes = bm.getObjects(true, DataSourceCube.class);
        if (dataSourceCubes.isEmpty()) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadDataSource.txt", new java.lang.Object[0]);
            throw new GenerationException(formatter);
        }
        DataSourceCube cube = dataSourceCubes.get(0);
        return cube;
    }

    public static String getCubeName(BusinessModel businessModel) throws GenerationException {
        String cubeName = "";
        try {
            cubeName = OLAPConnectionInfoUtil.getCube(businessModel).getCubeName();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new GenerationException(e);
        }
        return cubeName;
    }

    @Nonnull
    public static LogicalServerInterface getLogicalServer(DataSourceCube dataSource) throws GenerationException {
        LogicalServerInterface lsi = null;
        if (dataSource != null) {
            try {
                Server server = dataSource.getServer();
                if (server instanceof SoftwareServer) {
                    lsi = ((SoftwareServer)server).getLogicalServerInterface();
                }
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyMetadataExceptionGetServer.txt", new java.lang.Object[0]);
                throw new GenerationException(formatter, (Throwable)e);
            }
        }
        if (lsi == null) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilNullServer.txt", new java.lang.Object[0]);
            throw new GenerationException(formatter);
        }
        return lsi;
    }

    public static OLAPConnectionResource getOLAPConnectionResource(DataSelection dataSelection, LogicalServerInterface logicalServer, RetrievalPolicy policy, Locale connectionLocale) throws GenerationException {
        OLAPConnectionResource olapConnection = null;
        try {
            olapConnection = OLAPDataSetFactory.getOLAPConnectionResource(dataSelection, logicalServer, policy, connectionLocale);
        }
        catch (ExecutionException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPStrategyExecutionExceptionGetServer.txt", new java.lang.Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, formatter.toString(), e, dataSelection, logicalServer, policy, connectionLocale);
            throw new GenerationException(formatter, (Throwable)e);
        }
        if (olapConnection == null) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("OLAPConnectionInfoUtilBadOLAPConnection.txt", new java.lang.Object[0]);
            ConnectionUtil.LoggerErrorWithObjects(_logger, formatter.toString(), dataSelection, logicalServer, policy, connectionLocale);
            throw new GenerationException(formatter);
        }
        return olapConnection;
    }

    public static UUIDSeqHolder getOpenResultSetsForISession(ISession_1_1 session2) throws IQueryServicesException {
        UUIDSeqHolder queryID = new UUIDSeqHolder();
        StringSeqHolder queryStmt = new StringSeqHolder();
        ResultSetTypeSeqHolder type1 = new ResultSetTypeSeqHolder();
        StringSeqHolder lastUpdateTime = new StringSeqHolder();
        LongSeqHolder size1 = new LongSeqHolder();
        LongSeqHolder totalCells = new LongSeqHolder();
        LongSeqHolder readCells = new LongSeqHolder();
        try {
            session2.ListQueries_2(queryID, queryStmt, type1, lastUpdateTime, size1, totalCells, readCells);
            MDXGenerationUtil.applyDebugStatement(queryStmt.toString(), OLAPConnectionInfoUtil.class);
        }
        catch (GenericError e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(queryStmt.toString());
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("PreFilterDLLGenerationExcGetOpenResults.txt", new java.lang.Object[0]);
            throw new IQueryServicesException(formatter, (Throwable)e);
        }
        if (queryID.value.length > 0) {
            MDXGenerationUtil.applyDebugStatement("Any open results using this query statment:" + queryStmt.toString(), OLAPConnectionInfoUtil.class);
        }
        return queryID;
    }

    public static boolean isOLAP(ConnectionInterface connection) {
        ConnectionInterface realConnection = connection;
        if (connection instanceof UserSessionConnectionDecorator) {
            realConnection = ((UserSessionConnectionDecorator)realConnection).getComponent();
        }
        boolean isOLAP = realConnection instanceof OLAPConnectionResource;
        return isOLAP;
    }

    public static boolean isOLAPServer(LogicalServerInterface logicalServer) throws RemoteException, ServiceException {
        String olapServerId = "f3f46472-1e31-11d5-87c2-00c04f38f9f6".toLowerCase();
        return logicalServer.getClassIdentifier().equals(olapServerId);
    }

    public static TupleElement newEmbeddedTupleElement(TupleElementInterface fromTupleElement) throws OLAPException {
        TupleElement emTupleElement = new TupleElement();
        emTupleElement.setChildCount(fromTupleElement.getChildCount());
        emTupleElement.setContinued(fromTupleElement.isContinued());
        emTupleElement.setDrilledDown(fromTupleElement.isDrilledDown());
        emTupleElement.setLabel(fromTupleElement.getLabel());
        emTupleElement.setLevelDepth(fromTupleElement.getLevelDepth());
        emTupleElement.setMaximumCoordinate(fromTupleElement.getMaximumCoordinate());
        emTupleElement.setMinimumCoordinate(fromTupleElement.getMinimumCoordinate());
        emTupleElement.setName(fromTupleElement.getName());
        emTupleElement.setProperties(fromTupleElement.getProperties());
        emTupleElement.setUniqueLevelName(fromTupleElement.getUniqueLevelName());
        emTupleElement.setTuple(fromTupleElement.getTuple());
        emTupleElement.setType(fromTupleElement.getType());
        return emTupleElement;
    }
}

