/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.OMAWrapper;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olapv2.step.StepManager;
import com.sas.iquery.util.AssociationListUtil;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.services.session.SessionContextInterface;
import com.sas.storage.olap.MetadataInterface;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MDXVariable {
    private static final String AGGREGATE = " AGGREGATE_TOTAL as '";
    private static final String MEMBER = "MEMBER ";
    private static final String SET = "SET ";
    private static final String SPECIAL_AGGRE = " AGGREGATE(";
    private static final String EMPTY_STRING = "";
    private static final String GROUP = " GROUP=";
    private boolean _aggregateOn = false;
    private boolean _coalesceEmpty = false;
    private boolean _disableTotal = false;
    private String _firstHierarchy = null;
    private int _counter = 0;
    private DataItem _dataItem;
    private DataSelection _dataSelection = null;
    private String _format = null;
    private boolean _isSpecialLabel = false;
    private String _label;
    private String _mdxExpression = null;
    private MetadataInterface _metadataI;
    private boolean _specialAggrOn = false;
    private StepManager _stepManager = null;
    private String _type;
    private static final Logger _logger = LogManager.getLogger(MDXVariable.class);
    private static final Logger _mdxLogger = LogManager.getLogger(MDXGenerationUtil.class);

    /*
     * Enabled aggressive block sorting
     */
    public MDXVariable(MetadataInterface metadataI, Object object, boolean isOnAxis, DataSelection dataSelection) throws GenerationException {
        this._metadataI = metadataI;
        this._dataItem = null;
        this._dataSelection = dataSelection;
        if (object instanceof DataItem) {
            this._dataItem = (DataItem)object;
        } else {
            if (!(object instanceof ExpressionInterface)) {
                Object[] msgArgs2 = new Object[]{object.toString(), IQDataServicesResourceBundle.getStringResource("MDXVariableHierNameBadObject.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                throw e;
            }
            List<DataItem> daList = ((ExpressionInterface)object).getResources(DataItem.class, 0);
            if (daList.size() <= 0) {
                Object[] msgArgs2 = new Object[]{object.toString(), IQDataServicesResourceBundle.getStringResource("MDXVariableHierNameNoDataItem.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                throw e;
            }
            this._dataItem = daList.get(0);
        }
        StructureOfDataItem structure = this._dataItem.getStructure();
        if (structure.equals(StructureOfDataItem.STRUCTURE_MEASURE) || structure != StructureOfDataItem.STRUCTURE_MEASURE && !isOnAxis) {
            this._type = MEMBER;
            if (structure == StructureOfDataItem.STRUCTURE_MEASURE) return;
            if (isOnAxis) return;
            this._aggregateOn = true;
            return;
        }
        this._type = SET;
    }

    public int getCounter() {
        return this._counter;
    }

    public String getLabel() {
        return this._label;
    }

    public String getMDXExpression() {
        BusinessModel busModel;
        String returnValue = this._mdxExpression;
        if (this._dataSelection == null && this._dataItem != null && (busModel = this._dataItem.getBusinessModel()) instanceof DataSelection) {
            this._dataSelection = (DataSelection)busModel;
        }
        if (this._dataSelection != null && this._dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_CALCULATED_MEMBERS)) {
            boolean hasCalculatedMembers;
            block7: {
                hasCalculatedMembers = false;
                ExpressionInterface expression = this._dataItem.getExpression();
                if (!(expression instanceof ResourceAwareStringExpression) && expression instanceof Hierarchy) {
                    Hierarchy hierarchy = (Hierarchy)expression;
                    try {
                        if (hierarchy.getCalculatedMembers().size() > 0) {
                            hasCalculatedMembers = true;
                        }
                    }
                    catch (MetadataException e) {
                        if (!_mdxLogger.isEnabled(Level.ERROR)) break block7;
                        _mdxLogger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (hasCalculatedMembers) {
                StringBuilder coreExpression = new StringBuilder();
                coreExpression.append("AddCalculatedMembers(").append(this._mdxExpression).append(")");
                returnValue = coreExpression.toString();
            }
        }
        return returnValue;
    }

    public String getMDXForFilter() throws GenerationException {
        StringBuilder MDXClause = new StringBuilder(5000);
        MDXClause.append(MDXGenerationUtil.NEWLINE).append(this._type).append(EMPTY_STRING).append(this._label).append(" AS").append(MDXGenerationUtil.NEWLINE).append("     ").append("'");
        SessionContextInterface sessionContext = this._dataSelection.getSession();
        Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(sessionContext);
        try {
            DataSourceCube dataCube = (DataSourceCube)this._dataSelection.getEffectiveDataSources().get(0);
            viewerLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, viewerLocale, this._dataSelection.getComputationalLocale());
        }
        catch (MetadataException e) {
            throw new GenerationException(e, e.getLocalizedMessage());
        }
        if (this._mdxExpression == null) {
            if (this._metadataI != null) {
                this._mdxExpression = BusinessQueryOLAPUtil.buildOLAPExpression(this._dataItem, this._metadataI);
            } else {
                Object[] msgArgs2 = new Object[]{this._dataItem.getLabel(), IQDataServicesResourceBundle.getStringResource("MDXVariableNoMetaI.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                throw e;
            }
        }
        if (this._stepManager != null) {
            this._mdxExpression = this._stepManager.generateMDX(this._dataSelection, this._mdxExpression);
        }
        if (this._mdxExpression.length() > 0) {
            MDXClause.append(MDXGenerationUtil.NEWLINE).append(this._mdxExpression).append("' ");
        }
        if (_logger.isInfoEnabled()) {
            _logger.info(MDXClause.toString());
        }
        return MDXClause.toString();
    }

    public String getMDXPhrase() throws GenerationException {
        StringBuilder MDXClause = new StringBuilder(5000);
        _logger.info("MDXPhrase being built");
        if (!this._aggregateOn) {
            MDXClause.append(MDXGenerationUtil.NEWLINE).append(this._type).append(EMPTY_STRING).append(this._label).append(" AS").append(MDXGenerationUtil.NEWLINE).append("     ").append("'");
        }
        if (this._mdxExpression == null) {
            if (this._metadataI != null) {
                this._mdxExpression = BusinessQueryOLAPUtil.buildOLAPExpression(this._dataItem, this._metadataI);
            } else {
                Object[] msgArgs2 = new Object[]{this._dataItem.getLabel(), IQDataServicesResourceBundle.getStringResource("MDXVariableNoMetaI.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                throw e;
            }
        }
        if (this._stepManager != null) {
            this._mdxExpression = this._stepManager.generateMDX(this._dataSelection, this._mdxExpression);
        }
        this._mdxExpression = MDXGenerationUtil.repairQuotes(this._mdxExpression);
        if (this._dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE) && this._coalesceEmpty) {
            StringBuilder tempBuilder = new StringBuilder();
            tempBuilder.append("CoalesceEmpty(").append(this._mdxExpression).append(", 999999999999999999)");
            this._mdxExpression = tempBuilder.toString();
            tempBuilder.delete(0, tempBuilder.length());
        }
        if (this._mdxExpression.length() > 0) {
            String propertyOption;
            if (!this._aggregateOn && !this._specialAggrOn) {
                MDXClause.append(this._mdxExpression).append("'");
            } else if (this._aggregateOn && !this._specialAggrOn) {
                MDXClause.append(MDXGenerationUtil.NEWLINE).append(AGGREGATE).append(this._mdxExpression).append("' ");
            } else if (this._specialAggrOn) {
                MDXClause.append(MDXGenerationUtil.NEWLINE).append(SPECIAL_AGGRE).append(this._mdxExpression).append(")' ");
            }
            if (this._format != null && this._format.length() > 0) {
                MDXClause.append(", FORMAT_STRING=\"").append(this._format).append("\"");
            }
            List<BusinessGroup> effectiveMeasureGroupsForDI = this._dataSelection.getEffectiveGroupsContaining(this._dataItem, BusinessGroup.Type.GROUPED_MEASURES);
            boolean groupsActiveForDI = false;
            if (effectiveMeasureGroupsForDI.size() >= 1) {
                groupsActiveForDI = true;
            }
            if ((propertyOption = this.honorAnyMemberPropertiesAppliedToCalculatedMeasure()).length() > 0) {
                MDXClause.append(", ").append(propertyOption);
            }
            String currentMDXClause = MDXClause.toString();
            String mdxWithDisabledClause = MDXGenerationUtil.buildDisabledTotalsClause(currentMDXClause, this._disableTotal, this._firstHierarchy, this._dataSelection, this._dataItem);
            MDXClause.setLength(0);
            MDXClause.append(mdxWithDisabledClause);
            if (this._dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_MEASURE_GROUPING)) {
                if (groupsActiveForDI) {
                    BusinessGroup gp = effectiveMeasureGroupsForDI.get(0);
                    String gpLabel = MDXGenerationUtil.repairQuotes(gp.getLabel());
                    MDXClause.append(",").append(GROUP).append("'").append(gpLabel).append("'");
                } else {
                    String groupProperty = this.honorUserDefinedMemberPropertiesAppliedToCalculatedMeasure();
                    if (groupProperty.length() > 0) {
                        MDXClause.append(", ");
                        MDXClause.append(groupProperty);
                    }
                }
            }
            if (_logger.isInfoEnabled()) {
                _logger.info(MDXClause.toString());
            }
        }
        return MDXClause.toString();
    }

    protected String getType() {
        return this._type;
    }

    private String honorAnyMemberPropertiesAppliedToCalculatedMeasure() {
        OMAWrapper wrapper;
        CMetadata omrMetadataObjectForMeasure;
        String propertyOption = EMPTY_STRING;
        ExpressionInterface expression = this._dataItem.getExpression();
        if (expression instanceof OMAWrapper && (omrMetadataObjectForMeasure = (wrapper = (OMAWrapper)((Object)expression)).getOMAObject()) instanceof CalculatedMeasure) {
            StringBuilder optionBuff;
            block6: {
                Root rootMetadataObject = (Root)omrMetadataObjectForMeasure;
                optionBuff = new StringBuilder();
                try {
                    List<Property> properties = AssociationListUtil.filteredSnapshot(rootMetadataObject.getProperties(true), Property.class);
                    int size = properties.size();
                    for (int i = 0; i < size; ++i) {
                        Property olapPropertyOption = properties.get(i);
                        String defaultValue = olapPropertyOption.getDefaultValue();
                        String propertyName = olapPropertyOption.getPropertyName();
                        if (propertyName.trim().length() <= 0) continue;
                        optionBuff.append(propertyName).append(" = ").append(defaultValue);
                        if (i + 1 >= size) continue;
                        optionBuff.append(",");
                    }
                }
                catch (RemoteException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                catch (MdException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block6;
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            propertyOption = optionBuff.toString();
        }
        return propertyOption;
    }

    private String honorUserDefinedMemberPropertiesAppliedToCalculatedMeasure() {
        StringBuilder optionBuff;
        block3: {
            optionBuff = new StringBuilder();
            try {
                OMACalculatedMeasure calcMeasure;
                String groupLabel;
                ExpressionInterface expression = this._dataItem.getExpression();
                if (expression instanceof OMACalculatedMeasure && (groupLabel = (calcMeasure = (OMACalculatedMeasure)expression).getGroupLabel()).trim().length() > 0) {
                    optionBuff.append("GROUP").append(" = ").append("'").append(groupLabel).append("'");
                }
            }
            catch (MetadataException e) {
                if (!_logger.isEnabled(Level.ERROR)) break block3;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return optionBuff.toString();
    }

    public boolean isAggregateOn() {
        return this._aggregateOn;
    }

    public boolean isSpecialAggregateOn() {
        return this._specialAggrOn;
    }

    public void setAggregateOn(boolean aggregateOn) {
        this._aggregateOn = aggregateOn;
    }

    public void setCoalesceEmpty(boolean coalesceEmptyOn) {
        this._coalesceEmpty = coalesceEmptyOn;
    }

    public void setDisableTotal(boolean disabledTotal) {
        this._disableTotal = disabledTotal;
    }

    public void setFirstAxisDimension(String firstAxisDimension) {
        this._firstHierarchy = firstAxisDimension;
    }

    public void setCounter(int counter) {
        this._counter = counter;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public void setLabel(String hierarchyName) {
        String filler;
        StringBuilder label;
        block9: {
            label = new StringBuilder(1000);
            if (hierarchyName == null) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXVariableHierNameNotUsed.txt"));
                }
                this._label = this._dataItem.getLabel();
                return;
            }
            this._label = this._dataItem.getLabel();
            filler = EMPTY_STRING;
            if (this._counter > 1 || this._isSpecialLabel || this._label.trim().length() == 0) {
                filler = "&" + this._counter;
            } else {
                ExpressionInterface expression = this._dataItem.getExpression();
                if (expression instanceof Measure && !(expression instanceof ResourceAwareStringExpression) && !(expression instanceof TimeExpressionMeasure) && !(expression instanceof FractionOfTotalExpression)) {
                    Measure measure = (Measure)expression;
                    try {
                        this._label = measure.getMeasureName();
                    }
                    catch (MetadataException e) {
                        if (!_logger.isEnabled(Level.ERROR)) break block9;
                        _logger.error(e.getLocalizedMessage() + ":" + this._label, (Throwable)e);
                    }
                }
            }
        }
        if (this._type.equals(MEMBER)) {
            label.append(hierarchyName).append(".[").append(filler).append(this._label).append("] ");
        } else {
            label.append("[").append(filler).append(this._label).append("] ");
        }
        this._label = label.toString();
    }

    public void setLabel(String hierarchyName, String labelOfDataItem) {
        StringBuilder label = new StringBuilder(1000);
        if (hierarchyName == null) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("MDXVariableHierNameNotUsed.txt"));
            }
            this._label = this._dataItem.getLabel();
            return;
        }
        String diLabel = this._label = labelOfDataItem;
        if (this._type.equals(MEMBER)) {
            if (this._label.length() == 0) {
                diLabel = "BIQTempMem20030402";
            }
            label.append(hierarchyName).append(".[DATAITEM_").append(diLabel).append("]");
        } else {
            if (diLabel.length() == 0) {
                diLabel = "BIQTempSet20030402";
            }
            label.append("[DATAITEM_").append(diLabel).append("]");
        }
        this._label = label.toString();
        _logger.info(this._label);
    }

    public void setMDXExpression(String mdxExpression) {
        this._mdxExpression = mdxExpression;
    }

    public void setSpecialAggregateOn(boolean aggregateOn) {
        this._specialAggrOn = aggregateOn;
    }

    public void setSpecialLabel(boolean isSpecialLabel) {
        this._isSpecialLabel = isSpecialLabel;
    }

    public void setSteps(StepManager sm, DataSelection ds) {
        this._stepManager = sm;
        this._dataSelection = ds;
    }
}

