/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iom.SASIOMCommon.IServerStatus;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataretrieval.convenience.ByGroupCreator;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.AbstractEnumerationObject;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression_Between;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.Member;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.step.DataBasedFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.StepManager;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import com.sas.util.ChainedException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Object;

public class MDXGenerationUtil {
    public static final String DEFAULT_CONSTRUCTOR_BEHAVIOR = "DEFAULT_CONSTRUCTOR_BEHAVIOR";
    public static final String IQ_IGNORE_STATE_OF_ISESSION = "IGNOREISESSION";
    public static final String IQ_INTERNAL_GENERATION = "GENERATION";
    public static final String LEFT_PARENTHESIS = "( ";
    public static final String MDX_LEFT_BRACKET = "{ ";
    public static final String MDX_LEFT_SET_SEPERATOR = "[";
    public static final String MDX_RIGHT_BRACKET = "} ";
    public static final String MDX_RIGHT_SET_SEPERATOR = "]";
    public static final String MEMBER = ".MEMBERS";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String RIGHT_PARENTHESIS = " )";
    public static final String TABOVER = "     ";
    public static final String XJOIN = "CROSSJOIN";
    private static final String DISABLEALLTOTAL = " VISUALTOTALS_BEHAVIOR=(BLANK,";
    private static final String DISABLESUBTOTAL = " VISUALTOTALS_BEHAVIOR=(BLANK_SUBTOTALS,";
    private static final String DISABLETOTAL = " VISUALTOTALS_BEHAVIOR=(BLANK_TOTALS,";
    private static final String VERSION_NEW_MDXGENERATION_BEGAN = "9.02";
    private static final String WARNING_GET_SERVER_VERSION = "OLAPStrategyRemoteExceptionGetServVer.txt";
    private static final Logger _logger = LogManager.getLogger(MDXGenerationUtil.class);
    private static final Logger _ovLogger = LogManager.getLogger(OLAPValues.class);
    private static final Level ERROR_LEVEL = Level.ERROR;

    public static String addAllMemberToAddParents(DataItem resultItem, String clause, OLAPValues olapValues) {
        StringBuilder allDataItem = new StringBuilder(500);
        if (olapValues.doesFilterDDLHaveTotal(resultItem)) {
            String allDataItemLabel = olapValues.getAllTotalLabelForDDL(resultItem);
            if (allDataItemLabel != null && allDataItemLabel.length() > 0) {
                allDataItem.append("{{").append(allDataItemLabel).append("},").append(clause).append("}");
            } else {
                allDataItem.append(clause);
            }
        } else {
            allDataItem.append(clause);
        }
        return allDataItem.toString();
    }

    public static List<DataItem> getListOfAllDataItemsHiddenAndShown(Iterator<java.lang.Object> iterator) {
        ArrayList<DataItem> dataItemsFound = new ArrayList<DataItem>();
        while (iterator.hasNext()) {
            DataItem da;
            java.lang.Object obj = iterator.next();
            if (obj instanceof DataItemReference) {
                da = ((DataItemReference)obj).getBaseDataItem();
                dataItemsFound.add(da);
                continue;
            }
            if (obj instanceof DataItem) {
                da = (DataItem)obj;
                dataItemsFound.add(da);
                continue;
            }
            if (!(obj instanceof ExpressionInterface)) continue;
            ExpressionInterface e = (ExpressionInterface)obj;
            List<DataItem> daInExpression = e.getResources(DataItem.class, 0);
            for (int a = 0; a < daInExpression.size(); ++a) {
                DataItem da2 = daInExpression.get(a);
                dataItemsFound.add(da2);
            }
        }
        return dataItemsFound;
    }

    public static List<String> getAllLevelsForDimensionOnAxis(Role role, BusinessQuery model) throws MetadataException {
        ArrayList<String> returnList = new ArrayList<String>();
        List<DataItem> dataItems = model.getResultItems(role);
        for (DataItem dataItem : dataItems) {
            Hierarchy omaH;
            ExpressionInterface expression = dataItem.getExpression();
            if (!(expression instanceof Hierarchy) || (omaH = (Hierarchy)expression).isUnresolved()) continue;
            returnList.add(omaH.getAllMember());
        }
        return returnList;
    }

    public static String getLabelForSelectedSortedMeasure(List<java.lang.Object> sortCriteria, OLAPValues olapValues) {
        ArrayList<java.lang.Object> measuresNames = new ArrayList<java.lang.Object>();
        for (int i = 0; i < sortCriteria.size(); ++i) {
            java.lang.Object obj = sortCriteria.get(i);
            if (obj instanceof List) {
                List objList = (List)obj;
                for (int x = 0; x < objList.size(); ++x) {
                    java.lang.Object o = objList.get(x);
                    if (!(o instanceof ExpressionInterface) && !(o instanceof DataItem)) continue;
                    measuresNames.add(o);
                }
                continue;
            }
            if (obj instanceof String[]) {
                String[] names;
                if (i != 0 || (names = (String[])obj).length <= 0) continue;
                for (int i1 = 0; i1 < names.length; ++i1) {
                    String it1 = names[i1];
                    if (it1 == null || it1.isEmpty()) continue;
                    measuresNames.add(it1);
                }
                continue;
            }
            if (!(obj instanceof ExpressionInterface) && !(obj instanceof DataItem)) continue;
            measuresNames.add(obj);
        }
        String measureName = null;
        int endOfMeasures = measuresNames.size();
        for (int i = 0; i < endOfMeasures; ++i) {
            java.lang.Object obj = measuresNames.get(i);
            if (obj instanceof String) {
                measureName = (String)obj;
                measureName = measureName.substring(measureName.lastIndexOf(".[") + 1);
                measureName = measureName.replace('[', ' ');
                measureName = measureName.replace(']', ' ');
                measureName = measureName.trim();
                break;
            }
            if (obj instanceof DataItem) {
                ExpressionInterface expression = ((DataItem)obj).getExpression();
                if (expression instanceof FractionOfTotalExpression) {
                    try {
                        measureName = MDXGenerationUtil.determineLabelForExpressionOrPercentTotalMeasures(expression, olapValues);
                    }
                    catch (GenerationException e) {
                        if (!_logger.isEnabled(ERROR_LEVEL)) break;
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    break;
                }
                measureName = ((DataItem)obj).getLabel();
                break;
            }
            if (!(obj instanceof ExpressionInterface)) continue;
            try {
                measureName = MDXGenerationUtil.determineLabelForExpressionOrPercentTotalMeasures((ExpressionInterface)obj, olapValues);
                break;
            }
            catch (GenerationException e) {
                if (!_logger.isEnabled(ERROR_LEVEL)) continue;
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return measureName;
    }

    public static boolean isAllLevelsSelectedInSort(List<java.lang.Object> sortCriteria, List<String> dimensionWithAllMembers) {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (int i = 0; i < sortCriteria.size(); ++i) {
            java.lang.Object obj = sortCriteria.get(i);
            if (obj instanceof List) {
                List objList = (List)obj;
                for (int x = 0; x < objList.size(); ++x) {
                    java.lang.Object o = objList.get(x);
                    if (!(o instanceof String)) continue;
                    memberNames.add((String)o);
                }
                continue;
            }
            if (obj instanceof String[]) {
                String[] names;
                if (i != 1 || (names = (String[])obj).length <= 0) continue;
                for (int a = 0; a < names.length; ++a) {
                    String _it2 = names[a];
                    if (_it2 == null || _it2.isEmpty()) continue;
                    memberNames.add(_it2);
                }
                continue;
            }
            if (!(obj instanceof String)) continue;
            memberNames.add((String)obj);
        }
        if (memberNames.isEmpty()) {
            return false;
        }
        for (String s : memberNames) {
            if (dimensionWithAllMembers.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean doesFilterDataItemMatchResultItemBeingRead(ExpressionInterface exprFilter, DataItem resultItem) {
        ConditionalExpression baseExprFilter;
        ExpressionInterface filterDataItem = null;
        boolean found = false;
        if (exprFilter instanceof BaseFilterExpression) {
            baseExprFilter = (BaseFilterExpression)exprFilter;
            filterDataItem = ((BaseFilterExpression)baseExprFilter).getWhatToCompare();
        } else {
            if (exprFilter instanceof MultipleConditionalExpression) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationBadMultiFilter.txt"));
                }
                return false;
            }
            if (exprFilter instanceof DataBasedFilterExpression_Between) {
                baseExprFilter = (DataBasedFilterExpression_Between)exprFilter;
                filterDataItem = ((DataBasedFilterExpression_Between)baseExprFilter).getWhatToFilter();
            } else {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(exprFilter.toString());
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationBadFilterTypes.txt"));
                }
                return false;
            }
        }
        if (resultItem.equals(filterDataItem)) {
            return true;
        }
        while (filterDataItem instanceof DataItemReference) {
            filterDataItem = ((DataItemReference)filterDataItem).getBaseDataItem();
        }
        DataItem resultDataItem = resultItem;
        while (resultDataItem instanceof DataItemReference) {
            resultDataItem = ((DataItemReference)resultDataItem).getBaseDataItem();
        }
        if (resultDataItem.equals(filterDataItem)) {
            return true;
        }
        return found;
    }

    public static String repairQuotes(String var) {
        String returnValue = var;
        String single_quote = "'";
        if (var.indexOf(single_quote) > -1) {
            returnValue = var.replace(single_quote, "''");
        }
        return returnValue;
    }

    public static String determineLabelForExpressionOrPercentTotalMeasures(ExpressionInterface expression, OLAPValues olapValues) throws GenerationException {
        StringBuilder coreExpression = new StringBuilder();
        if (!MDXGenerationUtil.isMeasure(expression)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataItemDataBasedDataItemMustBeMeasure.txt", new java.lang.Object[0]);
            throw new GenerationException(mft);
        }
        ExpressionInterface expressionOfDataItem = null;
        expressionOfDataItem = expression instanceof DataItem ? ((DataItem)expression).getExpression() : expression;
        if (expressionOfDataItem instanceof FractionOfTotalExpression) {
            FractionOfTotalExpression fractionMeasure = (FractionOfTotalExpression)expressionOfDataItem;
            DataItem numerator = fractionMeasure.getNumerator();
            coreExpression.append(numerator.getLabel());
        } else {
            String coreMDX = MDXGenerationUtil.buildCoreExpression(expression, olapValues);
            coreExpression.append(coreMDX);
        }
        String returnValue = coreExpression.toString();
        returnValue = returnValue.substring(returnValue.lastIndexOf(".[") + 1);
        returnValue = returnValue.replace('[', ' ');
        returnValue = returnValue.replace(']', ' ');
        returnValue = returnValue.trim();
        return returnValue;
    }

    public static void applyDebugStatement(String string, Class<?> thisClass) {
        Logger clsLogger = LogManager.getLogger(thisClass);
        if (clsLogger.isDebugEnabled()) {
            clsLogger.debug(string);
        }
    }

    public static String applyFilterAttributes(String value, MemberTuple MemberTuple2) {
        StringBuilder valueWithAttributes = new StringBuilder();
        if (MemberTuple2.isIncludeAllDescendents()) {
            valueWithAttributes.append(NEWLINE).append("Descendants(").append(value).append(")");
        } else {
            valueWithAttributes.append(NEWLINE).append(value);
        }
        return valueWithAttributes.toString();
    }

    public static boolean areListsDifferent(List<java.lang.Object> input1, List<java.lang.Object> input2) {
        boolean isDifferent = false;
        if (input1.size() == 0 && input2.size() == 0) {
            return isDifferent;
        }
        if (input1.size() != input2.size()) {
            isDifferent = true;
        } else {
            Iterator<java.lang.Object> iterator = input1.iterator();
            int count = 0;
            while (iterator.hasNext()) {
                java.lang.Object objectInList1 = iterator.next();
                java.lang.Object objectInList2 = input2.get(count);
                ++count;
                if (objectInList1 instanceof String && objectInList2 instanceof String) {
                    if (objectInList1.toString().equalsIgnoreCase(objectInList2.toString())) continue;
                    isDifferent = true;
                    break;
                }
                if (objectInList1.getClass().equals(objectInList2.getClass())) continue;
                isDifferent = true;
                break;
            }
        }
        return isDifferent;
    }

    protected static boolean BooleanObjectValue(java.lang.Object value) {
        return value.equals(Boolean.TRUE);
    }

    protected static Boolean BooleanStringValueOf(String value) {
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected static Boolean BooleanValue(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String buildAsClauseForOrphanedFilter(FilterItem filter, DataItem filterDataItem, DataSelection model, OLAPValues olapValues) throws GenerationException {
        StringBuilder asClause = new StringBuilder();
        String coreExpression = MDXGenerationUtil.buildMembersDefinition(filterDataItem, olapValues, model);
        ExpressionInterface filterExpression = filter.getExpression();
        StepInterface step = MDXGenerationUtil.generateStepsForFilterExpression(filterExpression);
        if (step == null) {
            return coreExpression;
        }
        String filterId = "";
        try {
            filterId = filter.getID();
        }
        catch (InvalidIDException iE) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(filter.toString());
            }
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(msF.toString());
            }
            throw new GenerationException((MessageFormatter)msF, (Throwable)iE);
        }
        if (filterId == null) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(filter.toString());
            }
            throw new GenerationException(msF);
        }
        boolean isOldByGroup = false;
        if (filterExpression instanceof MemberFilterExpression && filterId.length() > 0) {
            isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(filterExpression, model, filterId, filter);
        }
        if (step instanceof DataItemMemberFilter) {
            if (!(filterExpression instanceof SlicerFilterExpression) && !isOldByGroup) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilBadMemFilter.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            asClause.append(MemberFilter.getMDXExpression(model, coreExpression, (DataItemMemberFilter)step));
        } else if (step instanceof DataItemDataBasedFilter) {
            StringBuilder filterExp = new StringBuilder();
            filterExp.append(" { FILTER({").append(coreExpression).append("}, ");
            asClause.append(DataBasedFilter.getMDXExpression(model, filterExp.toString(), (DataItemDataBasedFilter)step, olapValues)).append(") }");
        } else if (step instanceof CompoundStep) {
            StepManager manager = new StepManager((CompoundStep)step);
            manager.setOLAPValue(olapValues);
            asClause.append(manager.generateMDX(model, coreExpression));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Building AS Clause for orphaned filter: " + asClause.toString());
        }
        return asClause.toString();
    }

    public static String buildCacheKey(BusinessModel businessModel, Locale cacheAsLocale, String constructor) throws GenerationException {
        String fullKey = null;
        try {
            String key1 = businessModel.getSession().getUserContext().getName();
            String key2 = OLAPConnectionInfoUtil.getCubeName(businessModel);
            String key3 = MDXGenerationUtil.buildFilterKey(businessModel, constructor);
            if (key3.trim().length() == 0) {
                key3 = "None";
            }
            if (cacheAsLocale == null) {
                cacheAsLocale = LocaleUtilities.getDefaultComputationalLocale(businessModel);
            }
            String key4 = cacheAsLocale == null || cacheAsLocale.toString().trim().length() == 0 ? "" : cacheAsLocale.toString().trim();
            fullKey = key1 + ':' + key2 + ':' + key3 + ':' + key4;
        }
        catch (RemoteException e) {
            throw new GenerationException(e, IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.badKey.txt"));
        }
        return fullKey;
    }

    public static String buildCoreExpression(ExpressionInterface expression, OLAPValues olapValues) throws GenerationException {
        String returnValue = "";
        try {
            DataSelection dataSelection = olapValues.getDataSelection();
            if (expression instanceof Measure) {
                String measureName = null;
                returnValue = measureName = ((Measure)expression).getUniqueName();
            } else if (expression instanceof ConstantExpression || expression instanceof StringExpression || expression instanceof Prompt) {
                returnValue = MDXGenerationUtil.getExpressionValue(expression, dataSelection, null);
            } else {
                MDXVariable mdxVar = (MDXVariable)olapValues.getOLAPValue((DataItem)expression, OLAPItemType.MDXVARIABLE);
                if (expression instanceof DataItem) {
                    ExpressionInterface expr;
                    StructureOfDataItem structure = ((DataItem)expression).getStructure();
                    BusinessModel model = ((DataItem)expression).getBusinessModel();
                    Role role = Role.COLUMN;
                    if (model instanceof DataSelection) {
                        role = ((DataSelection)model).getResultItemRole((DataItem)expression);
                    }
                    if (role == null) {
                        role = Role.COLUMN;
                    }
                    if (structure == StructureOfDataItem.STRUCTURE_MEASURE && (expr = ((DataItem)expression).getExpression()) instanceof Measure) {
                        returnValue = ((Measure)expr).getUniqueName() + " ";
                        return returnValue;
                    }
                }
                if (mdxVar != null) {
                    returnValue = mdxVar.getLabel();
                } else {
                    MDXVariable mdxVariable = new MDXVariable(olapValues.getMetadataInterface(), (DataItem)expression, true, dataSelection);
                    mdxVariable.setLabel(olapValues.getMeasureCaption());
                    returnValue = mdxVariable.getLabel();
                }
            }
        }
        catch (MetadataException e) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt")};
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(expression.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(msF.toString());
            }
            throw new GenerationException((MessageFormatter)msF, (Throwable)e);
        }
        return returnValue;
    }

    public static List<java.lang.Object> buildDataItemListInOtherDataItems(DataSelection model, List<DataItem> resultItems) {
        String label;
        ArrayList<DataItem> dataItemInDataItemsRelativeToOther = new ArrayList<DataItem>();
        ArrayList<String> dataItemInDataItems = new ArrayList<String>();
        for (DataItem item : resultItems) {
            ExpressionInterface expressionInterface = item.getExpression();
            label = item.getLabel();
            if (expressionInterface == null || !(expressionInterface instanceof OLAPResourceAwareStringExpression) && !(expressionInterface instanceof TimeExpressionMeasure) && !(expressionInterface instanceof FractionOfTotalExpression)) continue;
            dataItemInDataItems.add(label);
        }
        for (DataItem item : resultItems) {
            java.lang.Object var6_8 = null;
            ExpressionInterface expression = item.getExpression();
            if (expression instanceof OLAPResourceAwareStringExpression) {
                List<DataItem> list = item.getResources(DataItem.class, 2);
                for (DataItem itemA : list) {
                    if (itemA.getLabel().equals(item.getLabel())) continue;
                    dataItemInDataItemsRelativeToOther.add(itemA);
                }
                continue;
            }
            if (expression instanceof TimeExpressionMeasure) {
                List<DataItem> list = item.getResources(DataItem.class, 2);
                for (DataItem itemA : list) {
                    dataItemInDataItemsRelativeToOther.add(itemA);
                }
                continue;
            }
            if (!(expression instanceof FractionOfTotalExpression)) continue;
            FractionOfTotalExpression fTE = (FractionOfTotalExpression)expression;
            dataItemInDataItemsRelativeToOther.add(fTE.getNumerator());
        }
        ArrayList<java.lang.Object> dataItemThatAreContainsInOtherDataItems = new ArrayList<java.lang.Object>();
        for (java.lang.Object e : dataItemInDataItemsRelativeToOther) {
            int i;
            java.lang.Object o;
            label = null;
            if (e instanceof DataItem) {
                label = ((DataItem)e).getLabel();
            }
            if (label == null || !dataItemInDataItems.contains(label) || dataItemThatAreContainsInOtherDataItems.contains(o = dataItemInDataItems.get(i = dataItemInDataItems.indexOf(label)))) continue;
            dataItemThatAreContainsInOtherDataItems.add(o);
        }
        dataItemInDataItems.clear();
        dataItemInDataItemsRelativeToOther.clear();
        return dataItemThatAreContainsInOtherDataItems;
    }

    public static List<DataItem> buildDataItemListInSort(DataSelection model, boolean allSort) {
        java.lang.Object item;
        ArrayList<DataItem> allDataItemInAnySort = new ArrayList<DataItem>();
        ArrayList<String[]> morelist = new ArrayList<String[]>();
        Iterator<java.lang.Object> listItA = model.getSortCriteria(Role.ROW).listIterator();
        while (listItA.hasNext()) {
            item = listItA.next();
            if (item instanceof DataItem) {
                allDataItemInAnySort.add((DataItem)item);
                continue;
            }
            if (!(item instanceof List)) continue;
            morelist.addAll((List)item);
        }
        listItA = model.getSortCriteria(Role.COLUMN).listIterator();
        while (listItA.hasNext()) {
            item = listItA.next();
            if (item instanceof DataItem) {
                allDataItemInAnySort.add((DataItem)item);
                continue;
            }
            if (!(item instanceof List)) continue;
            morelist.addAll((List)item);
        }
        if (allSort) {
            for (DataItem daItem : model.getResultItems()) {
                morelist.addAll(daItem.getSortCriteria());
            }
        }
        listItA = morelist.listIterator();
        while (listItA.hasNext()) {
            item = listItA.next();
            if (!(item instanceof DataItem)) continue;
            allDataItemInAnySort.add((DataItem)item);
        }
        return allDataItemInAnySort;
    }

    public static List<DataItem> buildDataItemListInSteps(DataSelection model, boolean includeDataItemsInSteps) {
        ArrayList<DataItem> dataItemInSteps = new ArrayList<DataItem>();
        ArrayList<StepInterface> allStepInQuery = new ArrayList<StepInterface>();
        List<StepInterface> stepsInColumn = model.getSteps(Role.COLUMN);
        List<StepInterface> stepsInRow = model.getSteps(Role.ROW);
        if (!stepsInColumn.isEmpty()) {
            allStepInQuery.addAll(stepsInColumn);
        }
        if (!stepsInRow.isEmpty()) {
            allStepInQuery.addAll(stepsInRow);
        }
        for (StepInterface step : allStepInQuery) {
            dataItemInSteps.addAll(step.getResources(DataItem.class, 65535));
        }
        if (!includeDataItemsInSteps) {
            return dataItemInSteps;
        }
        for (DataItem resultItem : model.getResultItems()) {
            List<StepInterface> steps;
            if (!resultItem.hasSteps() || (steps = resultItem.getSteps()).size() <= 0) continue;
            dataItemInSteps.add(resultItem);
            for (StepInterface resultStep : steps) {
                dataItemInSteps.addAll(resultStep.getResources(DataItem.class, 65535));
            }
        }
        return dataItemInSteps;
    }

    private static String buildFilterKey(BusinessModel businessModel, String constructor) throws GenerationException {
        String key3 = businessModel.getID();
        if (businessModel instanceof LookThroughDataSelection || constructor.equalsIgnoreCase(IQ_INTERNAL_GENERATION)) {
            DataSelection model = null;
            if (businessModel instanceof DataSelection) {
                model = (DataSelection)businessModel;
                ArrayList<String> filterKeyList = new ArrayList<String>();
                for (FilterItem filterItemDefinition : model.getEffectiveFilters()) {
                    ExpressionInterface filterExpression = MDXGenerationUtil.getRealEffectiveFilter(filterItemDefinition, model);
                    if (!(filterExpression instanceof TimeFilterNParallelPeriodsExpression) && !(filterExpression instanceof TimeFilterNPeriodsExpression) && !(filterExpression instanceof TimeFilterFirstLastPeriodsExpression) && !(filterExpression instanceof TimeRangeFilterExpression) && !(filterExpression instanceof MemberFilterExpression)) continue;
                    String filLabel = filterItemDefinition.getLabel();
                    if (filLabel == null || filLabel.length() == 0) {
                        filLabel = filterItemDefinition.getIntraModelID();
                    }
                    filterKeyList.add(filLabel);
                }
                StringBuilder sb = new StringBuilder(500);
                if (filterKeyList.size() > 0) {
                    sb.append('{');
                    ListIterator listIterator = filterKeyList.listIterator();
                    sb.append((String)listIterator.next());
                    while (listIterator.hasNext()) {
                        sb.append(',');
                        sb.append((String)listIterator.next());
                    }
                    sb.append('}');
                }
                key3 = constructor.equalsIgnoreCase(IQ_INTERNAL_GENERATION) && filterKeyList.size() > 0 ? "IQINTERNALFILTER" + sb.toString().trim() : (filterKeyList.size() > 0 ? sb.toString().trim() : "None");
                filterKeyList = null;
            } else {
                key3 = "None";
            }
        } else {
            key3 = "None";
        }
        return key3;
    }

    /*
     * Exception decompiling
     */
    public static String buildMDXOnFlyExpression(DataItem dataItem) throws GenerationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 30[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String buildMemberQuery(List<BusinessModelResource> resources, String exprText, String cubeName, BusinessModel businessModel) throws GenerationException {
        String dimName = null;
        OlapItem measure = null;
        for (BusinessModelResource resource : resources) {
            if (!(resource instanceof Measure)) continue;
            measure = (Measure)resource;
            break;
        }
        if (measure != null) {
            try {
                dimName = measure.getDimensionName();
                dimName = MDX_LEFT_SET_SEPERATOR + dimName + MDX_RIGHT_SET_SEPERATOR;
            }
            catch (MetadataException me) {
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilMetaExcQuery.txt")};
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(measure.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(msF.toString());
                }
                throw new GenerationException((MessageFormatter)msF, (Throwable)me);
            }
        } else {
            dimName = MDXGenerationUtil.getLocalMeasure(businessModel, null);
        }
        exprText = MDXGenerationUtil.repairQuotes(exprText);
        String memberName = dimName + ".[BIQTempMem" + MDXGenerationUtil.getRandom() + MDX_RIGHT_SET_SEPERATOR;
        StringBuilder mdxExpression = new StringBuilder(100000);
        mdxExpression.append("Member ").append(memberName).append(" as '").append(exprText).append("' ");
        return MDXGenerationUtil.buildMemberQuery(mdxExpression.toString(), cubeName, dimName);
    }

    public static String buildMemberQuery(DataItem dataItem, String cubeName, MDXVariable mdxVariable) throws GenerationException {
        String phrase = null;
        boolean isResourceExpression = dataItem.getExpression() instanceof ResourceAwareStringExpression;
        phrase = isResourceExpression ? mdxVariable.getMDXPhrase() : mdxVariable.getMDXExpression();
        String mdx = MDXGenerationUtil.buildMemberQuery(phrase, cubeName, mdxVariable.getLabel(), isResourceExpression);
        return mdx;
    }

    public static String buildMemberQuery(String exprText, String cubeName, String memberName, boolean isResourceExpression) throws GenerationException {
        if (!isResourceExpression) {
            StringBuilder mdx = new StringBuilder(9000);
            mdx.append(" WITH MEMBER [Measures].[&] AS 1 Select NON EMPTY ").append("{" + exprText + "}").append(" on columns From ").append(MDX_LEFT_SET_SEPERATOR + cubeName + "] WHERE [Measures].[&]");
            return mdx.toString();
        }
        return MDXGenerationUtil.buildMemberQuery(exprText, cubeName, memberName);
    }

    public static String buildMeasureQuery(String exprText, String cubeName, String memberName, boolean isResourceExpression) throws GenerationException {
        if (!isResourceExpression) {
            StringBuilder mdx = new StringBuilder();
            mdx.append(" Select NON EMPTY ").append("{" + exprText + "}").append(" on columns From ").append(MDX_LEFT_SET_SEPERATOR + cubeName + "] ");
            return mdx.toString();
        }
        return MDXGenerationUtil.buildMemberQuery(exprText, cubeName, memberName);
    }

    private static String buildMemberQuery(String exprText, String cubeName, String memberName) throws GenerationException {
        StringBuilder mdx = new StringBuilder(1000);
        mdx.append("With ").append(exprText).append(" Select ").append("{" + memberName + "}").append(" on columns From ").append(MDX_LEFT_SET_SEPERATOR + cubeName + MDX_RIGHT_SET_SEPERATOR);
        return mdx.toString();
    }

    public static String buildMembersDefinition(DataItem dataItem, OLAPValues olapValues, DataSelection dataSelection) throws GenerationException {
        StringBuilder coreExpression = new StringBuilder();
        ExpressionInterface expression = dataItem.getExpression();
        if (expression instanceof Dimension || expression instanceof Hierarchy || expression instanceof com.sas.iquery.metadata.physical.Level) {
            boolean ignoreDrillUp = dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_DRILLUP_IGNORED_WHEN_GETTING_BYGROUP_VALUES);
            if (olapValues.isFilterDDLApplied(dataItem, false) && !ignoreDrillUp) {
                ExpressionInterface dIFilterExpression = olapValues.getFilterExpressionListForDDL(dataItem.getLabel());
                StringBuilder stValue = new StringBuilder(9000);
                stValue.append(MDX_LEFT_SET_SEPERATOR).append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.DIMNAME)).append(MDX_RIGHT_SET_SEPERATOR);
                String valueOf = stValue.toString();
                if (dIFilterExpression instanceof MemberFilterExpression || dIFilterExpression instanceof TimeFilterExpression || dIFilterExpression instanceof TimeRangeFilterExpression) {
                    String root = null;
                    if (dIFilterExpression instanceof MemberFilterExpression) {
                        MemberFilterExpression mfe = (MemberFilterExpression)dIFilterExpression;
                        if (mfe.getResources(Prompt.class, 65535).size() > 0) {
                            root = olapValues.getPromptMemberLevelRoot(dataItem.getLabel());
                        }
                        if (root == null) {
                            root = mfe.getMemberLevelRoot();
                        } else if (root.length() == 0) {
                            root = mfe.getMemberLevelRoot();
                        }
                        if (mfe.isNegated()) {
                            root = (String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME);
                        }
                    } else if (dIFilterExpression instanceof TimeFilterExpression) {
                        TimeFilterExpression mfe = (TimeFilterExpression)dIFilterExpression;
                        if (mfe.getResources(Prompt.class, 65535).size() > 0) {
                            root = olapValues.getPromptMemberLevelRoot(dataItem.getLabel());
                        }
                        if (root == null) {
                            root = mfe.getMemberLevelRoot();
                        } else if (root.length() == 0) {
                            root = mfe.getMemberLevelRoot();
                        }
                        if (mfe.isNegated()) {
                            root = (String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME);
                        }
                    } else if (dIFilterExpression instanceof TimeRangeFilterExpression) {
                        TimeRangeFilterExpression mfe = (TimeRangeFilterExpression)dIFilterExpression;
                        if (mfe.getResources(Prompt.class, 65535).size() > 0) {
                            root = olapValues.getPromptMemberLevelRoot(dataItem.getLabel());
                        }
                        if (root == null) {
                            root = mfe.getMemberLevelRoot();
                        } else if (root.length() == 0) {
                            root = mfe.getMemberLevelRoot();
                        }
                        if (mfe.isNegated()) {
                            root = (String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME);
                        }
                    }
                    if (root != null) {
                        valueOf = root;
                    }
                }
                coreExpression.append(valueOf).append(MEMBER);
            } else {
                coreExpression.append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME)).append(MEMBER);
            }
        } else if (expression instanceof ResourceAwareStringExpression) {
            List<BusinessModelResource> resources;
            ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expression;
            java.lang.Object RASEString = olapValues.getOLAPValue(dataItem, OLAPItemType.RASENAME);
            if (RASEString == null) {
                RASEString = olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME);
            }
            boolean isMembers = true;
            String RaseStringS = RASEString.toString();
            int indexOFMem = RaseStringS.toUpperCase().indexOf("MEMBERS");
            if (indexOFMem > 0) {
                isMembers = false;
            }
            if ((resources = resourceExp.getResources(BusinessModelResource.class, 65535)).size() == 0) {
                coreExpression.append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME));
            }
            boolean isMeasure = ((OLAPResourceAwareStringExpression)expression).isMeasure();
            for (int i = 0; i < resources.size(); ++i) {
                BusinessModelResource bmaResource = resources.get(i);
                if (bmaResource instanceof Hierarchy || bmaResource instanceof Measure || bmaResource instanceof Dimension) {
                    coreExpression.append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME));
                    break;
                }
                if (bmaResource instanceof CalculatedMember) {
                    CalculatedMember calcMem = (CalculatedMember)bmaResource;
                    try {
                        return calcMem.getUniqueName();
                    }
                    catch (MetadataException e1) {
                        String message = e1.getLocalizedMessage();
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            _logger.error(message);
                        }
                        throw new GenerationException(e1, message);
                    }
                }
                if (bmaResource instanceof NamedSet) {
                    NamedSet namedSet = (NamedSet)bmaResource;
                    try {
                        coreExpression.append(namedSet.getUniqueName());
                        break;
                    }
                    catch (MetadataException e1) {
                        String message = e1.getLocalizedMessage();
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            _logger.error(message);
                        }
                        throw new GenerationException(e1, message);
                    }
                }
                if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                    coreExpression.append(RASEString.toString());
                    if (isMembers && !isMeasure) {
                        coreExpression.append(MEMBER);
                    }
                    break;
                }
                if (bmaResource instanceof DataItem) {
                    DataItem di = (DataItem)bmaResource;
                    ExpressionInterface expressionDa = di.getExpression();
                    if (expressionDa instanceof Dimension || expressionDa instanceof Hierarchy || expressionDa instanceof com.sas.iquery.metadata.physical.Level) {
                        coreExpression.append(RASEString.toString());
                        if (isMembers && !isMeasure) {
                            coreExpression.append(MEMBER);
                        }
                    } else {
                        coreExpression.append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME));
                    }
                    break;
                }
                coreExpression.append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME));
            }
        } else {
            coreExpression.append((String)olapValues.getOLAPValue(dataItem, OLAPItemType.UNIQUENAME));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("CoreExpression from buildMembersDefinition method: " + coreExpression.toString());
        }
        if (dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_CALCULATED_MEMBERS)) {
            boolean hasCalculatedMembers;
            block55: {
                hasCalculatedMembers = false;
                if (!(expression instanceof ResourceAwareStringExpression) && expression instanceof Hierarchy) {
                    Hierarchy hierarchy = (Hierarchy)expression;
                    try {
                        if (hierarchy.getCalculatedMembers().size() > 0) {
                            hasCalculatedMembers = true;
                        }
                    }
                    catch (MetadataException e) {
                        if (!_logger.isEnabled(ERROR_LEVEL)) break block55;
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (hasCalculatedMembers) {
                coreExpression.insert(0, "AddCalculatedMembers(").append(")");
            }
        }
        return coreExpression.toString();
    }

    public static OLAPDataSet buildResultSet(List<? extends ExpressionInterface> memberNames, BusinessModel model, List<String> memberTrimStrings, Locale locale) throws GenerationException {
        OLAPDataSet olapDataSet = null;
        String mdxSet = "";
        String cubeName = null;
        try {
            cubeName = OLAPConnectionInfoUtil.getCube(model).getCubeName();
        }
        catch (MetadataException me) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilNoCube.txt"), me};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException ge = new GenerationException((MessageFormatter)msF, (Throwable)me);
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(msF.toString(), (Throwable)me);
            }
            throw ge;
        }
        mdxSet = MDXGenerationUtil.getMDXString(memberNames, cubeName, memberTrimStrings, locale);
        try {
            olapDataSet = OLAPConnectionInfoUtil.executeQuery(model, mdxSet);
        }
        catch (GenerationException e) {
            throw e;
        }
        catch (IQueryServicesException e) {
            MessageFormatter msf = MDXGenerationUtil.getArrayMessageFormatter("MDXGenerationUtilQueryFail.txt", mdxSet, e);
            throw new GenerationException(msf, (Throwable)e);
        }
        if (olapDataSet == null) {
            GenerationException e = new GenerationException(MDXGenerationUtil.getArrayMessageFormatter("MDXGenerationUtilNoOLAPDataSet.txt", mdxSet, null));
            throw e;
        }
        return olapDataSet;
    }

    private static MessageFormatter getArrayMessageFormatter(String resourceKey, String queryString, Exception e) {
        String msg = IQDataServicesResourceBundle.getStringResource(resourceKey);
        java.lang.Object[] msgArgs2 = null;
        if (e == null) {
            msgArgs2 = new java.lang.Object[]{msg, queryString};
        } else {
            java.lang.Object[] objectArray;
            Throwable t = ChainedException.getRootException((Throwable)e);
            if (e != t && t != null) {
                java.lang.Object[] objectArray2 = new java.lang.Object[3];
                objectArray2[0] = msg;
                objectArray2[1] = queryString;
                objectArray = objectArray2;
                objectArray2[2] = t;
            } else {
                java.lang.Object[] objectArray3 = new java.lang.Object[3];
                objectArray3[0] = msg;
                objectArray3[1] = queryString;
                objectArray = objectArray3;
                objectArray3[2] = e;
            }
            msgArgs2 = objectArray;
        }
        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
        if (_logger.isEnabled(ERROR_LEVEL)) {
            _logger.error(msg + ":" + queryString, (Throwable)e);
        }
        return msF;
    }

    public static String buildSetQuery(String exprText, String cubeName) {
        String setName = "[BIQTempSet" + MDXGenerationUtil.getRandom() + MDX_RIGHT_SET_SEPERATOR;
        StringBuilder mdx = new StringBuilder("With Set ");
        exprText = MDXGenerationUtil.repairQuotes(exprText);
        mdx.append(setName).append(" as '").append(exprText).append("' Select {").append(setName).append("} on columns From ").append(MDX_LEFT_SET_SEPERATOR + cubeName + MDX_RIGHT_SET_SEPERATOR);
        return mdx.toString();
    }

    public static boolean containsValue(String stringArray, String value) {
        boolean found = false;
        String[] checkArray = stringArray.split(",");
        for (int i = 0; i < checkArray.length; ++i) {
            String check = checkArray[i].trim();
            if (!value.equalsIgnoreCase(check)) continue;
            return true;
        }
        return found;
    }

    public static String fixOrphanFilterMember(MemberTuple MemberTuple2) {
        StringBuilder fixedOrphans = new StringBuilder();
        if (MemberTuple2.isOrphaned()) {
            for (String parentName : MemberTuple2.getLostAncestors()) {
                fixedOrphans.append(NEWLINE).append(parentName).append(" , ");
            }
        }
        return fixedOrphans.toString();
    }

    public static StepInterface generateStepsForFilterExpression(ExpressionInterface filterExpression) throws GenerationException {
        AbstractModelItem filterStep = null;
        java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationIllegalExpression.txt")};
        if (filterExpression instanceof CompoundConditionalExpression) {
            ExpressionInterface leftExpression = ((CompoundConditionalExpression)filterExpression).getLeftExpression();
            ConditionalRelationType relationType = ((CompoundConditionalExpression)filterExpression).getRelationType();
            ExpressionInterface rightExpression = ((CompoundConditionalExpression)filterExpression).getRightExpression();
            boolean isNegated = ((CompoundConditionalExpression)filterExpression).isNegated();
            CompoundStep compoundStep = new CompoundStep();
            compoundStep.setNegated(isNegated);
            if (leftExpression != null) {
                compoundStep.addStep(MDXGenerationUtil.generateStepsForFilterExpression(leftExpression));
            }
            if (leftExpression != null && rightExpression != null) {
                if (relationType == ConditionalRelationType.AND) {
                    compoundStep.setConditionType("AND");
                } else if (relationType == ConditionalRelationType.OR) {
                    compoundStep.setConditionType("OR");
                }
            }
            if (rightExpression != null) {
                compoundStep.addStep(MDXGenerationUtil.generateStepsForFilterExpression(rightExpression));
            }
            filterStep = compoundStep;
            if (_logger.isInfoEnabled()) {
                _logger.info(IQDataServicesResourceBundle.getStringResource("MDXGenerationGenCompound.txt"));
            }
        } else if (filterExpression instanceof SlicerFilterExpression || filterExpression instanceof MemberFilterExpression) {
            filterStep = new DataItemMemberFilter();
            boolean isNegate = false;
            List<ExpressionInterface> memberNames = null;
            if (filterExpression instanceof MemberFilterExpression) {
                isNegate = ((MemberFilterExpression)filterExpression).isNegated();
                memberNames = ((MemberFilterExpression)filterExpression).getMemberNames();
            } else {
                isNegate = ((SlicerFilterExpression)filterExpression).isNegated();
                memberNames = ((SlicerFilterExpression)filterExpression).getMemberNames();
            }
            if (memberNames.size() > 0) {
                ((DataItemMemberFilter)filterStep).setMemberNames(memberNames);
                ((DataItemMemberFilter)filterStep).setIsNegated(isNegate);
                if (_logger.isInfoEnabled()) {
                    _logger.info(IQDataServicesResourceBundle.getStringResource("MDXGenerationGenMember.txt"));
                }
                if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression)) {
                    _logger.debug("This is a memberFilter Expression that is probably from a legacy report");
                }
                if (filterExpression instanceof BusinessGroupMemberFilterExpression) {
                    _logger.debug("This is an elastic Filter that will produce a child step for query processing only.");
                }
            }
        } else if (filterExpression instanceof BusinessGroupMemberFilterExpression) {
            filterStep = new DataItemMemberFilter();
            boolean isNegate = ((MemberFilterExpression)filterExpression).isNegated();
            List<ExpressionInterface> memberNames = ((MemberFilterExpression)filterExpression).getMemberNames();
            filterStep.setMemberNames(memberNames);
            ((DataItemMemberFilter)filterStep).setIsNegated(isNegate);
            if (_logger.isInfoEnabled()) {
                _logger.info(IQDataServicesResourceBundle.getStringResource("MDXGenerationGenMember.txt"));
            }
            _logger.debug("BusinessGroupMemberFilterExpression for ");
        } else if (filterExpression instanceof MultipleConditionalExpression) {
            MultipleConditionalExpression condition = (MultipleConditionalExpression)filterExpression;
            ExpressionInterface[] expressions = condition.getExpressions();
            ConditionalRelationType relationType = condition.getRelationType();
            boolean isNegated = condition.isNegated();
            CompoundStep compoundStep = new CompoundStep();
            compoundStep.setNegated(isNegated);
            for (int i = 0; i < expressions.length; ++i) {
                ExpressionInterface expression = expressions[i];
                if (expression != null) {
                    compoundStep.addStep(MDXGenerationUtil.generateStepsForFilterExpression(expression));
                }
                if (i + 1 >= expressions.length) continue;
                if (relationType.equals(ConditionalRelationType.AND)) {
                    compoundStep.setConditionType("AND");
                    continue;
                }
                if (!relationType.equals(ConditionalRelationType.OR)) continue;
                compoundStep.setConditionType("OR");
            }
            filterStep = compoundStep;
            if (_logger.isInfoEnabled()) {
                _logger.info(IQDataServicesResourceBundle.getStringResource("MDXGenerationGenCompound.txt"));
            }
        } else if (filterExpression instanceof DataBasedFilterExpression) {
            filterStep = new DataItemDataBasedFilter();
            List<ExpressionInterface> leftExpression = ((DataBasedFilterExpression)filterExpression).getLeftExpression();
            ((DataItemDataBasedFilter)filterStep).setLeftExpression(leftExpression);
            ComparisonOperator operator = ((DataBasedFilterExpression)filterExpression).getComparisonOperator();
            ((DataItemDataBasedFilter)filterStep).setOperator(operator);
            List<ExpressionInterface> rightExpression = ((DataBasedFilterExpression)filterExpression).getRightExpression();
            ((DataItemDataBasedFilter)filterStep).setRightExpression(rightExpression);
            if (_logger.isInfoEnabled()) {
                _logger.info(IQDataServicesResourceBundle.getStringResource("MDXGenerationGenDataBased.txt"));
            }
        } else if (filterExpression instanceof DataBasedFilterExpression_Between) {
            DataBasedFilterExpression_Between condition = (DataBasedFilterExpression_Between)filterExpression;
            List<ExpressionInterface> whatToCompare = condition.getWhatToCompare();
            List<ExpressionInterface> leftExpression = condition.getLowerBound();
            List<ExpressionInterface> rightExpression = condition.getUpperBound();
            boolean isNegated = condition.isNegated();
            CompoundStep compoundStep = new CompoundStep();
            compoundStep.setNegated(isNegated);
            compoundStep.setConditionType("AND");
            DataItemDataBasedFilter leftStep = new DataItemDataBasedFilter();
            leftStep.setLeftExpression(whatToCompare);
            leftStep.setOperator(ComparisonOperator.COMPARE_GE);
            leftStep.setRightExpression(leftExpression);
            compoundStep.addStep(leftStep);
            DataItemDataBasedFilter rightStep = new DataItemDataBasedFilter();
            rightStep.setLeftExpression(whatToCompare);
            rightStep.setOperator(ComparisonOperator.COMPARE_LE);
            rightStep.setRightExpression(rightExpression);
            compoundStep.addStep(rightStep);
            filterStep = compoundStep;
            if (_logger.isInfoEnabled()) {
                _logger.info(IQDataServicesResourceBundle.getStringResource("MDXGenerationGenMember.txt"));
            }
        } else {
            if (filterExpression instanceof TimeFilterFirstLastPeriodsExpression) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(filterExpression.toString());
                }
                GenerationException e = new GenerationException(msF);
                throw e;
            }
            if (filterExpression instanceof TimeFilterNParallelPeriodsExpression) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(filterExpression.toString());
                }
                throw e;
            }
            if (filterExpression instanceof TimeFilterNPeriodsExpression) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(filterExpression.toString());
                }
                throw e;
            }
            if (filterExpression instanceof TimeRangeFilterExpression) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(filterExpression.toString());
                }
                throw e;
            }
        }
        return filterStep;
    }

    public static String getDimensionExpression(Dimension dimension, OLAPServerUtilities olapServerUtil) throws GenerationException {
        List<Hierarchy> hierarchies = null;
        String levelUniqueName = null;
        try {
            if (dimension.isInMeasureDimension()) {
                return dimension.getUniqueName();
            }
            hierarchies = dimension.getHierarchies();
            if (null == hierarchies || hierarchies.size() == 0) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPValuesMissingHiercharyForDimension.fmt.txt", dimension);
                _logger.error((java.lang.Object)mft);
                throw new GenerationException(mft);
            }
            Hierarchy hierarchy = hierarchies.get(0);
            List<com.sas.iquery.metadata.physical.Level> levels = hierarchy.getLevels();
            if (null == levels || levels.isEmpty()) {
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{hierarchy.toString(), dimension.toString(), IQDataServicesResourceBundle.getStringResource("OLAPValuesNullLevel.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                throw e;
            }
            com.sas.iquery.metadata.physical.Level topLevel = levels.get(0);
            if (topLevel instanceof AllLevel) {
                if (olapServerUtil != null) {
                    ((AllLevel)topLevel).setOLAPServerUtilities(olapServerUtil);
                }
                if (levels.size() >= 2) {
                    topLevel = levels.get(1);
                }
            }
            levelUniqueName = topLevel.getUniqueName();
        }
        catch (MetadataException me) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("OLAPValuesMetaEDimExp.txt"), me.getLocalizedMessage()};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(msF.toString());
            }
            throw new GenerationException((MessageFormatter)msF, (Throwable)me);
        }
        if (null == levelUniqueName || levelUniqueName.length() == 0) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{dimension.toString(), IQDataServicesResourceBundle.getStringResource("OLAPValuesNullLevel.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException e = new GenerationException(msF);
            throw e;
        }
        return levelUniqueName;
    }

    public static String getExpressionValue(ExpressionInterface expression) throws GenerationException {
        return MDXGenerationUtil.getExpressionValue(expression, null, null);
    }

    public static String getExpressionValue(ExpressionInterface expression, DataSelection model, Locale locale) throws GenerationException {
        if (expression == null) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilExpressionNull.txt"));
            }
            return null;
        }
        Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale();
        if (model != null) {
            viewerLocale = LocaleUtilities.getDefaultViewerLocale(model.getSession());
        }
        boolean checkTranslation = false;
        Locale inLocale = viewerLocale;
        if (locale == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Input locale is null. Computational locale is being used.");
            }
            if (model != null) {
                inLocale = model.getComputationalLocale();
            }
        } else {
            inLocale = locale;
        }
        if (viewerLocale == null || inLocale == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Viewer and input locale are null.  No locale to build could be found.");
            }
            checkTranslation = false;
        } else if (!viewerLocale.getDisplayCountry().equalsIgnoreCase(inLocale.getDisplayCountry())) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Viewer and input locale are not the same. Translation will proceed.");
            }
            checkTranslation = true;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug(expression.toString());
        }
        if (expression instanceof StringExpression) {
            StringExpression memberName = (StringExpression)expression;
            String valueString = null;
            try {
                valueString = memberName.getText();
                if (model != null && checkTranslation) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("A Model or data was defined for the building of a MDX Expression, translation will ccur.");
                    }
                    ArrayList<StringExpression> memberList = new ArrayList<StringExpression>();
                    memberList.add(memberName);
                    List<StringExpression> tranMembers = IOMServerUtils.translateOLAPMembers(model, memberList, inLocale);
                    if (!tranMembers.isEmpty()) {
                        StringExpression newMemberName = tranMembers.get(0);
                        valueString = newMemberName.getText();
                    }
                } else if (_logger.isDebugEnabled()) {
                    _logger.debug("No Model was defined for the building of a MDX Expression, so no translation can occur.");
                }
            }
            catch (MetadataException me) {
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilMetaEStr.txt")};
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(memberName.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(msF.toString());
                }
                throw new GenerationException((MessageFormatter)msF, (Throwable)me);
            }
            return valueString;
        }
        if (expression instanceof ConstantExpression) {
            ConstantExpression memberName;
            ConstantExpression memberBeforeTranslation = memberName = (ConstantExpression)expression;
            if (model != null && checkTranslation) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("A Model or data was defined for the building of a MDX Expression, translation will ccur.");
                }
                ArrayList<StringExpression> memberList = new ArrayList<StringExpression>();
                StringExpression value = new StringExpression();
                value.setText(memberName.getValue());
                value.setExpressionType(3);
                memberList.add(value);
                List<StringExpression> tranMembers = IOMServerUtils.translateOLAPMembers(model, memberList, inLocale);
                if (!tranMembers.isEmpty()) {
                    StringExpression newMemberName = tranMembers.get(0);
                    try {
                        memberName.setValue(newMemberName.getText());
                    }
                    catch (MetadataException e) {
                        _logger.error(e.getLocalizedMessage(), (Throwable)e);
                        return memberBeforeTranslation.getValue();
                    }
                }
            }
            return memberName.getValue();
        }
        if (expression instanceof Prompt) {
            if (model == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationUtilPromptNoModel.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            PromptValuesInterface promptValues = model.getPromptValues();
            PromptDefinitionInterface promptDefinition = ((Prompt)expression).getPromptDefinition();
            StringBuilder promptValue = new StringBuilder();
            try {
                List pvalue = promptValues.getPromptValueAsList(promptDefinition);
                if (pvalue != null && !pvalue.isEmpty()) {
                    Iterator pvit = pvalue.iterator();
                    while (pvit.hasNext()) {
                        java.lang.Object value = pvit.next();
                        if (value == null) continue;
                        promptValue.append(value);
                        if (!pvit.hasNext()) continue;
                        promptValue.append(",").append(NEWLINE);
                    }
                }
            }
            catch (PromptValueNotFoundException pe) {
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilNoPrompt.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(msF.toString());
                }
                throw new GenerationException((MessageFormatter)msF, (Throwable)pe);
            }
            return promptValue.toString();
        }
        java.lang.Object[] msgArgs2 = new java.lang.Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilBadExpression.txt")};
        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
        GenerationException e = new GenerationException(msF);
        throw e;
    }

    public static String getLevelExpression(com.sas.iquery.metadata.physical.Level level) throws GenerationException {
        String levelUniqueName = null;
        try {
            levelUniqueName = level.getLevelUniqueName();
        }
        catch (MetadataException me) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{me.getLocalizedMessage(), level.toString()};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(msF.toString());
            }
            throw new GenerationException((MessageFormatter)msF, (Throwable)me);
        }
        if (levelUniqueName == null) {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{level.toString(), IQDataServicesResourceBundle.getStringResource("OLAPValuesLevelUniqueNull.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException e = new GenerationException(msF);
            throw e;
        }
        return levelUniqueName;
    }

    public static String getLocalMeasure(BusinessModel model, MetadataInterface metadataInterface) {
        String returnValue = MDXGenerationUtil.getLocalMeasure(model);
        if (returnValue == null && metadataInterface != null) {
            returnValue = MDXGenerationUtil.getLocalMeasure(metadataInterface);
        }
        if (returnValue == null) {
            MDXGenerationUtil.applyDebugStatement("Getting measurename from IQ property file", OLAPServerUtilities.class);
            Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(model);
            returnValue = MDXGenerationUtil.getLocalMeasure(computationalLocale);
        }
        return returnValue;
    }

    private static String getLocalMeasure(MetadataInterface metadataInterface) {
        String returnValue = null;
        MDXGenerationUtil.applyDebugStatement("Getting measurename from the OLAP metadataServer", OLAPServerUtilities.class);
        try {
            Locale locale = metadataInterface.getLocale();
            returnValue = MDXGenerationUtil.getLocalMeasure(locale);
        }
        catch (OLAPException e) {
            _ovLogger.debug(IQDataServicesResourceBundle.getStringResource("OLAPValuesNoMeasure.txt"), (Throwable)e);
        }
        return returnValue;
    }

    private static String getLocalMeasure(BusinessModel model) {
        String returnValue = null;
        try {
            List<Dimension> dims = OLAPConnectionInfoUtil.getCube(model).getDimensions();
            for (Dimension member : dims) {
                Dimension omad;
                if (!(member instanceof Dimension) || (omad = member).isUnresolved() || omad.getDimensionType() != 1) continue;
                returnValue = MDX_LEFT_SET_SEPERATOR + omad.getDimensionName() + MDX_RIGHT_SET_SEPERATOR;
                break;
            }
        }
        catch (IQueryServicesException e) {
            MDXGenerationUtil.applyDebugStatement(IQMetadataResourceBundle.getStringResource("OLAPServerUtilitiesUnableToConnect.txt"), OLAPServerUtilities.class);
            MDXGenerationUtil.applyDebugStatement(e.getLocalizedMessage(), OLAPServerUtilities.class);
        }
        return returnValue;
    }

    private static String getLocalMeasure(Locale locale) {
        StringBuilder buffer = new StringBuilder(60);
        buffer.append(MDX_LEFT_SET_SEPERATOR).append(IQMetadataResourceBundle.getStringResource("BusinessqueryOLAPMeasure.txt", locale)).append(MDX_RIGHT_SET_SEPERATOR);
        return buffer.toString();
    }

    private static String getMDXString(List<? extends ExpressionInterface> memberNames, String cubeName, List<String> memberTrimStrings, Locale locale) throws GenerationException {
        Iterator<? extends ExpressionInterface> iterator = memberNames.iterator();
        StringBuilder memberNamesString = new StringBuilder();
        String mdxSet = "";
        memberNamesString.append("{");
        while (iterator.hasNext()) {
            ExpressionInterface member = iterator.next();
            String valueString = member.toString();
            if (member instanceof ExpressionInterface) {
                valueString = MDXGenerationUtil.getExpressionValue(member);
            }
            if (valueString == null) continue;
            memberNamesString.append(valueString);
            if (iterator.hasNext()) {
                memberNamesString.append(", ").append(NEWLINE);
            }
            memberTrimStrings.add(valueString.trim());
        }
        memberNamesString.append("}");
        if (memberTrimStrings.size() == 0) {
            return null;
        }
        mdxSet = MDXGenerationUtil.buildSetQuery(memberNamesString.toString(), cubeName);
        if (null == mdxSet || mdxSet.length() == 0) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(memberNamesString.toString());
            }
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MemberFitlerExpressionNoMDXSet.txt", new java.lang.Object[0]);
            throw new GenerationException(mft);
        }
        return mdxSet;
    }

    public static String getMeasureExpression(Measure measure) throws GenerationException {
        String measureName = null;
        try {
            measureName = measure.getUniqueName();
            return measureName;
        }
        catch (MetadataException e) {
            _logger.error((java.lang.Object)e);
            throw new GenerationException(e);
        }
    }

    private static int getRandom() {
        int range = 0x55555554;
        Random rand = new Random();
        return rand.nextInt(range);
    }

    public static ExpressionInterface getRealEffectiveFilter(FilterItem filterItemDefinition, DataSelection model) throws GenerationException {
        String filterId = "";
        try {
            filterId = filterItemDefinition.getID();
        }
        catch (InvalidIDException iE) {
            throw new GenerationException(iE, IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt"));
        }
        boolean isOldByGroup = false;
        ExpressionInterface filterExpression = filterItemDefinition.getExpression();
        if (filterExpression instanceof BaseFilterExpression && filterExpression instanceof MemberFilterExpression) {
            isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(filterExpression, model, filterId, filterItemDefinition);
        }
        if (filterExpression instanceof SlicerFilterExpression) {
            filterExpression = null;
        } else if (filterExpression instanceof BusinessGroupMemberFilterExpression) {
            filterExpression = null;
        } else if (isOldByGroup) {
            filterExpression = null;
        }
        return filterExpression;
    }

    public static String getSortName(DataItem dataItem, OLAPValues olapValues, DataSelection model) throws GenerationException {
        StringBuilder sortNameBuff = new StringBuilder();
        ExpressionInterface expression = dataItem.getExpression();
        _logger.info((java.lang.Object)expression);
        if (expression instanceof Dimension || expression instanceof Hierarchy || expression instanceof com.sas.iquery.metadata.physical.Level || expression instanceof Member) {
            String value = (String)olapValues.getOLAPValue(dataItem, OLAPItemType.HIERNAME);
            if (value == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadMemberName.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            sortNameBuff.append(value);
        } else if (expression instanceof CalculatedMember) {
            CalculatedMember calcMem = (CalculatedMember)expression;
            try {
                sortNameBuff.append(calcMem.getUniqueName());
            }
            catch (MetadataException e1) {
                String message = e1.getLocalizedMessage();
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(message);
                }
                throw new GenerationException(e1, message);
            }
        } else if (expression instanceof NamedSet) {
            String value = (String)olapValues.getOLAPValue(dataItem, OLAPItemType.HIERNAME);
            if (value == null) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadMemberName.txt", new java.lang.Object[0]);
                throw new GenerationException(mft);
            }
            sortNameBuff.append(value);
        } else if (expression instanceof Measure) {
            sortNameBuff.append(MDXGenerationUtil.buildCoreExpression(expression, olapValues));
        } else if (expression instanceof ResourceAwareStringExpression) {
            try {
                java.lang.Object valueO = olapValues.getOLAPValue(dataItem, OLAPItemType.HIERNAME);
                String valueOfSortName = null;
                if (valueO == null) {
                    valueOfSortName = BusinessQueryOLAPUtil.getHierarchyName(model, dataItem, model.getComputationalLocale());
                    if (valueOfSortName == null) {
                        MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadMemberName.txt", new java.lang.Object[0]);
                        throw new GenerationException(mft);
                    }
                } else {
                    valueOfSortName = (String)valueO;
                }
                sortNameBuff.append(valueOfSortName);
            }
            catch (MetadataException me) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(expression.toString());
                }
                String message = IQDataServicesResourceBundle.getStringResource("DataItemSortBadMemberName.txt");
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(message);
                }
                throw new GenerationException(me, message);
            }
        } else {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortNoMemberLevelDimensionName.txt", new java.lang.Object[0]);
            throw new GenerationException(mft);
        }
        if (_logger.isInfoEnabled()) {
            _logger.info(sortNameBuff.toString());
        }
        return sortNameBuff.toString();
    }

    public static String getStartingLevel(DataItem dataItem) throws GenerationException {
        String startingLevel = null;
        try {
            startingLevel = dataItem.getStartingLevelName();
        }
        catch (MetadataException me) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(dataItem.toString());
            }
            String message = IQDataServicesResourceBundle.getStringResource("MDXGenerationUtilMetaSL.txt");
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(message);
            }
            throw new GenerationException(me, message);
        }
        return startingLevel;
    }

    public static String getTypeOfSortString(AbstractEnumerationObject sortDirection) throws GenerationException {
        String sortValue = null;
        if (sortDirection == DataItemActionType.SORT_NONE || sortDirection == BusinessQueryActionType.SORT_NONE) {
            return null;
        }
        if (sortDirection == DataItemActionType.SORT_HIERARCHICAL_ASCENDING || sortDirection == BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING) {
            sortValue = ", ASC)";
        } else if (sortDirection == DataItemActionType.SORT_HIERARCHICAL_DESCENDING || sortDirection == BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING) {
            sortValue = ", DESC)";
        } else if (sortDirection == DataItemActionType.SORT_ASCENDING || sortDirection == BusinessQueryActionType.SORT_ASCENDING) {
            sortValue = ", BASC)";
        } else if (sortDirection == DataItemActionType.SORT_DESCENDING || sortDirection == BusinessQueryActionType.SORT_DESCENDING) {
            sortValue = ", BDESC)";
        } else {
            java.lang.Object[] msgArgs2 = new java.lang.Object[]{sortDirection, IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedSortInvalidSort.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException e = new GenerationException(msF);
            throw e;
        }
        return sortValue;
    }

    public static String buildMDXForOrphan(DataItem item, String mdxFilter, OLAPValues olapValues, DataSelection model) throws GenerationException {
        if (item.getExpression() instanceof TimeExpressionMeasure) {
            return "";
        }
        String asClause = MDXGenerationUtil.buildMembersDefinition(item, olapValues, model);
        if (asClause == null) {
            return "";
        }
        MDXGenerationUtil.applyDebugStatement("MDX constructed for Orphans: " + mdxFilter, MDXGenerationUtil.class);
        MDXVariable mdxVariable = MDXGenerationUtil.getOrphanedMDXVariableOrCreate(item, olapValues.getOLAPValue(item, OLAPItemType.HIERNAME).toString(), olapValues, model);
        mdxVariable.setMDXExpression(asClause);
        olapValues.setOLAPValue(item, OLAPItemType.MDXVARIABLE, mdxVariable);
        return mdxVariable.getMDXPhrase();
    }

    public static MDXVariable getOrphanedMDXVariableOrCreate(DataItem resultItem, String hierName, OLAPValues olapValues, DataSelection model) throws GenerationException {
        MDXVariable mdxVariable = null;
        MetadataInterface metadataInterface = olapValues.getMetadataInterface();
        if (!olapValues.hasOLAPValue(resultItem)) {
            mdxVariable = new MDXVariable(metadataInterface, resultItem, true, model);
        } else {
            java.lang.Object mdxVar = olapValues.getOLAPValue(resultItem, OLAPItemType.MDXVARIABLE);
            mdxVariable = mdxVar == null ? new MDXVariable(metadataInterface, resultItem, true, model) : (mdxVar instanceof MDXVariable ? (MDXVariable)mdxVar : new MDXVariable(metadataInterface, resultItem, true, model));
            if (hierName != null) {
                mdxVariable.setLabel(hierName);
            }
        }
        return mdxVariable;
    }

    public static List<DataItem> getOrphanedList(List<DataItem> potentialOrphans, OLAPValues olapValues) throws GenerationException {
        ArrayList<DataItem> orphanedStepDataItems = new ArrayList<DataItem>();
        MDXGenerationUtil.applyDebugStatement("Creating orphaned step List ", MDXGenerationUtil.class);
        for (DataItem daItem : potentialOrphans) {
            if (MDXGenerationUtil.isDataItemVisibleOrOrphaned(daItem, olapValues)) continue;
            orphanedStepDataItems.add(daItem);
        }
        return orphanedStepDataItems;
    }

    public static boolean isDataItemVisibleOrOrphaned(DataItem daItem, OLAPValues olapValues) throws GenerationException {
        boolean isVisible = true;
        if (!olapValues.hasOLAPValue(daItem)) {
            Locale locale = LocaleUtilities.getDefaultViewerLocale(daItem.getBusinessModel());
            String label = daItem.getLabel(locale);
            label = MDXGenerationUtil.repairQuotes(label);
            olapValues.setOLAPValue(daItem, OLAPItemType.LABEL, label);
            isVisible = false;
        } else {
            isVisible = olapValues.isVisible(daItem);
        }
        return isVisible;
    }

    public static boolean isHiddenGroupFilter(DataItem dataItem, OLAPValues olapValues) {
        boolean returnValue = false;
        Iterator<FilterItem> iteratorForFilter = olapValues.getFilterListForMDX().iterator();
        FilterItem filter = null;
        while (iteratorForFilter.hasNext()) {
            MemberFilterExpression mfe;
            ExpressionInterface expr;
            filter = iteratorForFilter.next();
            ExpressionInterface expression = filter.getExpression();
            if (!(expression instanceof BusinessGroupMemberFilterExpression) || !((expr = (mfe = (MemberFilterExpression)expression).getWhatToCompare()) instanceof DataItem) || !dataItem.getLabel().equalsIgnoreCase(((DataItem)expr).getLabel())) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static boolean isHiddenItem(DataItem item, List<DataItem> hiddenResults) {
        boolean isHidden = false;
        if (hiddenResults.contains(item)) {
            isHidden = true;
        }
        Iterator<DataItem> it = hiddenResults.iterator();
        while (!isHidden && it.hasNext()) {
            DataItem hiddenItem = it.next();
            while (!isHidden && hiddenItem instanceof DataItemReference) {
                isHidden = (hiddenItem = ((DataItemReference)hiddenItem).getBaseDataItem()) == item;
            }
        }
        return isHidden;
    }

    public static boolean isDataItemInList(List list, String checkLabel) {
        boolean isInList = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (java.lang.Object object : list) {
            if (object instanceof DataItem) {
                DataItem datt = (DataItem)object;
                if (!datt.getLabel().equals(checkLabel)) continue;
                isInList = true;
                break;
            }
            if (!object.equals(checkLabel)) continue;
            isInList = true;
            break;
        }
        return isInList;
    }

    public static boolean isMeasure(ExpressionInterface expression) {
        boolean isMeasure = false;
        if (expression instanceof Measure || expression instanceof TimeExpressionMeasure || expression instanceof FractionOfTotalExpression) {
            isMeasure = true;
        } else if (expression instanceof DataItem) {
            DataItem daItem = (DataItem)expression;
            StructureOfDataItem struct = daItem.getStructure();
            if (struct.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                isMeasure = true;
            }
        } else if (expression instanceof OLAPResourceAwareStringExpression) {
            isMeasure = ((OLAPResourceAwareStringExpression)expression).isMeasure();
        } else if (expression instanceof ResourceAwareStringExpression) {
            ResourceAwareStringExpression rsExpression = (ResourceAwareStringExpression)expression;
            List<DataItem> daList = rsExpression.getResources(DataItem.class, 65535);
            if (daList.isEmpty()) {
                return isMeasure;
            }
            DataItem daItem = daList.get(0);
            if (daItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                isMeasure = true;
            }
        }
        return isMeasure;
    }

    public static boolean isMultipleMemberInStep(StepInterface step, DataItem resultItem) {
        boolean multipleMembers = true;
        int type = ((DataItemMemberFilter)step).getMemberFilterType();
        List<NonCalculatedValue> members = null;
        if (type == 1) {
            try {
                IQDataServices iqDataService = IQDataServicesFactory.newService(resultItem.getBusinessModel().getMetadataService());
                members = iqDataService.getMembers(resultItem, -999);
            }
            catch (DataServicesException e) {
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{resultItem.toString(), e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("MDXGenerationDataExcGetMetadata.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(msF.toString(), (Throwable)e);
                }
            }
        } else {
            members = ((DataItemMemberFilter)step).getMemberNames();
        }
        if (members != null && members.size() < 2) {
            multipleMembers = false;
        }
        return multipleMembers;
    }

    public static boolean isOldByGroupExpression(ExpressionInterface filterExpression, BusinessQuery model, String filterId, FilterItem filter) {
        boolean isOldByGroup = false;
        if (filterId == null) {
            _logger.debug("FilterId is null");
            return isOldByGroup;
        }
        if (filterExpression instanceof MemberFilterExpression) {
            isOldByGroup = filterId.substring(0, 7).equalsIgnoreCase("ByGroup") ? true : ByGroupCreator.isByGroupFilter(model, filter);
        }
        return isOldByGroup;
    }

    public static boolean isResultItemInList(List resultItems, DataItem resultItem) {
        boolean inList = false;
        Iterator iterator = resultItems.iterator();
        ArrayList<String> listOfLabels = new ArrayList<String>();
        while (iterator.hasNext()) {
            java.lang.Object objectInList = iterator.next();
            if (!(objectInList instanceof DataItem)) continue;
            listOfLabels.add(((DataItem)objectInList).getLabel());
        }
        inList = listOfLabels.contains(resultItem.getLabel());
        return inList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTimeDimension(DataItem dataItem) throws GenerationException {
        ExpressionInterface expression = dataItem.getExpression();
        boolean isTimeDimension = false;
        if (expression instanceof Hierarchy) {
            Hierarchy omaH = (Hierarchy)expression;
            try {
                Dimension omaD = omaH.getOwningDimension();
                int dimType = omaD.getDimensionType();
                if (dimType != 0) return isTimeDimension;
                return true;
            }
            catch (MetadataException me) {
                java.lang.Object[] msgArgs2 = new java.lang.Object[]{IQDataServicesResourceBundle.getStringResource("DataItemSortBadHierarchyName.txt"), me.getLocalizedMessage()};
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(expression.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (!_logger.isEnabled(ERROR_LEVEL)) throw new GenerationException((MessageFormatter)msF, (Throwable)me);
                _logger.error(msF.toString());
                throw new GenerationException((MessageFormatter)msF, (Throwable)me);
            }
        }
        int isTimeIndicator = expression.getExpressionType();
        if (isTimeIndicator == 4) return true;
        if (isTimeIndicator == 5) return true;
        if (isTimeIndicator != 6) return isTimeDimension;
        return true;
    }

    public static Double getMDXVersion(DataSelection dataSelection, String cubeName, OLAPConnectionResource olapConnection) throws GenerationException {
        String version = VERSION_NEW_MDXGENERATION_BEGAN;
        Double versionInt = 9.02;
        if (olapConnection == null) {
            return versionInt;
        }
        Object corbaObject = olapConnection.getObject();
        try {
            IServerStatus isHelper = IOMServerUtils.GetIServerStatus(corbaObject);
            if (isHelper != null) {
                StringSeqHolder holderInfo = new StringSeqHolder();
                isHelper.ServerStatusGetInfo(holderInfo);
                String[] holderString = holderInfo.value;
                if (holderString.length > 0) {
                    version = holderString[0];
                    _logger.debug("getMDXVersion(): IOM MDX version = [" + version + MDX_RIGHT_SET_SEPERATOR);
                }
            } else {
                MessageFormatter msF = IQDataServicesResourceBundle.getMessageFormatter(WARNING_GET_SERVER_VERSION, new java.lang.Object[0]);
                _logger.warn((java.lang.Object)msF);
            }
        }
        catch (GenericError e) {
            _logger.warn(cubeName, (Throwable)e);
            MDXGenerationUtil.newGenerationException(WARNING_GET_SERVER_VERSION, dataSelection, (Exception)((java.lang.Object)e));
        }
        String versionParsed = version.replaceAll("^([\\d]+([.][\\d]*)?).*", "$1");
        _logger.debug("getMDXVersion(): parsing MDX version = [" + versionParsed + MDX_RIGHT_SET_SEPERATOR);
        versionInt = Double.parseDouble(versionParsed);
        _logger.debug("getMDXVersion(): returning MDX version = " + versionInt);
        return versionInt;
    }

    public static GenerationException newGenerationException(String errorConnectingToOlapServer, DataSelection dataSelection, Exception e) {
        if (_logger.isEnabled(ERROR_LEVEL)) {
            _logger.error(dataSelection.getIdentityString());
        }
        MessageFormatter msF = null;
        if (errorConnectingToOlapServer == null) {
            if (e != null) {
                _logger.error((java.lang.Object)e);
            }
        } else {
            msF = IQDataServicesResourceBundle.getMessageFormatter(errorConnectingToOlapServer, new java.lang.Object[0]);
            if (e == null) {
                _logger.error((java.lang.Object)msF);
            } else {
                _logger.error((java.lang.Object)msF, (Throwable)e);
            }
        }
        return e == null ? new GenerationException(msF) : new GenerationException(msF, (Throwable)e);
    }

    public static String buildDisabledTotalsClause(String mdx, boolean disableTotal, String firstHierarchy, DataSelection ds, DataItem dataItem) {
        StringBuilder clause = new StringBuilder();
        clause.append(mdx);
        String uncasedMDXClause = mdx.toLowerCase();
        int isVisualBehaviorInClause = uncasedMDXClause.indexOf("visualtotal");
        if (isVisualBehaviorInClause <= 0 && disableTotal && firstHierarchy != null) {
            String totalCommand = DISABLEALLTOTAL;
            Map<DataItem, Set<TotalingType>> disabledItems = DisabledTotalsBuilder.getDisabledTotalingByItem(ds);
            Set<TotalingType> disabledType = disabledItems.get(dataItem);
            if (disabledType.size() == 1) {
                java.lang.Object[] tObject = disabledType.toArray();
                TotalingType tType = (TotalingType)tObject[0];
                if (tType.equals(TotalingType.SUBTOTAL)) {
                    totalCommand = DISABLESUBTOTAL;
                } else if (tType.equals(TotalingType.AXISTOTAL)) {
                    totalCommand = DISABLETOTAL;
                }
            }
            clause.append(", ").append(totalCommand).append("{").append(firstHierarchy).append("})");
        }
        return clause.toString();
    }
}

