/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olapv2.PreFilterDLLGeneration;
import java.util.List;

public class ISessionCacheContainer {
    private String _cacheKey = null;
    private String _cube = null;
    private PreFilterDLLGeneration _preFilterDDL = null;
    private ISession _session = null;
    private List _sessionAssociatedDDLDefinition = null;
    private boolean _sessionAssociatedReapplyFilterIndicator = true;
    private String _totalTypeRow = BusinessQuery.TOTAL_NONE;
    private String _totalTypeColumn = BusinessQuery.TOTAL_NONE;

    public ISessionCacheContainer(ISession isession, String cube, PreFilterDLLGeneration preFilterDDL, List DDLList, String cacheKey, BusinessModel model) {
        this._preFilterDDL = preFilterDDL;
        this._session = isession;
        this._cacheKey = cacheKey;
        this._cube = cube;
        String totalRow = BusinessQuery.TOTAL_NONE;
        String totalCol = BusinessQuery.TOTAL_NONE;
        if (model instanceof DataSelection) {
            totalRow = ((DataSelection)model).getTotalType(Role.ROW);
            totalCol = ((DataSelection)model).getTotalType(Role.COLUMN);
        }
        this.setTotalIndicator(totalRow, Role.ROW);
        this.setTotalIndicator(totalCol, Role.COLUMN);
        this._sessionAssociatedDDLDefinition = DDLList;
    }

    public String getCacheKey() {
        return this._cacheKey;
    }

    public synchronized String getCube() {
        return this._cube;
    }

    public List getDDLDefinition() {
        return this._sessionAssociatedDDLDefinition;
    }

    public ISession getISession() {
        return this._session;
    }

    public PreFilterDLLGeneration getPreFilterContainer() {
        return this._preFilterDDL;
    }

    public boolean isPreviouslyFilter() {
        if (this._sessionAssociatedDDLDefinition.size() > 0) {
            MDXGenerationUtil.applyDebugStatement("There was a previously applied filter", this.getClass());
            return true;
        }
        MDXGenerationUtil.applyDebugStatement("There was no previously applied filter", this.getClass());
        return false;
    }

    public synchronized void setCube(String cube) {
        this._cube = cube;
        MDXGenerationUtil.applyDebugStatement("Set this cube as being tracked with its ISession. " + cube, this.getClass());
    }

    public void setTotalIndicator(String totalType, Role role) {
        if (role == Role.ROW) {
            this._totalTypeRow = totalType;
        } else {
            this._totalTypeColumn = totalType;
        }
    }

    public String getTotalIndicator(Role role) {
        if (role == Role.ROW) {
            return this._totalTypeRow;
        }
        return this._totalTypeColumn;
    }

    public synchronized void setDDLDefinition(List DDLList) {
        this._sessionAssociatedDDLDefinition = DDLList;
        MDXGenerationUtil.applyDebugStatement("Set the DDL definition for this cube", this.getClass());
    }

    public synchronized void setISession(ISession isession) {
        this._session = isession;
        MDXGenerationUtil.applyDebugStatement("Set the ISession that is associated to this pre-filter", this.getClass());
    }

    public synchronized void setPreFilerContainer(PreFilterDLLGeneration prefilterDDL) {
        if (this._preFilterDDL != null) {
            this._preFilterDDL = null;
        }
        this._preFilterDDL = prefilterDDL;
    }

    public synchronized void setReapply(boolean reapply) {
        this._sessionAssociatedReapplyFilterIndicator = reapply;
        MDXGenerationUtil.applyDebugStatement("Set the indicator that the filter needs to be reapplied", this.getClass());
    }

    public boolean toReapply() {
        return this._sessionAssociatedReapplyFilterIndicator;
    }
}

