/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.execution.ConnectionResources;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.instructions.OLAPDataSetFactory;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSetInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.services.connection.ConnectionInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.embedded.ResultSet;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.storage.olap.sasmdx.OLAPDataSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IQOLAPDataSet
extends OLAPDataSet
implements IQOLAPDataSetInterface {
    private static final Logger _perfDSLogger = LogManager.getLogger((String)"com.sas.iquery.perf.DataServer");
    private BusinessModel _businessModel = null;
    private String _key = null;
    private OLAPConnectionResource _olapConnection = null;
    private String _queryID = null;
    private ConnectionInterface _pfsConnection = null;
    private Map<String, String> _labelNameMap = new LinkedHashMap<String, String>();

    public IQOLAPDataSet() throws OLAPException {
    }

    public IQOLAPDataSet(ISession session, int contextType, ConnectionInterface connection) throws OLAPException {
        super((Object)session, null);
        this.contextType = contextType;
        this._pfsConnection = connection;
    }

    public IQOLAPDataSet(IMDXServer mdxServer, String query, int contextType, ConnectionInterface connection) throws OLAPException {
        super((Object)mdxServer, query, contextType);
        this._pfsConnection = connection;
    }

    public IQOLAPDataSet(ResultSet resultSet) throws OLAPException {
        super((Object)resultSet);
    }

    public void setBusinesModel(BusinessModel model) throws OLAPException {
        this._queryID = model != null ? model.getID() : null;
        this._businessModel = model;
    }

    @Override
    public void setContextType(int contextType, BusinessModel model, String query) throws OLAPException, IQueryServicesException {
        this.setBusinesModel(model);
        if (this.getQueryStatement() == null) {
            this.setQueryStatement(query);
        }
        super.setContextType(contextType);
    }

    @Override
    public void execute(BusinessModel model, String queryStatement) throws OLAPException, IQueryServicesException {
        this.setBusinesModel(model);
        this.executeQuery(queryStatement);
    }

    public void setLabelNameMap(Map<String, String> labelNameMap) {
    }

    public void executeQuery(String queryStatement) throws OLAPException {
        OLAPDataSetFactory.writeOutStatment("Executing MDX: " + queryStatement);
        long start = 0L;
        if (_perfDSLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogDataServerPerformance("> Submitting OLAP SAS code.  Code=" + queryStatement);
            start = System.currentTimeMillis();
        }
        super.executeQuery(queryStatement);
        if (_perfDSLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogDataServerPerformance("> done (" + (end - start) + "ms)");
        }
        MetadataInterface metadata = this.getDatabaseMetadata();
        metadata.setLocale(this.locale);
        if (this._businessModel != null && this._key == null) {
            Locale connectionLocale = this.getLocale();
            try {
                this._key = MDXGenerationUtil.buildCacheKey(this._businessModel, connectionLocale, "DEFAULT_CONSTRUCTOR_BEHAVIOR");
            }
            catch (GenerationException e) {
                this._key = null;
                _perfDSLogger.error((Object)e);
            }
        }
    }

    @Override
    public String getExecuteKey() {
        return this._key;
    }

    @Override
    public String getQueryID() {
        return this._queryID;
    }

    @Override
    public BusinessModel getRelatedBusinessModel() {
        return this._businessModel;
    }

    @Override
    public OLAPConnectionResource getRelatedConnection() {
        return this._olapConnection;
    }

    @Override
    public void setRelatedConnection(OLAPConnectionResource olapConnection) {
        this._olapConnection = olapConnection;
    }

    public void setConnection(Object connection) throws OLAPException {
        boolean isEqual;
        boolean bl = isEqual = connection == null && this._session == null && this._connection == null || this._session != null && connection == this._session || this._connection != null && connection == this._connection;
        if (!isEqual) {
            this.resetConnection();
            super.setConnection(connection);
        }
    }

    public void setLocale(Locale newLocale) throws OLAPException {
        boolean isEqual;
        boolean bl = isEqual = this.locale == null && newLocale == null || this.locale != null && newLocale != null && newLocale.toString().equalsIgnoreCase(this.locale.toString());
        if (!isEqual) {
            this.resetConnection();
            super.setLocale(newLocale);
        }
    }

    protected void resetConnection() throws OLAPException {
        if (this.isConnected) {
            this.isConnected = false;
            this.initialized = false;
            this.close = false;
            if (this._mdDataSet != null) {
                if (this.cache != null) {
                    this.cache.flush((OLAPDataSetInterface)this, this._mdDataSet);
                }
                try {
                    this._mdDataSet.Close();
                }
                catch (GenericError e) {
                    e.printStackTrace();
                }
                this._mdDataSet = null;
            }
            if (this._session != null) {
                Metadata.clearCache(null, (Object)this._session, (int)2);
            }
            if (this._connection != null) {
                try {
                    this._session.Close();
                }
                catch (GenericError e) {
                    e.printStackTrace();
                }
                this._session = null;
            }
        }
    }

    public void close() throws OLAPException {
        if (!this.close) {
            super.close();
            if (this._pfsConnection != null) {
                ConnectionResources.close(this._pfsConnection);
                this._pfsConnection = null;
            }
            if (this._olapConnection != null) {
                this._olapConnection.releaseOLAPDataSetFromISession(this);
                this._olapConnection = null;
            }
            if (this._businessModel != null) {
                this._businessModel = null;
            }
        }
    }
}

