/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.strategies.sas.oma.olap.util.IQISessionInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.IQOLAPDataSetInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IQISession
implements IQISessionInterface {
    private IdentityList _metadataInterfacesHeld = new IdentityList();
    private IdentityList _olapDataSetsInterfacesHeld = new IdentityList();
    private ISession _session = null;
    private Locale _connectionLocale = null;
    private static final Logger _logger = LogManager.getLogger(IQISession.class);

    public IQISession(ISession session, Locale connectionLocale) {
        this._session = session;
        this._connectionLocale = connectionLocale;
    }

    public ISession getISession() {
        return this._session;
    }

    public boolean isFree() {
        boolean isFree = true;
        if (this._metadataInterfacesHeld.size() != 0) {
            isFree = false;
        } else if (this._olapDataSetsInterfacesHeld.size() != 0) {
            isFree = false;
        }
        return isFree;
    }

    @Override
    public void releaseMetadataInterface(MetadataInterface metadataI) {
        if (this._metadataInterfacesHeld.contains(metadataI)) {
            this._metadataInterfacesHeld.remove(metadataI);
            MDXGenerationUtil.applyDebugStatement("IMPORTANT: A metadataInterface object is released from a IQISession for " + ((IQMetadataInterface)metadataI).getCacheKey(), this.getClass());
            metadataI = null;
        } else {
            MDXGenerationUtil.applyDebugStatement("MetadataInterface has already been released for this ISession", this.getClass());
        }
    }

    @Override
    public void releaseOLAPDataSetInterface(OLAPDataSetInterface OLAPDataSet2) {
        if (this._olapDataSetsInterfacesHeld.contains(OLAPDataSet2)) {
            this._olapDataSetsInterfacesHeld.remove(OLAPDataSet2);
            String executeKey = ((IQOLAPDataSetInterface)OLAPDataSet2).getExecuteKey();
            MDXGenerationUtil.applyDebugStatement("IMPORTANT: A OLAPDataSet object is released from a IQISession for " + executeKey, this.getClass());
            try {
                if (OLAPDataSet2.getConnection() != null) {
                    OLAPDataSet2.close();
                }
            }
            catch (OLAPException e) {
                _logger.error((Object)e);
            }
        } else {
            _logger.warn("OLAPDataSetInterface has already been released for this ISession");
        }
    }

    public IdentityList getMetadataList() {
        return this._metadataInterfacesHeld;
    }

    public void releaseISessionResources() {
        block8: {
            IdentityList metadatas = this.getMetadataList();
            IdentityList olapdatas = this.getOLAPDataSetList();
            try {
                while (!metadatas.toList().isEmpty()) {
                    MDXGenerationUtil.applyDebugStatement("Metadata is being released and removed from keyed list. ", OLAPConnectionResource.class);
                    if (_logger.isEnabled(Level.WARN)) {
                        _logger.warn(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResourceNonEmptyIQISession.txt"));
                        _logger.warn("metadatas = " + metadatas.toList());
                    }
                    MetadataInterface metad = (MetadataInterface)metadatas.get(0);
                    this.releaseMetadataInterface(metad);
                }
                while (!olapdatas.toList().isEmpty()) {
                    MDXGenerationUtil.applyDebugStatement("OLAPDATASet is being released and removed from keyed list. ", OLAPConnectionResource.class);
                    if (_logger.isEnabled(Level.WARN)) {
                        _logger.warn(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResourceNonEmptyIQISession.txt"));
                        _logger.warn("olapdatas = " + olapdatas.toList());
                    }
                    OLAPDataSetInterface olapd = (OLAPDataSetInterface)olapdatas.get(0);
                    this.releaseOLAPDataSetInterface(olapd);
                    MDXGenerationUtil.applyDebugStatement(olapd.getQueryStatement(), this.getClass());
                }
            }
            catch (OLAPException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage());
                    _logger.error(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResourceNonEmptyIQISession.txt"), (Throwable)e);
                    _logger.warn("metadatas = " + metadatas.toList());
                    _logger.warn("olapdatas = " + olapdatas.toList());
                }
            }
            catch (Exception e) {
                if (!_logger.isEnabled(Level.ERROR)) break block8;
                _logger.error(e.getLocalizedMessage());
                _logger.error(IQDataServicesResourceBundle.getStringResource("OLAPConnectionResourceNonEmptyIQISession.txt"), (Throwable)e);
                _logger.warn("metadatas = " + metadatas.toList());
                _logger.warn("olapdatas = " + olapdatas.toList());
            }
        }
        MDXGenerationUtil.applyDebugStatement("Close ISession container and associated ISession", this.getClass());
    }

    public IdentityList getOLAPDataSetList() {
        return this._olapDataSetsInterfacesHeld;
    }

    @Override
    public void setMetadataInterface(MetadataInterface metadataI) throws OLAPException, ExecutionException {
        Locale oldMetadataLocale = metadataI.getLocale();
        if (this._connectionLocale != null) {
            if (oldMetadataLocale == null || oldMetadataLocale.toString().equalsIgnoreCase(this._connectionLocale.toString())) {
                metadataI.setLocale(this._connectionLocale);
            } else {
                throw new ExecutionException("The metadata interface with locale '" + oldMetadataLocale + "' cannot be added to an IQ ISession containing locales '" + this._connectionLocale + "'");
            }
        }
        this._metadataInterfacesHeld.add(metadataI);
        MDXGenerationUtil.applyDebugStatement("IMPORTANT: A metadataInterface object is being associated to a IQISession", this.getClass());
    }

    public Locale getISessionLocale() {
        return this._connectionLocale;
    }

    @Override
    public void setOLAPDataSetInterface(OLAPDataSetInterface OLAPDataSet2) {
        this._olapDataSetsInterfacesHeld.add(OLAPDataSet2);
        MDXGenerationUtil.applyDebugStatement("IMPORTANT: A OLAPDataSetInterface object is being associated to a IQISession", this.getClass());
    }
}

