/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class BusinessQueryTotal {
    String totalingType;
    int emptycount1 = 1;
    int emptycount2 = 2;
    int emptycountOld;
    int setCount = 2;
    String defaultTotalLabel;
    String labelForDataItemInSet;
    BusinessQueryActionType sortType;
    String mergerMeasures;
    DataSelection dataSelection;
    DataItem dataItem;
    String totalingDefinition;
    String totalingDefinition2;
    String dataItemLabel;
    String totaledDataItemLabel;
    String totalStringUsed;
    String grandTotalLabelAllTotals = " ";
    String rowLabel;
    boolean measureAtTop = false;
    boolean applyMergedMeasure = false;
    StringBuffer applyTotalSort = new StringBuffer();
    String newline = System.getProperty("line.separator");
    String newtab = "     ";
    private static final Logger _logger = LogManager.getLogger(BusinessQueryTotal.class);

    public BusinessQueryTotal(DataItem dataItem, String typeOfTotaling, String defaultTotalLabel, String labelForDataItemInSet) {
        this.totalingType = typeOfTotaling;
        this.dataItemLabel = dataItem.getLabel();
        this.defaultTotalLabel = defaultTotalLabel;
        this.labelForDataItemInSet = labelForDataItemInSet;
        this.dataItem = dataItem;
        this.totalingDefinition = null;
        this.totaledDataItemLabel = null;
    }

    public boolean isMeasureOnTop() {
        return this.measureAtTop;
    }

    public String getMergedMeasure() {
        return this.mergerMeasures;
    }

    public String generateUNIONMDX(List rowTotalList, String coreMDXExpression, List dimensionTotalList, List column_row, List checkList, boolean nonEmptyTotal) {
        StringBuffer MDXExpression = new StringBuffer();
        int openParenthesesCount = 0;
        if (nonEmptyTotal) {
            MDXExpression.append("NON EMPTY UNION");
        } else {
            MDXExpression.append("UNION");
        }
        MDXExpression.append("(");
        boolean manyColumnOrRow = false;
        boolean measureInColumnOrRow = false;
        if (column_row.size() > 1) {
            manyColumnOrRow = true;
        }
        ++openParenthesesCount;
        for (DataItem _resultItem : column_row) {
            StructureOfDataItem _structure = _resultItem.getStructure();
            if (_structure != StructureOfDataItem.STRUCTURE_MEASURE) continue;
            measureInColumnOrRow = true;
        }
        MDXExpression.append(coreMDXExpression);
        MDXExpression.append(", ");
        if (dimensionTotalList.size() == 0) {
            MDXExpression.append((String)rowTotalList.get(0));
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        if (dimensionTotalList.size() == 1) {
            String totalElement = (String)dimensionTotalList.get(0);
            if (totalElement == null) {
                return coreMDXExpression;
            }
            MDXExpression.append("{");
            MDXExpression.append(totalElement);
            MDXExpression.append("}, ");
        } else {
            Iterator iterator = dimensionTotalList.iterator();
            while (iterator.hasNext()) {
                String totalElement = (String)iterator.next();
                if (iterator.hasNext()) {
                    MDXExpression.append("CROSSJOIN");
                    MDXExpression.append("(");
                    ++openParenthesesCount;
                }
                if (totalElement == null) continue;
                MDXExpression.append("{");
                MDXExpression.append(totalElement);
                MDXExpression.append("}, ");
            }
        }
        if (MDXExpression.length() > 2) {
            StringBuffer closeParentheses = new StringBuffer();
            for (int i = 0; i < openParenthesesCount; ++i) {
                closeParentheses.append(")");
            }
            MDXExpression.replace(MDXExpression.length() - 2, MDXExpression.length(), closeParentheses.toString());
        }
        return MDXExpression.toString();
    }

    public String getTotalSetMDX() {
        if (this.totalingType.equals(BusinessQuery.TOTAL_NONE)) {
            if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("BusinessQueryTotalNoTotaling.txt"));
            }
            return null;
        }
        if (this.totalingType.equals(BusinessQuery.TOTAL_NONE)) {
            return null;
        }
        if (this.totalingDefinition == null) {
            return null;
        }
        StringBuffer combinedSetWithTotalMember = new StringBuffer();
        combinedSetWithTotalMember.append("[");
        combinedSetWithTotalMember.append(this.dataItemLabel);
        combinedSetWithTotalMember.append("AND");
        combinedSetWithTotalMember.append(this.defaultTotalLabel);
        combinedSetWithTotalMember.append("]");
        this.totaledDataItemLabel = combinedSetWithTotalMember.toString();
        return this.totaledDataItemLabel;
    }

    public String getTotalType() {
        return this.totalingType;
    }

    public String generateWITHMDXCombinedSet(DataSelection model, Role role) {
        if (this.totalingType.equals(BusinessQuery.TOTAL_NONE)) {
            return null;
        }
        if (this.totalingDefinition == null) {
            return null;
        }
        StringBuffer MDXExpression = new StringBuffer();
        StringBuffer combinedSetWithTotalMember = new StringBuffer();
        combinedSetWithTotalMember.append("[");
        combinedSetWithTotalMember.append(this.dataItemLabel);
        combinedSetWithTotalMember.append("AND");
        combinedSetWithTotalMember.append(this.defaultTotalLabel);
        combinedSetWithTotalMember.append("]");
        String uncombinedTotalLabel = this.totaledDataItemLabel;
        MDXExpression.append(this.newline);
        MDXExpression.append("SET");
        MDXExpression.append(" ");
        MDXExpression.append(combinedSetWithTotalMember.toString());
        MDXExpression.append(" AS");
        MDXExpression.append(this.newline + this.newtab);
        MDXExpression.append(" '{");
        MDXExpression.append(this.labelForDataItemInSet);
        MDXExpression.append(", ");
        MDXExpression.append(uncombinedTotalLabel);
        MDXExpression.append("}' ");
        return MDXExpression.toString();
    }

    public String generateWITHMDXSet() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        if (this.totalingDefinition == null) {
            return null;
        }
        StringBuffer MDXExpression = new StringBuffer();
        StringBuffer setWithTotalMember = new StringBuffer();
        setWithTotalMember.append("[");
        setWithTotalMember.append(this.dataItemLabel);
        setWithTotalMember.append("TOTAL");
        setWithTotalMember.append(" ");
        setWithTotalMember.append("]");
        this.totaledDataItemLabel = setWithTotalMember.toString();
        MDXExpression.append(this.newline);
        MDXExpression.append("SET");
        MDXExpression.append(" ");
        MDXExpression.append(this.totaledDataItemLabel);
        MDXExpression.append(" ");
        MDXExpression.append(" AS");
        MDXExpression.append(this.newline + this.newtab);
        MDXExpression.append(" '{");
        MDXExpression.append(this.totalingDefinition);
        MDXExpression.append("}' ");
        return MDXExpression.toString();
    }

    public String getTotalingLabel() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        return this.dataItemLabel;
    }

    public void setGrandTotalLabelForAllTotals(String label) {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return;
        }
        this.grandTotalLabelAllTotals = label;
    }

    public String getTotalingDefinition() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        return this.totalingDefinition;
    }

    public String getTotalingFractionalDefinition() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        return this.totalingDefinition2;
    }

    public String generateWITHMDXMember() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        ExpressionInterface expression = this.dataItem.getExpression();
        if (expression instanceof Hierarchy || expression instanceof Level || expression instanceof Dimension || this.isAnAllowedCalculatedExpression(expression)) {
            String hierarchyNameAllMembers = null;
            try {
                hierarchyNameAllMembers = BusinessQueryOLAPUtil.getUniqueNameWithHierarchyAllMember(this.dataItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationHierNameAllMemberException.txt"));
                }
                return null;
            }
            StringBuffer MDXExpression = new StringBuffer();
            MDXExpression.append(this.newline);
            MDXExpression.append("MEMBER");
            MDXExpression.append(" ");
            MDXExpression.append(hierarchyNameAllMembers);
            MDXExpression.append(".[");
            MDXExpression.append(this.defaultTotalLabel);
            MDXExpression.append("] as");
            MDXExpression.append(this.newline + this.newtab);
            MDXExpression.append("'Aggregate(");
            return MDXExpression.toString();
        }
        return null;
    }

    public String getTotalSETLabel() {
        return this.rowLabel;
    }

    public String generateWITHGrandALLMDXMember() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        ExpressionInterface expression = this.dataItem.getExpression();
        if (expression instanceof Hierarchy || expression instanceof Level || expression instanceof Dimension || this.isAnAllowedCalculatedExpression(expression)) {
            String hierarchyNameAllMembers = null;
            try {
                hierarchyNameAllMembers = BusinessQueryOLAPUtil.getUniqueNameWithHierarchyAllMember(this.dataItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationHierNameAllMemberException.txt"));
                }
                return null;
            }
            StringBuffer MDXExpression = new StringBuffer();
            MDXExpression.append(this.newline);
            MDXExpression.append("MEMBER");
            MDXExpression.append(" ");
            MDXExpression.append(hierarchyNameAllMembers);
            MDXExpression.append(".[");
            if (this.grandTotalLabelAllTotals.equalsIgnoreCase(" ")) {
                this.grandTotalLabelAllTotals = "&T";
            }
            MDXExpression.append(this.grandTotalLabelAllTotals);
            MDXExpression.append("] as");
            MDXExpression.append(this.newline + this.newtab);
            MDXExpression.append("'Aggregate(");
            return MDXExpression.toString();
        }
        return null;
    }

    public String getTotalMember() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        ExpressionInterface expression = this.dataItem.getExpression();
        if (expression instanceof Hierarchy || expression instanceof Level || expression instanceof Dimension || this.isAnAllowedCalculatedExpression(expression)) {
            String hierarchyNameAllMembers = null;
            try {
                hierarchyNameAllMembers = BusinessQueryOLAPUtil.getUniqueNameWithHierarchyAllMember(this.dataItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationHierNameAllMemberException.txt"));
                }
                return null;
            }
            StringBuffer calculatedTotalMember = new StringBuffer();
            calculatedTotalMember.append(hierarchyNameAllMembers);
            calculatedTotalMember.append(".[");
            calculatedTotalMember.append(this.defaultTotalLabel);
            calculatedTotalMember.append("]");
            this.totalingDefinition = calculatedTotalMember.toString();
            return this.totalingDefinition;
        }
        return null;
    }

    private boolean isAnAllowedCalculatedExpression(ExpressionInterface expression) {
        boolean isAnAllowedCalculatedExpr;
        block4: {
            isAnAllowedCalculatedExpr = false;
            if (expression instanceof ResourceAwareStringExpression) {
                try {
                    if (this.dataItem != null && !BusinessQueryOLAPUtil.isInMeasureDimension(this.dataItem.getBusinessModel(), this.dataItem)) {
                        isAnAllowedCalculatedExpr = true;
                    }
                }
                catch (MetadataException e) {
                    if (!_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) break block4;
                    _logger.error(IQDataServicesResourceBundle.getStringResource("BusinessQueryTotalExceptionDeterminingMeasure.txt"));
                }
            }
        }
        return isAnAllowedCalculatedExpr;
    }

    public String generateTotalingMDX(String totalType, boolean calculatedRowIs, boolean onlyMeasuresOnRow, String rowLabel1, String totalLabel, List rowTotalSelectList, List grandTotalDimensionRowList, List rows, List grandNameDimensionRowList, boolean nonEmptyTotal, List rowTotalList, List rowTotalLabelList, List rowTotalCurrentMemberList, List rowTotalNameList, List rowMDXGrandALLMembersList, List rowGrandALLMemberNameList, Role role, List measuresColumnTotalingList, StringBuffer measureInColumnTotaling, boolean isMeasureAtTop, boolean isFractionalTotalExpressionTurnOnTotalingRow, Map resultItemMap, List currentMemberList, Role roleInMeasure, int numberOfMeasures, boolean isFractionalTotalExpressionTurnOnTotalingColumnSub, DataSelection dataSelection) {
        ArrayList<DataItem> rows1 = new ArrayList<DataItem>();
        if (roleInMeasure == null) {
            roleInMeasure = Role.HIDDEN;
        }
        this.measureAtTop = isMeasureAtTop;
        this.dataSelection = dataSelection;
        this.sortType = dataSelection.getSortDirection(role);
        for (DataItem rS : rows) {
            if (rS.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
            rows1.add(rS);
        }
        StringBuffer rowSelect = new StringBuffer();
        this.rowLabel = rowLabel1;
        if (rowTotalList.size() == 0) {
            String nothing = "";
            return nothing;
        }
        boolean processSubtotalsForFractional = false;
        boolean subTotalInsideDim = false;
        if (rows.size() > rowTotalList.size() && totalType.equalsIgnoreCase(BusinessQuery.SUBTOTAL)) {
            subTotalInsideDim = true;
        }
        if (totalType.equalsIgnoreCase(BusinessQuery.GRANDTOTAL) && !calculatedRowIs && !onlyMeasuresOnRow) {
            totalLabel = "[&&GRANDTOT" + this._toLabelPart(role) + "&]";
            String rowSelectStr = this.setGrandTotalingLine(rowTotalList, this.rowLabel, totalLabel, rowTotalSelectList, grandTotalDimensionRowList, rows, grandNameDimensionRowList, isFractionalTotalExpressionTurnOnTotalingRow, nonEmptyTotal);
            rowSelect.append(rowSelectStr);
            if (!isFractionalTotalExpressionTurnOnTotalingRow) {
                this.rowLabel = "{[&&GRANDTOT" + this._toLabelPart(role) + "&]}";
                String mergerMeasures = this.mergeMeasureWithColumn(measureInColumnTotaling, isMeasureAtTop, role);
                if (mergerMeasures.length() > 0) {
                    rowSelect.append(mergerMeasures);
                }
            }
            return rowSelect.toString();
        }
        if ((totalType.equalsIgnoreCase(BusinessQuery.SUBTOTAL) || totalType.equalsIgnoreCase(BusinessQuery.ALLTOTAL) || isFractionalTotalExpressionTurnOnTotalingRow) && rows.size() == 1 && !calculatedRowIs && !onlyMeasuresOnRow || rowTotalList.size() == 1 && totalType.equals(BusinessQuery.ALLTOTAL) && roleInMeasure.equals(role) && rows1.size() == 1 && rows.size() == 2) {
            if (totalType.equalsIgnoreCase(BusinessQuery.SUBTOTAL)) {
                totalLabel = "[&&SUBTOT" + this._toLabelPart(role) + "&]";
            } else if (totalType.equalsIgnoreCase(BusinessQuery.ALLTOTAL)) {
                totalLabel = "[&&ALLTOT" + this._toLabelPart(role) + "&]";
            }
            String mergerLabel = "[&&MERGETOTALMEASURE" + this._toLabelPart(role) + "&]";
            StringBuffer subTotal = new StringBuffer();
            subTotal.append((String)rowTotalSelectList.get(0));
            subTotal.append(this.rowLabel);
            subTotal.append(")' ");
            String test1 = measureInColumnTotaling.toString();
            StringBuffer rS = new StringBuffer();
            rS.append("{");
            rS.append((String)resultItemMap.get(rows.get(0)));
            rS.append("}");
            if (test1.equalsIgnoreCase(rS.toString())) {
                this.measureAtTop = true;
            }
            subTotal.append(this.newline);
            subTotal.append("SET ");
            subTotal.append(totalLabel);
            subTotal.append(" AS");
            subTotal.append(this.newline + this.newtab);
            subTotal.append("'UNION(");
            subTotal.append(this.rowLabel);
            subTotal.append(",");
            subTotal.append((String)rowTotalList.get(0));
            subTotal.append(")' ");
            BusinessQueryActionType sortDirect = dataSelection.getSortDirection(role);
            if (!sortDirect.equals(BusinessQueryActionType.SORT_NONE) && roleInMeasure.equals(role)) {
                this.applyMergedMeasure = true;
            }
            if (totalType.equalsIgnoreCase(BusinessQuery.SUBTOTAL) && !this.measureAtTop) {
                subTotal.append(this.newline);
                subTotal.append("SET ");
                String mergeWithFirst = "[&&MERGETOP" + this._toLabelPart(role) + "&]";
                subTotal.append(mergeWithFirst);
                subTotal.append(" AS");
                subTotal.append(this.newline + this.newtab);
                subTotal.append("'CROSSJOIN(");
                subTotal.append(rS.toString());
                subTotal.append(",");
                subTotal.append(totalLabel);
                subTotal.append(")'");
                totalLabel = mergeWithFirst;
            }
            subTotal.append(this.newline);
            subTotal.append("SET ");
            subTotal.append(mergerLabel);
            subTotal.append(" AS");
            subTotal.append(this.newline + this.newtab);
            subTotal.append("'");
            if (roleInMeasure != null) {
                if (roleInMeasure.equals(role) && !isFractionalTotalExpressionTurnOnTotalingRow) {
                    if (this.measureAtTop) {
                        subTotal.append("CROSSJOIN(");
                        subTotal.append(test1);
                        subTotal.append(",");
                        subTotal.append(totalLabel);
                        subTotal.append(")");
                    } else {
                        subTotal.append("CROSSJOIN(");
                        subTotal.append(totalLabel);
                        subTotal.append(",");
                        subTotal.append(test1);
                        subTotal.append(")");
                    }
                } else if (roleInMeasure.equals(role) && isFractionalTotalExpressionTurnOnTotalingRow) {
                    if (this.measureAtTop) {
                        subTotal.append("CROSSJOIN(");
                        subTotal.append(test1);
                        subTotal.append(",");
                        subTotal.append(this.rowLabel);
                        subTotal.append(")");
                    } else {
                        subTotal.append("CROSSJOIN(");
                        subTotal.append(this.rowLabel);
                        subTotal.append(",");
                        subTotal.append(test1);
                        subTotal.append(")");
                    }
                } else if (isFractionalTotalExpressionTurnOnTotalingRow) {
                    subTotal.append(this.rowLabel);
                } else {
                    subTotal.append(totalLabel);
                }
                subTotal.append("'");
                this.rowLabel = totalLabel = mergerLabel;
            }
            rowSelect.append(subTotal.toString());
            return rowSelect.toString();
        }
        if ((totalType.equals(BusinessQuery.ALLTOTAL) || totalType.equals(BusinessQuery.SUBTOTAL) || isFractionalTotalExpressionTurnOnTotalingRow) && rowTotalList.size() > 0) {
            ArrayList subTotalLabelsList = new ArrayList();
            int ctR = rowTotalList.size() - 1;
            int ctR3 = 0;
            StringBuffer allSubTotalLine = new StringBuffer();
            if (totalType.equals(BusinessQuery.ALLTOTAL)) {
                totalLabel = "[&&ALLTOT" + this._toLabelPart(role) + "&]";
            } else if (totalType.equals(BusinessQuery.SUBTOTAL)) {
                totalLabel = "[&&SUBTOT" + this._toLabelPart(role) + "&]";
            }
            int endOfSubTotaling = 0;
            if (totalType.equals(BusinessQuery.SUBTOTAL) && subTotalInsideDim) {
                endOfSubTotaling = -1;
            } else if (isFractionalTotalExpressionTurnOnTotalingRow || isFractionalTotalExpressionTurnOnTotalingColumnSub) {
                endOfSubTotaling = -1;
                processSubtotalsForFractional = true;
            }
            int endOfSubTotalingFinish = 1;
            if (rowTotalList.size() > 0) {
                int end = rowTotalLabelList.size();
                int numberPassed = 1;
                while (ctR > endOfSubTotaling) {
                    allSubTotalLine.append(this.newline);
                    allSubTotalLine.append("MEMBER ");
                    allSubTotalLine.append((String)rowTotalList.get(ctR));
                    subTotalLabelsList.add(rowTotalList.get(ctR));
                    allSubTotalLine.append(" AS");
                    allSubTotalLine.append(this.newline + this.newtab);
                    allSubTotalLine.append("'AGGREGATE(INTERSECT(");
                    allSubTotalLine.append(this.rowLabel);
                    allSubTotalLine.append(", ");
                    int paren = 0;
                    if (subTotalInsideDim && currentMemberList.size() > 1) {
                        allSubTotalLine.append("CROSSJOIN(");
                        allSubTotalLine.append("{");
                        allSubTotalLine.append((String)currentMemberList.get(0));
                        allSubTotalLine.append(".currentmember}, ");
                        ++paren;
                    }
                    while (ctR3 < end) {
                        if (ctR3 + 1 < end) {
                            allSubTotalLine.append("CROSSJOIN(");
                            if (ctR3 == endOfSubTotalingFinish && ctR == endOfSubTotalingFinish) {
                                allSubTotalLine.append("{");
                                allSubTotalLine.append((String)rowTotalCurrentMemberList.get(0));
                                allSubTotalLine.append(".currentmember}, ");
                                allSubTotalLine.append("CROSSJOIN(");
                                ++paren;
                                allSubTotalLine.append((String)rowTotalNameList.get(ctR3));
                                allSubTotalLine.append(", ");
                            } else if (numberPassed == 1) {
                                allSubTotalLine.append("{");
                                allSubTotalLine.append((String)rowTotalCurrentMemberList.get(ctR3));
                                allSubTotalLine.append(".currentmember}, ");
                            } else {
                                allSubTotalLine.append((String)rowTotalNameList.get(ctR3));
                                if (ctR3 < rowTotalNameList.size()) {
                                    allSubTotalLine.append(", ");
                                }
                            }
                            ++paren;
                        } else {
                            allSubTotalLine.append((String)rowTotalNameList.get(ctR3));
                            StringBuffer closeParentheses1 = new StringBuffer();
                            for (int i = 0; i < paren; ++i) {
                                closeParentheses1.append(")");
                            }
                            allSubTotalLine.append(closeParentheses1.toString());
                        }
                        ++ctR3;
                    }
                    allSubTotalLine.append("))'");
                    ctR3 = --ctR;
                    ++numberPassed;
                }
            }
            if (allSubTotalLine.length() > 0) {
                rowSelect.append(allSubTotalLine.toString());
            }
            boolean multipleSubtotalLines = false;
            if (rowTotalList.size() > 2) {
                multipleSubtotalLines = true;
            } else if (rowTotalList.size() == 2 && rows1.size() > 2) {
                multipleSubtotalLines = true;
            }
            if (rowTotalList.size() == 2 && !multipleSubtotalLines || rows.size() > 2 && !multipleSubtotalLines && rows1.size() == 2 && role.equals(roleInMeasure) || rows.size() == 2 && !multipleSubtotalLines) {
                String mergerMeasures;
                String empty;
                if (totalType.equals(BusinessQuery.SUBTOTAL) && !isFractionalTotalExpressionTurnOnTotalingRow || totalType.equals(BusinessQuery.ALLTOTAL) && roleInMeasure.equals(role) && rows1.size() == 1 && rows.size() == 2 || isFractionalTotalExpressionTurnOnTotalingColumnSub && totalType.equals(BusinessQuery.ALLTOTAL)) {
                    StringBuffer subTotalLineWithTwo = new StringBuffer();
                    subTotalLineWithTwo.append(this.newline);
                    subTotalLineWithTwo.append("SET [&&SET");
                    subTotalLineWithTwo.append(this.setCount);
                    subTotalLineWithTwo.append("] AS");
                    subTotalLineWithTwo.append(this.newline + this.newtab);
                    subTotalLineWithTwo.append("'UNION(");
                    subTotalLineWithTwo.append(this.rowLabel);
                    subTotalLineWithTwo.append(", CROSSJOIN(");
                    if (rowTotalList.size() == 1 && rows.size() == 2) {
                        subTotalLineWithTwo.append((String)resultItemMap.get(rows.get(0)));
                        subTotalLineWithTwo.append(", {");
                        subTotalLineWithTwo.append((String)rowTotalList.get(0));
                    } else if (rows.size() > 2 && !multipleSubtotalLines && rows1.size() == 2 && role.equals(roleInMeasure) && !isFractionalTotalExpressionTurnOnTotalingColumnSub) {
                        subTotalLineWithTwo.append((String)resultItemMap.get(rows.get(0)));
                        subTotalLineWithTwo.append(", {");
                        subTotalLineWithTwo.append((String)rowTotalList.get(0));
                    } else {
                        subTotalLineWithTwo.append((String)rowTotalNameList.get(0));
                        subTotalLineWithTwo.append(", {");
                        subTotalLineWithTwo.append((String)rowTotalList.get(1));
                    }
                    subTotalLineWithTwo.append("}))'");
                    subTotalLineWithTwo.append(this.newline);
                    subTotalLineWithTwo.append("SET ");
                    subTotalLineWithTwo.append(totalLabel);
                    subTotalLineWithTwo.append(" AS");
                    subTotalLineWithTwo.append(this.newline + this.newtab);
                    subTotalLineWithTwo.append("'HIERARCHIZE([&&SET");
                    subTotalLineWithTwo.append(this.setCount);
                    subTotalLineWithTwo.append("])'");
                    ++this.setCount;
                    this.rowLabel = totalLabel;
                    rowSelect.append(subTotalLineWithTwo.toString());
                } else if (totalType.equals(BusinessQuery.ALLTOTAL) && !processSubtotalsForFractional) {
                    StringBuffer allTotalLineWithTwo = new StringBuffer();
                    allTotalLineWithTwo.append(this.newline);
                    allTotalLineWithTwo.append("MEMBER ");
                    allTotalLineWithTwo.append((String)rowTotalList.get(0));
                    allTotalLineWithTwo.append(" AS");
                    allTotalLineWithTwo.append(this.newline + this.newtab);
                    allTotalLineWithTwo.append("'AGGREGATE(");
                    allTotalLineWithTwo.append(this.rowLabel);
                    allTotalLineWithTwo.append(")'");
                    if (!isFractionalTotalExpressionTurnOnTotalingRow) {
                        allTotalLineWithTwo.append(this.newline);
                        allTotalLineWithTwo.append("SET [&&TOTALED");
                        allTotalLineWithTwo.append((String)rowTotalLabelList.get(0));
                        allTotalLineWithTwo.append("&&] AS");
                        allTotalLineWithTwo.append(this.newline + this.newtab);
                        allTotalLineWithTwo.append("'{");
                        allTotalLineWithTwo.append((String)rowTotalNameList.get(0));
                        allTotalLineWithTwo.append(",");
                        allTotalLineWithTwo.append((String)rowTotalList.get(0));
                        allTotalLineWithTwo.append("}'");
                        if (!isFractionalTotalExpressionTurnOnTotalingColumnSub) {
                            allTotalLineWithTwo.append(this.newline);
                            allTotalLineWithTwo.append("SET [&&SET");
                            allTotalLineWithTwo.append(this.setCount);
                            allTotalLineWithTwo.append("] AS");
                            allTotalLineWithTwo.append(this.newline + this.newtab);
                            allTotalLineWithTwo.append("'UNION(");
                            allTotalLineWithTwo.append(this.rowLabel);
                            allTotalLineWithTwo.append(", CROSSJOIN(");
                            allTotalLineWithTwo.append("[&&TOTALED");
                            allTotalLineWithTwo.append((String)rowTotalLabelList.get(0));
                            allTotalLineWithTwo.append("&&], {");
                            allTotalLineWithTwo.append((String)rowTotalList.get(1));
                            allTotalLineWithTwo.append("}))'");
                            allTotalLineWithTwo.append(this.newline);
                            allTotalLineWithTwo.append("SET ");
                            allTotalLineWithTwo.append(totalLabel);
                            allTotalLineWithTwo.append(" AS");
                            allTotalLineWithTwo.append(this.newline + this.newtab);
                            allTotalLineWithTwo.append("'HIERARCHIZE([&&SET");
                            allTotalLineWithTwo.append(this.setCount);
                            allTotalLineWithTwo.append("])'");
                            this.rowLabel = totalLabel;
                        }
                    }
                    ++this.setCount;
                    if (!processSubtotalsForFractional) {
                        rowSelect.append(allTotalLineWithTwo.toString());
                    }
                }
                if (numberOfMeasures > 0 && rowTotalList.size() == 2 && (empty = this.createEmptyMDX(rowTotalCurrentMemberList, rowTotalList, measuresColumnTotalingList, totalType)).length() > 0 && !isFractionalTotalExpressionTurnOnTotalingRow && !isFractionalTotalExpressionTurnOnTotalingColumnSub) {
                    rowSelect.append(empty);
                    StringBuffer emptied = new StringBuffer();
                    emptied.append(this.newline);
                    emptied.append("SET ");
                    String emptyLabel = "[&&EMPTIEDTOTALED" + this._toLabelPart(role) + "&&]";
                    emptied.append(emptyLabel);
                    emptied.append(" AS");
                    emptied.append(this.newline + this.newtab);
                    emptied.append("'FILTER(");
                    emptied.append(this.rowLabel);
                    emptied.append(",  [MEASURES].[@STRIPEMPTYSUBTOTAL");
                    emptied.append(this.emptycountOld);
                    emptied.append("] <> -7777777777)' ");
                    this.rowLabel = emptyLabel;
                    rowSelect.append(emptied);
                }
                if ((mergerMeasures = this.mergeMeasureWithColumn(measureInColumnTotaling, isMeasureAtTop, role)).length() > 0) {
                    rowSelect.append(mergerMeasures);
                }
            } else if (multipleSubtotalLines && !isFractionalTotalExpressionTurnOnTotalingRow) {
                String mergerMeasures;
                String empty;
                ArrayList<String> subTotalLabelsList2 = new ArrayList<String>();
                StringBuffer labelSubtotalApply = new StringBuffer();
                StringBuffer labelGrandTotalApply = new StringBuffer();
                if (totalType.equals(BusinessQuery.SUBTOTAL) || totalType.equals(BusinessQuery.ALLTOTAL)) {
                    int i;
                    StringBuffer closeParentheses1;
                    StringBuffer subTotalLineWithMoreTwo = new StringBuffer();
                    int ctR1 = rowTotalList.size() - 1;
                    int endIt = 1;
                    if (totalType.equals(BusinessQuery.SUBTOTAL)) {
                        endIt = 0;
                    }
                    while (ctR1 > endIt) {
                        subTotalLineWithMoreTwo.append(this.newline);
                        subTotalLineWithMoreTwo.append("MEMBER ");
                        String label = (String)rowTotalList.get(ctR1);
                        String modLabel = label.substring(0, label.lastIndexOf("."));
                        subTotalLineWithMoreTwo.append(modLabel);
                        subTotalLineWithMoreTwo.append(".[&S] AS");
                        subTotalLineWithMoreTwo.append(this.newline + this.newtab);
                        subTotalLineWithMoreTwo.append("'AGGREGATE(INTERSECT(");
                        StringBuffer temp = new StringBuffer();
                        temp.append(modLabel);
                        temp.append(".[&S]");
                        subTotalLabelsList2.add(temp.toString());
                        subTotalLineWithMoreTwo.append(this.rowLabel);
                        subTotalLineWithMoreTwo.append(", ");
                        int paren1 = 0;
                        subTotalLineWithMoreTwo.append("CROSSJOIN(");
                        subTotalLineWithMoreTwo.append("{");
                        subTotalLineWithMoreTwo.append((String)currentMemberList.get(0));
                        subTotalLineWithMoreTwo.append(".currentmember}, ");
                        ++paren1;
                        int end = rowTotalLabelList.size();
                        int startOfTotals = 0;
                        if (totalType.equals(BusinessQuery.ALLTOTAL)) {
                            startOfTotals = 1;
                        }
                        while (startOfTotals < end) {
                            if (startOfTotals + 1 < end) {
                                subTotalLineWithMoreTwo.append("CROSSJOIN(");
                                ++paren1;
                            }
                            subTotalLineWithMoreTwo.append((String)rowTotalNameList.get(startOfTotals));
                            if (startOfTotals + 1 < end) {
                                subTotalLineWithMoreTwo.append(",");
                            }
                            ++startOfTotals;
                        }
                        closeParentheses1 = new StringBuffer();
                        for (i = 0; i < paren1; ++i) {
                            closeParentheses1.append(")");
                        }
                        subTotalLineWithMoreTwo.append(closeParentheses1.toString());
                        --ctR1;
                    }
                    if (subTotalLineWithMoreTwo.length() > 0) {
                        subTotalLineWithMoreTwo.append("))'");
                        rowSelect.append(subTotalLineWithMoreTwo);
                    }
                    if (subTotalLabelsList.size() > 0 && !isFractionalTotalExpressionTurnOnTotalingRow) {
                        StringBuffer subTotalLineWithMoreTwoJoin = new StringBuffer();
                        int endHold = subTotalLabelsList.size();
                        int paren3 = 0;
                        int countOfUnions = 0;
                        String labelSubtotal = "[" + this._toLabelPart(role) + "SubTotal";
                        while (countOfUnions < endHold) {
                            int countOfTotals;
                            ++countOfUnions;
                            subTotalLineWithMoreTwoJoin.append(this.newline);
                            subTotalLineWithMoreTwoJoin.append("SET ");
                            subTotalLineWithMoreTwoJoin.append(labelSubtotal);
                            subTotalLineWithMoreTwoJoin.append(countOfUnions);
                            labelSubtotalApply.delete(0, labelSubtotalApply.length());
                            labelSubtotalApply.append(labelSubtotal);
                            labelSubtotalApply.append(countOfUnions);
                            labelSubtotalApply.append("]");
                            subTotalLineWithMoreTwoJoin.append("] AS");
                            subTotalLineWithMoreTwoJoin.append(this.newline + this.newtab);
                            subTotalLineWithMoreTwoJoin.append("'UNION(");
                            if (countOfUnions == 1) {
                                subTotalLineWithMoreTwoJoin.append(this.rowLabel);
                                subTotalLineWithMoreTwoJoin.append(", ");
                            } else {
                                subTotalLineWithMoreTwoJoin.append(labelSubtotal);
                                subTotalLineWithMoreTwoJoin.append(countOfUnions - 1);
                                subTotalLineWithMoreTwoJoin.append("], ");
                            }
                            subTotalLineWithMoreTwoJoin.append("CROSSJOIN(");
                            subTotalLineWithMoreTwoJoin.append((String)resultItemMap.get(rows.get(0)));
                            subTotalLineWithMoreTwoJoin.append(", ");
                            ++paren3;
                            int ctt3 = subTotalLabelsList.size() - 1;
                            int countOfBlankUnion = countOfTotals = 0;
                            while (countOfTotals < subTotalLabelsList.size()) {
                                if (countOfTotals < ctt3) {
                                    subTotalLineWithMoreTwoJoin.append("CROSSJOIN(");
                                    ++paren3;
                                }
                                if (countOfUnions == 1) {
                                    if (countOfTotals == 0) {
                                        if (totalType.equals(BusinessQuery.SUBTOTAL)) {
                                            subTotalLineWithMoreTwoJoin.append((String)rowTotalNameList.get(countOfTotals));
                                        } else {
                                            subTotalLineWithMoreTwoJoin.append((String)rowTotalNameList.get(countOfTotals + 1));
                                        }
                                    } else {
                                        subTotalLineWithMoreTwoJoin.append((String)subTotalLabelsList.get(countOfTotals - 1));
                                    }
                                    if (countOfTotals < ctt3) {
                                        subTotalLineWithMoreTwoJoin.append(",");
                                    }
                                } else {
                                    if (countOfTotals == 0) {
                                        subTotalLineWithMoreTwoJoin.append((String)subTotalLabelsList.get(countOfTotals + 1));
                                    } else {
                                        subTotalLineWithMoreTwoJoin.append((String)subTotalLabelsList2.get(countOfBlankUnion));
                                    }
                                    if (countOfTotals < ctt3) {
                                        subTotalLineWithMoreTwoJoin.append(",");
                                    }
                                }
                                countOfBlankUnion = ++countOfTotals;
                                --countOfBlankUnion;
                            }
                            StringBuffer closeParentheses33 = new StringBuffer();
                            for (int i2 = 0; i2 < paren3; ++i2) {
                                closeParentheses33.append(")");
                            }
                            paren3 = 0;
                            subTotalLineWithMoreTwoJoin.append(closeParentheses33.toString());
                            subTotalLineWithMoreTwoJoin.append(")'");
                        }
                        rowSelect.append(subTotalLineWithMoreTwoJoin.toString());
                    }
                    if (totalType.equals(BusinessQuery.ALLTOTAL) || isFractionalTotalExpressionTurnOnTotalingRow) {
                        StringBuffer grandTotal = new StringBuffer();
                        Iterator iTR = rowMDXGrandALLMembersList.iterator();
                        int ctt = 0;
                        while (iTR.hasNext()) {
                            grandTotal.append(iTR.next());
                            grandTotal.append(this.rowLabel);
                            grandTotal.append(")' ");
                            ++ctt;
                        }
                        rowSelect.append(grandTotal.toString());
                        Iterator iRG = rowGrandALLMemberNameList.iterator();
                        StringBuffer grandTotalMembers = new StringBuffer();
                        grandTotalMembers.append(this.newline);
                        grandTotalMembers.append("SET ");
                        labelGrandTotalApply.append("[" + this._toLabelPart(role) + "GRANDTOTAL]");
                        grandTotalMembers.append(labelGrandTotalApply.toString());
                        grandTotalMembers.append(" AS");
                        grandTotalMembers.append(this.newline + this.newtab);
                        grandTotalMembers.append("'");
                        int paren4 = 0;
                        while (iRG.hasNext()) {
                            String grandAllMemberLabel = (String)iRG.next();
                            if (iRG.hasNext()) {
                                grandTotalMembers.append("CROSSJOIN(");
                                ++paren4;
                            }
                            grandTotalMembers.append(grandAllMemberLabel);
                            if (!iRG.hasNext()) continue;
                            grandTotalMembers.append(",");
                        }
                        closeParentheses1 = new StringBuffer();
                        for (i = 0; i < paren4; ++i) {
                            closeParentheses1.append(")");
                        }
                        grandTotalMembers.append(closeParentheses1.toString());
                        grandTotalMembers.append("' ");
                        rowSelect.append(grandTotalMembers.toString());
                    }
                }
                StringBuffer allTotalFinalLine = new StringBuffer();
                if (totalType.equals(BusinessQuery.ALLTOTAL) && !isFractionalTotalExpressionTurnOnTotalingRow && !isFractionalTotalExpressionTurnOnTotalingColumnSub) {
                    allTotalFinalLine.append(this.newline);
                    allTotalFinalLine.append("SET ");
                    allTotalFinalLine.append(totalLabel);
                    allTotalFinalLine.append(" AS");
                    allTotalFinalLine.append(this.newline + this.newtab);
                    allTotalFinalLine.append("'HIERARCHIZE(UNION(");
                    allTotalFinalLine.append(labelSubtotalApply.toString());
                    allTotalFinalLine.append(",");
                    allTotalFinalLine.append(labelGrandTotalApply);
                    allTotalFinalLine.append("))'");
                } else if (totalType.equals(BusinessQuery.SUBTOTAL) && !isFractionalTotalExpressionTurnOnTotalingRow) {
                    allTotalFinalLine.append(this.newline);
                    allTotalFinalLine.append("SET ");
                    allTotalFinalLine.append(totalLabel);
                    allTotalFinalLine.append(" AS");
                    allTotalFinalLine.append(this.newline + this.newtab);
                    allTotalFinalLine.append("'HIERARCHIZE(");
                    allTotalFinalLine.append(labelSubtotalApply.toString());
                    allTotalFinalLine.append(")'");
                }
                rowSelect.append(allTotalFinalLine.toString());
                this.rowLabel = totalLabel;
                if (numberOfMeasures > 0 && (empty = this.createEmptyMDX(rowTotalCurrentMemberList, rowTotalList, measuresColumnTotalingList, totalType)).length() > 0 && !isFractionalTotalExpressionTurnOnTotalingRow && !isFractionalTotalExpressionTurnOnTotalingColumnSub) {
                    rowSelect.append(empty);
                    StringBuffer emptied = new StringBuffer();
                    emptied.append(this.newline);
                    emptied.append("SET ");
                    String emptyLabel = "[&&EMPTIEDTOTALED" + this._toLabelPart(role) + "&&]";
                    emptied.append(emptyLabel);
                    emptied.append(" AS");
                    emptied.append(this.newline + this.newtab);
                    emptied.append("'FILTER(");
                    emptied.append(this.rowLabel);
                    emptied.append(",  [MEASURES].[@STRIPEMPTYSUBTOTAL");
                    emptied.append(this.emptycountOld);
                    emptied.append("] <> -7777777777)' ");
                    this.rowLabel = emptyLabel;
                    rowSelect.append(emptied);
                }
                if ((mergerMeasures = this.mergeMeasureWithColumn(measureInColumnTotaling, isMeasureAtTop, role)).length() > 0) {
                    rowSelect.append(mergerMeasures);
                }
            } else if (totalType.equals(BusinessQuery.ALLTOTAL) && isFractionalTotalExpressionTurnOnTotalingRow && roleInMeasure.equals(role) && (role == Role.ROW || role == Role.COLUMN) && rows.size() > 2 && rowTotalList.size() > 2) {
                this.rowLabel = rowLabel1;
                String mergerMeasures = this.mergeMeasureWithColumn(measureInColumnTotaling, isMeasureAtTop, role);
                if (mergerMeasures.length() > 0) {
                    rowSelect.append(mergerMeasures);
                }
            }
        }
        return rowSelect.toString();
    }

    protected String mergeMeasureWithColumn(StringBuffer measureInColumnTotaling, boolean isMeasureAtTop, Role role) {
        StringBuffer mergerMeasures = new StringBuffer();
        if (this.sortType.equals(BusinessQueryActionType.SORT_NONE)) {
            if (measureInColumnTotaling.length() > 0) {
                mergerMeasures.append(this.newline);
                mergerMeasures.append("SET [&&MERGETOTALMEASURE");
                mergerMeasures.append(this._toLabelPart(role));
                mergerMeasures.append("&&] AS");
                mergerMeasures.append(this.newline + this.newtab);
                mergerMeasures.append("'CROSSJOIN(");
                if (isMeasureAtTop) {
                    mergerMeasures.append(measureInColumnTotaling.toString());
                    mergerMeasures.append(",");
                    mergerMeasures.append(this.rowLabel);
                } else {
                    mergerMeasures.append(this.rowLabel);
                    mergerMeasures.append(",");
                    mergerMeasures.append(measureInColumnTotaling.toString());
                }
                mergerMeasures.append(")'");
                this.rowLabel = "{[&&MERGETOTALMEASURE" + this._toLabelPart(role) + "&&]}";
            }
        } else {
            mergerMeasures.append(this.newline);
            mergerMeasures.append("SET [&&MERGETOTALMEASURE");
            mergerMeasures.append(this._toLabelPart(role));
            mergerMeasures.append("&&] AS");
            mergerMeasures.append(this.newline + this.newtab);
            mergerMeasures.append("'");
            mergerMeasures.append(this.rowLabel);
            mergerMeasures.append("'");
            this.rowLabel = "{[&&MERGETOTALMEASURE" + this._toLabelPart(role) + "&&]}";
            if (measureInColumnTotaling.length() > 0) {
                this.applyTotalSort.append(this.newline);
                this.applyTotalSort.append("SET [&&SORTEDMERGETOTALMEASURE");
                this.applyTotalSort.append(this._toLabelPart(role));
                this.applyTotalSort.append("&&] AS");
                this.applyTotalSort.append(this.newline + this.newtab);
                this.applyTotalSort.append("'CROSSJOIN(");
                if (isMeasureAtTop) {
                    this.applyTotalSort.append(measureInColumnTotaling.toString());
                    if (role == Role.COLUMN) {
                        this.applyTotalSort.append(",[&&SORTEDCOL&])'");
                    } else {
                        this.applyTotalSort.append(",[&&SORTEDROW&])'");
                    }
                } else {
                    if (role == Role.COLUMN) {
                        this.applyTotalSort.append(" [&&SORTEDCOL&],");
                    } else {
                        this.applyTotalSort.append(" [&&SORTEDROW&],");
                    }
                    this.applyTotalSort.append(measureInColumnTotaling.toString());
                    this.applyTotalSort.append(")'");
                }
            }
        }
        return mergerMeasures.toString();
    }

    public String getAppliedTotalSort() {
        return this.applyTotalSort.toString();
    }

    protected String createEmptyMDX(List rowTotalCurrentMemberList, List rowTotalList, List measuresTotalingList, String totalType) {
        StringBuffer empty1 = new StringBuffer();
        empty1.append(this.newline);
        empty1.append("MEMBER [MEASURES].[@STRIPEMPTYSUBTOTAL");
        empty1.append(this.emptycount1);
        empty1.append("] AS");
        empty1.append(this.newline + this.newtab);
        empty1.append("'");
        Iterator i1 = rowTotalCurrentMemberList.iterator();
        int ct = 0;
        int paren = 0;
        while (i1.hasNext()) {
            String it = (String)i1.next();
            if (totalType.equals(BusinessQuery.SUBTOTAL) && ct == 0) {
                ++ct;
                continue;
            }
            empty1.append("iif(");
            empty1.append(it);
            empty1.append(".CURRENTMEMBER IS ");
            empty1.append((String)rowTotalList.get(ct));
            ++ct;
            ++paren;
            empty1.append(", -99999999999");
            if (!i1.hasNext()) continue;
            empty1.append(",");
        }
        empty1.append(",0");
        StringBuffer closeParentheses1 = new StringBuffer();
        for (int i = 0; i < paren; ++i) {
            closeParentheses1.append(")");
        }
        empty1.append(closeParentheses1.toString());
        empty1.append("'");
        empty1.append(this.newline);
        empty1.append("MEMBER [MEASURES].[@STRIPEMPTYSUBTOTAL");
        empty1.append(this.emptycount2);
        empty1.append("] AS");
        empty1.append(this.newline + this.newtab);
        empty1.append("'iif(");
        Iterator i2 = measuresTotalingList.iterator();
        while (i2.hasNext()) {
            empty1.append(" isempty(");
            empty1.append((String)i2.next());
            empty1.append(") and");
        }
        empty1.append(" [measures].[@stripEmptySubtotal");
        empty1.append(this.emptycount1);
        empty1.append("] = -99999999999, -7777777777,0)' ");
        this.emptycountOld = this.emptycount2++;
        ++this.emptycount1;
        ++this.emptycount1;
        ++this.emptycount2;
        return empty1.toString();
    }

    protected String setGrandTotalingLine(List rowTotalList, String rowLabel, String totalLabel, List rowTotalSelectList, List grandTotalDimensionRowList, List rows, List grandNameDimensionList, boolean isFractionalTotalExpressionTurnOnTotalingRow, boolean nonEmptyTotal) {
        StringBuffer grandTotal = new StringBuffer();
        Iterator iTR = rowTotalSelectList.iterator();
        int ctt = 0;
        while (iTR.hasNext()) {
            grandTotal.append(iTR.next());
            grandTotal.append(rowLabel);
            grandTotal.append(")' ");
            ++ctt;
        }
        if (isFractionalTotalExpressionTurnOnTotalingRow) {
            return grandTotal.toString();
        }
        grandTotal.append(this.newline);
        grandTotal.append("SET ");
        grandTotal.append(totalLabel);
        grandTotal.append(" AS");
        grandTotal.append(this.newline + this.newtab);
        grandTotal.append("'");
        String _tempTotalMDX = this.generateUNIONMDX(rowTotalList, rowLabel, grandTotalDimensionRowList, rows, grandNameDimensionList, nonEmptyTotal);
        grandTotal.append(_tempTotalMDX);
        grandTotal.append("'");
        return grandTotal.toString();
    }

    public String getTotalGrandForALLTotalMember() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        ExpressionInterface expression = this.dataItem.getExpression();
        if (expression instanceof Hierarchy || expression instanceof Level || expression instanceof Dimension || this.isAnAllowedCalculatedExpression(expression)) {
            String hierarchyNameAllMembers = null;
            try {
                hierarchyNameAllMembers = BusinessQueryOLAPUtil.getUniqueNameWithHierarchyAllMember(this.dataItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationHierNameAllMemberException.txt"));
                }
                return null;
            }
            StringBuffer calculatedTotalMember = new StringBuffer();
            calculatedTotalMember.append(hierarchyNameAllMembers);
            calculatedTotalMember.append(".[");
            if (this.grandTotalLabelAllTotals.equalsIgnoreCase(" ")) {
                this.grandTotalLabelAllTotals = "&T";
            }
            calculatedTotalMember.append(this.grandTotalLabelAllTotals);
            calculatedTotalMember.append("]");
            return calculatedTotalMember.toString();
        }
        return null;
    }

    public String generateWITHMDXFractionalMember() {
        if (this.totalingType == BusinessQuery.TOTAL_NONE) {
            return null;
        }
        ExpressionInterface expression = this.dataItem.getExpression();
        if (expression instanceof Hierarchy || expression instanceof Level || expression instanceof Dimension || this.isAnAllowedCalculatedExpression(expression)) {
            String hierarchyNameAllMembers = null;
            try {
                hierarchyNameAllMembers = BusinessQueryOLAPUtil.getUniqueNameWithHierarchyAllMember(this.dataItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(org.apache.logging.log4j.Level.ERROR)) {
                    _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationHierNameAllMemberException.txt"));
                }
                return null;
            }
            StringBuffer MDXExpression = new StringBuffer();
            StringBuffer calculatedTotalMember = new StringBuffer();
            MDXExpression.append(this.newline);
            MDXExpression.append("MEMBER");
            MDXExpression.append(" ");
            MDXExpression.append(hierarchyNameAllMembers);
            calculatedTotalMember.append(hierarchyNameAllMembers);
            MDXExpression.append(".[");
            calculatedTotalMember.append(".[&&FRACTIONAL$");
            MDXExpression.append(this.defaultTotalLabel);
            calculatedTotalMember.append(this.defaultTotalLabel);
            MDXExpression.append("]");
            calculatedTotalMember.append("]");
            this.totalingDefinition2 = calculatedTotalMember.toString();
            MDXExpression.append(" AS");
            MDXExpression.append(this.newline + this.newtab);
            MDXExpression.append("'AGGREGATE");
            MDXExpression.append("(");
            MDXExpression.append(this.labelForDataItemInSet);
            MDXExpression.append(")' ");
            return MDXExpression.toString();
        }
        return null;
    }

    private String _toLabelPart(Role role) {
        String labelPart = "";
        if (role == Role.BACKGROUND) {
            labelPart = "BACKGROUND";
        } else if (role == Role.COLUMN) {
            labelPart = "COLUMN";
        } else if (role == Role.HIDDEN) {
            labelPart = "HIDDEN";
        } else if (role == Role.PAGE) {
            labelPart = "PAGE";
        } else if (role == Role.ROW) {
            labelPart = "ROW";
        } else if (role != null) {
            labelPart = role.toString();
            if (_logger.isEnabled(org.apache.logging.log4j.Level.WARN)) {
                _logger.warn("Unknown Role = " + role.toString());
            }
        }
        return labelPart;
    }
}

