/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma;

import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.HyperlinkType;
import com.sas.datatypes.InputFileType;
import com.sas.datatypes.OutputFileType;
import com.sas.datatypes.StringType;
import com.sas.iom.SAS.IDBMSConnection;
import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataSet;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.ShortSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfDoubleHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfOctetHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.SASLibrary;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.TransparentGroup;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.storedprocess.metadata.DataSourceOrTarget;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.GenericStream;
import com.sas.services.storedprocess.metadata.OutputParameter;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.util.Strings;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;

public class IQProcStpV2 {
    private static final Logger _logger = LogManager.getLogger(IQProcStpV2.class);
    private static final String PROC_STP_COMMAND = "\nPROC STP";
    private static final char SEP1 = ' ';
    private static final char EQUALS = '=';
    private static final String PROGRAM_EQUALS = "program=";
    private static final String INPUT_PARAM_COMMAND = "\n    inputParam";
    private static final String OUTPUT_PARAM_COMMAND = "\n    outputParam";
    private static final String OUTPUT_DATA_COMMAND = "\n    outputData";
    private static final String INPUT_DATA_COMMAND = "\n    inputData";
    private static final String OUTPUT_FILE_COMMAND = "\n    outputFile";
    private static final String INPUT_FILE_COMMAND = "\n    inputFile";
    private static final String LIST_COMMAND = "\n    list";
    private static final char END_COMMAND = ';';
    private static final String RUN_QUIT = "\nrun;\nquit;";
    private static final String SELF_ASSIGN_FILEREF = "*self*";
    private StringBuffer _comment = new StringBuffer();
    private StringBuffer _statement = new StringBuffer();
    private boolean _isListingOnly;
    private StoredProcessInterface _storedProcess;
    private ExecutionContext _executionContext;
    private Locale _computationLocale;
    private boolean _includeDefaultParams = false;
    private PromptValuesInterface _promptValues;
    private Map<String, PromptDefinitionInterface> _promptValuesMap;
    private Map<String, String> _nameValues;
    private Map<String, String> _alreadyWrittenInputParams = new HashMap<String, String>();
    private SessionContextInterface _sessionContext;

    public IQProcStpV2(SessionContextInterface sessionContext) {
        this._sessionContext = sessionContext;
    }

    public void prepareSQL() throws GenerationException {
        try {
            List outputParameters;
            this._promptValuesMap = this.getPromptValues(this._promptValues);
            this._nameValues = PromptUtil.getMacroVariableValues((PromptValuesInterface)this._promptValues, null, (boolean)false, (Locale)this._computationLocale);
            PathUrl pathUrl = this._storedProcess.getPathUrl();
            String programLoc = pathUrl.getAbsolutePath();
            this._comment.append("/* v2 (9.3) stored process support */");
            this.writeProcStp(this._statement, IQProcStpV2.quote(programLoc));
            List dataSourcesAndTargets = this._storedProcess.getDataSourcesAndTargets();
            if (dataSourcesAndTargets != null) {
                for (DataSourceOrTarget dataSourceOrTarget : dataSourcesAndTargets) {
                    this.formatSourceTarget(this._statement, dataSourceOrTarget);
                }
            }
            if (this._promptValuesMap.size() > 0) {
                for (Map.Entry entry : this._promptValuesMap.entrySet()) {
                    this.formatInputParam(this._statement, entry);
                }
            }
            if ((outputParameters = this._storedProcess.getOutputParameters()) != null) {
                for (OutputParameter outputParameter : outputParameters) {
                    this.formatOutputParam(this._statement, outputParameter);
                }
            }
        }
        catch (ExecutionException e) {
            throw new GenerationException(e);
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        catch (PromptValueNotFoundException e) {
            throw new GenerationException(e);
        }
        catch (ServiceException e) {
            throw new GenerationException(e);
        }
        catch (RemoteException e) {
            throw new GenerationException(e);
        }
        catch (InvalidPromptValueException e) {
            throw new GenerationException(e);
        }
    }

    public String write() {
        String code = this._isListingOnly ? this._statement.toString() + LIST_COMMAND + ';' + RUN_QUIT : this._comment.toString() + this._statement.toString() + RUN_QUIT;
        return code;
    }

    private void writeProcStp(StringBuffer statement, String quotedProgramLoc) {
        statement.append(PROC_STP_COMMAND).append(' ').append(PROGRAM_EQUALS).append(quotedProgramLoc);
        statement.append(';');
    }

    private void writeInputParam(StringBuffer statement, String name, String text) {
        statement.append(INPUT_PARAM_COMMAND).append(' ').append(name);
        statement.append('=').append(text);
        statement.append(';');
    }

    private void writeOutputParam(StringBuffer statement, String name) {
        statement.append(OUTPUT_PARAM_COMMAND).append(' ').append(name);
        statement.append(';');
    }

    private void writeOutputData(StringBuffer statement, String assignName, Object toValue) {
        statement.append(OUTPUT_DATA_COMMAND).append(' ').append(assignName);
        statement.append('=').append(toValue);
        statement.append(';');
    }

    private void writeInputData(StringBuffer statement, String assignName, Object toValue) {
        statement.append(INPUT_DATA_COMMAND).append(' ').append(assignName);
        statement.append('=').append(toValue);
        statement.append(';');
    }

    private void writeOutputFile(StringBuffer statement, String assignName, String toValue) {
        statement.append(OUTPUT_FILE_COMMAND).append(' ').append(assignName);
        if (toValue != SELF_ASSIGN_FILEREF) {
            statement.append('=').append(toValue);
        }
        statement.append(';');
    }

    private void writeInputFile(StringBuffer statement, String assignName, String toValue) {
        statement.append(INPUT_FILE_COMMAND).append(' ').append(assignName);
        if (toValue != SELF_ASSIGN_FILEREF) {
            statement.append('=').append(toValue);
        }
        statement.append(';');
    }

    private Map<String, PromptDefinitionInterface> getPromptValues(PromptValuesInterface promptValues) {
        LinkedHashMap<String, PromptDefinitionInterface> promptValuesMap = new LinkedHashMap<String, PromptDefinitionInterface>();
        if (promptValues != null) {
            PromptGroupInterface promptGroup = promptValues.getPromptGroup();
            List promptDefinitions = promptGroup.getPromptDefinitions(true);
            for (PromptDefinitionInterface pdi : promptDefinitions) {
                String key = pdi.getPromptName();
                promptValuesMap.put(key, pdi);
            }
        }
        return promptValuesMap;
    }

    private void formatOutputParam(StringBuffer statement, OutputParameter outputParameter) {
        String name = outputParameter.getName();
        this.writeOutputParam(statement, name);
    }

    private void formatInputParam(StringBuffer statement, Map.Entry<String, PromptDefinitionInterface> entry) throws ExecutionException, PromptValueNotFoundException {
        String name = entry.getKey();
        if (!this._alreadyWrittenInputParams.containsKey(name)) {
            boolean hasStickyValue;
            if (name.length() > 32) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.promptTooLong.fmt.txt", name, name.length(), 32);
                throw new ExecutionException(msg);
            }
            PromptDefinitionInterface pdi = entry.getValue();
            boolean valueSet = this._promptValues.isPromptValueSet(pdi);
            boolean bl = hasStickyValue = !valueSet && !pdi.isDefaultValueSet() && this._promptValues.isPromptValueAvailable(pdi);
            if (this._includeDefaultParams || valueSet || hasStickyValue) {
                this.formatInputParam(statement, name, pdi, this._promptValues);
            }
        }
    }

    private void formatInputParam(StringBuffer statement, String name, PromptDefinitionInterface pdi, PromptValuesInterface promptValues) throws PromptValueNotFoundException {
        Object promptValue = promptValues.getPromptValue(pdi);
        DataTypeInterface promptDataType = pdi.getPromptDataType();
        String value = promptDataType.getValueAsString(promptValue, this._computationLocale);
        this.writeInputParam(statement, name, IQProcStpV2.quote(value));
    }

    private void formatSourceTarget(StringBuffer statement, DataSourceOrTarget dataSourceOrTarget) throws RemoteException, PromptValueNotFoundException, InvalidPromptValueException, GenerationException, ExecutionException, MetadataException {
        String inputParamValue;
        String toValue;
        String paramName;
        boolean isSource = dataSourceOrTarget.isSource();
        if (dataSourceOrTarget instanceof DataTable) {
            paramName = ((DataTable)dataSourceOrTarget).getParameterName();
        } else if (dataSourceOrTarget instanceof GenericStream) {
            paramName = ((GenericStream)dataSourceOrTarget).getFileref();
        } else {
            MessageFormatter msg = isSource ? IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.wrongSourceDataType.fmt.txt", this._storedProcess.getName(), dataSourceOrTarget.getLabel(), dataSourceOrTarget.getClass().getName()) : IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.wrongTargetDataType.fmt.txt", this._storedProcess.getName(), dataSourceOrTarget.getLabel(), dataSourceOrTarget.getClass().getName());
            throw new GenerationException(msg);
        }
        String lookupParm = paramName;
        boolean writeInputParm = true;
        boolean isFileRef = dataSourceOrTarget instanceof GenericStream;
        StpNames stpNames = this._executionContext == null ? null : this._executionContext.getStpNames();
        String assignName = paramName;
        PromptDefinitionInterface pdi = this._promptValuesMap.get(lookupParm);
        if (pdi == null) {
            String filerefName;
            String string = filerefName = stpNames == null ? null : stpNames.getStpFileRefName(lookupParm, false);
            if (isFileRef) {
                toValue = filerefName == null ? SELF_ASSIGN_FILEREF : this.quoteFileRefNameOrPath(filerefName);
                inputParamValue = filerefName;
            } else if (stpNames == null) {
                toValue = this.quoteDataSetNameOrPath(paramName);
                inputParamValue = paramName;
            } else {
                String quoteDataSetNameOrPath;
                String qualifiedTableName = stpNames.getStpDataFileName(this._executionContext, lookupParm, true);
                toValue = quoteDataSetNameOrPath = this.quoteDataSetNameOrPath(qualifiedTableName);
                inputParamValue = qualifiedTableName;
            }
        } else {
            DataTypeInterface promptDataType = pdi.getPromptDataType();
            inputParamValue = this._nameValues.get(lookupParm);
            String value = null;
            if (inputParamValue != null) {
                if (promptDataType instanceof DataSourceType) {
                    DataSourceInterface dst = (DataSourceInterface)this._promptValues.getPromptValue(pdi);
                    String qualifiedName = null;
                    try {
                        qualifiedName = this.getQualifiedDataSetName(dst);
                        this.warnUnsupportedPromptType(lookupParm, dataSourceOrTarget, null);
                    }
                    catch (RemoteException e) {
                        this.warnUnsupportedPromptType(lookupParm, dataSourceOrTarget, e);
                        qualifiedName = lookupParm;
                    }
                    catch (ServiceException e) {
                        this.warnUnsupportedPromptType(lookupParm, dataSourceOrTarget, (Exception)((Object)e));
                        qualifiedName = lookupParm;
                    }
                    catch (MdException e) {
                        this.warnUnsupportedPromptType(lookupParm, dataSourceOrTarget, (Exception)((Object)e));
                        qualifiedName = lookupParm;
                    }
                    value = isFileRef ? this.quoteFileRefNameOrPath(qualifiedName) : this.quoteDataSetNameOrPath(qualifiedName);
                } else if (promptDataType instanceof InputFileType) {
                    value = IQProcStpV2.quote(inputParamValue);
                } else if (promptDataType instanceof OutputFileType) {
                    value = IQProcStpV2.quote(inputParamValue);
                } else if (promptDataType instanceof HyperlinkType) {
                    String inputParamPathValue = this._nameValues.get(lookupParm + "_path");
                    value = IQProcStpV2.quote(inputParamPathValue);
                } else if (promptDataType instanceof StringType) {
                    value = isFileRef ? this.quoteFileRefNameOrPath(inputParamValue) : this.quoteDataSetNameOrPath(inputParamValue);
                } else {
                    writeInputParm = false;
                }
            }
            if (value != null) {
                assignName = paramName;
                toValue = value;
            } else {
                String filerefName;
                String string = filerefName = stpNames == null ? null : stpNames.getStpFileRefName(lookupParm, false);
                if (isFileRef) {
                    toValue = filerefName == null ? SELF_ASSIGN_FILEREF : this.quoteFileRefNameOrPath(filerefName);
                    inputParamValue = filerefName;
                } else if (stpNames == null) {
                    toValue = this.quoteDataSetNameOrPath(filerefName);
                    inputParamValue = filerefName;
                } else {
                    String memberName = stpNames.getStpDataFileName(this._executionContext, lookupParm, true);
                    toValue = this.quoteDataSetNameOrPath(memberName);
                    inputParamValue = memberName;
                }
                if (toValue != null) {
                    this.warn(this._storedProcess, this._promptValues, lookupParm, dataSourceOrTarget.getLabel(), pdi, promptDataType, toValue);
                }
            }
        }
        if (toValue == null) {
            MessageFormatter msgRequiredTypes = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.requiredTypesForParameter.fmt.txt", this._storedProcess.getName(), lookupParm, dataSourceOrTarget.getLabel());
            _logger.error((Object)msgRequiredTypes);
            throw new GenerationException(msgRequiredTypes);
        }
        if (isFileRef) {
            if (isSource) {
                this.writeInputFile(statement, assignName, toValue);
            } else {
                this.writeOutputFile(statement, assignName, toValue);
            }
        } else if (isSource) {
            this.writeInputData(statement, assignName, toValue);
        } else {
            this.writeOutputData(statement, assignName, toValue);
        }
        if (writeInputParm) {
            this.formatInputParam(statement, lookupParm, pdi, inputParamValue);
            this._alreadyWrittenInputParams.put(lookupParm, inputParamValue);
        }
    }

    private void warnUnsupportedPromptType(String lookupParm, DataSourceOrTarget dataSourceOrTarget, Exception e) throws RemoteException {
        _logger.warn("DataSource is not a supported prompt type for the default values of stored process Source and Target data.  Define a text prompt for the default value of '" + lookupParm + "'.", (Throwable)e);
        MessageFormatter unsupportedPromptType = IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.unsupportedPromptType.fmt.txt", this._storedProcess.getName(), lookupParm, dataSourceOrTarget.getLabel());
        if (e != null) {
            _logger.warn((Object)unsupportedPromptType, (Throwable)e);
        } else {
            _logger.warn((Object)unsupportedPromptType);
        }
    }

    String getQualifiedDataSetName(DataSourceInterface dsi) throws ServiceException, RemoteException, MdException {
        String qualifiedName = null;
        String dataSourceLocation = dsi.getDataSourceLocation();
        if (this._sessionContext == null) {
            qualifiedName = dataSourceLocation;
        } else {
            String type;
            UserContextInterface userContext = this._sessionContext.getUserContext();
            ServerInterface metadataServer = userContext.getAuthServer();
            MetadataInterface mi = this.getMetadataObject(metadataServer, dataSourceLocation, type = "SASLibrary");
            if (mi != null && mi instanceof PhysicalTableInterface) {
                PhysicalTableInterface pti = (PhysicalTableInterface)mi;
                SASLibraryInterface sli = pti.getLibrary();
                qualifiedName = sli == null ? pti.getName() : sli.getLibref() + "." + pti.getName();
                if (!sli.isPreassigned()) {
                    boolean encodePasswords = true;
                    boolean genFileNameForXMLLibs = true;
                    MdLibGenInterface generator = MdModelUtil.getInstance((CredentialResolver)userContext, (String)null, (boolean)encodePasswords, (boolean)genFileNameForXMLLibs, (boolean)false);
                    String string = generator.genLibname((SASLibrary)sli.getRepositoryEntity());
                }
            }
        }
        return qualifiedName;
    }

    private MetadataInterface getMetadataObject(ServerInterface metadataServer, String path, String type) throws ServiceException, RemoteException {
        MetadataInterface mi = null;
        if (metadataServer != null && path != null) {
            PathUrl pathUrl = null;
            try {
                pathUrl = PathUrl.newPathUrlFromExistingUrl((ServerInterface)metadataServer, (PathUrl)new PathUrl(path));
            }
            catch (IllegalArgumentException e) {
                pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)metadataServer, (String)path);
            }
            if (pathUrl != null) {
                if (pathUrl.getType() == null && type != null) {
                    if (!pathUrl.isWritable()) {
                        pathUrl = new PathUrl(pathUrl.toString());
                    }
                    pathUrl.setType(type);
                }
                mi = metadataServer.getObjectByPath(pathUrl);
            }
        }
        return mi;
    }

    private void formatInputParam(StringBuffer statement, String lookupParm, PromptDefinitionInterface pdi, String inputParamValue) throws InvalidPromptValueException, PromptValueNotFoundException {
        TransparentGroup writePromptGroup = new TransparentGroup();
        writePromptGroup.setPromptGroupLabel(this.getClass().getSimpleName(), this._computationLocale);
        PromptDefinitionInterface writePromptDefinition = null;
        if (pdi == null) {
            TextDefinition prompt = new TextDefinition(lookupParm);
            prompt.setPromptDescription(lookupParm, this._computationLocale);
            prompt.setPromptLabel(lookupParm, this._computationLocale);
            prompt.setDefaultValue((Object)inputParamValue);
            writePromptDefinition = prompt;
        } else {
            writePromptDefinition = pdi;
        }
        writePromptGroup.addPromptDefinition(writePromptDefinition);
        PromptValues writePromptValues = new PromptValues((PromptGroupInterface)writePromptGroup);
        writePromptValues.setPromptValue(writePromptDefinition, inputParamValue);
        this.formatInputParam(statement, lookupParm, writePromptDefinition, (PromptValuesInterface)writePromptValues);
    }

    private String quoteFileRefNameOrPath(String value) {
        String result = value == null ? null : (Names.validateSASFilerefName((String)value, (boolean)false) ? value : IQProcStpV2.quote(value));
        return result;
    }

    private String quoteDataSetNameOrPath(String value) {
        String result = value == null ? null : (value.matches("([_A-Za-z][A-Za-z0-9_]{0,7}\\.)?[_A-Za-z][A-Za-z0-9_]*") ? value : (value.trim().length() == 0 ? "'" + value + "'" : IQProcStpV2.quote(value)));
        return result;
    }

    private static String quote(String value) {
        String result;
        if (value == null) {
            result = null;
        } else {
            int qt2;
            int qt1;
            int q1 = value.indexOf(39);
            int q2 = value.indexOf(34);
            result = q1 != -1 && (q2 == -1 || q1 < q2) ? ((qt1 = value.trim().indexOf(39)) == 0 ? value : '\"' + value + '\"') : (q2 != -1 && (q1 == -1 || q2 < q1) ? ((qt2 = value.trim().indexOf(34)) == 0 ? value : "'" + value + "'") : "'" + value + "'");
        }
        return result;
    }

    private void warn(StoredProcessInterface spInterface, PromptValuesInterface spPromptValues, String lookupParm, String lookupLabel, PromptDefinitionInterface pdi, DataTypeInterface promptDataType, String value) throws RemoteException, PromptValueNotFoundException {
        _logger.warn((Object)IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.incompatiblePromptForParameter.fmt.txt", spInterface.getName(), spPromptValues.getPromptValue(pdi), promptDataType.getClass().getSimpleName()));
        _logger.warn((Object)IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.requiredTypesForParameter.fmt.txt", spInterface.getName(), lookupParm, lookupLabel));
        _logger.warn((Object)IQDataServicesResourceBundle.getMessageFormatter("StoredProcessHandler.autoGenerationUsed.fmt.txt", value));
    }

    public Locale getComputationLocale() {
        return this._computationLocale;
    }

    public ExecutionContext getExecutionContext() {
        return this._executionContext;
    }

    public PromptValuesInterface getPromptValues() {
        return this._promptValues;
    }

    public StoredProcessInterface getStoredProcess() {
        return this._storedProcess;
    }

    public boolean isListingOnly() {
        return this._isListingOnly;
    }

    public void setComputationLocale(Locale computationLocale) {
        this._computationLocale = computationLocale;
    }

    public void setExecutionContext(ExecutionContext context) {
        this._executionContext = context;
    }

    public void setListingOnly(boolean isListingOnly) {
        this._isListingOnly = isListingOnly;
    }

    public void setPromptValues(PromptValuesInterface promptValues) {
        this._promptValues = promptValues == null ? new PromptValues() : promptValues;
    }

    public void setStoredProcess(StoredProcessInterface spInterface) {
        this._storedProcess = spInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getOutputMacroVariables(IDataService dataService, Set<String> outputParameterNames, boolean includeSASStandardVariables) throws UserException {
        int VALUE_MAX_NUM_CHARACTERS = 200;
        String QUERY = "SELECT name, offset, value FROM sashelp.vmacro ORDER BY name, offset, value";
        String SAS_SYSCC = "SYSCC";
        String SAS_SYSERR = "SYSERR";
        String SAS_SYSMSG = "SYSMSG";
        String SAS_SYSRC = "SYSRC";
        String SAS_SYSDATE9 = "SYSDATE9";
        String SAS_SYSTIME = "SYSTIME";
        String SAS_SYSDSN = "SYSDSN";
        String SAS_SYSLAST = "SYSLAST";
        String SAS_SYSVER = "SYSVER";
        String SAS_SYSVLONG = "SYSVLONG";
        Set<String> SAS_STANDARD_OUTPUT_VARS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("SYSCC", "SYSERR", "SYSMSG", "SYSRC", "SYSDATE9", "SYSTIME", "SYSDSN", "SYSLAST", "SYSVER", "SYSVLONG")));
        int numMacros = includeSASStandardVariables ? outputParameterNames.size() + SAS_STANDARD_OUTPUT_VARS.size() : outputParameterNames.size();
        LinkedHashMap<String, String> outputParameterMap = new LinkedHashMap<String, String>(numMacros);
        IDBMSConnection connection = null;
        try {
            LinkedHashSet<String> outputParamNames = new LinkedHashSet<String>(numMacros);
            for (String outputParameterName : outputParameterNames) {
                outputParamNames.add(outputParameterName.toUpperCase());
            }
            if (includeSASStandardVariables) {
                outputParamNames.addAll(SAS_STANDARD_OUTPUT_VARS);
            }
            IntHolder warning = new IntHolder();
            StringHolder warningMessage = new StringHolder();
            IntHolder bookmarkLength = new IntHolder();
            IntHolder numberColumns = new IntHolder();
            StringSeqHolder columnNames = new StringSeqHolder();
            LongSeqHolder columnTypes = new LongSeqHolder();
            LongSeqHolder columnLengths = new LongSeqHolder();
            StringSeqHolder columnLabels = new StringSeqHolder();
            StringSeqHolder formatNames = new StringSeqHolder();
            ShortSeqHolder formatWidths = new ShortSeqHolder();
            ShortSeqHolder formatDecimals = new ShortSeqHolder();
            ShortSeqHolder formatLengths = new ShortSeqHolder();
            StringSeqHolder informatNames = new StringSeqHolder();
            ShortSeqHolder informatWidths = new ShortSeqHolder();
            ShortSeqHolder informatDecimals = new ShortSeqHolder();
            OctetSeqHolder sortedBy = new OctetSeqHolder();
            IntHolder logicalRecordCount = new IntHolder();
            IntHolder physicalRecordCount = new IntHolder();
            VariableArray2dOfStringHolder characterValues = new VariableArray2dOfStringHolder();
            VariableArray2dOfDoubleHolder numericValues = new VariableArray2dOfDoubleHolder();
            VariableArray2dOfOctetHolder missingNumericValues = new VariableArray2dOfOctetHolder();
            OctetSeqHolder bookmarks = new OctetSeqHolder();
            IntHolder status = new IntHolder();
            connection = dataService.ConnectToDBMS("SQLVIEW", "", warning, warningMessage);
            IDataSet iDataSet = connection.ExecuteQuery("SELECT name, offset, value FROM sashelp.vmacro ORDER BY name, offset, value", true, bookmarkLength, warning, warningMessage);
            iDataSet.GetColumnDefs(new boolean[0], numberColumns, columnNames, columnTypes, columnLengths, columnLabels, formatNames, formatWidths, formatDecimals, formatLengths, informatNames, informatWidths, informatDecimals, sortedBy);
            iDataSet.GetRecordCounts(logicalRecordCount, physicalRecordCount);
            iDataSet.ReadRecords(0, 0, new byte[0], logicalRecordCount.value, 0, characterValues, numericValues, missingNumericValues, bookmarks, status);
            String[][] stringValues = characterValues.value;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Macro values returned = " + stringValues.length);
            }
            String[] strings2 = null;
            String macroName = null;
            StringBuffer valueBuffer = null;
            block4: for (String[] strings2 : stringValues) {
                for (int index = 0; index < strings2.length; ++index) {
                    if (0 == index) {
                        if (Strings.equal(macroName, (String)strings2[index], (boolean)true, (boolean)true)) continue;
                        if (null != macroName) {
                            outputParameterMap.put(macroName, valueBuffer.toString().trim());
                        }
                        if (!outputParamNames.contains(macroName = strings2[index].trim())) {
                            macroName = null;
                            continue block4;
                        }
                        valueBuffer = new StringBuffer(200);
                        continue;
                    }
                    if (1 != index) continue;
                    valueBuffer.append(strings2[index]);
                }
            }
            if (null != macroName) {
                outputParameterMap.put(macroName, valueBuffer.toString().trim());
            }
        }
        finally {
            if (connection != null) {
                connection._release();
                connection = null;
            }
        }
        return outputParameterMap;
    }

    public void setIncludeDefaultParams(boolean includeDefaultParams) {
        this._includeDefaultParams = includeDefaultParams;
    }

    public boolean getIncludeDefaultParams() {
        return this._includeDefaultParams;
    }
}

