/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma;

import com.sas.MissingValues;
import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.AbstractSASStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcDataSets;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPBuilderInformation;
import com.sas.iquery.strategies.sas.oma.summaryrolap.ROLAPStepGenerationUtil;
import com.sas.iquery.strategies.sas.oma.summaryrolap.RolapDataSelectionProcessor;
import com.sas.iquery.util.impl.MessageFormatter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpandedProcSummaryStatement
extends AbstractSASStatement {
    private static final String SAS_FORMAT_PREFIX = "sasf_";
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    private static final String NEWLINE_TAB = "\n\t";
    private static final String PROC_RUN_QUIT = "run;quit;\n";
    private static final String SUBTOTAL_TABLE = "_S";
    private static final String GRANDTOTAL_TABLE = "_G";
    private static final String REGULAR_TABLE = "_R";
    private static final String NO_TOTAL_TABLE = "_N";
    private static final String PROCSUMMARY_MERGED = "_M";
    protected static Map<FunctionNameID, String> _procSummaryFunctionNames = null;
    protected static Map<FunctionNameID, String> _nonProcSummaryFunctionNames = null;
    protected static Map<FunctionNameID, String> _internallyFormattedFunctionNames = null;
    protected static List<FunctionNameID> _procSummaryKeepsFormat = null;
    private final boolean _includeMissing;
    private final boolean _useNWay;
    private final List<DataItem> _classItems;
    private final List<DataItem> _varItems;
    private final String _summaryTableName;
    private final boolean _dropType;
    private final boolean _supportNonProcStats;
    private final boolean _useMissingForUnsupportedStats;
    private final boolean _deleteOutputOnError;
    private final boolean _sumGroupValues;
    private ROLAPBuilderInformation _rolapBuilderInfo = null;
    private final boolean _doOnlyGrandTotal;
    private final boolean _ignoreDisabledTotals;
    private final boolean _ignoreFotDisabledTotals;
    private List<SQLComponentAbstract> _compositeList = null;
    private static final Logger _logger = LogManager.getLogger(ExpandedProcSummaryStatement.class);

    public ExpandedProcSummaryStatement(DataSelection dataSelection, String intputTableName, boolean includeMissing, boolean useNWay, List<DataItem> classItems, List<DataItem> varItems, String summaryTableName, boolean dropType, boolean supportNonProcStats, boolean useMissingForUnsupportedStats, boolean deleteOutputOnError, boolean sumGroupValues, ROLAPBuilderInformation rolapBuilderInfo, boolean doOnlyGrandTotal, boolean ignoreDisabledTotals, boolean ignoreFotDisabledTotals) throws GenerationException {
        super(dataSelection, intputTableName);
        this._includeMissing = includeMissing;
        this._useNWay = useNWay;
        this._classItems = classItems;
        this._varItems = varItems;
        this._summaryTableName = summaryTableName;
        this._dropType = dropType;
        this._supportNonProcStats = supportNonProcStats;
        this._useMissingForUnsupportedStats = useMissingForUnsupportedStats;
        this._deleteOutputOnError = deleteOutputOnError;
        this._sumGroupValues = sumGroupValues;
        this._rolapBuilderInfo = rolapBuilderInfo;
        this._doOnlyGrandTotal = doOnlyGrandTotal;
        this._ignoreDisabledTotals = ignoreDisabledTotals;
        this._ignoreFotDisabledTotals = ignoreFotDisabledTotals;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        StringBuffer dataStep;
        StringBuffer procSummary;
        boolean procSumDropsType;
        boolean useTypesBasedTotaling = this._rolapBuilderInfo != null;
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        List<DataItem> classItems = this._classItems;
        String summaryTableName = this._summaryTableName;
        boolean dropType = this._dropType;
        String baseTableName = this._baseTableName;
        String nonProcValueTableName = summaryTableName + "_dv";
        LinkedHashMap<String, DataItem> missingValueVars = new LinkedHashMap<String, DataItem>();
        LinkedHashMap<String, DataItem> missingTotalVars = new LinkedHashMap<String, DataItem>();
        LinkedHashMap<String, DataItem> nonProcVars = new LinkedHashMap<String, DataItem>();
        LinkedHashMap<String, DataItem> summaryVars = new LinkedHashMap<String, DataItem>();
        this.extractVars(this._varItems, summaryVars, this._supportNonProcStats, nonProcVars, this._useMissingForUnsupportedStats, missingValueVars);
        Collection<DataItem> procSummaryVarItems = summaryVars.values();
        LinkedHashSet<DataItem> procSumRegular = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procSumOnlySTs = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procSumOnlyGTs = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procSumCellsOnly = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procVars = new LinkedHashSet<DataItem>(procSummaryVarItems.size());
        if (_logger.isDebugEnabled()) {
            _logger.debug("Splitting summary proc summary totaling items");
        }
        boolean hasDisabledProcTotals = ExpandedProcSummaryStatement.split(this._ignoreDisabledTotals, this._ignoreFotDisabledTotals, useTypesBasedTotaling, this._dataSelection, procSummaryVarItems, procSumRegular, procSumOnlySTs, procSumOnlyGTs, procSumCellsOnly, procVars);
        if (this._doOnlyGrandTotal && (classItems == null || classItems.size() == 0) && procSumCellsOnly.size() > 0) {
            for (DataItem dataItem : procSumCellsOnly) {
                missingTotalVars.put(dataItem.getResultSetID(), dataItem);
            }
            for (DataItem dataItem : procSumOnlySTs) {
                missingTotalVars.put(dataItem.getResultSetID(), dataItem);
            }
            for (DataItem dataItem : procSumOnlySTs) {
                missingTotalVars.put(dataItem.getResultSetID(), dataItem);
            }
        }
        Collection<DataItem> procSqlVarItems = nonProcVars.values();
        LinkedHashSet<DataItem> procSqlRegular = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procSqlOnlySTs = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procSqlOnlyGTs = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> procSqlCellsOnly = new LinkedHashSet<DataItem>();
        LinkedHashSet<DataItem> sqlVars = new LinkedHashSet<DataItem>(procSqlVarItems.size());
        if (_logger.isDebugEnabled()) {
            _logger.debug("Splitting summary proc summary totaling items");
        }
        boolean hasDisabledSqlTotals = ExpandedProcSummaryStatement.split(this._ignoreDisabledTotals, this._ignoreFotDisabledTotals, useTypesBasedTotaling, this._dataSelection, procSqlVarItems, procSqlRegular, procSqlOnlySTs, procSqlOnlyGTs, procSqlCellsOnly, sqlVars);
        if (this._doOnlyGrandTotal && (classItems == null || classItems.size() == 0) && procSqlCellsOnly.size() > 0) {
            for (DataItem dataItem : procSqlCellsOnly) {
                missingTotalVars.put(dataItem.getResultSetID(), dataItem);
            }
            for (DataItem dataItem : procSqlOnlySTs) {
                missingTotalVars.put(dataItem.getResultSetID(), dataItem);
            }
            for (DataItem dataItem : procSqlOnlySTs) {
                missingTotalVars.put(dataItem.getResultSetID(), dataItem);
            }
        }
        ArrayList<SQLComponentAbstract> code = new ArrayList<SQLComponentAbstract>();
        if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
            StringBuffer comment = this.generateComment(dsProcessor, classItems, baseTableName, procSummaryVarItems, procSqlVarItems);
            SQLStatementFactory.addText(code, comment);
        }
        boolean hasNonProcAggs = !sqlVars.isEmpty();
        boolean bl = procSumDropsType = dropType && !hasNonProcAggs && missingValueVars.isEmpty();
        if (hasDisabledProcTotals || hasDisabledSqlTotals) {
            SQLStatementFactory.addText(code, "\n/* this query contains disabled totaling */");
        }
        if (hasDisabledProcTotals) {
            if (useTypesBasedTotaling) {
                SQLStatementFactory.addText(code, "\n/* using TYPES to do disabled totaling */");
                procSummary = this.generateProcSummary(summaryTableName, baseTableName, classItems, procSumDropsType, procSumRegular, procSumOnlySTs, procSumOnlyGTs, procSumCellsOnly, this._sumGroupValues, dsProcessor, this._rolapBuilderInfo);
            } else {
                procSummary = this.generateProcSummary(summaryTableName, baseTableName, classItems, procSumDropsType, this._sumGroupValues, procVars, dsProcessor);
            }
        } else {
            procSummary = this.generateProcSummary(summaryTableName, baseTableName, classItems, procSumDropsType, this._sumGroupValues, procSummaryVarItems, dsProcessor);
        }
        SQLStatementFactory.addText(code, procSummary);
        if (this._deleteOutputOnError) {
            ExpandedProcSummaryStatement.addPerformStepMacro(code, dsProcessor, summaryTableName);
        }
        if (hasNonProcAggs) {
            SQLStatementFactory.addText(code, "\n/* calculate statistics not supported by PROC SUMMARY */");
            dataStep = this.generateEmptyBaseFile(nonProcValueTableName, summaryTableName, classItems, sqlVars, procVars, dsProcessor);
            SQLStatementFactory.addText(code, dataStep);
            this.addMergeNonProcStatisticsVars(code, summaryTableName, baseTableName, nonProcValueTableName, classItems, sqlVars, procSqlRegular, procSqlOnlySTs, procSqlOnlyGTs, procSqlCellsOnly, missingValueVars, this._doOnlyGrandTotal, dropType, dsProcessor);
        }
        if (!missingValueVars.isEmpty()) {
            dataStep = this.generateAppendMissingValueVars("/* MissingValues being added for vars with unsupported statistics */", summaryTableName, missingValueVars.values(), dropType, dsProcessor);
            SQLStatementFactory.addText(code, dataStep);
        }
        if (!missingTotalVars.isEmpty()) {
            dataStep = this.generateAppendMissingValueVars("/* MissingValues being added for vars with disabled totals */", summaryTableName, missingTotalVars.values(), dropType, dsProcessor);
            SQLStatementFactory.addText(code, dataStep);
        }
        if (hasNonProcAggs) {
            SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
            SQLStatementFactory.addDropTableByName(code, dsProcessor, nonProcValueTableName);
            SQLStatementFactory.addEndProcSql(code, dsProcessor);
        }
        this._compositeList = code;
    }

    static boolean splitForTotallingTypes(DataSelection ds, Collection<DataItem> varItems, boolean ignoreFotDisabledTotals, Set<DataItem> regular, Set<DataItem> sts, Set<DataItem> gts, Set<DataItem> cellsOnly) {
        boolean hasDisabledTotals = false;
        if (varItems.size() > 0) {
            Map<TotalingType, Set<DataItem>> map = DisabledTotalsBuilder.getDisabledTotalingByType(ds);
            Set<DataItem> stsDisabled = map.get(TotalingType.SUBTOTAL);
            Set<DataItem> gtsDisabled = map.get(TotalingType.AXISTOTAL);
            Set<DataItem> allDisabled = map.get(TotalingType.ALLTOTAL);
            if (stsDisabled == null) {
                stsDisabled = new HashSet<DataItem>();
            }
            if (gtsDisabled == null) {
                gtsDisabled = new HashSet<DataItem>();
            }
            if (allDisabled == null) {
                allDisabled = new HashSet<DataItem>();
            }
            if (ignoreFotDisabledTotals) {
                HashSet<DataItem> fotsIgnore = new HashSet<DataItem>();
                for (DataItem dataItem : varItems) {
                    try {
                        if (!FractionOfTotalUtilImpl.isFractionOfTotalItem(dataItem)) continue;
                        fotsIgnore.add(dataItem);
                    }
                    catch (GenerationException generationException) {}
                }
                if (fotsIgnore.size() > 0) {
                    stsDisabled.removeAll(fotsIgnore);
                    gtsDisabled.removeAll(fotsIgnore);
                    allDisabled.removeAll(fotsIgnore);
                }
            }
            hasDisabledTotals = !stsDisabled.isEmpty() || !gtsDisabled.isEmpty() || !allDisabled.isEmpty();
            regular.addAll(varItems);
            if (hasDisabledTotals) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Disabled Totaling Types TotalingType.SUBTOTAL: " + stsDisabled);
                    _logger.debug("Disabled Totaling Types TotalingType.AXISTOTAL: " + gtsDisabled);
                    _logger.debug("Disabled Totaling Types TotalingType.ALLTOTAL: " + allDisabled);
                }
                regular.removeAll(stsDisabled);
                regular.removeAll(gtsDisabled);
                regular.removeAll(allDisabled);
                sts.addAll(varItems);
                sts.removeAll(regular);
                sts.removeAll(stsDisabled);
                sts.removeAll(allDisabled);
                gts.addAll(varItems);
                gts.removeAll(regular);
                gts.removeAll(gtsDisabled);
                gts.removeAll(allDisabled);
                cellsOnly.addAll(varItems);
                cellsOnly.removeAll(regular);
                cellsOnly.removeAll(sts);
                cellsOnly.removeAll(gts);
                hasDisabledTotals = !regular.containsAll(varItems) || !gts.isEmpty() || !sts.isEmpty() || !cellsOnly.isEmpty();
            }
        }
        return hasDisabledTotals;
    }

    private StringBuffer generateProcSummary(String summaryTableName, String baseTableName, List<DataItem> classItems, boolean procSumDropsType, Set<DataItem> regular, Set<DataItem> sts, Set<DataItem> gts, Set<DataItem> none, boolean sumGroupValues, DataSelectionProcessorAbstract dsProcessor, ROLAPBuilderInformation rolapBuilderInfo) throws GenerationException {
        StringBuffer procSummary = new StringBuffer();
        Map<TotalingType, List<List<DataItem>>> crossings = this.getCrossings(classItems, rolapBuilderInfo.getDataSelection());
        if (_logger.isDebugEnabled()) {
            _logger.debug("Class crossings for totals:" + crossings);
        }
        StringBuffer procSummary_template = this.generateProcSummary(summaryTableName, baseTableName, classItems, procSumDropsType, false, null, dsProcessor);
        procSummary.append(procSummary_template);
        ArrayList<String> totalTables = new ArrayList<String>();
        if (_logger.isDebugEnabled()) {
            _logger.debug(">>>>>>>>>>>>>>>> NO ST AND GT: " + none + "\n only GT: " + gts + "\n only ST: " + sts + "\n regular: " + regular);
        }
        if (!sts.isEmpty()) {
            List<List<DataItem>> stCrossings = crossings.get(TotalingType.SUBTOTAL);
            StringBuffer procSummary_st = this.generateProcSummaryWithTypes(summaryTableName + SUBTOTAL_TABLE, baseTableName, classItems, stCrossings, procSumDropsType, sumGroupValues, sts, dsProcessor);
            procSummary.append(procSummary_st);
            totalTables.add(summaryTableName + SUBTOTAL_TABLE);
        }
        if (!gts.isEmpty()) {
            List<List<DataItem>> gtCrossings = crossings.get(TotalingType.AXISTOTAL);
            StringBuffer procSummary_gt = this.generateProcSummaryWithTypes(summaryTableName + GRANDTOTAL_TABLE, baseTableName, classItems, gtCrossings, procSumDropsType, sumGroupValues, gts, dsProcessor);
            procSummary.append(procSummary_gt);
            totalTables.add(summaryTableName + GRANDTOTAL_TABLE);
        }
        if (!regular.isEmpty()) {
            List<List<DataItem>> atCrossings = crossings.get(TotalingType.ALLTOTAL);
            StringBuffer procSummary_rt = this.generateProcSummaryWithTypes(summaryTableName + REGULAR_TABLE, baseTableName, classItems, atCrossings, procSumDropsType, sumGroupValues, regular, dsProcessor);
            procSummary.append(procSummary_rt);
            totalTables.add(summaryTableName + REGULAR_TABLE);
        }
        if (!none.isEmpty()) {
            List<List<DataItem>> ntCrossings = crossings.get(TotalingType.TOTAL_NONE);
            StringBuffer procSummary_nt = this.generateProcSummaryWithTypes(summaryTableName + NO_TOTAL_TABLE, baseTableName, classItems, ntCrossings, procSumDropsType, sumGroupValues, none, dsProcessor);
            procSummary.append(procSummary_nt);
            totalTables.add(summaryTableName + NO_TOTAL_TABLE);
        }
        StringBuffer mergedProcSummary = this.generateMergeProcSummary(summaryTableName, classItems, totalTables, dsProcessor, rolapBuilderInfo);
        procSummary.append(mergedProcSummary);
        return procSummary;
    }

    public static boolean isColumnOrderPreserved(Collection<DataItem> itemVars) throws GenerationException {
        boolean preservedColumnOrder = true;
        for (DataItem di : itemVars) {
            boolean isCharacter;
            boolean bl = isCharacter = di.getExpressionType() == 3;
            if (isCharacter) {
                preservedColumnOrder = false;
                break;
            }
            Function itemFunction = ExpandedProcSummaryStatement.extractFunction(di);
            FunctionNameID functionNameID = itemFunction.getFunctionNameID();
            boolean isValidSummaryFunction = ExpandedProcSummaryStatement.getProcSummaryStatisticText(functionNameID) != null;
            if (isValidSummaryFunction) continue;
            preservedColumnOrder = false;
            break;
        }
        return preservedColumnOrder;
    }

    private StringBuffer generateComment(DataSelectionProcessorAbstract dsProcessor, List<DataItem> classItems, String baseTableName, Collection<DataItem> procSummaryVarItems, Collection<DataItem> procSqlVarItems) throws GenerationException {
        StringBuffer comment = new StringBuffer("/* calculating statistics on data in table " + baseTableName + NEWLINE + " * Classes: ");
        this.appendVarsListText(comment, " ", classItems, " ", "", dsProcessor, false, 200, NEWLINE, "\n *\t");
        if (!procSummaryVarItems.isEmpty()) {
            comment.append("\n * Proc Summary Variables: ");
            this.appendVarsListText(comment, " ", procSummaryVarItems, " ", "", dsProcessor, true, 200, NEWLINE, "\n *+TAB");
        }
        if (!procSqlVarItems.isEmpty()) {
            comment.append("\n * Proc SQL Variables: ");
            this.appendVarsListText(comment, " ", procSqlVarItems, " ", "", dsProcessor, false, 200, NEWLINE, "\n *+TAB");
        }
        comment.append("\n */");
        return comment;
    }

    @Override
    public String writeSQL() {
        return ExpandedProcSummaryStatement.writeCompositeList(this._compositeList);
    }

    private void extractVars(Collection<DataItem> itemVars, Map<String, DataItem> summaryVars, boolean supportNonProcStats, Map<String, DataItem> nonProcVars, boolean useMissingForUnsupportedStats, Map<String, DataItem> missingValueVars) throws GenerationException {
        for (DataItem di : itemVars) {
            boolean isCharacter;
            String rsid = di.getResultSetID();
            Function itemFunction = ExpandedProcSummaryStatement.extractFunction(di);
            FunctionNameID functionNameID = itemFunction.getFunctionNameID();
            boolean isValidSummaryFunction = ExpandedProcSummaryStatement.getProcSummaryStatisticText(functionNameID) != null;
            boolean isNonProcSummaryFunction = ExpandedProcSummaryStatement.getNonProcSummaryStatisticText(functionNameID) != null;
            boolean bl = isCharacter = di.getExpressionType() == 3;
            if (isValidSummaryFunction) {
                if (isCharacter && supportNonProcStats && isNonProcSummaryFunction) {
                    nonProcVars.put(rsid, di);
                    continue;
                }
                summaryVars.put(rsid, di);
                continue;
            }
            boolean isDistinct = itemFunction.isDistinct();
            if (isDistinct && supportNonProcStats) {
                nonProcVars.put(rsid, di);
                continue;
            }
            if (isCharacter && supportNonProcStats) {
                nonProcVars.put(rsid, di);
                continue;
            }
            MessageFormatter message = IQDataServicesResourceBundle.getMessageFormatter("AbstractProcSummaryStatement.makeStatisticsStatement.invalidFunction.fmt.txt", di, itemFunction);
            if (useMissingForUnsupportedStats) {
                if (_logger.isEnabled(Level.WARN)) {
                    _logger.warn(rsid + ": " + message);
                }
                missingValueVars.put(rsid, di);
                continue;
            }
            throw new GenerationException(message);
        }
    }

    protected static Function extractFunction(DataItem item) throws GenerationException {
        Function itemFunction = item.getAggregationType();
        boolean isFotTotalItem = FractionOfTotalUtilImpl.isFractionOfTotalItem(item);
        if (isFotTotalItem) {
            DataItem numeratorItem = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(item);
            itemFunction = numeratorItem.getAggregationType();
        }
        if (itemFunction == null) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("AbstractProcSummaryStatement.extractDataItemFunction.noFunction.fmt.txt", item));
        }
        return itemFunction;
    }

    private StringBuffer generateProcSummaryWithTypes(String summaryTableName, String baseTableName, List<DataItem> classItems, List<List<DataItem>> crossings, boolean dropType, boolean sumGroupValues, Collection<DataItem> summaryItems, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer procSummary = new StringBuffer();
        procSummary.append(NEWLINE).append("PROC SUMMARY data=").append(baseTableName);
        if (this._includeMissing) {
            procSummary.append(" missing");
        }
        if (this._useNWay) {
            procSummary.append(" NWAY");
        }
        procSummary.append(";");
        if (classItems != null && classItems.size() > 0) {
            procSummary.append(NEWLINE).append("class ");
            this.appendVarsListText(procSummary, "", classItems, " ", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
            procSummary.append(";");
        }
        if (!crossings.isEmpty()) {
            StringBuffer typeSb = new StringBuffer();
            typeSb.append(NEWLINE);
            typeSb.append("types ");
            typeSb.append(NEWLINE_TAB);
            for (List<DataItem> titems : crossings) {
                if (titems.isEmpty()) {
                    typeSb.append("()").append(NEWLINE);
                } else {
                    this.appendVarsListText(typeSb, "", titems, "*", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
                }
                typeSb.append(NEWLINE_TAB);
            }
            typeSb.append(";");
            procSummary.append(typeSb);
        }
        if (summaryItems != null && !summaryItems.isEmpty()) {
            procSummary.append(NEWLINE).append("var ");
            this.appendVarsListText(procSummary, "", summaryItems, " ", "", dsProcessor, true, 200, NEWLINE, NEWLINE_TAB);
            procSummary.append(";");
        }
        procSummary.append(NEWLINE).append("output out=").append(summaryTableName);
        procSummary.append(NEWLINE_TAB).append("(drop=_freq_");
        if (dropType) {
            procSummary.append(" _type_");
        }
        procSummary.append(")");
        procSummary.append(NEWLINE_TAB);
        if (summaryItems != null && !summaryItems.isEmpty()) {
            this.appendProcSummaryStatisticAssignments(procSummary, summaryItems, sumGroupValues, dsProcessor);
        }
        procSummary.append(";");
        procSummary.append(NEWLINE);
        procSummary.append(PROC_RUN_QUIT);
        return procSummary;
    }

    private StringBuffer generateMergeProcSummary(String summaryTableName, List<DataItem> classItems, List<String> totalTables, DataSelectionProcessorAbstract dsProcessor, ROLAPBuilderInformation rolapBuilderInfo) throws GenerationException {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append(NEWLINE).append("DATA ").append(summaryTableName + PROCSUMMARY_MERGED).append(";");
        StringBuffer orderCols = new StringBuffer();
        List<String> retainColumnOrder = ROLAPStepGenerationUtil.getResultColumnsList((RolapDataSelectionProcessor)dsProcessor, rolapBuilderInfo);
        orderCols.append("  ").append(NEWLINE).append("retain").append(TAB).append(" ");
        Iterator<String> iter = retainColumnOrder.iterator();
        while (iter.hasNext()) {
            String rsid = iter.next();
            String identifier = dsProcessor.generateDataStepVar(rsid);
            orderCols.append(identifier);
            if (!iter.hasNext()) continue;
            orderCols.append(NEWLINE_TAB);
        }
        orderCols.append(";").append(NEWLINE);
        dataStep.append(orderCols);
        dataStep.append(NEWLINE_TAB).append("MERGE ").append(summaryTableName);
        for (String table : totalTables) {
            dataStep.append(NEWLINE_TAB).append(table);
        }
        dataStep.append(";");
        dataStep.append(NEWLINE_TAB).append("BY _TYPE_ ");
        this.appendVarsListText(dataStep, " ", classItems, " ", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
        dataStep.append(";").append(NEWLINE);
        dataStep.append("run;").append(NEWLINE).append(NEWLINE);
        dataStep.append("Proc Sql;").append(NEWLINE);
        dataStep.append("Drop table ").append(summaryTableName).append(";");
        dataStep.append(NEWLINE);
        dataStep.append(PROC_RUN_QUIT);
        dataStep.append(NEWLINE);
        String renamedTable = ProcDataSets.generateRename(summaryTableName + PROCSUMMARY_MERGED, summaryTableName);
        dataStep.append(renamedTable);
        if (totalTables.size() > 0) {
            dataStep.append("Proc Sql;").append(NEWLINE);
            dataStep.append("Drop table ");
            int i = 0;
            for (String table : totalTables) {
                dataStep.append(table);
                if (++i == totalTables.size()) continue;
                dataStep.append(", ");
            }
            dataStep.append(";");
            dataStep.append(NEWLINE);
            dataStep.append(PROC_RUN_QUIT);
            dataStep.append(NEWLINE);
        }
        return dataStep;
    }

    private StringBuffer generateProcSummary(String summaryTableName, String baseTableName, List<DataItem> classItems, boolean dropType, boolean sumGroupValues, Collection<DataItem> summaryItems, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer procSummary = new StringBuffer();
        procSummary.append(NEWLINE).append("PROC SUMMARY data=").append(baseTableName);
        if (this._includeMissing) {
            procSummary.append(" missing");
        }
        if (this._useNWay) {
            procSummary.append(" NWAY");
        }
        procSummary.append(";");
        if (classItems != null && classItems.size() > 0) {
            procSummary.append(NEWLINE).append("class ");
            this.appendVarsListText(procSummary, "", classItems, " ", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
            procSummary.append(";");
        }
        if (summaryItems != null && !summaryItems.isEmpty()) {
            procSummary.append(NEWLINE).append("var ");
            this.appendVarsListText(procSummary, "", summaryItems, " ", "", dsProcessor, true, 200, NEWLINE, NEWLINE_TAB);
            procSummary.append(";");
        }
        procSummary.append(NEWLINE).append("output out=").append(summaryTableName);
        procSummary.append(NEWLINE_TAB).append("(drop=_freq_");
        if (dropType) {
            procSummary.append(" _type_");
        }
        procSummary.append(")");
        procSummary.append(NEWLINE_TAB);
        if (summaryItems != null && !summaryItems.isEmpty()) {
            this.appendProcSummaryStatisticAssignments(procSummary, summaryItems, sumGroupValues, dsProcessor);
        }
        procSummary.append(";");
        procSummary.append(NEWLINE);
        procSummary.append(PROC_RUN_QUIT);
        return procSummary;
    }

    static void addPerformStepMacro(List<SQLComponentAbstract> code, DataSelectionProcessorAbstract dsProcessor, String tableName) throws GenerationException {
        StringBuffer startMacroDef = new StringBuffer();
        startMacroDef.append("%macro performCheck();\n");
        startMacroDef.append("   %let tableName = " + tableName + ";\n");
        startMacroDef.append("   %if %eval(&syserr) ne 0 and %eval(&syserr) ne 4 %then %do;\n");
        startMacroDef.append("     %let exists = %SYSFUNC(EXIST(&tableName));\n");
        startMacroDef.append("     %if %eval(&exists) eq 1 %then %do;\n");
        SQLStatementFactory.addText(code, startMacroDef);
        SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
        SQLStatementFactory.addDropTableByName(code, dsProcessor, tableName);
        SQLStatementFactory.addEndProcSql(code, dsProcessor);
        StringBuffer endMacroDef = new StringBuffer();
        endMacroDef.append("     %end;\n");
        endMacroDef.append("   %end;\n");
        endMacroDef.append("%mend;\n\n");
        endMacroDef.append("%performCheck();\n");
        SQLStatementFactory.addText(code, endMacroDef);
    }

    private void appendVarsListText(StringBuffer procSummary, String leadingSep, Collection<DataItem> items, String varSep, String trailingSep, DataSelectionProcessorAbstract dsProcessor, boolean useNumericIfEmpty, int maxLineLen, String newLine, String startNewLine) throws GenerationException {
        String nextSep = leadingSep;
        if (items != null && items.size() > 0) {
            int lineStart = procSummary.lastIndexOf(newLine);
            int curLineLen = procSummary.length() - (lineStart == -1 ? 0 : lineStart);
            for (DataItem dataItem : items) {
                String rsid = dataItem.getResultSetID();
                String identifier = dsProcessor.generateDataStepVar(rsid);
                int len = nextSep.length() + identifier.length();
                if (curLineLen + len > maxLineLen) {
                    procSummary.append(startNewLine);
                    curLineLen = 1;
                }
                procSummary.append(nextSep).append(identifier);
                curLineLen += len;
                nextSep = varSep;
            }
            procSummary.append(trailingSep);
        } else if (useNumericIfEmpty) {
            procSummary.append(nextSep).append("_NUMERIC_");
        }
    }

    private void appendProcSummaryStatisticAssignments(StringBuffer procSummary, Collection<DataItem> summaryItems, boolean sumGroupValues, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        boolean hasItems;
        boolean bl = hasItems = summaryItems != null && summaryItems.size() > 0;
        if (sumGroupValues || !hasItems) {
            procSummary.append("sum=");
        } else {
            boolean hasMoreThanOneStat = false;
            Function singleStat = null;
            String singleStatisticText = null;
            LinkedHashMap<Function, String> stats = new LinkedHashMap<Function, String>();
            for (DataItem item : summaryItems) {
                Function itemFunction = ExpandedProcSummaryStatement.extractFunction(item);
                FunctionNameID functionNameID = itemFunction.getFunctionNameID();
                String itemStatText = ExpandedProcSummaryStatement.getProcSummaryStatisticText(functionNameID);
                stats.put(itemFunction, itemStatText);
                if (singleStat == null) {
                    singleStat = itemFunction;
                    singleStatisticText = itemStatText;
                    continue;
                }
                if (hasMoreThanOneStat || singleStatisticText.equalsIgnoreCase(itemStatText)) continue;
                hasMoreThanOneStat = true;
            }
            if (hasMoreThanOneStat) {
                String deliminator = "";
                for (DataItem item : summaryItems) {
                    Function itemFunction = ExpandedProcSummaryStatement.extractFunction(item);
                    String summaryStatistic = (String)stats.get(itemFunction);
                    procSummary.append(deliminator);
                    String rsid = item.getResultSetID();
                    String identifier = dsProcessor.generateDataStepVar(rsid);
                    this.appendProcSummaryStatisticVariable(procSummary, identifier, summaryStatistic);
                    deliminator = NEWLINE_TAB;
                }
            } else if (singleStat != null) {
                procSummary.append(singleStatisticText).append("=");
            } else {
                procSummary.append("SUM=");
            }
        }
    }

    private void appendProcSummaryStatisticVariable(StringBuffer statisticsStatement, String identifier, String summaryStatistic) {
        statisticsStatement.append(summaryStatistic).append("(").append(identifier).append(")=").append(identifier);
    }

    public static boolean isValidSummaryFunction(Function itemFunction) {
        return ExpandedProcSummaryStatement.getStatisticText(itemFunction.getFunctionNameID()) != null;
    }

    public static String getStatisticText(FunctionNameID functionNameId) {
        String text = null;
        if (functionNameId != null && (text = ExpandedProcSummaryStatement.getProcSummaryStatisticText(functionNameId)) == null) {
            text = ExpandedProcSummaryStatement.getNonProcSummaryStatisticText(functionNameId);
        }
        return text;
    }

    private static String getProcSummaryStatisticText(FunctionNameID functionNameId) {
        return ExpandedProcSummaryStatement.getProcSummaryFunctionNames().get(functionNameId);
    }

    private static synchronized Map<FunctionNameID, String> getProcSummaryFunctionNames() {
        if (_procSummaryFunctionNames == null) {
            _procSummaryFunctionNames = new HashMap<FunctionNameID, String>(19);
            _procSummaryFunctionNames.put(FunctionNameID.AVG, "MEAN");
            _procSummaryFunctionNames.put(FunctionNameID.COUNT, "N");
            _procSummaryFunctionNames.put(FunctionNameID.CSS, "CSS");
            _procSummaryFunctionNames.put(FunctionNameID.CV, "CV");
            _procSummaryFunctionNames.put(FunctionNameID.FREQ, "N");
            _procSummaryFunctionNames.put(FunctionNameID.MAX, "MAX");
            _procSummaryFunctionNames.put(FunctionNameID.MEAN, "MEAN");
            _procSummaryFunctionNames.put(FunctionNameID.MIN, "MIN");
            _procSummaryFunctionNames.put(FunctionNameID.N, "N");
            _procSummaryFunctionNames.put(FunctionNameID.PRT, "PRT");
            _procSummaryFunctionNames.put(FunctionNameID.NMISS, "NMISS");
            _procSummaryFunctionNames.put(FunctionNameID.RANGE, "RANGE");
            _procSummaryFunctionNames.put(FunctionNameID.STD, "STD");
            _procSummaryFunctionNames.put(FunctionNameID.STDERR, "STDERR");
            _procSummaryFunctionNames.put(FunctionNameID.SUM, "SUM");
            _procSummaryFunctionNames.put(FunctionNameID.USS, "USS");
            _procSummaryFunctionNames.put(FunctionNameID.T, "T");
            _procSummaryFunctionNames.put(FunctionNameID.VAR, "VAR");
            _procSummaryFunctionNames.put(FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE, "/* Internal Aggregate w/additive raw data: */ SUM");
            _procSummaryFunctionNames.put(FunctionNameID.INTERNAL_AGGREGATION, "/* Internal Aggregate w/non-additive raw data: */ MIN");
        }
        return _procSummaryFunctionNames;
    }

    private static String getNonProcSummaryStatisticText(FunctionNameID functionNameId) {
        return ExpandedProcSummaryStatement.getNonProcSummaryFunctionNames().get(functionNameId);
    }

    private static synchronized Map<FunctionNameID, String> getNonProcSummaryFunctionNames() {
        if (_nonProcSummaryFunctionNames == null) {
            _nonProcSummaryFunctionNames = new HashMap<FunctionNameID, String>(19);
            _nonProcSummaryFunctionNames.put(FunctionNameID.AVG_DISTINCT, "MEAN_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.COUNT_DISTINCT, "N_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.CSS_DISTINCT, "CSS_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.CV_DISTINCT, "CV_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.FREQ_DISTINCT, "N_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.MAX_DISTINCT, "MAX_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.MEAN_DISTINCT, "MEAN_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.MIN_DISTINCT, "MIN_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.N_DISTINCT, "N_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.PRT_DISTINCT, "PRT_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.NMISS_DISTINCT, "NMISS_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.RANGE_DISTINCT, "RANGE_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.STD_DISTINCT, "STD_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.STDERR_DISTINCT, "STDERR_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.SUM_DISTINCT, "SUM_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.USS_DISTINCT, "USS_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.T_DISTINCT, "T_DISTINCT");
            _nonProcSummaryFunctionNames.put(FunctionNameID.VAR_DISTINCT, "VAR_DISTINCT");
        }
        return _nonProcSummaryFunctionNames;
    }

    public static boolean isInternallyFormatted(Function itemFunction) {
        FunctionNameID functionNameID;
        boolean result = false;
        result = itemFunction == null ? false : ExpandedProcSummaryStatement.getInternallyFormattedText(functionNameID = itemFunction.getFunctionNameID()) != null;
        return result;
    }

    private static String getInternallyFormattedText(FunctionNameID functionNameId) {
        return ExpandedProcSummaryStatement.getInternallyFormattedFunctionNames().get(functionNameId);
    }

    private static synchronized Map<FunctionNameID, String> getInternallyFormattedFunctionNames() {
        if (_internallyFormattedFunctionNames == null) {
            _internallyFormattedFunctionNames = new HashMap<FunctionNameID, String>(4);
            _internallyFormattedFunctionNames.put(FunctionNameID.COUNT_DISTINCT, "N_DISTINCT");
            _internallyFormattedFunctionNames.put(FunctionNameID.NMISS_DISTINCT, "NMISS_DISTINCT");
            _internallyFormattedFunctionNames.put(FunctionNameID.FREQ_DISTINCT, "N_DISTINCT");
            _internallyFormattedFunctionNames.put(FunctionNameID.N_DISTINCT, "N_DISTINCT");
        }
        return _internallyFormattedFunctionNames;
    }

    public static boolean isKeepingFormat(Function itemFunction) {
        boolean result = false;
        if (itemFunction == null) {
            result = true;
        } else {
            FunctionNameID functionNameID = itemFunction.getFunctionNameID();
            result = ExpandedProcSummaryStatement.getNonProcSummaryFunctionNames().containsKey(functionNameID) ? true : ExpandedProcSummaryStatement.getProcSummaryKeepsFormatFunctionNameIDs().contains(functionNameID);
        }
        return result;
    }

    private static synchronized List<FunctionNameID> getProcSummaryKeepsFormatFunctionNameIDs() {
        if (_procSummaryKeepsFormat == null) {
            _procSummaryKeepsFormat = new ArrayList<FunctionNameID>(22);
            _procSummaryKeepsFormat.add(FunctionNameID.AVG);
            _procSummaryKeepsFormat.add(FunctionNameID.MIN);
            _procSummaryKeepsFormat.add(FunctionNameID.MAX);
            _procSummaryKeepsFormat.add(FunctionNameID.RANGE);
            _procSummaryKeepsFormat.add(FunctionNameID.SUM);
            _procSummaryKeepsFormat.add(FunctionNameID.MEAN);
            _procSummaryKeepsFormat.add(FunctionNameID.STD);
            _procSummaryKeepsFormat.add(FunctionNameID.STDERR);
        }
        return _procSummaryKeepsFormat;
    }

    private void addMergeNonProcStatisticsVars(List<SQLComponentAbstract> code, String summaryTableName, String baseTableName, String nonProcValueTableName, List<DataItem> classItems, Collection<DataItem> nonProcItems, Collection<DataItem> procSqlRegular, Collection<DataItem> procSqlOnlySTs, Collection<DataItem> procSqlOnlyGTs, Collection<DataItem> procSqlNone, Map<String, DataItem> missingValueVars, boolean grandTotalsOnly, boolean dropType, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        ArrayList<DataItem> catsOnColumn = new ArrayList<DataItem>();
        ArrayList<DataItem> catsOnRow = new ArrayList<DataItem>();
        ArrayList<DataItem> catsOnSlicer = new ArrayList<DataItem>();
        LinkedHashMap<DataItem, BitSet> catBitMasks = new LinkedHashMap<DataItem, BitSet>();
        BitSet allCellsBitMask = new BitSet();
        this.splitCategories(classItems, catsOnColumn, catsOnRow, catsOnSlicer, catBitMasks, allCellsBitMask);
        this.addProcSqlSummaries(code, nonProcValueTableName, baseTableName, classItems, catsOnColumn, catsOnRow, catBitMasks, allCellsBitMask, nonProcItems, procSqlRegular, procSqlOnlySTs, procSqlOnlyGTs, procSqlNone, dsProcessor);
        if (!grandTotalsOnly && classItems != null && classItems.size() > 0) {
            this.addProcSortByType(code, nonProcValueTableName, classItems, dsProcessor);
        }
        boolean nonProcVarsDropsType = dropType && missingValueVars.isEmpty();
        StringBuffer dataStepMerge = this.generateMergeSummaryAndSqlStatistics(summaryTableName, nonProcValueTableName, classItems, nonProcItems, nonProcVarsDropsType, dsProcessor);
        SQLStatementFactory.addText(code, dataStepMerge);
        SQLStatementFactory.addNewLine(code);
    }

    private StringBuffer generateEmptyBaseFile(String nonProcValueTableName, String sourceTemplateTableName, List<DataItem> classItems, Collection<DataItem> nonProcItems, Collection<DataItem> summaryItems, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append(NEWLINE).append("DATA ").append(nonProcValueTableName).append(";");
        dataStep.append(NEWLINE_TAB).append("SET ").append(sourceTemplateTableName).append(" (obs=0);");
        dataStep.append(NEWLINE_TAB).append("_type_ = . ;");
        this.generateMissingVarAttribs(dataStep, nonProcItems, dsProcessor);
        this.generateMissingVarValues(dataStep, nonProcItems, dsProcessor);
        if (!summaryItems.isEmpty()) {
            dataStep.append(NEWLINE_TAB).append("DROP ");
            this.appendVarsListText(dataStep, "", summaryItems, " ", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
            dataStep.append(";");
        }
        dataStep.append(NEWLINE_TAB).append("RETAIN ");
        this.appendVarsListText(dataStep, "", classItems, " ", " ", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
        dataStep.append("_type_ ");
        this.appendVarsListText(dataStep, "", nonProcItems, " ", "", dsProcessor, true, 200, NEWLINE, NEWLINE_TAB);
        dataStep.append(";");
        dataStep.append(NEWLINE);
        dataStep.append(PROC_RUN_QUIT);
        return dataStep;
    }

    private void generateMissingVarValues(StringBuffer dataStep, Collection<DataItem> items, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        if (items != null && items.size() > 0) {
            for (DataItem item : items) {
                String rsid = item.getResultSetID();
                String identifier = dsProcessor.generateDataStepVar(rsid);
                String missing = this.generateMissingValue(item);
                dataStep.append(NEWLINE_TAB).append(identifier).append(" = ").append(missing).append(" ;");
            }
        }
    }

    private String generateMissingValue(DataItem item) {
        String missing = null;
        if (item.getExpressionTypeIgnoringFormattingForced() == 3) {
            missing = MissingValues.toQueryString((MissingValues)MissingValues._BLANK_);
            missing = GenerationUtil.generateQuotedLiteral(missing);
        } else {
            missing = MissingValues.toQueryString((MissingValues)MissingValues.Dot);
        }
        return missing;
    }

    private void generateMissingVarAttribs(StringBuffer dataStep, Collection<DataItem> items, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        if (items != null && items.size() > 0) {
            for (DataItem item : items) {
                String tmpFormat;
                String format = item.getFormat();
                format = format != null && !"$.".equals(format) && !"$CHAR.".equals(format.toUpperCase()) ? (!(tmpFormat = ExpandedProcSummaryStatement.getDataStepOutputFormat(item)).equals("") ? " format=" + tmpFormat : "") : "";
                String label = item.getLabel();
                label = label != null ? " label=" + GenerationUtil.generateQuotedLiteral(label) : "";
                if (format.length() <= 0 && label.length() <= 0) continue;
                String rsid = item.getResultSetID();
                String identifier = dsProcessor.generateDataStepVar(rsid);
                dataStep.append(NEWLINE_TAB).append("ATTRIB ").append(identifier).append(format).append(label).append(";");
            }
        }
    }

    private void addProcSqlSummaries(List<SQLComponentAbstract> code, String nonProcValueTableName, String inputTableName, List<DataItem> classItems, List<DataItem> catsOnColumn, List<DataItem> catsOnRow, Map<DataItem, BitSet> catBitMasks, BitSet allCellsBitMask, Collection<DataItem> nonProcItems, Collection<DataItem> procSqlRegular, Collection<DataItem> procSqlOnlySTs, Collection<DataItem> procSqlOnlyGTs, Collection<DataItem> procSqlNone, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer macroCode = ExpandedProcSummaryStatement.generateFormatMacroVariables(inputTableName, classItems, dsProcessor);
        SQLStatementFactory.addText(code, macroCode);
        int numberOfBits = allCellsBitMask.length();
        SQLStatementFactory.addNewLine(code);
        SQLExpressionAbstract sqlExpression = this.getSQLFactory().createSQLExpression();
        sqlExpression.setDataSelectionProcessor(dsProcessor);
        sqlExpression.setDataSelection(this._dataSelection);
        String viewAlias = "dvv";
        SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
        ArrayList<DataItem> cats = new ArrayList<DataItem>();
        int countRowCats = catsOnRow.size();
        int countColCats = catsOnColumn.size();
        if (_logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer("/* categories (ROW): ").append(countRowCats);
            for (DataItem dataItem : catsOnRow) {
                buffer.append(NEWLINE).append(" *    class ").append(dataItem.getResultSetID());
                buffer.append(", label '").append(dataItem.getLabel()).append("'");
            }
            buffer.append(NEWLINE).append(" * categories (COLUMN): ").append(countColCats);
            for (DataItem dataItem : catsOnColumn) {
                buffer.append(NEWLINE).append(" *   class ").append(dataItem.getResultSetID());
                buffer.append(", var '").append(dataItem.getLabel()).append("'");
            }
            buffer.append(NEWLINE).append(" * measures: ").append(nonProcItems.size());
            for (DataItem dataItem : nonProcItems) {
                buffer.append(NEWLINE).append(" *   var ").append(dataItem.getResultSetID());
                buffer.append(", label '").append(dataItem.getLabel()).append("'");
            }
            buffer.append(NEWLINE).append(" */").append(NEWLINE);
            _logger.debug((CharSequence)buffer);
        }
        ArrayList<DataItem> axisTotalMeasures = new ArrayList<DataItem>(nonProcItems);
        axisTotalMeasures.removeAll(procSqlNone);
        axisTotalMeasures.removeAll(procSqlOnlySTs);
        ArrayList<DataItem> subTotalMeasures = new ArrayList<DataItem>(nonProcItems);
        subTotalMeasures.removeAll(procSqlNone);
        subTotalMeasures.removeAll(procSqlOnlyGTs);
        int queryIndex = 0;
        for (int rowMax = 0; rowMax < countRowCats + 1; ++rowMax) {
            for (int colMax = 0; colMax < countColCats + 1; ++colMax) {
                if (queryIndex != 0) {
                    SQLStatementFactory.addNewLine(code);
                }
                cats.clear();
                BitSet rowBitMask = this.addToCatList(cats, catsOnRow, catBitMasks, numberOfBits, rowMax);
                BitSet colBitMask = this.addToCatList(cats, catsOnColumn, catBitMasks, numberOfBits, colMax);
                String typeBinary = this.generateType(numberOfBits, rowBitMask, colBitMask);
                long type = 0L;
                if (typeBinary != null && typeBinary.length() > 0) {
                    type = Long.valueOf(typeBinary, 2);
                }
                Collection<DataItem> whichMeasures = rowMax == countRowCats && colMax == countColCats ? nonProcItems : (rowMax == 0 && colMax == 0 ? axisTotalMeasures : (rowMax == 0 && colMax == countColCats ? axisTotalMeasures : (colMax == 0 && rowMax == countRowCats ? axisTotalMeasures : subTotalMeasures)));
                String viewName = nonProcValueTableName + queryIndex;
                SQLStatementFactory.addStartSqlStatement(code, dsProcessor);
                SQLStatementFactory.addCreateViewAs(code, dsProcessor, viewName);
                StringBuffer sql = this.generateCalculationQuery(inputTableName, dsProcessor, sqlExpression, viewAlias, whichMeasures, cats, type);
                SQLStatementFactory.addText(code, sql);
                SQLStatementFactory.addEndSqlStatement(code, dsProcessor);
                SQLStatementFactory.addEndProcSql(code, dsProcessor);
                StringBuffer procDataSets = this.generateProcDataSetsAppend(nonProcValueTableName, viewName);
                SQLStatementFactory.addText(code, procDataSets);
                SQLStatementFactory.addNewLine(code);
                SQLStatementFactory.addStartProcSql(code, dsProcessor, false, null);
                SQLStatementFactory.addDropViewByName(code, dsProcessor, viewName);
                ++queryIndex;
            }
        }
        SQLStatementFactory.addEndProcSql(code, dsProcessor);
    }

    private StringBuffer generateCalculationQuery(String inputTableName, DataSelectionProcessorAbstract dsProcessor, SQLExpressionAbstract sqlExpression, String viewAlias, Collection<DataItem> nonProcItems, ArrayList<DataItem> cats, long type) throws GenerationException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select");
        this.appendMinimumsOfCatVars(sql, viewAlias, cats, dsProcessor);
        sql.append(' ').append(type).append(" as _type_");
        this.appendSqlAggregations(sql, viewAlias, nonProcItems, dsProcessor);
        sql.append(NEWLINE).append("    from ").append(inputTableName).append(" ").append(viewAlias);
        sql.append(NEWLINE).append("   group by ");
        sql.append(NEWLINE).append("         _type_");
        if (cats.size() > 0) {
            sql.append(',');
            this.appendFormattedGroupByVars(sql, viewAlias, sqlExpression, cats, dsProcessor);
        }
        return sql;
    }

    private StringBuffer generateProcDataSetsAppend(String nonProcValueTableName, String queryTableName) {
        StringBuffer procDataSetsAppend = new StringBuffer();
        procDataSetsAppend.append(NEWLINE).append("Proc DataSets NOLIST;");
        procDataSetsAppend.append(NEWLINE_TAB).append("APPEND BASE=").append(nonProcValueTableName).append(" DATA=").append(queryTableName).append(" FORCE");
        procDataSetsAppend.append(";");
        procDataSetsAppend.append(NEWLINE);
        procDataSetsAppend.append(PROC_RUN_QUIT);
        return procDataSetsAppend;
    }

    private void addProcSortByType(List<SQLComponentAbstract> code, String nonProcValueTableName, List<DataItem> classItems, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer procSort = new StringBuffer();
        procSort.append(NEWLINE).append("PROC SORT data=").append(nonProcValueTableName);
        procSort.append(NEWLINE_TAB).append(" out=").append(nonProcValueTableName).append(";");
        procSort.append(NEWLINE_TAB).append("BY _type_");
        this.appendVarsListText(procSort, " ", classItems, " ", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
        procSort.append(";");
        procSort.append(NEWLINE);
        procSort.append(PROC_RUN_QUIT);
        SQLStatementFactory.addText(code, procSort);
    }

    private void appendSqlAggregations(StringBuffer sql, String viewAlias, Collection<DataItem> nonProcItems, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        for (DataItem item : nonProcItems) {
            String rsid = item.getResultSetID();
            String identifier = dsProcessor.generateColumnIdentifier(rsid);
            String tableColRef = viewAlias + "." + identifier;
            Function function = ExpandedProcSummaryStatement.extractFunction(item);
            String syntaxTemplate = function.getSyntaxTemplateFor(1);
            String aggregatedVar = MessageFormat.format(syntaxTemplate, tableColRef);
            sql.append(",").append(NEWLINE).append("         ").append(aggregatedVar);
            if (identifier == null) continue;
            sql.append(" AS ");
            sql.append(identifier);
        }
    }

    private String generateType(int numberOfBits, BitSet rowBitMask, BitSet colBitMask) {
        char[] typeChars;
        if (numberOfBits == 0) {
            typeChars = new char[]{'0'};
        } else {
            BitSet queryBitMask = new BitSet(numberOfBits);
            queryBitMask.or(colBitMask);
            queryBitMask.or(rowBitMask);
            typeChars = this.toChars(numberOfBits, queryBitMask);
        }
        String typeBinary = String.valueOf(typeChars);
        return typeBinary;
    }

    protected char[] toChars(int numberOfBits, BitSet queryBitMask) {
        char[] typeChars = new char[numberOfBits];
        for (int bitIndex = 0; bitIndex < typeChars.length; ++bitIndex) {
            int bit;
            typeChars[numberOfBits - bitIndex - 1] = bit = queryBitMask.get(bitIndex) ? 49 : 48;
        }
        return typeChars;
    }

    private void appendMinimumsOfCatVars(StringBuffer sql, String viewAlias, ArrayList<DataItem> cats, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        if (cats != null && cats.size() > 0) {
            Iterator<DataItem> iterCategories = cats.iterator();
            while (iterCategories.hasNext()) {
                DataItem item = iterCategories.next();
                String rsid = item.getResultSetID();
                String identifier = dsProcessor.generateColumnIdentifier(rsid);
                String unfDataIdentifier = viewAlias + "." + identifier;
                String text = MessageFormat.format("min({0}) as {1}", unfDataIdentifier, identifier);
                boolean hasNext = iterCategories.hasNext();
                this.smartAppend(sql, text, hasNext, 200);
            }
            sql.append(",");
        }
    }

    private void appendFormattedGroupByVars(StringBuffer sql, String viewAlias, SQLExpressionAbstract sqlExpression, ArrayList<DataItem> cats, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        for (int group = 0; group < cats.size(); ++group) {
            DataItem item = cats.get(group);
            String rsid = item.getResultSetID();
            String identifier = dsProcessor.generateColumnIdentifier(rsid);
            boolean formatTransforming = false;
            String format = null;
            boolean useMacroName = ExpandedProcSummaryStatement.useFormatMacroVariable(item);
            if (useMacroName) {
                format = "&" + ExpandedProcSummaryStatement.generateFormatMacroVariableName(item);
                formatTransforming = true;
            } else {
                format = GenerationUtil.getSqlOutputFormat(item);
                ExpressionInterface expression = item.getExpression();
                int unformatedType = item.getExpressionTypeIgnoringFormattingForced();
                formatTransforming = GenerationUtil.isFormatTransforming(format, expression, unformatedType);
            }
            boolean groupByPut = GenerationUtil.useFormattedValueForGrouping(item);
            boolean inlinePut = sqlExpression.forceFormatItemDeclaration(item);
            boolean formattingForced = groupByPut && !inlinePut;
            if ((item.isFormattingForced() || formatTransforming) != (formattingForced || formatTransforming)) {
                new Exception("OLD: " + (item.isFormattingForced() || formatTransforming) + " NEW: " + (formattingForced || formatTransforming)).printStackTrace();
            }
            String sqlText = viewAlias + "." + identifier;
            if (formattingForced || formatTransforming) {
                sqlText = GenerationUtil.generatePut(dsProcessor, sqlText, format);
            }
            boolean hasNext = group + 1 < cats.size();
            this.smartAppend(sql, sqlText, hasNext, 200);
        }
    }

    private void smartAppend(StringBuffer buffer, String text, boolean hasNext, int maxLength) {
        int len;
        int lineStart = buffer.lastIndexOf(NEWLINE);
        int curLineLen = buffer.length() - (lineStart == -1 ? 0 : lineStart);
        if (curLineLen + (len = text.length()) + 2 > maxLength) {
            buffer.append(NEWLINE).append("        ");
        }
        buffer.append(' ').append(text);
        if (hasNext) {
            buffer.append(",");
        }
    }

    private BitSet addToCatList(List<DataItem> cats, List<DataItem> catsOnAxis, Map<DataItem, BitSet> catBitMasks, int numberOfBits, int catMax) {
        BitSet rowBitMask = new BitSet(numberOfBits);
        for (int r = 0; r <= catMax; ++r) {
            if (r == catMax) continue;
            DataItem rowItem = catsOnAxis.get(r);
            BitSet rowItemBitMask = catBitMasks.get(rowItem);
            rowBitMask.or(rowItemBitMask);
            cats.add(rowItem);
        }
        return rowBitMask;
    }

    private void splitCategories(List<DataItem> classItems, List<DataItem> catsOnColumn, List<DataItem> catsOnRow, List<DataItem> catsOnSlicer, Map<DataItem, BitSet> catBitMasks, BitSet allCellsBitMask) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Cats: " + classItems);
        }
        if (classItems != null) {
            int maxCats = classItems.size();
            for (int catIndex = 0; catIndex < maxCats; ++catIndex) {
                Role role;
                int bitIndex = maxCats - catIndex - 1;
                DataItem cat = classItems.get(catIndex);
                BitSet catBitMask = new BitSet();
                catBitMask.set(bitIndex, true);
                catBitMasks.put(cat, catBitMask);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("   " + cat + " mask=" + catBitMask + ", " + String.valueOf(this.toChars(maxCats, catBitMask)));
                }
                allCellsBitMask.set(bitIndex, true);
                try {
                    role = this._dataSelection.getResultItemRole(cat);
                }
                catch (MetadataException e) {
                    role = Role.BACKGROUND;
                }
                if (role.equals(Role.ROW)) {
                    catsOnRow.add(cat);
                    continue;
                }
                if (role.equals(Role.COLUMN)) {
                    catsOnColumn.add(cat);
                    continue;
                }
                catsOnSlicer.add(cat);
            }
        }
    }

    private StringBuffer generateMergeSummaryAndSqlStatistics(String summaryTableName, String nonProcValueTableName, Collection<DataItem> classItems, Collection<DataItem> nonProcItems, boolean dropType, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append(NEWLINE).append("DATA ").append(summaryTableName).append(";");
        dataStep.append(NEWLINE_TAB).append("MERGE ").append(summaryTableName).append(" (in=inSummaryStats)");
        dataStep.append(NEWLINE_TAB).append("      ").append(nonProcValueTableName).append(" (in=inNonProcStats);");
        dataStep.append(NEWLINE_TAB).append("BY _type_");
        this.appendVarsListText(dataStep, " ", classItems, " ", "", dsProcessor, false, 200, NEWLINE, NEWLINE_TAB);
        dataStep.append(";");
        if (dropType) {
            dataStep.append(NEWLINE_TAB).append("DROP _type_;");
        }
        this.generateMissingVarAttribs(dataStep, nonProcItems, dsProcessor);
        dataStep.append(NEWLINE_TAB).append("IF inSummaryStats and not inNonProcStats THEN DO");
        this.generateMissingVarValues(dataStep, nonProcItems, dsProcessor);
        dataStep.append(NEWLINE_TAB).append("END").append(";");
        dataStep.append(NEWLINE);
        dataStep.append(PROC_RUN_QUIT);
        return dataStep;
    }

    private StringBuffer generateAppendMissingValueVars(String comment, String summaryTableName, Collection<DataItem> items, boolean dropType, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer dataStep = new StringBuffer();
        dataStep.append(NEWLINE).append(comment);
        dataStep.append(NEWLINE).append("DATA ").append(summaryTableName).append(";");
        dataStep.append(NEWLINE_TAB).append("SET ").append(summaryTableName).append(";");
        if (dropType) {
            dataStep.append(NEWLINE_TAB).append("DROP _type_;");
        }
        this.generateMissingVarAttribs(dataStep, items, dsProcessor);
        this.generateMissingVarValues(dataStep, items, dsProcessor);
        dataStep.append(NEWLINE);
        dataStep.append(PROC_RUN_QUIT);
        return dataStep;
    }

    public static String getSqlExtractFormat(DataItem item) throws GenerationException {
        Function aggregationFunction = item.getAggregationType();
        String format = item.getFormat();
        ExpressionInterface expression = item.getExpression();
        DataItemActionType usage = item.getUsage();
        if ((format == null || format == "") && usage == DataItemActionType.USAGE_AGGREGATE) {
            format = null;
        } else {
            boolean valid;
            boolean hasFormat = format != null && !format.trim().equals("");
            boolean bl = valid = hasFormat && DataItemImpl.isValidFormatForType(format, expression, usage, aggregationFunction);
            if (!valid) {
                format = null;
            }
        }
        return format;
    }

    private static String getSqlGroupByFormat(DataItem item) throws GenerationException {
        boolean valid;
        String format = item.getFormat();
        ExpressionInterface expression = item.getExpression();
        DataItemActionType usage = item.getUsage();
        Function aggregationFunction = item.getAggregationType();
        boolean hasFormat = format != null && !format.trim().equals("");
        boolean bl = valid = hasFormat && DataItemImpl.isValidFormatForType(format, expression, usage, aggregationFunction);
        if (!valid) {
            format = null;
        }
        return format;
    }

    static String getDataStepOutputFormat(DataItem item) throws GenerationException {
        boolean valid;
        String format = item.getFormat();
        ExpressionInterface expression = item.getExpression();
        DataItemActionType usage = item.getUsage();
        Function aggregationFunction = item.getAggregationType();
        boolean hasFormat = format != null && !format.trim().equals("");
        boolean bl = valid = hasFormat && DataItemImpl.isValidFormatForType(format, expression, usage, aggregationFunction);
        if (!valid) {
            int type = item.getExpressionTypeIgnoringFormattingForced();
            switch (type) {
                case 2: {
                    format = "BEST.";
                    break;
                }
                case 4: {
                    format = "DATE.";
                    break;
                }
                case 6: {
                    format = "DATETIME.";
                    break;
                }
                case 0: {
                    format = "$CHAR.";
                    break;
                }
                case 3: {
                    format = "$CHAR.";
                    break;
                }
                default: {
                    format = "$CHAR.";
                    break;
                }
            }
        } else if ("$.".equals(format)) {
            format = "$CHAR.";
        }
        return format;
    }

    private static StringBuffer generateFormatMacroVariables(String inputTableName, List<DataItem> items, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        StringBuffer macroCode = new StringBuffer();
        if (items != null && items.size() > 0) {
            StringBuffer defCode = new StringBuffer();
            for (int index = 0; index < items.size(); ++index) {
                DataItem item = items.get(index);
                boolean useMacroName = ExpandedProcSummaryStatement.useFormatMacroVariable(item);
                if (!useMacroName) continue;
                String rsid = item.getResultSetID();
                String identifier = dsProcessor.generateDataStepVar(rsid);
                String macro = ExpandedProcSummaryStatement.generateFormatMacroVariableName(item);
                defCode.append(NEWLINE_TAB).append("call symput('").append(macro).append("',vformat(").append(identifier).append("));");
            }
            if (defCode.length() > 0) {
                macroCode.append(NEWLINE).append("/* create macro variables to support server side formats */");
                macroCode.append(NEWLINE).append("DATA _null_; goto defs; SET ").append(inputTableName).append(';');
                macroCode.append(NEWLINE).append("  defs:;").append(defCode);
                macroCode.append(NEWLINE).append("  stop").append(";");
                macroCode.append(NEWLINE);
                macroCode.append(PROC_RUN_QUIT);
            }
        }
        return macroCode;
    }

    public static boolean useFormatMacroVariable(DataItem item) throws GenerationException {
        boolean haveFormat;
        boolean useMacroName = false;
        String format = ExpandedProcSummaryStatement.getSqlGroupByFormat(item);
        boolean bl = haveFormat = format != null && format.length() != 0;
        if (!haveFormat) {
            boolean formattingForced;
            boolean formatTransforming = false;
            int unformatedType = item.getExpressionTypeIgnoringFormattingForced();
            ExpressionInterface expression = item.getExpression();
            int detailsType = expression.getExpressionType();
            if (detailsType == unformatedType) {
                formatTransforming = true;
            }
            if ((formattingForced = item.isFormattingForced()) || formatTransforming) {
                useMacroName = true;
            }
        }
        return useMacroName;
    }

    public static String generateFormatMacroVariableName(DataItem item) {
        String rsid = item.getResultSetID();
        return SAS_FORMAT_PREFIX + rsid.replaceAll("[\\W]", "_");
    }

    public static boolean split(boolean ignoreDisabledTotals, boolean ignoreFotDisabledTotals, boolean useTypesBasedTotaling, DataSelection ds, Collection<DataItem> inputVars, Set<DataItem> onlyATs, Set<DataItem> onlySTs, Set<DataItem> onlyXTs, Set<DataItem> onlyCells, Collection<DataItem> outputVars) {
        boolean hasDisabledTotals;
        if (ignoreDisabledTotals) {
            hasDisabledTotals = false;
            outputVars.addAll(inputVars);
        } else {
            hasDisabledTotals = ExpandedProcSummaryStatement.splitForTotallingTypes(ds, inputVars, ignoreFotDisabledTotals, onlyATs, onlySTs, onlyXTs, onlyCells);
            if (hasDisabledTotals && !useTypesBasedTotaling) {
                outputVars.addAll(onlyATs);
                outputVars.addAll(onlyXTs);
                hasDisabledTotals = onlyXTs.size() != inputVars.size();
            } else {
                outputVars.addAll(inputVars);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Starting summary totaling items: " + inputVars);
            if (hasDisabledTotals) {
                _logger.debug("Calc all totals for : " + onlyATs);
                _logger.debug("Calc only subtotals for : " + onlySTs);
                _logger.debug("Calc only axistotals for : " + onlyXTs);
                _logger.debug("Calc only cell values for : " + onlyCells);
            }
            _logger.debug("final totaling items : " + outputVars);
        }
        return hasDisabledTotals;
    }

    protected Map<TotalingType, List<List<DataItem>>> getCrossings(List<DataItem> classItems, DataSelection ds) {
        ArrayList atTypesCrossings = new ArrayList();
        ArrayList stTypesCrossings = new ArrayList();
        ArrayList gtTypesCrossings = new ArrayList();
        ArrayList ntTypesCrossings = new ArrayList();
        LinkedHashMap<TotalingType, List<List<DataItem>>> crossings = new LinkedHashMap<TotalingType, List<List<DataItem>>>();
        crossings.put(TotalingType.ALLTOTAL, atTypesCrossings);
        crossings.put(TotalingType.SUBTOTAL, stTypesCrossings);
        crossings.put(TotalingType.AXISTOTAL, gtTypesCrossings);
        crossings.put(TotalingType.TOTAL_NONE, ntTypesCrossings);
        ArrayList<DataItem> rowItems = new ArrayList<DataItem>();
        ArrayList<DataItem> colItems = new ArrayList<DataItem>();
        for (SelectedItem si : ds.getSelectedItems()) {
            DataItem dataItem = si.getItem();
            if (!classItems.contains(dataItem)) continue;
            Role role = si.getRole();
            if (role.equals(Role.ROW)) {
                rowItems.add(dataItem);
                continue;
            }
            if (!role.equals(Role.COLUMN)) continue;
            colItems.add(dataItem);
        }
        int numCols = colItems.size();
        int numRows = rowItems.size();
        for (int r = 0; r < numRows + 1; ++r) {
            List rowSubItems = rowItems.subList(0, numRows - r);
            for (int c = 0; c < numCols + 1; ++c) {
                List colSubItems = colItems.subList(0, numCols - c);
                ArrayList crossing = new ArrayList(colSubItems.size() + rowSubItems.size());
                crossing.addAll(colSubItems);
                crossing.addAll(rowSubItems);
                atTypesCrossings.add(crossing);
                if (c == 0 && r == 0) {
                    stTypesCrossings.add(crossing);
                    gtTypesCrossings.add(crossing);
                    ntTypesCrossings.add(crossing);
                    continue;
                }
                if (!(c != 0 && c != numCols || r != 0 && r != numRows)) {
                    gtTypesCrossings.add(crossing);
                    continue;
                }
                stTypesCrossings.add(crossing);
            }
        }
        return crossings;
    }
}

