/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.combined;

import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.LookThroughDataSelection;
import com.sas.iquery.metadata.business.impl.AbstractBusinessModel;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.metadata.business.impl.LookThroughDataSelectionImpl;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.strategies.combined.DataSelectionWithEmbedded;
import com.sas.iquery.strategies.combined.LookThroughDataSelectionWithEmbedded;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedData;
import com.sas.iquery.strategies.sas.report.xml.EmbeddedOLAPDataReadROM;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Element;

public class CombinedDataSelectionFactory
extends DataSelectionFactory {
    private static CombinedDataSelectionFactory _instance = new CombinedDataSelectionFactory();

    public static DataSelectionFactory getInstance() {
        return _instance;
    }

    public static DataSelection newDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        return CombinedDataSelectionFactory.getInstance().newDataSelectionNonStatic(session, service);
    }

    @Override
    public DataSelection newDataSelectionNonStatic(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service) {
        DataSelectionWithEmbedded ds = new DataSelectionWithEmbedded(session, service);
        return ds;
    }

    public static DataSelection newDataSelection(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale dataLocale) {
        return CombinedDataSelectionFactory.getInstance().newDataSelectionNonStatic(session, service, dataLocale);
    }

    @Override
    public DataSelection newDataSelectionNonStatic(SessionContextInterface session, IntelligentQueryMetadataServiceInterface service, Locale dataLocale) {
        DataSelectionWithEmbedded dataSelection = new DataSelectionWithEmbedded(session, service, dataLocale);
        return dataSelection;
    }

    public static DataSelection newDataSelection(BusinessModel businessModel) {
        return CombinedDataSelectionFactory.getInstance().newDataSelectionNonStatic(businessModel);
    }

    @Override
    public DataSelection newDataSelectionNonStatic(BusinessModel businessModel) {
        DataSelectionWithEmbedded ds = null;
        if (businessModel == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("CombinedDataSelectionFactory.ErrorNullBaseBusinessModel.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(msg.toString());
        }
        if (!(businessModel instanceof AbstractBusinessModel)) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("CombinedDataSelectionFactory.ErrorNullBaseBusinessModel.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(msg.toString());
        }
        ds = new DataSelectionWithEmbedded((AbstractBusinessModel)businessModel);
        return ds;
    }

    public static LookThroughDataSelection newLookThroughDataSelection(DataSelection parentDataSelection) {
        return CombinedDataSelectionFactory.getInstance().newLookThroughDataSelectionNonStatic(parentDataSelection);
    }

    @Override
    public LookThroughDataSelection newLookThroughDataSelectionNonStatic(DataSelection parentDataSelection) {
        LookThroughDataSelectionImpl ds = null;
        if (parentDataSelection == null) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("CombinedDataSelectionFactory.ErrorNullBaseDataSelection.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(msg.toString());
        }
        if (parentDataSelection instanceof DataSelectionWithEmbedded) {
            ds = new LookThroughDataSelectionWithEmbedded((DataSelectionWithEmbedded)parentDataSelection);
        } else if (parentDataSelection instanceof DataSelectionImpl) {
            ds = new LookThroughDataSelectionImpl((DataSelectionImpl)parentDataSelection);
        } else {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("CombinedDataSelectionFactory.ErrorNotDataSelectionImpl.txt", new Object[0]);
            throw new IQueryServicesIllegalArgumentException(msg.toString());
        }
        return ds;
    }

    public static DataSelection readDataSelection(Element dataSelectionElement, Map<BusinessModelReferenceInfo, BusinessModel> reuseBusinessModels, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws MetadataException {
        return CombinedDataSelectionFactory.getInstance().readDataSelectionNonStatic(dataSelectionElement, reuseBusinessModels, metadataService, session);
    }

    @Override
    public DataSelection readDataSelectionNonStatic(Element modelElement, Map<BusinessModelReferenceInfo, BusinessModel> reuseBusinessModels, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session) throws MetadataException {
        if (modelElement == null) {
            throw new IQueryServicesIllegalArgumentException(IQModelImplUtilities.getMessage("BusinessQueryImplMapItemNull.txt", new Object[0]));
        }
        String elementName = modelElement.getTagName();
        DataSelectionImpl ds = null;
        if (elementName.equals("DataSelection")) {
            ds = DataSelectionWithEmbedded.readInNewDataSelectionWithEmbedded(session, metadataService, modelElement, null, reuseBusinessModels);
        } else if (elementName.equals("DataSelectionWithEmbedded")) {
            Element dsElement = IQModelImplUtilities.getFirstSubelementNamed(modelElement, "DataSelection");
            Element embeddedDataElement = IQModelImplUtilities.getFirstSubelementNamed(modelElement, "EmbeddedData");
            ds = DataSelectionWithEmbedded.readInNewDataSelectionWithEmbedded(session, metadataService, dsElement, embeddedDataElement, reuseBusinessModels);
        } else if (elementName.equals("LookThroughDataSelection")) {
            ds = LookThroughDataSelectionWithEmbedded.readInNewLookThroughDataSelectionWithEmbedded(session, metadataService, modelElement, null, reuseBusinessModels);
        } else if (elementName.equals("LookThroughDataSelectionWithEmbedded")) {
            Element ltdsElement = IQModelImplUtilities.getFirstSubelementNamed(modelElement, "LookThroughDataSelection");
            Element embeddedDataElement = IQModelImplUtilities.getFirstSubelementNamed(modelElement, "EmbeddedData");
            ds = LookThroughDataSelectionWithEmbedded.readInNewLookThroughDataSelectionWithEmbedded(session, metadataService, ltdsElement, embeddedDataElement, reuseBusinessModels);
        } else {
            throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("CombinedDataSelectionFactory.readDataSelectionNonStatic.invalidElement.fmt.txt", elementName));
        }
        return ds;
    }

    static boolean isValidEmbeddedDataElement(Element embeddedDataElement) {
        boolean isEmbeddedValid = false;
        if (EmbeddedOLAPDataReadROM.isValidEmbeddedDataElement(embeddedDataElement)) {
            isEmbeddedValid = true;
        } else if (EmbeddedData.isValidEmbeddedDataElement(embeddedDataElement)) {
            isEmbeddedValid = true;
        }
        return isEmbeddedValid;
    }
}

