/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop.formats;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptions;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionsFactory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;

@SASScope
class SASFormatStringParser {
    private static final String DEFAULT_BASE_NAME = "F";
    private final String _formatString;
    private SASFormatCategory _type;
    private SASFormatDescription _formatDescription;
    private String _baseFormatName;
    private int _width;
    private boolean _widthFound;
    private int _decimalWidth;
    private boolean _decimalWidthSupported;
    private boolean _decimalWidthFound;
    private static final String EMPTY_FORMAT_STRING = "SASFormatStringParser.EmptyFormatString.txt";
    private static final String INVALID_FORMAT_STRING = "SASFormatStringParser.InvalidFormatString.fmt.txt";
    private static final String INVALID_WIDTH = "SASFormatStringParser.InvalidWidth.fmt.txt";
    private static final String INVALID_DECIMAL_WIDTH = "SASFormatStringParser.InvalidDecimalWidth.fmt.txt";

    static SASFormatAttributes parseFormatString(String formatString) throws SASFormatException {
        return new SASFormatStringParser(formatString).parseFormatString();
    }

    private SASFormatStringParser(String formatString) {
        this._formatString = formatString.trim();
    }

    private SASFormatAttributes parseFormatString() throws SASFormatException {
        if (this._formatString == null || this._formatString.length() == 0) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(EMPTY_FORMAT_STRING, new Object[0]));
        }
        if (this._formatString.compareTo(".") == 0) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_FORMAT_STRING, this._formatString));
        }
        int indexOfDecimalWidth = this._formatString.indexOf(46);
        if (indexOfDecimalWidth == -1) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_FORMAT_STRING, this._formatString));
        }
        if (this._formatString.indexOf(46, indexOfDecimalWidth + 1) != -1) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_FORMAT_STRING, this._formatString));
        }
        String baseNameAndWidth = this._formatString.substring(0, indexOfDecimalWidth);
        this.processBaseNameAndWidth(baseNameAndWidth);
        this.processFormatAttributes();
        String decimalWidth = this._formatString.substring(indexOfDecimalWidth + 1);
        this.processDecimalWidth(decimalWidth);
        if (this._baseFormatName == null || this._baseFormatName.length() == 0) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_FORMAT_STRING, this._formatString));
        }
        if (this._decimalWidthFound && this._decimalWidth != 0 && this._baseFormatName.startsWith("$") && !this._decimalWidthSupported) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_FORMAT_STRING, this._formatString));
        }
        return new SASFormatAttributes(this._type, this._baseFormatName, this._width, this._decimalWidthSupported, this._decimalWidth);
    }

    private void processBaseNameAndWidth(String str) throws SASFormatException {
        char cur;
        StringBuffer widthBuf = new StringBuffer();
        this._width = 0;
        this._widthFound = false;
        this._baseFormatName = DEFAULT_BASE_NAME;
        for (int i = str.length() - 1; i >= 0; --i) {
            cur = str.charAt(i);
            if (!Character.isDigit(cur)) {
                int endIndex = i + 1;
                this._baseFormatName = str.substring(0, endIndex);
                if (this._baseFormatName == null || this._baseFormatName.length() == 0) {
                    this._baseFormatName = DEFAULT_BASE_NAME;
                }
                this._baseFormatName = this._baseFormatName.toUpperCase();
                break;
            }
            widthBuf.append(cur);
        }
        for (int j = this._baseFormatName.length() - 1; j >= 0; --j) {
            cur = this._baseFormatName.charAt(j);
            if (Character.isLetter(cur) || Character.isDigit(cur) || cur == '_' || cur == '$' && j == 0) continue;
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_FORMAT_STRING, this._formatString));
        }
        if (widthBuf.length() != 0) {
            String widthStr = widthBuf.reverse().toString();
            try {
                this._width = Integer.parseInt(widthStr);
                this._widthFound = true;
            }
            catch (NumberFormatException e) {
                throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_WIDTH, this._formatString), (Throwable)e);
            }
        }
    }

    private void processFormatAttributes() throws SASFormatException {
        SASFormatDescriptions formatDescriptions = SASFormatDescriptionsFactory.getSASFormatDescriptions(null);
        this._formatDescription = formatDescriptions.getFormatDescription(this._baseFormatName);
        if (this._formatDescription != null) {
            this._type = this._formatDescription.getType();
            this._decimalWidthSupported = this._formatDescription.isDecimalWidthSupported();
            if (!this._widthFound) {
                this._width = this._formatDescription.getDefaultWidth();
            }
        } else {
            this._type = SASFormatCategory.USER_DEFINED_CATEGORY;
            this._decimalWidthSupported = !this._baseFormatName.startsWith("$");
        }
    }

    private void processDecimalWidth(String str) throws SASFormatException {
        try {
            this._decimalWidth = 0;
            if (str.length() != 0) {
                this._decimalWidth = Integer.parseInt(str);
                this._decimalWidthFound = true;
            }
        }
        catch (NumberFormatException e) {
            throw new SASFormatException(IQMetadataResourceBundle.getMessageFormatter(INVALID_DECIMAL_WIDTH, this._formatString), (Throwable)e);
        }
    }
}

