/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop.formats;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SASScope
class SASFormatDescriptionsImpl
implements SASFormatDescriptions {
    private List<SASFormatDescription> _allFormatDescriptions;
    private Map<String, SASFormatDescription> _formatMap;
    private Map<SASFormatCategory, List<SASFormatDescription>> _formatDescriptions;

    SASFormatDescriptionsImpl(Map<SASFormatCategory, List<SASFormatDescription>> formatDescriptions) {
        SASFormatCategory[] categories;
        this._formatDescriptions = formatDescriptions;
        this._formatMap = new LinkedHashMap<String, SASFormatDescription>();
        this._allFormatDescriptions = new ArrayList<SASFormatDescription>();
        for (SASFormatCategory category : categories = this.getSASFormatCategorys()) {
            List<SASFormatDescription> descsInType = formatDescriptions.get(category);
            for (SASFormatDescription cur : descsInType) {
                this._formatMap.put(cur.getBaseFormatName(), cur);
                this._allFormatDescriptions.add(cur);
            }
        }
        Collections.sort(this._allFormatDescriptions, new Comparator<SASFormatDescription>(){

            @Override
            public int compare(SASFormatDescription o1, SASFormatDescription o2) {
                return o1.getBaseFormatName().compareTo(o2.getBaseFormatName());
            }
        });
    }

    @Override
    public List<SASFormatDescription> getAllSASFormatDescriptions() {
        return Collections.unmodifiableList(this._allFormatDescriptions);
    }

    @Override
    public List<SASFormatDescription> getSASFormatDescriptions(SASFormatCategory type) {
        List<SASFormatDescription> rval = this._formatDescriptions.get(type);
        if (rval != null) {
            return Collections.unmodifiableList(rval);
        }
        return Collections.emptyList();
    }

    @Override
    public SASFormatDescription getFormatDescription(String baseFormatName) {
        return this._formatMap.get(baseFormatName);
    }

    @Override
    public SASFormatCategory[] getSASFormatCategorys() {
        Set<SASFormatCategory> categories = this._formatDescriptions.keySet();
        SASFormatCategory[] sorted = categories.toArray(new SASFormatCategory[categories.size()]);
        Arrays.sort(sorted, new Comparator<SASFormatCategory>(){

            @Override
            public int compare(SASFormatCategory o1, SASFormatCategory o2) {
                int ord2;
                SASFormatCategory cat1 = o1;
                SASFormatCategory cat2 = o2;
                int ord1 = this.ord(cat1);
                if (ord1 < (ord2 = this.ord(cat2))) {
                    return 1;
                }
                if (ord2 > ord1) {
                    return -1;
                }
                return cat1.getLabel().compareTo(cat2.getLabel());
            }

            private int ord(SASFormatCategory type) {
                int ord = SASFormatCategory.CHARACTER_CATEGORY == type ? 1 : (SASFormatCategory.NUMERIC_CATEGORY == type ? 2 : (SASFormatCategory.DATE_TIME_CATEGORY == type ? 3 : (SASFormatCategory.CURRENCY_CONVERSION_CATEGORY == type ? 4 : (SASFormatCategory.USER_DEFINED_CATEGORY == type ? 5 : 9999))));
                return ord;
            }
        });
        return sorted;
    }
}

