/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.serverprop.ParameterType;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@SASScope(value="ALL")
@SubjectToChange
@Immutable
public final class Parameter {
    private final ParameterType _type;
    private final boolean _isVarying;
    private final String _separator;
    private final List<ExpressionInterface> _enumList;
    private static final Parameter PARAMETER_OLAP_NUMERIC_SIMPLE = new Parameter(ParameterType.PARM_OLAP_NUMERIC_EXPRESSION, false, null, null);
    private static final Parameter PARAMETER_NUMERIC_SIMPLE = new Parameter(ParameterType.PARM_NUMERIC, false, null, null);
    private static final Parameter PARAMETER_CHAR_SIMPLE = new Parameter(ParameterType.PARM_CHAR, false, null, null);
    private static final Parameter PARAMETER_SET_SIMPLE = new Parameter(ParameterType.PARM_SET, false, null, null);
    private static final Parameter PARAMETER_TIMESTAMP_SIMPLE = new Parameter(ParameterType.PARM_TIMESTAMP, false, null, null);
    private static final Parameter PARAMETER_DATE_SIMPLE = new Parameter(ParameterType.PARM_DATE, false, null, null);
    private static final Parameter PARAMETER_TIME_SIMPLE = new Parameter(ParameterType.PARM_TIME, false, null, null);
    private static final Parameter PARAMETER_MEMBER_SIMPLE = new Parameter(ParameterType.PARM_MEMBER, false, null, null);

    Parameter(ParameterType type, boolean isVarying, String separator, List<ExpressionInterface> enumList) {
        this._type = type;
        this._isVarying = isVarying;
        this._separator = separator;
        this._enumList = enumList;
    }

    static Parameter getParameter(ParameterType type, boolean isVarying, String separator, List<ExpressionInterface> enumList) {
        int charSep = 88;
        if (",".equals(separator)) {
            charSep = 44;
        }
        if (type == ParameterType.PARM_OLAP_NUMERIC_EXPRESSION && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_OLAP_NUMERIC_SIMPLE;
        }
        if (type == ParameterType.PARM_NUMERIC && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_NUMERIC_SIMPLE;
        }
        if (type == ParameterType.PARM_CHAR && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_CHAR_SIMPLE;
        }
        if (type == ParameterType.PARM_SET && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_SET_SIMPLE;
        }
        if (type == ParameterType.PARM_TIMESTAMP && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_TIMESTAMP_SIMPLE;
        }
        if (type == ParameterType.PARM_DATE && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_DATE_SIMPLE;
        }
        if (type == ParameterType.PARM_TIME && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_TIME_SIMPLE;
        }
        if (type == ParameterType.PARM_MEMBER && !isVarying && charSep == 44 && enumList == null) {
            return PARAMETER_MEMBER_SIMPLE;
        }
        return new Parameter(type, isVarying, separator, enumList);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ParameterType getType() {
        return this._type;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isVarying() {
        return this._isVarying;
    }

    @SASScope
    public String getSeparator() {
        return this._separator;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isEnumerated() {
        return this._type == ParameterType.PARM_ENUMERATION;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public List<ExpressionInterface> getEnumerationList() {
        return this._enumList == null ? new ArrayList<ExpressionInterface>(0) : new ArrayList<ExpressionInterface>(this._enumList);
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isCompatibleWith(ExpressionInterface argument) {
        boolean compatible = false;
        if (argument != null) {
            int argType;
            compatible = this._type.isCompatibleWith(argument);
            if (this._enumList != null && !this._enumList.isEmpty() && compatible && (argType = argument.getExpressionType()) == 10) {
                StringExpressionUtil util = StringExpressionUtil.getInstance();
                try {
                    String argText = util.getText(argument);
                    for (int index = 0; index < this._enumList.size() && !compatible; ++index) {
                        ExpressionInterface enumExpr = this._enumList.get(index);
                        if (enumExpr == null) continue;
                        try {
                            String enumText = util.getText(enumExpr);
                            if (!enumText.equals(argText)) continue;
                            compatible = true;
                            continue;
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                    }
                }
                catch (MetadataException e) {
                    compatible = false;
                }
            }
        }
        return compatible;
    }

    @SASScope
    public String toString() {
        String result = null;
        if (this.isEnumerated() && this._enumList != null && !this._enumList.isEmpty()) {
            StringBuffer enumStr = new StringBuffer();
            StringExpressionUtil util = StringExpressionUtil.getInstance();
            boolean first = true;
            for (ExpressionInterface expr : this._enumList) {
                if (first) {
                    first = false;
                } else {
                    enumStr.append('|');
                }
                try {
                    String text = util.getText(expr);
                    enumStr.append(text);
                }
                catch (MetadataException e) {
                    enumStr.append(e.getMessage());
                }
            }
            result = enumStr.substring(0);
        } else {
            result = this._type.toString();
        }
        return result;
    }
}

