/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.metadata.serverprop;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.serverprop.Parameter;
import com.sas.iquery.metadata.serverprop.ParameterType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@SubjectToChange
@ThreadSafe
public class FunctionSignature {
    private final String _syntaxTemplate;
    private final ParameterType returnType;
    private final List<Parameter> parameters;
    private final int argumentCount;
    private final boolean canParenWrap;
    private static final Logger _logger = LogManager.getLogger(FunctionSignature.class);

    FunctionSignature(String inSyntaxTemplate, boolean canParenWrap, ParameterType inReturnType, List<Parameter> inParameters) {
        if (inParameters == null) {
            throw new IQueryServicesIllegalArgumentException(IQMetadataResourceBundle.getMessageFormatter("ServerProperties.NullParameterTypesList.txt", new Object[0]));
        }
        this.canParenWrap = canParenWrap;
        this._syntaxTemplate = inSyntaxTemplate;
        this.returnType = inReturnType;
        this.parameters = new ArrayList<Parameter>(inParameters);
        int argC = inParameters.size();
        for (Parameter parm : inParameters) {
            if (!parm.isVarying()) continue;
            argC = -1;
            break;
        }
        this.argumentCount = argC;
    }

    @SASScope
    public boolean canParenWrap() {
        return this.canParenWrap;
    }

    @SubjectToChange
    public ParameterType getReturnType() {
        return this.returnType;
    }

    @SubjectToChange
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @SubjectToChange
    public int getArgumentCount() {
        return this.argumentCount;
    }

    @SubjectToChange
    public String getDefaultSyntaxTemplate() {
        return this._syntaxTemplate;
    }

    public String getSyntaxTemplateFor(List<? extends ExpressionInterface> parms) {
        String template = null;
        if (this.isCompatibleWith(parms)) {
            template = this._syntaxTemplate;
            int fntArgCount = this.getArgumentCount();
            if (fntArgCount == -1) {
                template = this.resizeTemplate(template, parms.size());
            }
        }
        return template;
    }

    String resizeTemplate(String template, int neededArgCount) {
        int numOfParams = this.parameters.size();
        if (numOfParams <= neededArgCount) {
            Object[] messageFormatArgs = new String[numOfParams];
            StringBuffer newTemplate = new StringBuffer();
            int faIndex = 0;
            int aIndex = 0;
            while (faIndex < numOfParams) {
                Parameter param = this.parameters.get(faIndex);
                messageFormatArgs[faIndex] = "";
                newTemplate.setLength(0);
                if (param.isVarying()) {
                    String separator = param.getSeparator();
                    int endIndex = neededArgCount - (numOfParams - faIndex);
                    for (int index = aIndex; index <= endIndex; ++index) {
                        newTemplate.append('{');
                        newTemplate.append(index);
                        newTemplate.append('}');
                        if (index + 1 > endIndex) continue;
                        newTemplate.append(separator);
                    }
                    aIndex = endIndex;
                } else {
                    newTemplate.append('{');
                    newTemplate.append(aIndex);
                    newTemplate.append('}');
                }
                messageFormatArgs[faIndex] = newTemplate.substring(0);
                ++faIndex;
                ++aIndex;
            }
            template = template == null ? MessageFormat.format(this.getDefaultSyntaxTemplate(), messageFormatArgs) : MessageFormat.format(template, messageFormatArgs);
        }
        return template;
    }

    public boolean isCompatibleWith(List<? extends ExpressionInterface> args) {
        boolean compatible;
        block10: {
            int numOfParams;
            int argCount;
            int fntArgCount;
            block11: {
                block9: {
                    compatible = true;
                    fntArgCount = this.getArgumentCount();
                    argCount = args.size();
                    numOfParams = this.parameters.size();
                    if ((fntArgCount == -1 || argCount == numOfParams) && (fntArgCount != -1 || argCount >= numOfParams)) break block9;
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Invalid argument list for function " + this._syntaxTemplate);
                    }
                    compatible = false;
                    break block10;
                }
                if (fntArgCount == -1 || argCount != numOfParams) break block11;
                for (int index = 0; index < numOfParams && compatible; ++index) {
                    Parameter param = this.parameters.get(index);
                    compatible = param.isCompatibleWith(args.get(index));
                }
                break block10;
            }
            if (fntArgCount != -1 || argCount < numOfParams) break block10;
            int faIndex = 0;
            int aIndex = 0;
            while (faIndex < numOfParams && compatible) {
                Parameter param = this.parameters.get(faIndex);
                if (param.isVarying()) {
                    if (numOfParams > faIndex + 1) {
                        int endIndex = argCount - (numOfParams - faIndex);
                        for (int index = aIndex; index <= endIndex && compatible; ++index) {
                            compatible = param.isCompatibleWith(args.get(index));
                        }
                        aIndex = endIndex;
                    } else {
                        while (aIndex < argCount && compatible) {
                            compatible = param.isCompatibleWith(args.get(aIndex));
                            ++aIndex;
                        }
                    }
                } else {
                    compatible = param.isCompatibleWith(args.get(aIndex));
                }
                ++faIndex;
                ++aIndex;
            }
        }
        return compatible;
    }

    @SASScope
    public String toString() {
        return MessageFormat.format(this._syntaxTemplate, this.parameters.toArray());
    }
}

